package com.ulcjava.base.application;


	/**
	* The <code>ULCFiller</code> component can be used to explicitly fill in extra
	* space in user interfaces. This layout component is used to
enhance the visual
	* appearance of box layout based user interfaces. In the box layout, the height
	* of the rows (and width of the columns)
is defined by the minimal height
	* (width) of the contained components. In most cases the static factory methods
	* will be the right choice
to create <code>ULCFiller</code>
	* classes.
<p>
</p>
<b>Features</b>
<ul>
<li>The <code>ULCFiller</code>
	* component is a transparent area that fills the space defined by its width and
	* height properties.
<li>Typical applications of the <code>ULCFiller</code>
	* are:<ul>
<li>Creating empty rows (or columns) that save white space: add a
	* <code>ULCFiller</code> to the row (or column), either with a
specified size
	* orspecify the cell to be expandable.
<li>Expanding a row (or column) that
	* doesnot yet contain an expandable component (i.e., cell): adding a
	* <code>ULCFiller</code>
created by
	* <code>ULCFiller.createHorizontalGlue()</code> (i.e.
	* <code>ULCFiller.createVerticalGlue()</code>) to a row (column) and
defining
	* the corresponding cell to be expandable marks the row (column) as
	* expandable.
<li>Specifying a minimal height for a row (minimal width for a
	* column): adding a <code>ULCFiller</code>
	* with
<code>ULCFiller.createVerticalStruts(height)</code> (i. e. with
	* <code>ULCFiller.createHorizontalStruts(width)</code>) ensures that
the row
	* (column) is at least as high (wide).
</ul>
</ul>
<b>Examples</b>
<p>
</p>
The
	* following excerpt shows how to create empty space between two rows. Note that
	* instead of spanning the <code>ULCFiller</code>
component, we might also skip
	* the unused cell.
<p>
</p>

<pre>
ULCBoxPane box = new ULCBoxPane(2, 4); // (2
	* cols, 4 rows)
box.add(new ULCLabel(&quot;Name:&quot;));
ULCTextField
	* nameField= new ULCTextField(&quot;name&quot;,
	* 20);
box.add(nameField);
box.add(2, ULCFiller.createVerticalStrut(10)); // 10
	* pixel margin
box.add(new ULCLabel(&quot;Address:&quot;));
ULCTextField
	* addressField = new ULCTextField(&quot;address&quot;,
	* 20);
box.add(addressField);
box.add(new
	* ULCLabel(&quot;City:&quot;));
ULCTextField cityField = new
	* ULCTextField(&quot;city&quot;, 20);
box.add(cityField);
</pre>

<p>
</p>
The
	* following example ensures that the first column (containing the ULCLabels) is
	* at least 150 pixels wide (if a label exceeds this size,
the column is
	* enlarged). By using a horizontal strut the height is set to 0 and the bottom
	* row is not visible. The field column is
configured to get the rest of the
	* available width.
<p>
</p>

<pre>
ULCBoxPane box = new ULCBoxPane(2, 4); // (2
	* cols, 4 rows)
box.add(new ULCLabel(&quot;Name:&quot;));
ULCTextField
	* nameField= new ULCTextField(&quot;name&quot;,
	* 20);
box.add(ULCBoxPane.BOX_EXPAND_CENTER, nameField);
box.add(new
	* ULCLabel(&quot;Address:&quot;));
ULCTextField addressField = new
	* ULCTextField(&quot;address&quot;, 20);
box.add(ULCBoxPane.BOX_EXPAND_CENTER,
	* addressField);
box.add(new ULCLabel(&quot;City:&quot;));
ULCTextField
	* cityField = new ULCTextField(&quot;city&quot;,
	* 20);
box.add(ULCBoxPane.BOX_EXPAND_CENTER,
	* cityField);
box.add(ULCFiller.createHorizontalStrut(150)); // ensure 150
	* pixelwide
box.skip(1); // only necessary when adding more rows
</pre>
	*
	* @ulc.application		
	* @see		ULCBoxPane
	**/
 public class ULCFiller extends com.ulcjava.base.application.ULCComponent
{

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* Constructs a new filler with zero width and height.
	*
	**/
	 public ULCFiller()
	{
		 super();
	}


	/**
	* Constructs a new filler with the specified size.
	*
	* @param width 		 The width
	* @param height 		 The height
	**/
	 public ULCFiller(int width, int height)
	{
		 super();
	}


	/**
	* Constructs a new filler with the specified dimensions.
	*
	* @param dimension 		 the size of the filler
	**/
	 public ULCFiller(com.ulcjava.base.application.util.Dimension dimension)
	{
		 super();
	}


	/**
	* Constructs a new filler with the specified minimum, preferred and maximum
	* dimensions.
	*
	* @param minimumSize 		 the minimum size of the filler
	* @param preferredSize 		 the preferred size of the filler
	* @param maximumSize 		 the maximum size of the filler
	**/
	 public ULCFiller(com.ulcjava.base.application.util.Dimension minimumSize, com.ulcjava.base.application.util.Dimension preferredSize, com.ulcjava.base.application.util.Dimension maximumSize)
	{
		 super();
	}


	/**
	* Change the shape of a ULCFiller after construction time.
	*
	* @param minimumSize 		 the new minimal size
	* @param preferredSize 		 the new preferred size
	* @param maximumSize 		 the new maximum size
	**/
	 public void changeShape(com.ulcjava.base.application.util.Dimension minimumSize, com.ulcjava.base.application.util.Dimension preferredSize, com.ulcjava.base.application.util.Dimension maximumSize)
	{
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}


	/**
	* For backward compatibility with Anything keys used in deprecated {@link
	* com.ulcjava.base.client.UIProxy#createBasicObject(Anything)}
	*
	* @ulc.extension		
	**/
	 protected void saveState(com.ulcjava.base.shared.internal.Anything a)
	{
	}


	/**
	* Constructs a new filler with a rigid dimension.
	*
	* @param dimension 		 the dimension of this rigid sized filler
	* @return		the rigid sized ULCFiller
	**/
	 public  static com.ulcjava.base.application.ULCFiller createRigidArea(com.ulcjava.base.application.util.Dimension dimension)
	{
		return null;
	}


	/**
	* Constructs a new filler that will have a rigid horizontal height.
	*
	* @param width 		 the dimension of this horizontally rigid sized filler
	* @return		the horizontally rigid sized ULCFiller
	**/
	 public  static com.ulcjava.base.application.ULCFiller createHorizontalStrut(int width)
	{
		return null;
	}


	/**
	* Constructs a new filler that will have a rigid vertical height.
	*
	* @param height 		 the dimension of this vertically rigid sized filler
	* @return		the vertically rigid sized ULCFiller
	**/
	 public  static com.ulcjava.base.application.ULCFiller createVerticalStrut(int height)
	{
		return null;
	}


	/**
	* Constructs a new filler that may grow.
	*
	* @return		the ULCFiller that may grow
	**/
	 public  static com.ulcjava.base.application.ULCFiller createGlue()
	{
		return null;
	}


	/**
	* Constructs a new filler that may grow horizontally.
	*
	* @return		the ULCFiller that may grow horizontally
	**/
	 public  static com.ulcjava.base.application.ULCFiller createHorizontalGlue()
	{
		return null;
	}


	/**
	* Constructs a new filler that may grow vertically.
	*
	* @return		the ULCFiller that may grow vertically
	**/
	 public  static com.ulcjava.base.application.ULCFiller createVerticalGlue()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCFillerDispatcher extends ULCComponentDispatcher
{


}
}