package com.ulcjava.base.application;


	/**
	* <code>ULCFrame</code> is the basic ULC window component, used for normal
	* windows.
<p>
</p>
<b>Features</b>
<ul>
<li>A <code>ULCFrame</code> can
	* containonly one top-level component. Use layout widgets to place and arrange
	* more than one component.
In addition to the contained component, a menu bar
	* can be set on the frame.
<li>Define the closing strategy, i.e., the operation
	* that is triggered when <code>ULCFrame</code> is closed by the user. The
	* method<code>setDefaultCloseOperation()</code> can take one of the following
	* arguments: <code>DO_NOTHING_ON_CLOSE</code>,
<code>HIDE_ON_CLOSE</code>,
	* <code>DISPOSE_ON_CLOSE</code> and <code>TERMINATE_ON_CLOSE</code>.
<li>An
	* application can register a window listener that is notified when a user
	* closesthe window.
<li><code>ULCFrame</code> returns an array of all frames of
	* an application instance.
</ul>
<b>Examples</b>
<p>
</p>
To add more than one
	* widget to the frame, add a layout container that acts as a container for the
	* child components.
<p>
</p>

<pre>
ULCBoxPane box = new
	* ULCBoxPane();
box.add(button);
// ... add more
	* components
fFrame.add(box);
</pre>

<p>
</p>
To add a menu
	* bar:
<p>
</p>

<pre>
ULCMenuBar menuBar = new ULCMenuBar();
menuBar.add(new
	* ULCMenu());
// ... add more
	* menus
fFrame.setMenuBar(menuBar);
</pre>

<p>
</p>The following code snippet
	* shows how to handle a close window request in the application itself.
	* Typically, an application would display
a confirmation alert asking the user
	* whether he really wishes to quit the application. Depending on the user's
	* feedback, the application
would terminate or continue to
	* run.
<p>
</p>

<pre>
fFrame.setDefaultCloseOperation(ULCFrame.DO_NOTHING_ON_CLO
	* SE);
fFrame.addWindowListener(new IWindowListener() {
public void
	* windowClosing(WindowEvent event) {
openConfirmationDialog();
}
});
</pre>

To
	* get all frames of the application the following method can be
	* called:

<pre>
ULCFrame[] allFrames = ULCFrame.getFrames();
</pre>
	*
	* @ulc.application		
	* @see		ULCDialog
	* @see		ULCAlert
	* @see		ULCBoxPane
	* @see		com.ulcjava.base.application.event.WindowEvent
	* @see		ULCWindow#addWindowListener
	**/
 public class ULCFrame extends com.ulcjava.base.application.ULCWindow
{

	/**
	* The flag for the defaultCloseOperation for terminating the application on
	* window closing.
	*
	**/
	 public  final  static int TERMINATE_ON_CLOSE = 0;

	/**
	* Frame is in the "normal" extended state (i.e., not extended or iconized).
	*
	* @see		#getExtendedState
	* @see		#setExtendedState(int)
	**/
	 public  final  static int NORMAL = 0;

	/**
	* Frame is iconified.
	*
	* @see		#getExtendedState
	* @see		#setExtendedState(int)
	**/
	 public  final  static int ICONIFIED = 0;

	/**
	* Frame is maximized in the horizontal direction.
	*
	* @see		#getExtendedState
	* @see		#setExtendedState(int)
	**/
	 public  final  static int MAXIMIZED_HORIZONTAL = 0;

	/**
	* Frame is maximized in the vertical direction.
	*
	* @see		#getExtendedState
	* @see		#setExtendedState(int)
	**/
	 public  final  static int MAXIMIZED_VERTICAL = 0;

	/**
	* Frame is fully maximized (both horizontally and vertically). This is
	* equivalentto
<code>MAXIMIZED_VERTICAL&nbsp;|&nbsp;MAXIMIZED_HORIZONTAL</code>.
	*
	* @see		#getExtendedState
	* @see		#setExtendedState(int)
	**/
	 public  final  static int MAXIMIZED_BOTH = 0;


	/**
	* Constructs a new, initially invisible <code>Frame</code>.
	*
	* @see		ULCWindow#setVisible
	**/
	 public ULCFrame()
	{
		 super();
	}


	/**
	* Creates a new, initially invisible <code>Frame</code> with the specified title.
	*
	* @param title 		 the title for the frame
	* @see		ULCWindow#setVisible
	**/
	 public ULCFrame(java.lang.String title)
	{
		 super();
	}


	/**
	* Returns all frames for an application instance in an array.
	*
	* @return		an array of frames for an application instance
	**/
	 public  static com.ulcjava.base.application.ULCFrame[] getFrames()
	{
		return null;
	}


	/**
	* Returns the image to be displayed as the minimized icon for this frame.
	*
	* @return		the icon image for this frame, or <code>null</code> if this frame doesn't have an icon image.
	* @see		#setIconImage
	**/
	 public com.ulcjava.base.application.util.ULCIcon getIconImage()
	{
		return null;
	}


	/**
	* Returns true if this window can be resized by the user. By default, all
	* windowsare resizable.
	*
	* @return		<code>true</code> if the user can resize this window; <code>false</code> otherwise.
	* @see		#setResizable
	**/
	 public boolean isResizable()
	{
		return false;
	}


	/**
	* Sets whether this window's size can be changed by the user.
	*
	* @param resizable 		 <code>true</code> if this frame is resizable; <code>false</code> otherwise.
	* @see		#isResizable
	**/
	 public void setResizable(boolean resizable)
	{
	}


	/**
	* Returns the extended state of this frame. The state is represented as a
	* bitwisemask.
<ul>
<li><code>NORMAL</code>: Frame is in normal state, i.e.,
	* neither extended nor iconified.</li>
<li><code>ICONIFIED</code>: Frame is
	* iconified.</li>
<li><code>MAXIMIZED_HORIZONTAL</code>: Frame is maximized
	* horizontally.</li>
<li><code>MAXIMIZED_VERTICAL</code>: Frame is maximized
	* vertically.</li>
<li><code>MAXIMIZED_BOTH</code>: Frame is maximized both
	* horizontally and vertically.</li>
</ul>
	*
	* @return		the extended state as a bitwise mask
	* @see		#setExtendedState(int)
	**/
	 public int getExtendedState()
	{
		return 0;
	}


	/**
	* Sets the extended state of this frame. The state is represented as a bitwise
	* mask.
<ul>
<li><code>NORMAL</code>: Frame is in normal state, i.e., neither
	* extended nor iconified.</li>
<li><code>ICONIFIED</code>: Frame is
	* iconified.</li>
<li><code>MAXIMIZED_HORIZONTAL</code>: Frame is maximized
	* horizontally.</li>
<li><code>MAXIMIZED_VERTICAL</code>: Frame is maximized
	* vertically.</li>
<li><code>MAXIMIZED_BOTH</code>: Frame is maximized both
	* horizontally and vertically.</li>
</ul>
<p>
Note that setting a state not
	* supported on a given client platform is silently ignored.
</p>
	*
	* @param extendedState 		 a bitwise mask of frame state constants
	* @see		#getExtendedState
	**/
	 public void setExtendedState(int extendedState)
	{
	}

	 protected void updateExtendedState(int extendedState)
	{
	}


	/**
	* Returns true if the frame is undecorated, false otherwise.
	*
	* @return		the undecorated flag
	**/
	 public boolean isUndecorated()
	{
		return false;
	}


	/**
	* Sets the undecorated property to disable or enable decorations for this frame.
	* This property can only be set while the frame is not
displayable.
	*
	* @param undecorated 		 <code>true</code> if no frame decorations are to be enabled, <code>false</code> otherwise.
	* @throws		IllegalStateException if the frame is displayable.
	* @see		#isUndecorated
	* @see		ULCWindow#isDisplayable
	**/
	 public void setUndecorated(boolean undecorated)
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* For backward compatibility with Anything keys used in deprecated {@link
	* com.ulcjava.base.client.UIProxy#createBasicObject(Anything)}
	*
	* @ulc.extension		
	**/
	 protected void saveState(com.ulcjava.base.shared.internal.Anything a)
	{
	}


	/**
	* Sets the image to displayed as the minimized icon for this frame. Not all
	* platforms support minimizing of a window.
	*
	* @param image 		 the icon image to be displayed. If this parameter is <code>null</code> then the icon image is set to the default
image, which depends on the platform.
	* @see		#getIconImage
	**/
	 public void setIconImage(com.ulcjava.base.application.util.ULCIcon image)
	{
	}


	/**
	* Choose what should happen when the user closes this frame. The following
	* options are available:
<p>
</p>
<ul>
<li><code>DO_NOTHING_ON_CLOSE</code>
	* (defined in <code>IWindowConstants</code>): Ignore the event; requires the
	* program to
handle the operation in the <code>windowClosing()</code> method of
	* a registered <code>IWindowListener</code>
	* object.
<p>
</p>
<li><code>HIDE_ON_CLOSE</code> (defined in
	* <code>IWindowConstants</code>): Hide the frame, then notify all
	* registered
<code>IWindowListener</code>
	* objects.
<p>
</p>
<li><code>DISPOSE_ON_CLOSE</code> (defined in
	* <code>IWindowConstants</code>): Hide and dispose the frame, then notify
	* all
registered <code>IWindowListener</code>
	* objects.
<p>
</p>
<li><code>TERMINATE_ON_CLOSE</code> (defined in
	* <code>ULCFrame</code>): Terminate the application. Use this only
	* in
applications.
</ul>
<p>
</p>
The value is set to
	* <code>HIDE_ON_CLOSE</code>by default.
	*
	* @param operation 		 the default close operation
	* @see		ULCWindow#addWindowListener
	* @see		#getDefaultCloseOperation
	* @see		com.ulcjava.base.shared.IWindowConstants
	**/
	 public void setDefaultCloseOperation(int operation)
	{
	}


	/**
	* Returns the operation performed when the user closes this window.
	*
	* @return		an integer indicating the window-close operation
	* @see		#setDefaultCloseOperation
	**/
	 public int getDefaultCloseOperation()
	{
		return 0;
	}


	/**
	* Returns the frame's title.
	*
	* @return		the title of this frame, or an empty string ("") if this frame doesn't have a title.
	* @see		#setTitle
	**/
	 public java.lang.String getTitle()
	{
		return null;
	}


	/**
	* Sets the title for this frame.
	*
	* @param title 		 the title for this frame
	* @see		#getTitle
	**/
	 public void setTitle(java.lang.String title)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCFrameDispatcher extends ULCWindowDispatcher
{

	 public  final void updateExtendedState(int extendedState)
	{
	}


}
}