package com.ulcjava.base.application;


	/**
	* The <code>ULCGridLayoutPane</code> aligns widgets in a rectangular grid. The
	* container is divided into equal-sized rectangles, and one
component is placed
	* in each rectangle. ULC's <code>ULCGridLayoutPane</code> is analogous to
	* Swing's <code>GridLayout</code>.
<p>
</p>
<b>Features</b>
<p>
</p>
When both
	* the number of rows and the number of columns have been set to non-zero
	* values,either by a constructor or by the
<code>setRows()</code> and
	* <code>setColumns()</code> methods, the number of columns specified is
	* ignored.Instead, the number of
columns is determined from the specified
	* numberor rows and the total number of components in the layout. So, for
	* example, if three rows
and two columns have been specified and nine
	* componentsare added to the layout, then they will be displayed as three rows
	* of three
columns. Specifying the number of columns affects the layout only
	* when the number of rows is set to zero.
<p>
</p>
<b>Examples</b>
<p>
</p>
The
	* following code snippet shows how to add components to a
	* <code>ULCGridLayoutPane</code>, specifying that 3 components will be
	* added
perrow. All added buttons will be of the same
	* size.
<p>
</p>

<pre>
ULCGridLayoutPane gridLayoutPane = new
	* ULCGridLayoutPane(0, 3);
gridLayoutPane.add(new
	* ULCButton(&quot;1&quot;));
gridLayoutPane.add(new
	* ULCButton(&quot;2&quot;));
gridLayoutPane.add(new
	* ULCButton(&quot;3&quot;));
gridLayoutPane.add(new
	* ULCButton(&quot;4&quot;));
gridLayoutPane.add(new
	* ULCButton(&quot;5&quot;));
gridLayoutPane.add(new
	* ULCButton(&quot;6&quot;));
</pre>
	*
	* @ulc.application		
	**/
 public class ULCGridLayoutPane extends com.ulcjava.base.application.ULCContainer implements com.ulcjava.base.shared.IDefaults
{


	/**
	* Creates a new <code>ULCGridLayoutPane</code> instance with a default of one
	* column per component, in a single row.
	*
	**/
	 public ULCGridLayoutPane()
	{
		 super();
	}


	/**
	* Creates a new <code>ULCGridLayoutPane</code> instance with the specified
	* numberof rows and columns. All components in the layout
are given equal
	* size.
<p>
</p>
One, but not both, of <code>rows</code> and
	* <code>columns</code> can be zero, which means that any number of objects can
	* be
placed in a row or in a column.
	*
	* @param rows 		 the rows, with the value zero meaning any number of rows
	* @param columns 		 the columns, with the value zero meaning any number of columns
	* @throws		IllegalArgumentException thrown if the values of <code>rows</code> and <code>columns</code> are both zero
	**/
	 public ULCGridLayoutPane(int rows, int columns)
	{
		 super();
	}


	/**
	* Creates a new <code>ULCGridLayoutPane</code> instance with the specified
	* numberof rows and columns and vertical and horizontal
gap. All components in
	* the layout are given equal size.
	*
	* @param rows 		 the rows, with the value zero meaning any number of rows
	* @param columns 		 the columns, with the value zero meaning any number of columns
	* @param hgap 		 the horizontal gap
	* @param vgap 		 the vertical gap
	* @throws		IllegalArgumentException thrown if the values of <code>rows</code> and <code>columns</code> are both zero
	**/
	 public ULCGridLayoutPane(int rows, int columns, int hgap, int vgap)
	{
		 super();
	}


	/**
	* Adds a component to the container at the position given by index.
	*
	* @param component 		 the component to be added
	* @param index 		 the position where to add the component
	* @return		the component argument
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, int index)
	{
		return null;
	}


	/**
	* Adds a component to the container with the specified constraints.
	*
	* @param component 		 the content.
	* @param constraints 		 the constraints, must be an Integer.
	* @return		the component argument.
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, java.lang.Object constraints)
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* For backward compatibility with Anything keys used in deprecated {@link
	* com.ulcjava.base.client.UIProxy#createBasicObject(Anything)}
	*
	* @ulc.extension		
	**/
	 protected void saveState(com.ulcjava.base.shared.internal.Anything a)
	{
	}


	/**
	* Returns the horizontal gap.
	*
	* @return		the horizontal gap
	**/
	 public int getHgap()
	{
		return 0;
	}


	/**
	* Set the horizontal gap.
	*
	* @param hgap 		 an int value specifying the horizontal gap.
	**/
	 public void setHgap(int hgap)
	{
	}


	/**
	* Returns the vertical gap.
	*
	* @return		the vertical gap
	**/
	 public int getVgap()
	{
		return 0;
	}


	/**
	* Set the vertical gap.
	*
	* @param vgap 		 an int value specifying the vertical gap.
	**/
	 public void setVgap(int vgap)
	{
	}


	/**
	* Gets the number of rows in this pane.
	*
	* @return		the number of rows in this pane
	**/
	 public int getRows()
	{
		return 0;
	}


	/**
	* Sets the number of rows in this pane to the specified value.
	*
	* @param rows 		 the number of rows in this pane
	* @throws		IllegalArgumentException thrown if the values of <code>rows</code> and <code>columns</code> are both zero
	**/
	 public void setRows(int rows)
	{
	}


	/**
	* Gets the number of columns in this pane.
	*
	* @return		the number of columns in this pane
	**/
	 public int getColumns()
	{
		return 0;
	}


	/**
	* Gets the number of columns in this pane.
	*
	* @return		the number of columns in this pane
	* @deprecated		Use {@link #getColumns()} instead.
	**/
	 public int getCols()
	{
		return 0;
	}


	/**
	* Sets the number of columns in this pane to the specified value. Setting the
	* number of columns has no affect on the pane if the number
of rows specified
	* bya constructor or by the <tt>setRows</tt> method is non-zero. In that case,
	* the number of columns displayed in
the layout is determined by the total
	* number of components and the number of rows specified.
	*
	* @param columns 		 the number of columns in this layout
	* @throws		IllegalArgumentException thrown if the values of <code>rows</code> and <code>cols</code> are both zero
	**/
	 public void setColumns(int columns)
	{
	}


	/**
	* Sets the number of columns in this pane to the specified value. Setting the
	* number of columns has no affect on the pane if the number
of rows specified
	* bya constructor or by the <tt>setRows</tt> method is non-zero. In that case,
	* the number of columns displayed in
the layout is determined by the total
	* number of components and the number of rows specified.
	*
	* @param cols 		 the number of columns in this layout
	* @throws		IllegalArgumentException thrown if the values of <code>rows</code> and <code>cols</code> are both zero
	* @deprecated		Use {@link #setColumns(int)} instead.
	**/
	 public void setCols(int cols)
	{
	}

	 protected java.lang.Object createDefaultConstraints(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}

	 protected int convertToIndex(java.lang.Object constraints)
	{
		return 0;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCGridLayoutPaneDispatcher extends ULCContainerDispatcher
{


}
}