package com.ulcjava.base.application;


	/**
	* <code>ULCInternalFrame</code> - together with <code>ULCDesktopPane</code> -
	* canbe used to build sophisticated multiple document
interface (MDI) user
	* interfaces.
<p>
</p>
<b>Features</b>
<ul>
<li>Like <code>ULCFrame</code>, a
	* <code>ULCInternalFrame</code> instance contains one ULC component. ULC layout
	* components must be
used to add multiple components. A menu bar for each
	* <code>ULCInternalFrame</code> can be specified.
<li>In addition to changing
	* the usual visual attributes, a <code>ULCInternalFrame</code> can be brought
	* tothe foreground or sent to
the background.
<li>Offers a <code>pack</code>
	* method which initiates the layout of the components according to the
	* preferredsize and layouts of the
contained
	* components.
</ul>
<b>Examples</b>
<p>
</p>
The following example shows how to
	* create and configure a <code>ULCInternalFrame</code>
	* instance.

<pre>
ULCInternalFrame internalFrame = new
	* ULCInternalFrame(&quot;Internal Frame&quot;);
internalFrame
.setFrameIcon(new
	* ULCIcon(getClass().getResource(&quot;/icon.gif&quot;)));
internalFrame.setResiz
	* able(true);
internalFrame.setIconifiable(true);
ULCBoxPane contentBox = new
	* ULCBoxPane();
contentBox.add(new ULCLabel(&quot;Content&quot;));
// ... add
	* child components
internalFrame.add(contentBox);
</pre>
	*
	* @ulc.application		
	* @see		ULCDesktopPane
	**/
 public class ULCInternalFrame extends com.ulcjava.base.application.ULCRootPane implements com.ulcjava.base.shared.IWindowConstants
{


	/**
	* Creates a non-resizable, non-closable, non-maximizable, non-iconifiable
	* <code>ULCInternalFrame</code> without title.
	*
	**/
	 public ULCInternalFrame()
	{
		 super();
	}


	/**
	* Creates a non-resizable, non-closable, non-maximizable, non-iconifiable
	* <code>ULCInternalFrame</code> with the specified title.
	*
	* @param title 		 the <code>String</code> to display in the title bar
	**/
	 public ULCInternalFrame(java.lang.String title)
	{
		 super();
	}


	/**
	* Creates a non-closable, non-maximizable, non-iconifiable
	* <code>ULCInternalFrame</code> with the specified title and with
resizability
	* specified.
	*
	* @param title 		 the <code>String</code> to display in the title bar
	* @param resizable 		 if true, the frame can be resized
	**/
	 public ULCInternalFrame(java.lang.String title, boolean resizable)
	{
		 super();
	}


	/**
	* Creates a non-maximizable, non-iconifiable <code>ULCInternalFrame</code> with
	* the specified title and with the specified
resizability and closability.
	*
	* @param title 		 the <code>String</code> to display in the title bar
	* @param resizable 		 if true, the frame can be resized
	* @param closable 		 if true, the frame can be closed
	**/
	 public ULCInternalFrame(java.lang.String title, boolean resizable, boolean closable)
	{
		 super();
	}


	/**
	* Creates a non-iconifiable <code>ULCInternalFrame</code> with the specified
	* title and with the specified resizability, closability,
and maximizability.
	*
	* @param title 		 the <code>String</code> to display in the title bar
	* @param resizable 		 if true, the frame can be resized
	* @param closable 		 if true, the frame can be closed
	* @param maximizable 		 if true, the frame can be maximized
	**/
	 public ULCInternalFrame(java.lang.String title, boolean resizable, boolean closable, boolean maximizable)
	{
		 super();
	}


	/**
	* Creates a <code>ULCInternalFrame</code> with the specified title and with the
	* specified resizability, closability, maximizability,
and iconifiability.
	*
	* @param title 		 the <code>String</code> to display in the title bar
	* @param resizable 		 if true, the frame can be resized
	* @param closable 		 if true, the frame can be closed
	* @param maximizable 		 if true, the frame can be maximized
	* @param iconifiable 		 if true, the frame can be iconified
	**/
	 public ULCInternalFrame(java.lang.String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable)
	{
		 super();
	}


	/**
	* Returns the icon displayed in the title bar of the frame (usually in the
	* top-left corner).
	*
	* @return		the icon displayed in the title bar
	* @see		#setFrameIcon
	**/
	 public com.ulcjava.base.application.util.ULCIcon getFrameIcon()
	{
		return null;
	}


	/**
	* Returns the title of the <code>ULCInternalFrame</code>.
	*
	* @return		the frame's title as a <code>String</code>
	* @see		#setTitle
	**/
	 public java.lang.String getTitle()
	{
		return null;
	}


	/**
	* Returns whether this <code>ULCInternalFrame</code> be closed by the user.
	*
	* @return		true if the frame can be closed by the user
	**/
	 public boolean isClosable()
	{
		return false;
	}


	/**
	* Returns whether the <code>ULCInternalFrame</code> can be iconified by the user.
	*
	* @return		true if the frame can be iconified by the user
	**/
	 public boolean isIconifiable()
	{
		return false;
	}


	/**
	* Returns whether the <code>ULCInternalFrame</code> is currently iconified.
	*
	* @return		true if the frame is iconified
	**/
	 public boolean isIcon()
	{
		return false;
	}


	/**
	* Returns whether the <code>ULCInternalFrame</code> can be maximized by the user.
	*
	* @return		true if the frame can be maximized by the user
	**/
	 public boolean isMaximizable()
	{
		return false;
	}


	/**
	* Returns whether the <code>ULCInternalFrame</code> is currently maximized.
	*
	* @return		true if the frame is maximized
	**/
	 public boolean isMaximum()
	{
		return false;
	}


	/**
	* Returns whether the <code>ULCInternalFrame</code> can be resized by the user.
	*
	* @return		true if the frame can be resized by the user
	**/
	 public boolean isResizable()
	{
		return false;
	}


	/**
	* Moves this component to the back of its layer.
<p>
</p>
<b>Note:</b> Calling
	* this method before the widget has been uploaded has no effect.
	*
	**/
	 public void moveToBack()
	{
	}


	/**
	* Moves this component to the front of its layer.
<p>
</p>
<b>Note:</b> Calling
	* this method before the widget has been uploaded has no effect.
	*
	**/
	 public void moveToFront()
	{
	}


	/**
	* Returns <code>true</code> because all Internal Frames must be roots of a focus
	* traversal cycle.
	*
	* @see		ULCComponent#setFocusCycleRoot
	**/
	 public  final boolean isFocusCycleRoot()
	{
		return false;
	}


	/**
	* Initiates the layout of the components in this window according to the
	* preferred size and layouts of the contained components.
	*
	**/
	 public void pack()
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* Moves and resizes this component. The new location of the top-left corner is
	* specified by <code>x</code> and <code>y</code>, and
the new size is specified
	* by <code>width</code> and <code>height</code>.
	*
	* @param x 		 The new <i>x</i>-coordinate of this component.
	* @param y 		 The new <i>y</i>-coordinate of this component.
	* @param width 		 The new <code>width</code> of this component.
	* @param height 		 The new <code>height</code> of this component.
	**/
	 public void setBounds(int x, int y, int width, int height)
	{
	}


	/**
	* Sets that this <code>ULCInternalFrame</code> can be closed by the user.
	*
	* @param closable 		 a boolean value, where true means the frame can be closed by the user
	**/
	 public void setClosable(boolean closable)
	{
	}


	/**
	* Sets an icon to be displayed in the titlebar of the frame (usually in the
	* top-left corner). This icon is not the
<code>desktopIcon</code> object, which
	* is the icon displayed in the ULCDesktopPane when the frame is
	* iconified.
<p>
</p>
Passing null to this function is valid, but the L&F can
	* choose the appropriate behavior for that situation, such as displaying
	* no
iconor a default icon for the L&F.
	*
	* @param frameIcon 		 the icon to display in the title bar
	* @see		#getFrameIcon
	**/
	 public void setFrameIcon(com.ulcjava.base.application.util.ULCIcon frameIcon)
	{
	}


	/**
	* Sets that the <code>ULCInternalFrame</code> can be iconified by the user.
	*
	* @param iconifiable 		 true means that the frame can be iconified by the user
	**/
	 public void setIconifiable(boolean iconifiable)
	{
	}


	/**
	* Iconizes and de-iconizes the frame.
	*
	* @param icon 		 true means to iconify the frame and false means to de-iconify it
	**/
	 public void setIcon(boolean icon)
	{
	}


	/**
	* Sets the <code>ULCInternalFrame</code> title. <code>title</code> may have a
	* <code>null</code> value.
	*
	* @param title 		 the <code>String</code> to display in the title bar
	* @see		#getTitle
	**/
	 public void setTitle(java.lang.String title)
	{
	}


	/**
	* Sets that the <code>ULCInternalFrame</code> can be maximized by the user.
	*
	* @param maximizable 		 a boolean where true means the frame can be maximized by the user
	**/
	 public void setMaximizable(boolean maximizable)
	{
	}


	/**
	* Maximizes and restores the frame. A maximized frame is resized to fully fit
	* the<code>ULCDesktopPane</code> area associated with
this
	* <code>ULCInternalFrame</code>. A restored frame's size is set to the actual
	* size of the <code>ULCInternalFrame</code>.
	*
	* @param maximum 		 true maximizes the frame and false restores it
	**/
	 public void setMaximum(boolean maximum)
	{
	}


	/**
	* Sets that the <code>ULCInternalFrame</code> can be resized by the action.
	*
	* @param resizable 		 true means that the frame can be resized by the user
	**/
	 public void setResizable(boolean resizable)
	{
	}


	/**
	* Sets that the <code>ULCInternalFrame</code> can be selected by the action.
	*
	* @param selected 		 true means that the frame can be selected
	**/
	 public void setSelected(boolean selected)
	{
	}


	/**
	* Choose what should happen when the user closes this
	* <code>ULCInternalFrame</code>. The following options are
	* available:
<ul>
<li>DO_NOTHING_ON_CLOSE Ignore the event; requires the
	* programto handle the operation in the
	* <code>internalFrameClosing</code>
methodof a registered
	* <code>IInternalFrameListener</code> object.
<li>HIDE_ON_CLOSE Hide the window
	* after notifying all registered <code>IInternalFrameListener</code>
	* objects.
<li>DISPOSE_ON_CLOSE Hide and dispose the window after notifying all
	* registered <code>IInternalFrameListener</code> objects.
</ul>
<p>
</p>
The
	* value is set to HIDE_ON_CLOSE by default.
	*
	* @param defaultCloseOperation 		 the operation which will happen by default when the user initiates a "close" on this dialog
	* @see		#addInternalFrameListener
	* @see		#getDefaultCloseOperation
	**/
	 public void setDefaultCloseOperation(int defaultCloseOperation)
	{
	}


	/**
	* Returns the operation performed when the user closes this
	* <code>IInternalFrameListener</code>.
	*
	* @return		an integer indicating the window-close operation
	* @see		#setDefaultCloseOperation
	**/
	 public int getDefaultCloseOperation()
	{
		return 0;
	}

	 public void setVisible(boolean visible)
	{
	}


	/**
	* Adds the specified internal frame listener to receive internal frame events
	* from this internal frame.
	*
	* @param l 		 the internal frame listener
	**/
	 public void addInternalFrameListener(com.ulcjava.base.application.event.IInternalFrameListener l)
	{
	}


	/**
	* Returns an array of all the <code>IInternalFrameListener</code>s added to this
	* <code>ULCInternalFrame</code> with
<code>addInternalFrameListener()</code>.
	*
	* @return		all <code>IInternalFrameListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.IInternalFrameListener[] getInternalFrameListeners()
	{
		return null;
	}


	/**
	* Removes the specified internal frame listener so that it no longer receives
	* internal frame events from this internal frame.
	*
	* @param l 		 the internal frame listener
	**/
	 public void removeInternalFrameListener(com.ulcjava.base.application.event.IInternalFrameListener l)
	{
	}

	 protected void updateSelected(boolean selected)
	{
	}

	 protected void updateIcon(boolean icon)
	{
	}

	 protected void updateMaximum(boolean maximum)
	{
	}


	/**
	* Returns whether the ULCInternalFrame is the currently "selected" or active
	* frame.
	*
	* @return		true if the frame is currently selected (active)
	**/
	 public boolean isSelected()
	{
		return false;
	}


	/**
	* Brings this internal frame to the front.
<p>
</p>
<b>Note:</b> Calling this
	* method before the widget has been uploaded has no effect.
	*
	**/
	 public void toFront()
	{
	}


	/**
	* Sends this internal frame to the back.
<p>
</p>
<b>Note:</b> Calling this
	* method before the widget has been uploaded has no effect.
	*
	**/
	 public void toBack()
	{
	}


	/**
	* Returns the desktop pane for this internal frame.
	*
	* @return		the desktop pane for this internal frame
	**/
	 public com.ulcjava.base.application.ULCDesktopPane getDesktopPane()
	{
		return null;
	}


	/**
	* Dispose this internal frame by making it invisible, unselected, and closed.
	*
	* @see		#setVisible
	* @see		#setSelected
	**/
	 public void dispose()
	{
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}


	/**
	* Fires an internal frame closing event.
	*
	* @param internalFrameEvent 		 the internal frame event to be distributed to all listeners
	* @ulc.extension		
	**/
	 protected void fireInternalFrameClosing(com.ulcjava.base.application.event.InternalFrameEvent internalFrameEvent)
	{
	}


	/**
	* Creates an internal frame event.
<p>
</p>
<b>Note:</b> This method will be
	* called as part of a client-initiated event firing.
</p>
	*
	* @return		an internal frame event with this <code>ULCInternalFrame</code> object as the source, or null if no event should be fired
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.application.event.InternalFrameEvent createInternalFrameEvent()
	{
		return null;
	}


	/**
	* Dispatches an internal frame event to registered listeners via {@link
	* #dispatchEvent(String, String, java.util.EventObject)}.
Extension writers may
	* override this method to perform different or additional processing
	* actions.
<p>
</p>
<b>Note:</b> This method will be called as part of a
	* client-initiated event firing.
</p>
	*
	* @param eventCategory 		 the event category for dispatching ({@link UlcEventCategories#INTERNAL_FRAME_EVENT_CATEGORY})
	* @param listenerMethodName 		 the name of the listener method to which to dispatch
	* @param eventObject 		 the event to be dispatched
	* @ulc.extension		
	* @see		#dispatchEvent(String, String, java.util.EventObject)
	**/
	 protected void processInternalFrameEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.InternalFrameEvent eventObject)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* Get the listener class associated with the event category {@link
	* UlcEventCategories#INTERNAL_FRAME_EVENT_CATEGORY}.
	*
	* @return		The class object of {@link IInternalFrameListener}.
	* @ulc.extension		
	**/
	 protected java.lang.Class getInternalFrameListenerClass()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCInternalFrameDispatcher extends ULCRootPaneDispatcher
{

	 public  final void updateSelected(boolean selected)
	{
	}

	 public  final void updateIcon(boolean icon)
	{
	}

	 public  final void updateMaximum(boolean maximum)
	{
	}

	 public  final com.ulcjava.base.application.event.InternalFrameEvent createInternalFrameEvent()
	{
		return null;
	}

	 public  final void processInternalFrameEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.InternalFrameEvent eventObject)
	{
	}

	 public  final java.lang.Class getInternalFrameListenerClass()
	{
		return null;
	}


}
}