package com.ulcjava.base.application;


	/**
	* <code>ULCLayeredPane</code> provides depth to the container. For every
	* component, the layer and the position within the layer can be
specified.
	* Layerand position are defined by int. For layers the higher number also
	* specifies the higher layer. In contrast, the position
number is defined such
	* that 0 specifies the topmost position within a layer and -1 (or equivalently
	* the number of components in the layer -
1) specifies the bottommost
	* position.
<p>
</p>
<code>ULCLayeredPane</code> has no layout manager
	* associated with it. Every component must be laid out programmatically.
	* Therefore, the
bounds for every added component need to be
	* specified.
<p>
</p><code>ULCLayeredPane</code> is the super class for
	* <code>ULCDesktopPane</code>. For <code>ULCDesktopPane</code> it makes no
	* sensethat a layout manager rearranges the contained
	* <code>InternalFrame</code>s if the <code>ULCDesktopPane</code> gets
	* resized.
<p>
</p>
<b>Features</b>
<ul>
<li> Add components programmatically
	* specifying their position and size. No calculations by a layout manager.
<li>
	* Set layer and the position within the layer for a
	* component
</ul>
<p>
</p>
<b>Examples</b>
<p>
Adding components using
	* <code>ULCLayeredPane</code> is shown in the following
	* example:
<p>
<p>
</p>
Using the convenience
	* methods:
<p>
</p>

<pre>
ULCLayeredPane pane = new
	* ULCLayeredPane();
ULCButtonbutton1 = new ULCButton(&quot;layer one -
	* top&quot;);
pane.add(button1, 1, 2, new Rectangle(10, 10, 150,
	* 30));
ULCButtonbutton2 = new ULCButton(&quot;layer one -
	* bottom&quot;);
pane.add(button2, 1, new Rectangle(20, 50, 150,
	* 30));
</pre>

<p>
</p>
Using <code>setLayer()</code>:

<pre>
ULCButton
	* button3= new ULCButton(&quot;layer two &quot;);
pane.setLayer(button3,
	* 2);
pane.add(button3, new Rectangle(30, 70, 100, 30));
</pre>

The top-down
	* order of the added buttons corresponds with the index returned by
	* <code>ULCLayeredPane.getIndexOf()</code> starting with 0
as the topmost
	* index:<p>
<ul>
<li><code>button3</code> has index 0
<li><code>button1</code>
	* has index 1
<li><code>button2</code> has index 2
</ul>
The position of each
	* button is:
<p>
<ul>
<li>0 for <code>button3</code> in layer 2
<li>0 for
	* <code>button1</code> in layer 1
<li>1 for <code>button2</code> in layer 1
</ul>
	*
	* @ulc.application		
	* @see		ULCDesktopPane
	**/
 public class ULCLayeredPane extends com.ulcjava.base.application.ULCContainer
{

	/**
	* Defines the default layer. Equivalent to new Integer(0).
	*
	**/
	 public  final  static java.lang.Integer DEFAULT_LAYER = null;

	/**
	* Defines the palette layer. Equivalent to new Integer(100).
	*
	**/
	 public  final  static java.lang.Integer PALETTE_LAYER = null;

	/**
	* Defines the modal layer. Equivalent to new Integer(200).
	*
	**/
	 public  final  static java.lang.Integer MODAL_LAYER = null;

	/**
	* Defines the popup layer. Equivalent to new Integer(300).
	*
	**/
	 public  final  static java.lang.Integer POPUP_LAYER = null;

	/**
	* Defines the drag layer. Equivalent to new Integer(400).
	*
	**/
	 public  final  static java.lang.Integer DRAG_LAYER = null;


	/**
	* Adds a component with specified bounds. It is added to the default layer if no
	* setLayer method has been called. <b>Note:</b>The
bounds have to be specified
	* to show the added component.
	*
	* @param component 		 the component to be added
	* @param x 		 the x position in the layer
	* @param y 		 the y position in the layer
	* @param width 		 the width of the component
	* @param height 		 the height of the component
	* @return		the component to be added
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, int x, int y, int width, int height)
	{
		return null;
	}


	/**
	* Adds a component with specified bounds. It is added to the bottom of the
	* default layer or the layer specified with
	* <coed>setLayer()</code>.
<b>Note:</b>The bounds have to be specified to show
	* the added component.
	*
	* @param component 		 the component to be added.
	* @param bounds 		 the bounds of the component.
	* @return		the component to be added.
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, com.ulcjava.base.application.util.Rectangle bounds)
	{
		return null;
	}


	/**
	* Adds a component with specified bounds to the bottom of a specific layer.
	* <b>Note:</b>The bounds have to be specified to show the
added component.
	*
	* @param component 		 the component to be added
	* @param layer 		 the specified layer of the component
	* @param bounds 		 the bounds of the component
	* @return		the component to be added.
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, int layer, com.ulcjava.base.application.util.Rectangle bounds)
	{
		return null;
	}


	/**
	* Adds a component with specified bounds to a specified position of a specific
	* layer. <b>Note:</b>The bounds have to be specified to
show the added component.
	*
	* @param component 		 the component to be added.
	* @param layer 		 the specified layer of the component
	* @param position 		 the specified position of the component within the specified layer
	* @param bounds 		 the bounds of the component.
	* @return		the component to be added.
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, int layer, int position, com.ulcjava.base.application.util.Rectangle bounds)
	{
		return null;
	}


	/**
	* Adds a component with constraints. The constraints must be valid or the
	* component is added with null constraints. Valid constraints
are: - bounds as
	* an instance of com.ulcjava.base.application.util.Rectangle; - an Integer[]
	* containing the layer (Integer[0]) or/and
the position
	* (Integer[1])
<p>
</p>
<b>Note:</b> - The bounds have to be specified to show
	* the added component. - The use of this method is discouraged. Please use
	* one
of the convenience add methods.
	*
	* @param component 		 the component to be added.
	* @param constraints 		 the constraints of the component. Either an instance of com.ulcjava.base.application.util.Rectangle specifying the
bounds
	* @return		the component to be added.
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, java.lang.Object constraints)
	{
		return null;
	}

	 protected java.lang.Object createDefaultConstraints(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}

	 protected int convertToIndex(java.lang.Object constraints)
	{
		return 0;
	}


	/**
	* Gets the layer of a specific component. <b>Note:</b> Layer numbering is the
	* opposite of position numbering. Higher layer numbers are
closer to the top
	* andlower layer numbers are closer to the bottom.
	*
	* @param component 		 the component to check.
	* @return		an int which specifies the current layer of the component.
	**/
	 public int getLayer(com.ulcjava.base.application.ULCComponent component)
	{
		return 0;
	}


	/**
	* Puts the component at the bottom of a specific layer. <b>Note:</b> Layer
	* numbering is the opposite of position numbering. Higher
layer numbers are
	* closer to the top and lower layer numbers are closer to the bottom.
	*
	* @param component 		 the component to be put
	* @param layer 		 the specified layer where the component is put in.
	**/
	 public void setLayer(com.ulcjava.base.application.ULCComponent component, int layer)
	{
	}


	/**
	* Puts the component in a specific layer at a specific position. <b>Note:</b>
	* Layer numbering is the opposite of position numbering.
Higher layer numbers
	* are closer to the top and lower layer numbers are closer to the bottom.
	*
	* @param component 		 the component to be put
	* @param layer 		 the specified layer where the component is put in.
	* @param position 		 the specified position within the specified layer.
	**/
	 public void setLayer(com.ulcjava.base.application.ULCComponent component, int layer, int position)
	{
	}


	/**
	* Gets the position of a specified component within its current layer.
	* <b>Note:</b> Position numbering is the opposite of layer
numbering. Lower
	* position numbers are closer to the top and higher position numbers are closer
	* to the bottom.
	*
	* @param		component
	* @return		position of the component in the layer
	**/
	 public int getPosition(com.ulcjava.base.application.ULCComponent component)
	{
		return 0;
	}


	/**
	* Sets the position of a specified component in the current layer. 0 is the
	* topmost position and -1 the bottommost position in the
current layer.
	* <b>Note:</b> Position numbering is the opposite of layer numbering. Lower
	* position numbers are closer to the top and
higher position numbers are closer
	* to the bottom.
	*
	* @param component 		 the component to be set
	* @param position 		 the position on which the component is set
	**/
	 public void setPosition(com.ulcjava.base.application.ULCComponent component, int position)
	{
	}


	/**
	* Returns the first ULCLayeredPane that has the specified component.
	*
	* @param component 		 the ULCComponent for which to find the layered pane.
	* @return		the ULCLayeredPane that contains the component, or null if no ULCLayeredPane is found in the containment hierarchy
	**/
	 public  static com.ulcjava.base.application.ULCLayeredPane getLayeredPaneAbove(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Gets the number of components in a specific layer.
	*
	* @param layer 		 an int which specifies the layer.
	* @return		the number of components in the specified layer.
	**/
	 public int getComponentCountInLayer(int layer)
	{
		return 0;
	}


	/**
	* Gets the components in a specific layer.
	*
	* @param layer 		 an int which specifies the layer.
	* @return		the number of components in the specified layer.
	**/
	 public com.ulcjava.base.application.ULCComponent[] getComponentsInLayer(int layer)
	{
		return null;
	}


	/**
	* Gets the topmost layer of this container.
	*
	* @return		an int specifiing the highest layer
	**/
	 public int highestLayer()
	{
		return 0;
	}


	/**
	* Gets the bottommost layer of this container.
	*
	* @return		an int specifing the lowest layer
	**/
	 public int lowestLayer()
	{
		return 0;
	}


	/**
	* Moves the component to the topmost position of its current layer. The topmost
	* position always is 0.
	*
	* @param component 		 the component to be moved to the front
	**/
	 public void moveToFront(com.ulcjava.base.application.ULCComponent component)
	{
	}


	/**
	* Moves the component to the bottom most position of its current layer. This
	* corresponds to the number of components in the current
layer.
	*
	* @param component 		 the component to be moved to the back
	**/
	 public void moveToBack(com.ulcjava.base.application.ULCComponent component)
	{
	}


	/**
	* Returns the index of the specified component. This is the absolute index,
	* ignoring layers. The topmost component has the index 0,
like position. The
	* larger the index the closer to the bottom.
	*
	* @param component 		 the component to check.
	* @return		the index of the specified component.
	**/
	 public int getIndexOf(com.ulcjava.base.application.ULCComponent component)
	{
		return 0;
	}


	/**
	* 
	*
	* @deprecated		Use new-style object serialization/deserialization mechanism based on {@link com.ulcjava.base.shared.IStreamCoder}
to send custom objects between server and client instead. (See the
<a href="http://www.canoo.com/ulc/developerzone/ULCExtensionGuide.pdf">ULC Extension Guide</a> for more information.)
<p/>
<b>Note:</b> this implementation is still based on the deprecated constraints conversion mechanism for backward
compatibility. In order to install the new {@link com.ulcjava.base.shared.IStreamCoder}-based conversion mechanism
in a subclass of this container, overwrite this method and therein, invoke {@link #defaultInternalConvertFromConstraints(Object)}.
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.shared.internal.Anything internalConvertFromConstraints(com.ulcjava.base.application.ULCComponent component, java.lang.Object constraints)
	{
		return null;
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCLayeredPaneDispatcher extends ULCContainerDispatcher
{


}
}