package com.ulcjava.base.application;


	/**
	* The <code>ULCListSelectionModel</code> represents the current state of the
	* selection in a <code>ULCList</code>. This class is used
internally and all
	* theAPI is accessible via <code>ULCList</code> calls. What selections are
	* allowed is determined by the specified
selection
	* mode.
<p>
</p>
<b>Features</b>
<ul>
<li>The
	* <code>ULCListSelectionModel</code>provides a set of basic methods to
	* add/remove selected items and to obtain information
about the current
	* selection.</li>
<li>It can be used as an enabler for the other widgets. Its
	* state is enabling when the selection is not empty.</li>
<li>It supports three
	* selection modes:
<ul>
<li><code>SINGLE_SELECTION</code> - only one item can
	* beselected at a time, selecting a new one will clear the previous
	* selection.</li>
<li><code>SINGLE_INTERVAL_SELECTION</code> - the selection
	* range must be contiguous, i.e., there can't be any unselected items
	* between
any two selected items. When a change to the selection interval would
	* make it non-contiguous, necessary items are being deselected to
keep the
	* selection contiguous and consistent with the applied
	* change.</li>
<li><code>MULTIPLE_INTERVAL_SELECTION</code> - there is no
	* restriction on what can be
	* selected.</li>
</ul>
</ul>
<b>Examples</b>
<p>
</p>To enable a button only
	* when the list selection is not empty, use the following
	* code:

<pre>
button.setEnabler(list.getSelectionModel());
</pre>
	*
	* @ulc.application		
	* @see		ULCList
	* @see		ULCTable
	* @see		ULCTableTree
	**/
 public class ULCListSelectionModel extends com.ulcjava.base.application.ULCProxy implements com.ulcjava.base.application.enabler.IEnabler, com.ulcjava.base.application.enabler.IHasChangedSource
{

	/**
	* A value for the selectionMode property: select one list index at a time.
	*
	* @see		#setSelectionMode
	**/
	 public  final  static int SINGLE_SELECTION = 0;

	/**
	* A value for the selectionMode property: select one contiguous range of indices
	* at a time.
	*
	* @see		#setSelectionMode
	**/
	 public  final  static int SINGLE_INTERVAL_SELECTION = 0;

	/**
	* A value for the selectionMode property: select one or more contiguous ranges
	* ofindices at a time.
	*
	* @see		#setSelectionMode
	**/
	 public  final  static int MULTIPLE_INTERVAL_SELECTION = 0;

	 public ULCListSelectionModel()
	{
		 super();
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}

	 protected void updateSelection(int[][] selectionRanges)
	{
	}


	/**
	* Returns the number of selected indices.
	*
	* @return		the number of selected indices
	**/
	 public int getSelectedIndicesCount()
	{
		return 0;
	}


	/**
	* Returns the selected indices.
	*
	* @return		the selected indices.
	**/
	 public int[] getSelectedIndices()
	{
		return null;
	}


	/**
	* Add a listener to the list selection model that's notified each time the
	* selection changes.
	*
	* @param listener 		 the IListSelectionListener
	**/
	 public void addListSelectionListener(com.ulcjava.base.application.event.IListSelectionListener listener)
	{
	}


	/**
	* Change the selection to be the set union of the current selection and the
	* indices between index0 and index1 inclusive. If this
represents a change to
	* the current selection, then notify each IListSelectionListener. Note that
	* index0 doesn't have to be less than
or equal to index1.
	*
	* @param index0 		 one end of the interval.
	* @param index1 		 other end of the interval
	**/
	 public void addSelectionInterval(int index0, int index1)
	{
	}


	/**
	* Change the selection to the empty set. If this represents a change to the
	* current selection then notify each IListSelectionListener.
	*
	**/
	 public void clearSelection()
	{
	}


	/**
	* Returns an array of all the <code>IListSelectionListener</code>s added to this
	* <code>ULCListSelectionModel</code>
	* with
<code>addListSelectionListener()</code>.
	*
	* @return		all <code>IListSelectionListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.IListSelectionListener[] getListSelectionListeners()
	{
		return null;
	}


	/**
	* Returns the last selected index or -1 if the selection is empty.
	*
	* @return		the last selected index or -1.
	**/
	 public int getMaxSelectionIndex()
	{
		return 0;
	}


	/**
	* Returns the first selected index or -1 if the selection is empty.
	*
	* @return		the first selected index or -1
	**/
	 public int getMinSelectionIndex()
	{
		return 0;
	}


	/**
	* Returns the current selection mode.
	*
	* @return		The value of the selectionMode property.
	**/
	 public int getSelectionMode()
	{
		return 0;
	}


	/**
	* Insert length indices beginning before/after index. This is typically called
	* tosync the selection model with a corresponding change
in the data model.
	*
	* @param index 		 the index where to insert length indices
	* @param length 		 the length
	* @param beforeFlag 		 flag to insert before or after index
	**/
	 public void insertIndexInterval(int index, int length, boolean beforeFlag)
	{
	}


	/**
	* Returns true if the specified index is selected.
	*
	* @param index 		 the index to check for selection state
	* @return		true if the index is selected else false
	**/
	 public boolean isSelectedIndex(int index)
	{
		return false;
	}


	/**
	* Returns true if no indices are selected.
	*
	* @return		true if no indices are selected
	**/
	 public boolean isSelectionEmpty()
	{
		return false;
	}


	/**
	* Remove a listener from the list selection model.
	*
	* @param listener 		 the IListSelectionListener
	**/
	 public void removeListSelectionListener(com.ulcjava.base.application.event.IListSelectionListener listener)
	{
	}


	/**
	* Set the selection mode. The following selectionMode values are
	* allowed:
<ul>
<li> <code>SINGLE_SELECTION</code> Only one list index can be
	* selected at a time. In this mode the setSelectionInterval
	* and
addSelectionInterval methods are equivalent, and only the second index
	* argument is used.
<li> <code>SINGLE_INTERVAL_SELECTION</code> One contiguous
	* index interval can be selected at a time. In this mode
setSelectionInterval
	* and addSelectionInterval are equivalent.
<li>
	* <code>MULTIPLE_INTERVAL_SELECTION</code> In this mode, there's no restriction
	* on what can be selected.
</ul>
	*
	* @param selectionMode 		 the selection mode
	**/
	 public void setSelectionMode(int selectionMode)
	{
	}


	/**
	* Change the selection to be between index0 and index1 inclusive. If this
	* represents a change to the current selection, then notify
each
	* IListSelectionListener. Note that index0 doesn't have to be less than or
	* equalto index1.
	*
	* @param index0 		 one end of the interval.
	* @param index1 		 other end of the interval
	**/
	 public void setSelectionInterval(int index0, int index1)
	{
	}


	/**
	* Remove the indices in the interval index0,index1 (inclusive) from the
	* selectionmodel. This is typically called to sync the selection
model width a
	* corresponding change in the data model.
	*
	* @param index0 		 the interval start
	* @param index1 		 the interval end
	**/
	 public void removeIndexInterval(int index0, int index1)
	{
	}


	/**
	* Change the selection to be the set difference of the current selection and the
	* indices between index0 and index1 inclusive. If this
represents a change to
	* the current selection, then notify each ListSelectionListener. Note that
	* index0 doesn't have to be less than
or equal to index1.
	*
	* @param index0 		 one end of the interval.
	* @param index1 		 other end of the interval
	**/
	 public void removeSelectionInterval(int index0, int index1)
	{
	}


	/**
	* Fires a list selection changed event.
	*
	* @param listSelectionEvent 		 the list selection event to be distributed to all listeners
	* @ulc.extension		
	**/
	 protected void fireListSelectionChanged(com.ulcjava.base.application.event.ListSelectionEvent listSelectionEvent)
	{
	}


	/**
	* Creates a list selection event from the given arguments.
<p>
</p>
<b>Note:</b>
	* This method will be called as part of a client-initiated event firing.
</p>
	*
	* @param rangeStart 		 the range start of the list selection event
	* @param rangeEnd 		 the range end of the list selection event
	* @return		a list selection event with this <code>ULCListSelectionModel</code> object as the source, or null if no event should be
fired
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.application.event.ListSelectionEvent createListSelectionEvent(int rangeStart, int rangeEnd)
	{
		return null;
	}


	/**
	* Dispatches a list selection event to registered listeners via {@link
	* #dispatchEvent(String, String, java.util.EventObject)}.
Extension writers may
	* override this method to perform different or additional processing
	* actions.
<p>
</p>
<b>Note:</b> This method will be called as part of a
	* client-initiated event firing.
</p>
	*
	* @param eventCategory 		 the event category for dispatching ({@link UlcEventCategories#LIST_SELECTION_EVENT_CATEGORY})
	* @param listenerMethodName 		 the name of the listener method to which to dispatch
	* @param eventObject 		 the event to be dispatched
	* @ulc.extension		
	* @see		#dispatchEvent(String, String, java.util.EventObject)
	**/
	 protected void processListSelectionEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.ListSelectionEvent eventObject)
	{
	}


	/**
	* Get the listener class associated with the event category {@link
	* UlcEventCategories#LIST_SELECTION_EVENT_CATEGORY}.
	*
	* @return		The class object of {@link IListSelectionListener}.
	* @ulc.extension		
	**/
	 protected java.lang.Class getListSelectionListenerClass()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCListSelectionModelDispatcher extends ULCProxyDispatcher
{

	 public  final void updateSelection(int[][] selection)
	{
	}

	 public  final com.ulcjava.base.application.event.ListSelectionEvent createListSelectionEvent(int rangeStart, int rangeEnd)
	{
		return null;
	}

	 public  final void processListSelectionEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.ListSelectionEvent eventObject)
	{
	}

	 public  final java.lang.Class getListSelectionListenerClass()
	{
		return null;
	}


}
}