package com.ulcjava.base.application;


	/**
	* A <code>ULCMenuItem</code> represents a menu item. Each menu item is typically
	* associated with an action to be performed when that item
is
	* selected.
<p>
</p><b>Features</b>
<ul>
<li>The <code>ULCMenuItem</code>
	* component inherits all features from <code>ULCAbstractButton</code> and
	* <code>ULCComponent</code>
except for the possibility to set pop-up
	* menus.
<li><code>ULCMenu</code> offers a convenience method to add menu
	* items.When using this method, ULC implicitly creates
<code>ULCMenuItem</code>
	* objects. For more sophisticated configuration support, the developer has to
	* use the <code>ULCMenuItem</code>
class directly.
<li>To make a menu item
	* accessible from the keyboard, a <code>KeyStroke</code> object can be
	* specifiedon the menu item.
</ul>
<b>Examples</b>
<p>
</p>
The following
	* example shows how to configure <code>ULCMenuItems</code>.

<pre>
ULCMenuItem
	* menuItem = new ULCMenuItem(&quot;ULCMenuItem&quot;,
	* icon);
menuItem.setMnemonic('u');
menuItem.setAccelerator(KeyStroke.getKeyStrok
	* e('U', KeyEvent.CTRL_MASK,
true));
menuItem.addActionListener(new
	* IActionListener() {
public void actionPerformed(ActionEvent event)
	* {
System.out.println(&quot;menu item selected&quot;);
}
});
</pre>
	*
	* @ulc.application		
	* @see		ULCAbstractButton
	* @see		ULCComponent
	* @see		ULCMenu
	* @see		KeyStroke
	**/
 public class ULCMenuItem extends com.ulcjava.base.application.ULCAbstractButton
{


	/**
	* Creates an empty menuItem with no text or icon.
	*
	**/
	 public ULCMenuItem()
	{
		 super();
	}


	/**
	* Creates a menuItem with an icon.
	*
	* @param icon 		 the icon of the MenuItem.
	**/
	 public ULCMenuItem(com.ulcjava.base.application.util.ULCIcon icon)
	{
		 super();
	}


	/**
	* Creates a menuItem with text.
	*
	* @param text 		 the text of the MenuItem.
	**/
	 public ULCMenuItem(java.lang.String text)
	{
		 super();
	}


	/**
	* Creates a menu item with the supplied text and icon.
	*
	* @param text 		 the text of the MenuItem.
	* @param icon 		 the icon of the MenuItem.
	**/
	 public ULCMenuItem(java.lang.String text, com.ulcjava.base.application.util.ULCIcon icon)
	{
		 super();
	}


	/**
	* Creates a menuItem with the specified text and keyboard mnemonic.
	*
	* @param text 		 the text of the MenuItem.
	* @param mnemonic 		 the keyboard mnemonic for the MenuItem
	**/
	 public ULCMenuItem(java.lang.String text, int mnemonic)
	{
		 super();
	}


	/**
	* Create a menu item with the properties defined in the action object. The
	* actionis registered as action listener with the menu item.
	*
	* @param action 		 the action containing the menu item properties
	**/
	 public ULCMenuItem(com.ulcjava.base.application.IAction action)
	{
		 super();
	}


	/**
	* Returns the KeyStroke which serves as an accelerator for the menu item.
	*
	* @return		a KeyStroke object identifying the accelerator key
	**/
	 public com.ulcjava.base.application.util.KeyStroke getAccelerator()
	{
		return null;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* Sets the popup menu for this menuItem.
	*
	* @param popupMenu 		 the popup menu for this menuItem
	**/
	 public void setPopupMenu(com.ulcjava.base.application.ULCMenu popupMenu)
	{
	}


	/**
	* Set the KeyStroke which triggers the menu item's action directly.
	*
	* @param keyStroke 		 the KeyStroke which will serve as an accelerator
	**/
	 public void setAccelerator(com.ulcjava.base.application.util.KeyStroke keyStroke)
	{
	}

	 protected void uploadStateUI()
	{
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}

	 protected void configurePropertiesFromAction(com.ulcjava.base.application.IAction action)
	{
	}

	 protected java.beans.PropertyChangeListener createActionPropertyChangeListener(com.ulcjava.base.application.IAction action)
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCMenuItemDispatcher extends ULCAbstractButtonDispatcher
{


}
}