package com.ulcjava.base.application;


	/**
	* A <code>ULCPasswordField</code> allows the editing of a single line of text
	* where the component indicates keystrokes, but does not show
the original
	* characters.
<p>
</p>
<b>Features</b>
<ul>
<li>The
	* <code>ULCPasswordField</code> component inherits all features from
	* <code>ULCTextField</code> (except support
	* for
<code>IDataType</code>).
<li>Theecho character of a
	* <code>ULCPasswordField</code> can be specified by the
	* developer.
</ul>
<b>Examples</b>
<p>
</p>
The following example creates a
	* password field.

<pre>
ULCPasswordField passwordField = new
	* ULCPasswordField(&quot;password&quot;,
	* 20);
passwordField.setEchoChar('#');
</pre>
	*
	* @ulc.application		
	* @see		ULCTextField
	* @see		ULCTextComponent
	* @see		ULCComponent
	**/
 public class ULCPasswordField extends com.ulcjava.base.application.ULCTextField
{


	/**
	* Constructs a new password field. The initial text is null, and the number of
	* columns is set to 0.
	*
	**/
	 public ULCPasswordField()
	{
		 super();
	}


	/**
	* Constructs a new empty password field with the specified number of columns.
	* Theinitial string is set to null.
	*
	* @param columns 		 the number of columns >= 0
	**/
	 public ULCPasswordField(int columns)
	{
		 super();
	}


	/**
	* Constructs a new password field initialized with the specified text. The
	* numberof columns is set to 0.
	*
	* @param text 		 the text to be displayed, null if none
	**/
	 public ULCPasswordField(java.lang.String text)
	{
		 super();
	}


	/**
	* Constructs a new password field with initial <code>text</code> and
	* <code>columns</code>. If the Look and Fell does not define a derfault for the
	* echo character it is set to '*'.
	*
	* @param text 		 the text to be displayed, or null
	* @param columns 		 the number of columns for determining the preferred width. If columns is set to zero, the preferred width is left to
the component implementation.
	* @throws		IllegalArgumentException if columns < 0
	**/
	 public ULCPasswordField(java.lang.String text, int columns)
	{
		 super();
	}


	/**
	* This operation is not supported for ULCPasswordFields.
	*
	* @param datatype 		 the data type
	* @throws		UnsupportedOperationException always
	**/
	 public void setDataType(com.ulcjava.base.application.datatype.IDataType datatype)
	{
	}


	/**
	* Returns the character to used for echoing. The default is '*'.
	*
	* @return		the echo character, 0 if not set
	* @see		#setEchoChar
	* @see		#echoCharIsSet
	**/
	 public char getEchoChar()
	{
		return 'a';
	}


	/**
	* Sets the echo character for this password field.
<p>
</p>
<b>Note:</b> The
	* viewmay use any technique to obfuscate the contents of the field. Setting a
	* value of 0 unsets the echo character.
	*
	* @param c 		 the echo character to display
	* @see		#echoCharIsSet
	* @see		#getEchoChar
	**/
	 public void setEchoChar(char c)
	{
	}


	/**
	* Returns true if this password field uses a character for echoing. All
	* characters other than 0 may be used for echoing.
	*
	* @return		true if a character is set for echoing
	* @see		#setEchoChar
	* @see		#getEchoChar
	**/
	 public boolean echoCharIsSet()
	{
		return false;
	}


	/**
	* Returns the password text as an array of characters.
	*
	* @return		the password text as an array of characters.
	**/
	 public char[] getPassword()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCPasswordFieldDispatcher extends ULCTextFieldDispatcher
{


}
}