package com.ulcjava.base.application;


	/**
	* This utility class generates action events at requested times. It can be
	* configured to start after an initial delay and then to either
generate a
	* single event or generate events in a cyclic way, with configurable delay. Any
	* number of action listeners can register with a
timer instance.
<p>
</p>
Each
	* time an action event is fired on the client side, a server roundtrip will be
	* triggered. Hence the <code>ULCPollingTimer</code>
class can be used to poll
	* the server for data updates. By default, timer events are delivered
	* asynchronously, that is, user input is not
blocked during event
	* processing.
<p>
</p>
Note: Since all polling events are generated on the
	* client side, you have to make sure that not more requests are being produced
	* in one
time frame by the <code>ULCPollingTimer</code> than the server is able
	* to handle in the same time frame. If the server is overrun (that
is, if one
	* ormore new timer events are generated on the client side while the roundtrip
	* for the current event is still underway), timer
events may be skipped. More
	* precisely, if a repeating <code>ULCPollingTimer</code> has fired one or more
	* times by the time the current
server roundtrip finishes, a new roundtrip is
	* started immediately, but only one <code>ActionEvent</code> is transmitted,
	* irrespective
of how often the client-side timer expired. This situation
	* shouldbe avoided, since it saturates the server with requests and,
	* if
blockingevent delivery mode is selected, also effectively disables user
	* input.
<p>
</p>
<b>Features</b>
<ul>
<li>The <code>ULCPollingTimer</code>
	* generates a single or a series of action events after a specified initial
	* delay.
<li>The delay between subsequent events can be configured
	* separately.
<li>Any number of listeners can be added to a single
	* <code>ULCPollingTimer</code> via <code>addActionListener()</code>
	* call
</ul>
<b>Examples</b>
<p>
</p>
In the following example a label is
	* updateevery 60 seconds to display the current time.

<pre>
ULCPollingTimer
	* timer = new ULCPollingTimer(60000, new IActionListener() {
public void
	* actionPerformed(ActionEvent event) {
DateFormat timeFormat = new
	* SimpleDateFormat(&quot;hh:mm&quot;);
fLabel.setText(&quot;Current time:
	* &quot;+ timeFormat.format(new Date()));
}
});
timer.start();
</pre>
	*
	* @ulc.application		
	* @see		ActionEvent
	* @see		ULCProgressBar
	**/
 public class ULCPollingTimer extends com.ulcjava.base.application.ULCProxy
{


	/**
	* Constructs a timer object that will notify its listeners every <i>delay</i>
	* milliseconds. Unless changed via
{@link ULCProxy#setEventDeliveryMode(String,
	* int)}, action events emitted by this timer are delivered asynchronously.
	*
	* @param delay 		 The number of milliseconds between listener notification
	* @param listener 		 An initial listener
	* @see		#setInitialDelay
	* @see		#setRepeats
	**/
	 public ULCPollingTimer(int delay, com.ulcjava.base.application.event.IActionListener listener)
	{
		 super();
	}


	/**
	* Registers an actionListener with this polling timer.
	*
	* @param listener 		 the action listener to be added
	**/
	 public void addActionListener(com.ulcjava.base.application.event.IActionListener listener)
	{
	}


	/**
	* Returns an array of all the <code>IActionListener</code>s added to this
	* <code>ULCPollingTimer</code> with
<code>addActionListener()</code>.
	*
	* @return		all <code>IActionListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.IActionListener[] getActionListeners()
	{
		return null;
	}


	/**
	* Removes an ActionListener from the polling timer listeners list.
	*
	* @param listener 		 the action listener to be removed
	**/
	 public void removeActionListener(com.ulcjava.base.application.event.IActionListener listener)
	{
	}


	/**
	* Sets the polling timer's delay, the number of milliseconds between successive
	* <b>actionPerfomed()</b> messages to its listeners. If
the timer is currently
	* running, the change will take effect after the current timer period has
	* expired.
	*
	* @param delay 		 the polling timer's delay
	* @throws		IllegalArgumentException if the specified delay is < 0
	* @see		#setInitialDelay
	**/
	 public void setDelay(int delay)
	{
	}


	/**
	* Returns the polling timer's delay.
	*
	* @return		the polling timer's delay
	* @see		#setDelay
	**/
	 public int getDelay()
	{
		return 0;
	}


	/**
	* Sets the polling timer's initial delay. This will be used for the first
	* "ringing" of the polling timer only. Subsequent ringings will
be spaced using
	* the delay property. Note that if the timer is currently running, the change
	* will take effect only after a restart.
	*
	* @param initialDelay 		 the polling timer's initial delay
	* @throws		IllegalArgumentException if the specified initial delay is < 0
	* @see		#setDelay
	**/
	 public void setInitialDelay(int initialDelay)
	{
	}


	/**
	* Returns the polling timer's initial delay.
	*
	* @return		the polling timer's initial delay
	* @see		#setDelay
	**/
	 public int getInitialDelay()
	{
		return 0;
	}


	/**
	* If <b>repeats</b> is <b>false</b>, instructs the polling timer to send
	* <b>actionPerformed()</b> to its listeners only once, and
then stop.
	*
	* @param repeats 		 false if the polling timer sends actionPerformed only once, true otherwise
	**/
	 public void setRepeats(boolean repeats)
	{
	}


	/**
	* Returns <b>true</b> if the polling timer will send a <b>actionPerformed()</b>
	* message to its listeners multiple times.
	*
	* @return		false if the polling timer sends actionPerformed only once, true otherwise
	* @see		#setRepeats
	**/
	 public boolean isRepeats()
	{
		return false;
	}


	/**
	* If <b>syncClientState</b> is <b>false</b>, client state will not be
	* synchronized as part of an action event.
	*
	* @param syncClientState 		 false if client state will not be synchronized, true otherwise
	* @see		#isSyncClientState
	**/
	 public void setSyncClientState(boolean syncClientState)
	{
	}


	/**
	* Returns <b>false</b> if client state will not be synchronized as part of an
	* action event, <b>true</b> otherwise.
	*
	* @return		<b>false</b> if client state will not be synchronized, <b>true</b> otherwise
	* @see		#setSyncClientState
	**/
	 public boolean isSyncClientState()
	{
		return false;
	}


	/**
	* Returns if the polling timer is running or not.
	*
	* @return		true, if the polling timer is running, false otherwise
	**/
	 public boolean isRunning()
	{
		return false;
	}


	/**
	* Starts the polling timer, causing it to send <b>actionPerformed()</b> messages
	* to its listeners. If the timer is currently running,
this call has no effect.
	*
	* @see		#stop()
	**/
	 public void start()
	{
	}


	/**
	* Stops a polling timer, causing it to stop sending <b>actionPerformed()</b>
	* messages to its listeners. If the timer is not currently
running, this call
	* has no effect.
	*
	* @see		#start()
	**/
	 public void stop()
	{
	}


	/**
	* Restarts a polling timer, canceling any pending firings, and causing it to
	* firewith its initial delay. Calling this method is
equivalent to calling
	* {@link #stop()} followed by {@link #start()}, except that this method is
	* slightly more efficient.
	*
	**/
	 public void restart()
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}

	 protected void processActionEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.ActionEvent eventObject)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCPollingTimerDispatcher extends ULCProxyDispatcher
{


}
}