package com.ulcjava.base.application;


	/**
	* <code>ULCProxy</code> provides an abstract implementation for
	* proxies.
<p>
</p><code>ULCProxy</code> provides a set of methods that aid in
	* synchronizing server-side half object state (of ULC objects) with
	* client-side
half objects (of UI objects): <list> <li>The
	* <code>setStateUI(...)</code> methods assist in synchronizing a new property
	* value between
this ULC object and a corresponding client-side UI
	* half-object.</li> <li>The methods {@link #invokeUI(String)} and
{@link
	* #invokeUI(String,Object[])} serve in calling specific methods on the
	* client-side UI half object associated with this ULC
	* object.</li>
</list>
<p>
</p>
When marshalling property values or method
	* argument values using <code>setState(...)</code> or {@link
	* #invokeUI(String,Object[])}
respectively, to the client, these values are
	* tranformed into client-side objects according to certain (extendable)
	* conversion rules. The
conversion rules depend on the server-side runtime type
	* of a given property value or argument value only. By default, conversions
	* for
such values are as follows: <list> <li>Instances of the following classes
	* are marshalled as is:
	* <code>java.lang.Byte</code>,
<code>java.lang.Short</code>,
	* <code>java.lang.Integer</code>, <code>java.lang.Long</code>,
	* <code>java.lang.Float</code>,
<code>java.lang.Double</code>,
	* <code>java.lang.Boolean</code>, <code>java.lang.Character</code>,
	* <code>java.lang.String</code>,
<code>java.util.Date</code>,
	* <code>java.math.BigDecimal</code></li> <li>Instances of the following
	* container classes result in an
instance of the same class on the client side,
	* however contained objects are also subject to
	* conversion:
<code>com.ulcjava.base.shared.Anything</code>,
	* <code>java.util.HashMap</code>,
	* <code>java.util.LinkedList</code>,
<code>java.util.ArrayList</code> and all
	* array classes. <br>
<br>
<b>Note:</b> <list> <li>Ensure that your container
	* class is one of the following:
	* <code>java.util.ArrayList</code>,
<code>java.util.LinkedList</code>,
	* <code>java.util.Vector</code>, <code>java.util.HashSet</code>,
	* <code>java.util.TreeSet</code>,
<code>java.util.HashMap</code> or
	* <code>java.util.TreeMap</code>.</li> <li>Ensure that your container class can
	* be instantiated by
reflection, i.e., it is <code>public</code> and has a
	* <code>public</code> default constructor.</li> <li>For a custom container
	* classyou
will have to provide a
	* <code>com.ulcjava.base.shared.IStreamCoder</code>.</li> </list> </li>
	* <li>Instances of the following ULC value
classes are converted into their
	* AWT/Swing counterparts on the client side:
	* <code>com.ulcjava.base.application.util.Color</code>,
<code>com.ulcjava.base.ap
	* plication.util.Font</code>,
	* <code>com.ulcjava.base.application.util.KeyStroke</code>,
<code>com.ulcjava.bas
	* e.application.util.Point</code>,
	* <code>com.ulcjava.base.application.util.Rectangle</code>,
<code>com.ulcjava.bas
	* e.application.util.Insets</code></li> <li>Instances of <code>ULCProxy</code>
	* orany of its subclasses are converted
into their corresponding UI half object
	* counterparts. E.g., an instance of <code>ULCButton</code> is converted into
	* aninstance of
<code>UIButton</code>.</li> </list> By default, no instances of
	* other classes can be marshalled to the client.
	*
	* @ulc.application		
	* @see		com.ulcjava.base.shared.IStreamCoder
	**/
 public  abstract class ULCProxy extends java.lang.Object implements java.io.Serializable, com.ulcjava.base.server.IProxy, com.ulcjava.base.shared.ICallable
{


	/**
	* Constructs a new ULC object which represents a client-side UI half object. The
	* client side UI half object will be created when this
ULC object is uploaded.
	*
	* @ulc.extension		
	**/
	 protected ULCProxy()
	{
		 super();
	}

	 protected java.util.EventListener getDummyEventListener()
	{
		return null;
	}


	/**
	* Distributes an event to the listeners registered on this ULC object and for
	* theevent category to which this event belongs. The
correct event category is
	* obtained via <code>event.getCategory()</code>.
	*
	* @param event 		 the event to be distributed
	* @deprecated		Use new-style event delivery mechanism instead.
	* @ulc.extension		
	**/
	 protected void distributeToListeners(com.ulcjava.base.application.event.UlcEvent event)
	{
	}


	/**
	* Gets the listeners registered on this ULC object for a given event category.
	*
	* @param eventCategory 		 an ID which identifiers the event category
	* @return		the registered listeners
	* @deprecated		Use {@link #getListeners(String)} instead.
	* @ulc.extension		
	**/
	 protected java.util.EventListener[] getListeners(int eventCategory)
	{
		return null;
	}


	/**
	* Gets the listeners registered on this ULC object for a given event category.
	*
	* @param eventCategory 		 an ID which identifiers the event category
	* @return		the registered listeners
	* @ulc.extension		
	**/
	 protected  final java.util.EventListener[] getListeners(java.lang.String eventCategory)
	{
		return null;
	}


	/**
	* Gets the listeners registered on this ULC object for a given event category.
	* This method returns a listener array whose component
type is
	* <code>component</code>. Listeners registered for the given event category
	* willbe inserted in the returned array.
	*
	* @param eventCategory 		 an ID which identifies the event category
	* @param componentType 		 the component type of the array to be returned
	* @return		the registered listeners
	* @throws		ArrayStoreException if the type <code>component</code> is not a supertype of a registered listener object
	* @deprecated		Use {@link #getListeners(String, Class)} instead.
	* @ulc.extension		
	**/
	 protected java.util.EventListener[] getListeners(int eventCategory, java.lang.Class componentType)
	{
		return null;
	}


	/**
	* Gets the listeners registered on this ULC object for a given event category.
	* This method returns a listener array whose component
type is
	* <code>component</code>. Listeners registered for the given event category
	* willbe inserted in the returned array.
	*
	* @param eventCategory 		 the event category
	* @param componentType 		 the component type of the array to be returned
	* @return		the registered listeners
	* @throws		ArrayStoreException if the type <code>component</code> is not a supertype of a registered listener object
	* @ulc.extension		
	**/
	 protected  final java.util.EventListener[] getListeners(java.lang.String eventCategory, java.lang.Class componentType)
	{
		return null;
	}


	/**
	* Gets the listeners of a given type registered on this ULC object. This method
	* returns a listener array whose component type is
<code>component</code>.
	* Listeners of the given type registered on this object be inserted in the
	* returned array.
	*
	* @param componentType 		 the component type of the array to be returned
	* @return		the registered listeners
	* @throws		ArrayStoreException if the type <code>component</code> is not a supertype of a registered listener object
	* @ulc.extension		
	**/
	 public  final java.util.EventListener[] getListeners(java.lang.Class componentType)
	{
		return null;
	}


	/**
	* Enables the delivery of events of the given event category from the
	* client-sideUI half object associated with this ULC object. This
method
	* increases a counter which assists in deciding, if the corresponding
	* client-side event delivery mechanism should be disabled
when calling {@link
	* #disableOptionalEvent(int)}.
	*
	* @param		eventCategory
	* @ulc.internal		
	* @see		#disableOptionalEvent(int)
	* @deprecated		Use {@link #enableOptionalEvent(String)} instead.
	**/
	 protected void enableOptionalEvent(int eventCategory)
	{
	}


	/**
	* Enables the delivery of events of the given event category from the
	* client-sideUI half object associated with this ULC object.
	*
	* @param		eventCategory
	* @see		#disableOptionalEvent(int)
	* @ulc.internal		
	* @deprecated		Since ULC 6.2. Event delivery is enabled by {@link #addListener(String, EventListener)}
	**/
	 protected  final void enableOptionalEvent(java.lang.String eventCategory)
	{
	}


	/**
	* Decreases a counter, which decides, if events of the given event category
	* should be delivered from the client-side UI half-object
associated with this
	* ULC object. If the counter is zero, then the corresponding event delivery
	* mechanism will be disabled on the
client side.
	*
	* @param		eventCategory
	* @deprecated		Use {@link #disableOptionalEvent(String)} instead.
	* @ulc.internal		
	**/
	 protected void disableOptionalEvent(int eventCategory)
	{
	}


	/**
	* Called when there are no listeners for an event category or when there are no
	* registered key board actions. In the above cases the
corresponding event
	* delivery mechanism will be disabled on the client side.
	*
	* @param		eventCategory
	* @ulc.internal		
	* @deprecated		Since ULC 6.2. Event delivery for the specified category is disabled by {@link #removeListener(String, EventListener)}
when all its listeners have been removed.
	**/
	 protected  final void disableOptionalEvent(java.lang.String eventCategory)
	{
	}


	/**
	* Ensures that this ULC object cannot be garbage collected even though it is not
	* currently referenced by application objects on the
server side.
	*
	* @ulc.internal		
	**/
	 protected  final void markUncollectable()
	{
	}


	/**
	* Marks this ULC object as collectable so that it can be garbage collected in
	* case it is not referenced anymore by other live
server-side application
	* objects.
	*
	* @ulc.internal		
	**/
	 protected void handleMarkCollectable()
	{
	}


	/**
	* Gets a unique identifier of this ULC object.
	*
	* @ulc.extension		
	**/
	 public  final int getId()
	{
		return 0;
	}


	/**
	* Gets a reference ID of this ULC object in an <code>Anything</code> object.
	* After calling this method, this ULC object is considered
uploaded.
	*
	* @return		the <code>Anything</code> containing the reference ID.
	* @deprecated		Using the ULC 6.1 extension API, extension writers do not need this method anymore.
	* @ulc.extension		
	**/
	 public com.ulcjava.base.shared.internal.Anything getRef()
	{
		return null;
	}


	/**
	* Handles a request coming from the client-side UI half-object associated with
	* this ULC object. (Override this method to customize the
handling of
	* respectiverequests and include a call to this overriden method using
	* <code>super.handleRequest(...)</code>.)
<p>
</p>
Typically you would override
	* this method according to the following pattern, if you want to handle a
	* customrequest:
<p>
</p>

<pre>
public void handleRequest(String request,
	* Anything args) {
if (request.equals(&quot;myRequestName&quot;))
	* {
handleMyRequest(args);
} else {
super.handleRequest(request,
	* args);
}
}
</pre>
	*
	* @param request 		 the name of the request
	* @param args 		 the arguments of the request
	* @deprecated		Use new-style client-server communication mechanism via
{@link com.ulcjava.base.client.UIProxy#invokeULC(String, Object[])} instead.
	* @ulc.extension		
	**/
	 public void handleRequest(java.lang.String request, com.ulcjava.base.shared.internal.Anything args)
	{
	}


	/**
	* Handles an event coming from the client side UI half-object associated with
	* this ULC object. (Override this method to customize the
handling of
	* respectiveevents and include a call to this overriden method using
	* <code>super.handleEvent(...)</code>.)
<p>
</p>
Typically you would override
	* this method according to the following pattern, if you want to handle a
	* customevent of the type
<code>MyEvent</code>:
<p>
</p>

<pre>
protected void
	* handleEvent(int listenerType, int eventId, Anything args) {
if (listenerType
	* == MyEventConstants.MY_EVENT) {
distributeToListeners(new MyEvent(this,
	* eventId));
} else {
super.handleEvent(listenerType, eventId, args);
}
}
</pre>
	*
	* @param listenerType 		 an ID identifying the group of listeners registered for the type of events given by <code>eventId</code>
	* @param eventId 		 an ID, which identifies the type of event, it is used to dispatch the event to the appropriate listener method
	* @param args 		 the arguments describing the event coming from the client
	* @deprecated		Use new-style event delivery mechanism via {@link com.ulcjava.base.client.UIProxy#invokeULC(String, Object[])} instead.
	* @ulc.extension		
	**/
	 protected void handleEvent(int listenerType, int eventId, com.ulcjava.base.shared.internal.Anything args)
	{
	}


	/**
	* Adds a listener <code>listener</code> for an event category such that
	* corresponding events from the client side UI half-object
associated with this
	* ULC object will be delivered to the listener <code>listener</code>.
	*
	* @param eventCategory 		 an ID identifying the event category
	* @param listener 		 the listener to be added
	* @deprecated		Use {@link #addListener(String, EventListener)} instead.
	* @ulc.extension		
	**/
	 protected void internalAddListener(int eventCategory, java.util.EventListener listener)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected  final void addListener(java.lang.String eventCategory, java.util.EventListener listener)
	{
	}


	/**
	* Gets the session associated with this ULC object. A call to this method is
	* equivalent to <code>ULCSession.currentSession()</code>.
	*
	* @return		the current session
	* @ulc.extension		
	**/
	 protected  static com.ulcjava.base.server.ULCSession getSession()
	{
		return null;
	}


	/**
	* 
	*
	* @deprecated		Just pass in the KeyStroke object at the related position instead.
	* @ulc.extension		
	**/
	 protected  static com.ulcjava.base.shared.internal.Anything internalConvertFromKeyStroke(com.ulcjava.base.application.util.KeyStroke keyStroke)
	{
		return null;
	}


	/**
	* 
	*
	* @deprecated		Use {@link Anything#toObject()} instead.
	* @ulc.extension		
	**/
	 protected  static com.ulcjava.base.application.util.KeyStroke internalConvertToKeyStroke(com.ulcjava.base.shared.internal.Anything keyStroke)
	{
		return null;
	}


	/**
	* 
	*
	* @deprecated		Just pass in the Color object at the related position instead.
	* @ulc.extension		
	**/
	 protected  static com.ulcjava.base.shared.internal.Anything internalConvertFromColor(com.ulcjava.base.application.util.Color color)
	{
		return null;
	}


	/**
	* 
	*
	* @deprecated		Just pass in the Font object at the related position instead.
	* @ulc.extension		
	**/
	 protected  static com.ulcjava.base.shared.internal.Anything internalConvertFromFont(com.ulcjava.base.application.util.Font font)
	{
		return null;
	}


	/**
	* 
	*
	* @deprecated		Just pass in the Insets object at the related position instead.
	* @ulc.extension		
	**/
	 protected  static com.ulcjava.base.shared.internal.Anything internalConvertFromInsets(com.ulcjava.base.application.util.Insets insets)
	{
		return null;
	}


	/**
	* 
	*
	* @deprecated		Just pass in the Dimension object at the related position instead.
	* @ulc.extension		
	**/
	 protected  static com.ulcjava.base.shared.internal.Anything internalConvertFromDimension(com.ulcjava.base.application.util.Dimension dimension)
	{
		return null;
	}


	/**
	* Removes a listener <code>listener</code> which is registered on this ULC
	* objectfor a given event category. If no more listeners on
this ULC object are
	* registered for the given event category, then the client-side event sending
	* mechanism for corresponding events
will be disabled.
	*
	* @param eventCategory 		 an ID identifiying the event category
	* @param listener 		 the listener to be removed
	* @deprecated		Use {@link #removeListener(String, EventListener)} instead.
	* @ulc.extension		
	**/
	 protected void internalRemoveListener(int eventCategory, java.util.EventListener listener)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected  final void removeListener(java.lang.String eventCategory, java.util.EventListener listener)
	{
	}


	/**
	* Checks if this <code>ULCProxy</code> object has already been uploaded to the
	* client. The corresponding upload flag changes when
{@link #getRef()} is
	* calledfor the first time for this <code>ULCProxy</code> object.
	*
	* @return		<code>true</code> if the upload has happened, <code>false</code> otherwise.
	* @ulc.extension		
	**/
	 public  final boolean isUploaded()
	{
		return false;
	}


	/**
	* Saves the state of this proxy in the passed in <code>Anything</code> object. A
	* ULC proxy that needs to send state to the client side
may override this
	* methodto save its state in the <code>Anything</code> object and then call the
	* superclass implementation.
<p>
</p>
<b>Note</b>: With ULC 6.1, extension
	* writers should override the method {@link #uploadStateUI()} instead of this
	* one.
	*
	* @param a 		 the <code>Anything</code> object into which the state of this <code>ULCProxy</code> object should be saved
	* @deprecated		Use/override {@link #uploadStateUI()} instead.
	* @ulc.extension		
	**/
	 protected void saveState(com.ulcjava.base.shared.internal.Anything a)
	{
	}


	/**
	* Sends a request with no arguments to the client side. This method has no
	* effectif this <code>ULCProxy</code> object is not yet
uploaded.
	*
	* @param request 		 the name of the request
	* @deprecated		Use {@link #invokeUI(String)} instead.
	* @ulc.extension		
	**/
	 protected void sendUI(java.lang.String request)
	{
	}


	/**
	* Sends a request with an argument to the client side. The argument
	* <code>argument</code> will be wrapped in or converted into
	* an
<code>Anything</code> object before it is sent to the client. This method
	* has no effect if this <code>ULCProxy</code> object is not
yet
	* uploaded.
<p>
</p>
If <code>argument</code> is an instance of
	* <code>Anything</code>, it will be sent as is. If <code>argument</code> is an
	* instance of
<code>IProxy</code>, then the result of
	* <code>argument.getRef()</code> will be sent to the client. If
	* <code>argument</code> is an
instance of <code>Object[]</code>, the object
	* array is examined and every array element which is an instance of
	* <code>IProxy</code>
will be replaced by an <code>Anything</code> object
	* resulting from a corresponding <code>getRef()</code> call on
	* the
<code>IProxy</code> array element. The changed object array is wrapped in
	* an <code>Anything</code> object and sent to the client. For
any other runtime
	* types of <code>argument</code>, the corresponding the object his wrapped in
	* an<code>Anything</code> object and
sent to the client.
	*
	* @param request 		 the name of the request
	* @param argument 		 the argument of the request
	* @deprecated		Use {@link #invokeUI(String, Object[])} instead.
	* @ulc.extension		
	**/
	 protected void sendUI(java.lang.String request, java.lang.Object argument)
	{
	}


	/**
	* Returns the fully qualified class name for the client-side UI half object of
	* this proxy.
	*
	* @return		the fully qualified class name for the client-side UI half object of this proxy
	* @ulc.extension		
	**/
	 abstract  protected java.lang.String typeString();

	/**
	* Uploads this proxy to the client. This method does nothing if this ULC object
	* is already uploaded. Otherwise a description of this
ULC object is sent to
	* theclient in order to create a respective UI half-object there.
	*
	* @ulc.extension		
	**/
	 public  final void upload()
	{
	}


	/**
	* Resets the upload flag for this proxy.
	*
	* @ulc.internal		
	**/
	 public  final void resetUploaded()
	{
	}


	/**
	* Gets the event delivery mode for a certain event category on this ULC object.
	* The event delivery mode has to be one of the
	* following
values:
<ul>
<li>UlcEventConstants.SYNCHRONOUS_MODE</li>
<li>UlcEvent
	* Constants.ASYNCHRONOUS_MODE</li>
<li>UlcEventConstants.DEFERRED_MODE</li>
</ul>
	*
	* @param eventCategory 		 the ID of the event category
	* @return		the event delivery mode
	* @deprecated		Use {@link #getEventDeliveryMode(String)} instead.
	**/
	 public int getEventDeliveryMode(int eventCategory)
	{
		return 0;
	}


	/**
	* Gets the event delivery mode for a certain event category on this ULC object.
	* The event delivery mode has to be one of the
	* following
values:
<ul>
<li>UlcEventConstants.SYNCHRONOUS_MODE</li>
<li>UlcEvent
	* Constants.ASYNCHRONOUS_MODE</li>
<li>UlcEventConstants.DEFERRED_MODE</li>
</ul>
	*
	* @param eventCategory 		 the event category
	* @return		the event delivery mode
	**/
	 public  final int getEventDeliveryMode(java.lang.String eventCategory)
	{
		return 0;
	}


	/**
	* Returns the default event delivery mode for all events of this proxy. Override
	* this method, if you want to change the default
behaviour of a proxy. The
	* eventdelivery mode has to be one of the following
	* values:
<ul>
<li>UlcEventConstants.SYNCHRONOUS_MODE</li>
<li>UlcEventConstants.
	* ASYNCHRONOUS_MODE</li>
<li>UlcEventConstants.DEFERRED_MODE</li>
</ul>
<b>Note:
	* </b> You also must override {@link
	* com.ulcjava.base.client.UIProxy#getDefaultEventDeliveryMode() }.
	*
	* @return		UlcEventConstants.SYNCHRONOUS_MODE as default value for this proxy.
	**/
	 protected int getDefaultEventDeliveryMode()
	{
		return 0;
	}


	/**
	* Sets the delivery mode for a certain event category on this ULC object. The
	* event delivery mode is one of the following
	* values:*
<ul>
<li>UlcEventConstants.SYNCHRONOUS_MODE</li>
<li>UlcEventConstants
	* .ASYNCHRONOUS_MODE</li>
<li>UlcEventConstants.DEFERRED_MODE</li>
</ul>
	*
	* @param eventCategory 		 the ID of the event category
	* @param		mode
	* @deprecated		Use {@link #setEventDeliveryMode(String, int)} instead.
	**/
	 public void setEventDeliveryMode(int eventCategory, int mode)
	{
	}


	/**
	* Sets the delivery mode for a certain event category on this ULC object. The
	* event delivery mode is one of the following
	* values:
<ul>
<li>UlcEventConstants.SYNCHRONOUS_MODE</li>
<li>UlcEventConstants.
	* ASYNCHRONOUS_MODE</li>
<li>UlcEventConstants.DEFERRED_MODE</li>
</ul>
	*
	* @param eventCategory 		 the event category
	* @param		mode
	**/
	 public void setEventDeliveryMode(java.lang.String eventCategory, int mode)
	{
	}


	/**
	* Converts the given object into an <code>Anything</code> object.
	*
	* @param o 		 The <code>Object</code> which needs to be sent to the UI
	* @return		The Anything that represents the object
	* @deprecated		Just pass in the object at the related position instead.
	* @ulc.extension		
	**/
	 public  static com.ulcjava.base.shared.internal.Anything internalConvertFromObject(java.lang.Object o)
	{
		return null;
	}


	/**
	* Converts the given <code>Anything</code> to an object.
	*
	* @param a 		 The Anything that desrcibes the object to be created.
	* @return		The object that matches the description.
	* @deprecated		Use {@link Anything#toObject()} instead.
	* @ulc.extension		
	**/
	 public  static java.lang.Object internalConvertToObject(com.ulcjava.base.shared.internal.Anything a)
	{
		return null;
	}


	/**
	* Sends a request with the <code>char</code> argument <code>newValue</code> to
	* the client side, if <code>newValue</code> differs from
<code>oldValue</code>.
	* In the latter case the effect of this method is the same as
	* if
<code>sendUI(command, new Anything(newValue)</code> was called. This
	* methodhas no effect, if this <code>ULCProxy</code> object is
not yet uploaded
	* or if <code>newValue == oldValue</code> holds.
	*
	* @param command 		 the name of the request
	* @param oldValue 		 the old value which must be different from the new value in order for the request to be sent
	* @param newValue 		 the new value to be sent
	* @return		The new value <code>newValue</code>.
	* @see		#sendUI(String, Object)
	* @deprecated		Use {@link #setStateUI(String, char, char)} instead.
	* @ulc.extension		
	**/
	 protected char update(java.lang.String command, char oldValue, char newValue)
	{
		return 'a';
	}


	/**
	* Sends a request with the <code>byte</code> argument <code>newValue</code> to
	* the client side, if <code>newValue</code> differs from
<code>oldValue</code>.
	* In the latter case the effect of this method is the same as
	* if
<code>sendUI(command, new Anything(newValue)</code> was called. This
	* methodhas no effect, if this <code>ULCProxy</code> object is
not yet uploaded
	* or if <code>newValue == oldValue</code> holds.
	*
	* @param command 		 the name of the request
	* @param oldValue 		 the old value which must be different from the new value in order for the request to be sent
	* @param newValue 		 the new value to be sent
	* @return		The new value <code>newValue</code>.
	* @see		#sendUI(String, Object)
	* @deprecated		Use {@link #setStateUI(String, byte, byte)} instead.
	* @ulc.extension		
	**/
	 protected byte update(java.lang.String command, byte oldValue, byte newValue)
	{
		return 0;
	}


	/**
	* Sends a request with the <code>short</code> argument <code>newValue</code> to
	* the client side, if <code>newValue</code> differs from
<code>oldValue</code>.
	* In the latter case the effect of this method is the same as
	* if
<code>sendUI(command, new Anything(newValue)</code> was called. This
	* methodhas no effect, if this <code>ULCProxy</code> object is
not yet uploaded
	* or if <code>newValue == oldValue</code> holds.
	*
	* @param command 		 the name of the request
	* @param oldValue 		 the old value which must be different from the new value in order for the request to be sent
	* @param newValue 		 the new value to be sent
	* @return		The new value <code>newValue</code>.
	* @see		#sendUI(String, Object)
	* @deprecated		Use {@link #setStateUI(String, short, short)} instead.
	* @ulc.extension		
	**/
	 protected short update(java.lang.String command, short oldValue, short newValue)
	{
		return 0;
	}


	/**
	* Sends a request with the <code>int</code> argument <code>newValue</code> to
	* theclient side, if <code>newValue</code> differs from
<code>oldValue</code>.
	* In the latter case the effect of this method is the same as
	* if
<code>sendUI(command, new Anything(newValue)</code> was called. This
	* methodhas no effect, if this <code>ULCProxy</code> object is
not yet uploaded
	* or if <code>newValue == oldValue</code> holds.
	*
	* @param command 		 the name of the request
	* @param oldValue 		 the old value which must be different from the new value in order for the request to be sent
	* @param newValue 		 the new value to be sent
	* @return		The new value <code>newValue</code>.
	* @see		#sendUI(String, Object)
	* @deprecated		Use {@link #setStateUI(String, int, int)} instead.
	* @ulc.extension		
	**/
	 protected int update(java.lang.String command, int oldValue, int newValue)
	{
		return 0;
	}


	/**
	* Sends a request with the <code>long</code> argument <code>newValue</code> to
	* the client side, if <code>newValue</code> differs from
<code>oldValue</code>.
	* In the latter case the effect of this method is the same as
	* if
<code>sendUI(command, new Anything(newValue)</code> was called. This
	* methodhas no effect, if this <code>ULCProxy</code> object is
not yet uploaded
	* or if <code>newValue == oldValue</code> holds.
	*
	* @param command 		 the name of the request
	* @param oldValue 		 the old value which must be different from the new value in order for the request to be sent
	* @param newValue 		 the new value to be sent
	* @return		The new value <code>newValue</code>.
	* @see		#sendUI(String, Object)
	* @deprecated		Use {@link #setStateUI(String, long, long)} instead.
	* @ulc.extension		
	**/
	 protected long update(java.lang.String command, long oldValue, long newValue)
	{
		return 0L;
	}


	/**
	* Sends a request with the <code>double</code> argument <code>newValue</code> to
	* the client side, if <code>newValue</code> differs from
<code>oldValue</code>.
	* In the latter case the effect of this method is the same as
	* if
<code>sendUI(command, new Anything(newValue)</code> was called. This
	* methodhas no effect, if this <code>ULCProxy</code> object is
not yet uploaded
	* or if <code>newValue == oldValue</code> holds.
	*
	* @param command 		 the name of the request
	* @param oldValue 		 the old value which must be different from the new value in order for the request to be sent
	* @param newValue 		 the new value to be sent
	* @return		The new value <code>newValue</code>.
	* @see		#sendUI(String, Object)
	* @deprecated		Use {@link #setStateUI(String, double, double)} instead.
	* @ulc.extension		
	**/
	 protected double update(java.lang.String command, double oldValue, double newValue)
	{
		return 0.0d;
	}


	/**
	* Sends a request with the <code>float</code> argument <code>newValue</code> to
	* the client side, if <code>newValue</code> differs from
<code>oldValue</code>.
	* In the latter case the effect of this method is the same as
	* if
<code>sendUI(command, new Anything(newValue)</code> was called. This
	* methodhas no effect, if this <code>ULCProxy</code> object is
not yet uploaded
	* or if <code>newValue == oldValue</code> holds.
	*
	* @param command 		 the name of the request
	* @param oldValue 		 the old value which must be different from the new value in order for the request to be sent
	* @param newValue 		 the new value to be sent
	* @return		The new value <code>newValue</code>.
	* @see		#sendUI(String, Object)
	* @deprecated		Use {@link #setStateUI(String, float, float)} instead.
	* @ulc.extension		
	**/
	 protected float update(java.lang.String command, float oldValue, float newValue)
	{
		return 0.0f;
	}


	/**
	* Sends a request with the <code>boolean</code> argument <code>newValue</code>
	* tothe client side, if <code>newValue</code> differs
from
	* <code>oldValue</code>. In the latter case the effect of this method is the
	* same as if
<code>sendUI(command, new Anything(newValue)</code> was called.
	* This method has no effect, if this <code>ULCProxy</code> object is
not yet
	* uploaded or if <code>newValue == oldValue</code> holds.
	*
	* @param command 		 the name of the request
	* @param oldValue 		 the old value which must be different from the new value in order for the request to be sent
	* @param newValue 		 the new value to be sent
	* @return		The new value <code>newValue</code>.
	* @see		#sendUI(String, Object)
	* @deprecated		Use {@link #setStateUI(String, boolean, boolean)} instead.
	* @ulc.extension		
	**/
	 protected boolean update(java.lang.String command, boolean oldValue, boolean newValue)
	{
		return false;
	}


	/**
	* Sends a request with the <code>Dimension</code> argument <code>newValue</code>
	* to the client side, if <code>newValue</code> is not
equal to
	* <code>oldValue</code>. This method delegates to {@link #update(String,
	* Object,Object)}.
	*
	* @param command 		 the name of the request
	* @param oldValue 		 the old value which must be different from the new value in order for the request to be sent
	* @param newValue 		 the new value to be sent
	* @return		The new value <code>newValue</code>.
	* @see		#update(String, Object, Object)
	* @deprecated		Use {@link #setStateUI(String, Object, Object)} instead.
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.application.util.Dimension update(java.lang.String command, com.ulcjava.base.application.util.Dimension oldValue, com.ulcjava.base.application.util.Dimension newValue)
	{
		return null;
	}


	/**
	* Sends a request with the <code>Dimension</code> argument <code>newValue</code>
	* to the client side, if <code>newValue</code> is not
equal to
	* <code>oldValue</code>. This method delegates to {@link #update(String,
	* Object,Object)}.
	*
	* @param command 		 the name of the request
	* @param oldValue 		 the old value which must be different from the new value in order for the request to be sent
	* @param newValue 		 the new value to be sent
	* @return		The new value <code>newValue</code>.
	* @see		#update(String, Object, Object)
	* @deprecated		Use {@link #setStateUI(String, Object, Object)} instead.
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.application.util.Font update(java.lang.String command, com.ulcjava.base.application.util.Font oldValue, com.ulcjava.base.application.util.Font newValue)
	{
		return null;
	}


	/**
	* Sends a request with the <code>Insets</code> argument <code>newValue</code> to
	* the client side, if <code>newValue</code> is not equal
to
	* <code>oldValue</code>. This method delegates to {@link #update(String,
	* Object,Object)}.
	*
	* @param command 		 the name of the request
	* @param oldValue 		 the old value which must be different from the new value in order for the request to be sent
	* @param newValue 		 the new value to be sent
	* @return		The new value <code>newValue</code>.
	* @see		#update(String, Object, Object)
	* @deprecated		Use {@link #setStateUI(String, Object, Object)} instead.
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.application.util.Insets update(java.lang.String command, com.ulcjava.base.application.util.Insets oldValue, com.ulcjava.base.application.util.Insets newValue)
	{
		return null;
	}


	/**
	* Sends a request with the <code>KeyStroke</code> argument <code>newValue</code>
	* to the client side, if <code>newValue</code> is not
equal to
	* <code>oldValue</code>. This method delegates to {@link #update(String,
	* Object,Object)}.
	*
	* @param command 		 the name of the request
	* @param oldValue 		 the old value which must be different from the new value in order for the request to be sent
	* @param newValue 		 the new value to be sent
	* @return		The new value <code>newValue</code>.
	* @see		#update(String, Object, Object)
	* @deprecated		Use {@link #setStateUI(String, Object, Object)} instead.
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.application.util.KeyStroke update(java.lang.String command, com.ulcjava.base.application.util.KeyStroke oldValue, com.ulcjava.base.application.util.KeyStroke newValue)
	{
		return null;
	}


	/**
	* Sends a request with the <code>Color</code> argument <code>newValue</code> to
	* the client side, if <code>newValue</code> is not equal
to
	* <code>oldValue</code>. This method delegates to {@link #update(String,
	* Object,Object)}.
	*
	* @param command 		 the name of the request
	* @param oldValue 		 the old value which must be different from the new value in order for the request to be sent
	* @param newValue 		 the new value to be sent
	* @return		The new value <code>newValue</code>.
	* @see		#update(String, Object, Object)
	* @deprecated		Use {@link #setStateUI(String, Object, Object)} instead.
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.application.util.Color update(java.lang.String command, com.ulcjava.base.application.util.Color oldValue, com.ulcjava.base.application.util.Color newValue)
	{
		return null;
	}


	/**
	* Sends a request with the <code>String</code> argument <code>newValue</code> to
	* the client side, if <code>newValue</code> is not equal
to
	* <code>oldValue</code>. This method delegates to {@link #update(String,
	* Object,Object)}.
	*
	* @param command 		 the name of the request
	* @param oldValue 		 the old value which must be different from the new value in order for the request to be sent
	* @param newValue 		 the new value to be sent
	* @return		The new value <code>newValue</code>.
	* @see		#update(String, Object, Object)
	* @deprecated		Use {@link #setStateUI(String, String, String)} instead.
	* @ulc.extension		
	**/
	 protected java.lang.String update(java.lang.String command, java.lang.String oldValue, java.lang.String newValue)
	{
		return null;
	}


	/**
	* Sends a request with the <code>Dimension</code> argument <code>newValue</code>
	* to the client side, if <code>newValue</code> is not
equal to
	* <code>oldValue</code>. This method delegates to {@link #update(String,
	* Object,Object)}.
	*
	* @param command 		 the name of the request
	* @param oldValue 		 the old value which must be different from the new value in order for the request to be sent
	* @param newValue 		 the new value to be sent
	* @return		The new value <code>newValue</code>.
	* @see		#update(String, Object, Object)
	* @deprecated		Use {@link #setStateUI(String, Object, Object)} instead.
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IProxy update(java.lang.String command, com.ulcjava.base.server.IProxy oldValue, com.ulcjava.base.server.IProxy newValue)
	{
		return null;
	}


	/**
	* Sends a request with the argument <code>newValue</code> to the client side, if
	* <code>newValue</code> is not equals to
<code>oldValue</code>. In the latter
	* case, the effect of this method is the same as if <code>sendUI(command,
	* newValue)</code> was
called. This method has no effect, if this
	* <code>ULCProxy</code> object is not yet uploaded or if both
	* <code>newValue</code> and
<code>oldValue</code> are <code>null</code> or if
	* <code>newValue != null && newValue.equals(oldValue)</code> holds.
	*
	* @param command 		 the name of the request
	* @param oldValue 		 the old value which must be different from the new value in order for the request to be sent
	* @param newValue 		 the new value to be sent
	* @return		The new value <code>newValue</code>.
	* @see		#sendUI(String, Object)
	* @deprecated		Use {@link #setStateUI(String, Object, Object)} instead.
	* @ulc.extension		
	**/
	 protected java.lang.Object update(java.lang.String command, java.lang.Object oldValue, java.lang.Object newValue)
	{
		return null;
	}


	/**
	* Stores the value of an <code>int</code> property in an <code>Anything</code>
	* object <code>a</code> such that during upload, the
properties's new value is
	* sent to the client-side UI half-object associated with this ULC object. The
	* new property value
<code>value</code> is only stored in the
	* <code>Anything</code> object, if it differs from the default property
	* value
<code>defaultValue</code>. It is assumed that the passed in
	* <code>Anything</code> object represents a map. If stored at all, the
property
	* name <code>name</code> is used as a storage key in the map and the value
	* <code>new java.lang.Integer(value)</code> is used
as the corresponding
	* value.
<p>
</p>
This method is meant to be used inside an overriden version
	* of{@link #saveState(Anything)}. On the client side, the property value
stored
	* in the passed in <code>Anything</code> object will have to be read via an
	* overriden version
	* of
<code>com.ulcjava.base.client.UIProxy.restoreState(Anything
	* anything)</code>.
	*
	* @param a 		 the <code>Anything</code> in which the property value will saved. It represents a map.
	* @param name 		 the name of the property, for which the value is saved. It is used as a key in the <code>Anything</code> map.
	* @param value 		 the new value assigned to the given property
	* @param defaultValue 		 the default value of the given property
	* @see		#saveState(Anything, String, Object, Object)
	* @deprecated		Use {@link #setStateUI(String, int, int)} instead.
	* @ulc.extension		
	**/
	 protected void saveState(com.ulcjava.base.shared.internal.Anything a, java.lang.String name, int value, int defaultValue)
	{
	}


	/**
	* Stores the value of a <code>double</code> property in an <code>Anything</code>
	* object <code>a</code> such that during upload, the
properties's new value is
	* sent to the client-side UI half-object associated with this ULC object. The
	* new property value
<code>value</code> is only stored in the
	* <code>Anything</code> object, if it differs from the default property
	* value
<code>defaultValue</code>. It is assumed that the passed in
	* <code>Anything</code> object represents a map. If stored at all, the
property
	* name <code>name</code> is used as a storage key in the map and the value
	* <code>new java.lang.Double(value)</code> is used as
the corresponding
	* value.
<p>
</p>
This method is meant to be used inside an overriden version
	* of{@link #saveState(Anything)}. On the client side, the property value
stored
	* in the passed in <code>Anything</code> object will have to be read via an
	* overriden version
	* of
<code>com.ulcjava.base.client.UIProxy.restoreState(Anything
	* anything)</code>.
	*
	* @param a 		 the <code>Anything</code> in which the property value will saved. It represents a map.
	* @param name 		 the name of the property, for which the value is saved. It is used as a key in the <code>Anything</code> map.
	* @param value 		 the new value assigned to the given property
	* @param defaultValue 		 the default value of the given property
	* @see		#saveState(Anything, String, Object, Object)
	* @deprecated		Use {@link #setStateUI(String, double, double)} instead.
	* @ulc.extension		
	**/
	 protected void saveState(com.ulcjava.base.shared.internal.Anything a, java.lang.String name, double value, double defaultValue)
	{
	}


	/**
	* Stores the value of a <code>boolean</code> property in an
	* <code>Anything</code>object <code>a</code> such that during upload,
	* the
properties's new value is sent to the client-side UI half-object
	* associated with this ULC object. The new property value
<code>value</code> is
	* only stored in the <code>Anything</code> object, if it differs from the
	* default property value
<code>defaultValue</code>. It is assumed that the
	* passed in <code>Anything</code> object represents a map. If stored at all,
	* theproperty name <code>name</code> is used as a storage key in the map and
	* thevalue <code>new java.lang.Boolean(value)</code> is used
as the
	* corresponding value.
<p>
</p>
This method is meant to be used inside an
	* overriden version of {@link #saveState(Anything)}. On the client side, the
	* property value
stored in the passed in <code>Anything</code> object will have
	* to be read via an overriden version
	* of
<code>com.ulcjava.base.client.UIProxy.restoreState(Anything
	* anything)</code>.
	*
	* @param a 		 the <code>Anything</code> in which the property value will saved. It represents a map.
	* @param name 		 the name of the property, for which the value is saved. It is used as a key in the <code>Anything</code> map.
	* @param value 		 the new value assigned to the given property
	* @param defaultValue 		 the default value of the given property
	* @see		#saveState(Anything, String, Object, Object)
	* @deprecated		Use {@link #setStateUI(String, boolean, boolean)} instead.
	* @ulc.extension		
	**/
	 protected void saveState(com.ulcjava.base.shared.internal.Anything a, java.lang.String name, boolean value, boolean defaultValue)
	{
	}


	/**
	* Stores the value of an <code>IProxy</code> property in an
	* <code>Anything</code>object <code>a</code> such that during upload,
	* the
properties's new value is sent to the client-side UI half-object
	* associated with this ULC object. The new property value
<code>value</code> is
	* resolved such that a corresponding <code>Anything</code> object describing
	* theproxy object will be available
during the execution of
	* <code>restoreState()</code> on the client side. The client-side
	* <code>Anything</code> object can be converted
to a corresponding
	* <code>com.ulcjava.base.client.UIProxy</code> object inside
	* <code>restoreState()</code> via
<code>UISession.getManaged(Class uiClass,
	* Anything args)</code>.
<p>
</p>
It is assumed that the passed in
	* <code>Anything</code> object <code>a</code> represents a map. The property
	* name <code>name</code> is
used as a storage key in the map and the value
	* <code>value</code> is used as the corresponding value.
<p>
</p>
This method
	* must be used inside an overriden version of {@link #saveState(Anything)}. On
	* the client side, the property value stored
in the passed in
	* <code>Anything</code> object will have to be read via an overriden version
	* of
<code>com.ulcjava.base.client.UIProxy.restoreState(Anything
	* anything)</code>.
	*
	* @param a 		 the <code>Anything</code> in which the property value will saved. It represents a map.
	* @param name 		 the name of the property, for which the value is saved. It is used as a key in the <code>Anything</code> map.
	* @param value 		 the new value assigned to the given property
	* @deprecated		Use {@link #setStateUI(String, Object)} instead.
	* @ulc.extension		
	**/
	 protected void saveState(com.ulcjava.base.shared.internal.Anything a, java.lang.String name, com.ulcjava.base.server.IProxy value)
	{
	}


	/**
	* Stores the value of a property in an <code>Anything</code> object
	* <code>a</code> such that during upload, the properties's new value
is sent to
	* the client-side UI half-object associated with this ULC object. The new
	* property value <code>value</code> is only stored
in the <code>Anything</code>
	* object, if it is not equal to the default property value
	* <code>defaultValue</code>. It is assumed that
the passed in
	* <code>Anything</code> object represents a map. If stored at all, the property
	* name <code>name</code> is used as a
storage key in the map and the value
	* <code>value</code> is used as the corresponding value.
<p>
</p>
This method
	* ismeant to be used inside an overriden version of {@link
	* #saveState(Anything)}. On the client side, the property value
stored in the
	* passed in <code>Anything</code> object will have to be read via an overriden
	* version of
<code>com.ulcjava.base.client.UIProxy.restoreState(Anything
	* anything)</code>.
	*
	* @param a 		 the <code>Anything</code> in which the property value will saved. It represents a map.
	* @param name 		 the name of the property, for which the value is saved. It is used as a key in the <code>Anything</code> map.
	* @param value 		 the new value assigned to the given property
	* @param defaultValue 		 the default value of the given property
	* @deprecated		Use {@link #setStateUI(String, Object, Object)} instead.
	* @ulc.extension		
	**/
	 protected void saveState(com.ulcjava.base.shared.internal.Anything a, java.lang.String name, java.lang.Object value, java.lang.Object defaultValue)
	{
	}


	/**
	* Checks the equality of the two passed in objects (which may be
	* <code>null</code>).
	*
	* @param first 		 the first object reference
	* @param second 		 the second object reference
	* @return		<code>true</code> if both <code>first</code> and <code>second</code> are <code>null</code> or if
<code>first.equals(second)</code> is true. Returns <code>false</code> otherwise.
	* @ulc.extension		
	**/
	 protected  final boolean equals(java.lang.Object first, java.lang.Object second)
	{
		return false;
	}


	/**
	* Checks the equality of the two passed in object arrays (which must not be
	* <code>null</code>). The two arrays are equal, if they have
the same length
	* andif elements at the same position of each array are equal according to
	* {@link #equals(Object, Object)}.
	*
	* @param first 		 the first object array
	* @param second 		 the second object array
	* @return		<code>true</code> if the two array are equal, <code>false</code> otherwise.
	* @ulc.extension		
	**/
	 protected  final boolean equals(java.lang.Object[] first, java.lang.Object[] second)
	{
		return false;
	}


	/**
	* Ensures that a new value of a <code>boolean</code> property is automatically
	* set on the client-side UI half-object associated with
this ULC
	* object.
<p>
</p>
Let "x" be the name of the property
	* <code>propertyName</code>. Then, a resulting marshalling call is equivalent
	* to<code>invokeUI("setX", new Object[] { new Boolean(newValue) })</code>.
	* Therefore, the respective client-side method to set the
property is expected
	* to have the signature <code>public void setX(boolean)</code>.
	*
	* @param propertyName 		 the name of the property to be set on the client side
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeUI(String, Object[])
	* @ulc.extension		
	**/
	 protected  final boolean setStateUI(java.lang.String propertyName, boolean newValue)
	{
		return false;
	}


	/**
	* Ensures that a new value of a <code>boolean</code> property is automatically
	* set on the client-side UI half-object associated with
this ULC object. The
	* newvalue of the property is marshalled to the client, only if the new value
	* isnot equal to the old property
value. To determine this, the old property
	* value is expected to be passed in to this method as
	* <code>oldValue</code>.
<p></p>
Let "x" be the name of the property
	* <code>propertyName</code>. Then, a potential marshalling call is equivalent
	* to<code>invokeUI("setX", new Object[] { new Boolean(newValue) })</code>.
	* Therefore, the respective client-side method to set the
property is expected
	* to have the signature <code>public void setX(boolean)</code>.
	*
	* @param propertyName 		 the name of the property to be set on the client side
	* @param oldValue 		 the old value of the property
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeUI(String, Object[])
	* @ulc.extension		
	**/
	 protected  final boolean setStateUI(java.lang.String propertyName, boolean oldValue, boolean newValue)
	{
		return false;
	}


	/**
	* Ensures that a new value of a <code>char</code> property is automatically set
	* on the client-side UI half-object associated with this
ULC
	* object.
<p>
</p>
Let "x" be the name of the property
	* <code>propertyName</code>. Then, a resulting marshalling call is equivalent
	* to<code>invokeUI("setX", new Object[] { new Character(newValue) })</code>.
	* Therefore, the respective client-side method to set the
property is expected
	* to have the signature <code>public void setX(char)</code>.
	*
	* @param propertyName 		 the name of the property to be set on the client side
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeUI(String, Object[])
	* @ulc.extension		
	**/
	 protected  final char setStateUI(java.lang.String propertyName, char newValue)
	{
		return 'a';
	}


	/**
	* Ensures that a new value of a <code>char</code> property is automatically set
	* on the client-side UI half-object associated with this
ULC object. The new
	* value of the property is marshalled to the client, only if the new value is
	* not equal to the old property value.
To determine this, the old property
	* valueis expected to be passed in to this method as
	* <code>oldValue</code>.
<p>
</p>
Let "x" be the name of the property
	* <code>propertyName</code>. Then, a potential marshalling call is equivalent
	* to<code>invokeUI("setX", new Object[] { new Character(newValue) })</code>.
	* Therefore, the respective client-side method to set the
property is expected
	* to have the signature <code>public void setX(char)</code>.
	*
	* @param propertyName 		 the name of the property to be set on the client side
	* @param oldValue 		 the old value of the property
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeUI(String, Object[])
	* @ulc.extension		
	**/
	 protected  final char setStateUI(java.lang.String propertyName, char oldValue, char newValue)
	{
		return 'a';
	}


	/**
	* Ensures that a new value of a <code>byte</code> property is automatically set
	* on the client-side UI half-object associated with this
ULC
	* object.
<p>
</p>
Let "x" be the name of the property
	* <code>propertyName</code>. Then, a resulting marshalling call is equivalent
	* to<code>invokeUI("setX", new Object[] { new Byte(newValue) })</code>.
	* Therefore, the respective client-side method to set the property
is expected
	* to have the signature <code>public void setX(byte)</code>.
	*
	* @param propertyName 		 the name of the property to be set on the client side
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeUI(String, Object[])
	* @ulc.extension		
	**/
	 protected  final byte setStateUI(java.lang.String propertyName, byte newValue)
	{
		return 0;
	}


	/**
	* Ensures that a new value of a <code>byte</code> property is automatically set
	* on the client-side UI half-object associated with this
ULC object. The new
	* value of the property is marshalled to the client, only if the new value is
	* not equal to the old property value.
To determine this, the old property
	* valueis expected to be passed in to this method as
	* <code>oldValue</code>.
<p>
</p>
Let "x" be the name of the property
	* <code>propertyName</code>. Then, a potential marshalling call is equivalent
	* to<code>invokeUI("setX", new Object[] { new Byte(newValue) })</code>.
	* Therefore, the respective client-side method to set the property
is expected
	* to have the signature <code>public void setX(byte)</code>.
	*
	* @param propertyName 		 the name of the property to be set on the client side. Let "x" be the name of the property. Then the respective
client-side method to set the property is expected to have the signature <code>public void setX(byte)</code>.
	* @param oldValue 		 the old value of the property
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeUI(String, Object[])
	* @ulc.extension		
	**/
	 protected  final byte setStateUI(java.lang.String propertyName, byte oldValue, byte newValue)
	{
		return 0;
	}


	/**
	* Ensures that a new value of a <code>short</code> property is automatically set
	* on the client-side UI half-object associated with this
ULC
	* object.
<p>
</p>
Let "x" be the name of the property
	* <code>propertyName</code>. Then, a resulting marshalling call is equivalent
	* to<code>invokeUI("setX", new Object[] { new Short(newValue) })</code>.
	* Therefore, the respective client-side method to set the property
is expected
	* to have the signature <code>public void setX(short)</code>.
	*
	* @param propertyName 		 the name of the property to be set on the client side
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeUI(String, Object[])
	* @ulc.extension		
	**/
	 protected  final short setStateUI(java.lang.String propertyName, short newValue)
	{
		return 0;
	}


	/**
	* Ensures that a new value of a <code>short</code> property is automatically set
	* on the client-side UI half-object associated with this
ULC object. The new
	* value of the property is marshalled to the client, only if the new value is
	* not equal to the old property value.
To determine this, the old property
	* valueis expected to be passed in to this method as
	* <code>short</code>.
<p>
</p>
Let "x" be the name of the property
	* <code>propertyName</code>. Then, a potential marshalling call is equivalent
	* to<code>invokeUI("setX", new Object[] { new Short(newValue) })</code>.
	* Therefore, the respective client-side method to set the property
is expected
	* to have the signature <code>public void setX(short)</code>.
	*
	* @param propertyName 		 the name of the property to be set on the client side
	* @param oldValue 		 the old value of the property
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeUI(String, Object[])
	* @ulc.extension		
	**/
	 protected  final short setStateUI(java.lang.String propertyName, short oldValue, short newValue)
	{
		return 0;
	}


	/**
	* Ensure that a new value of an <code>int</code> property is automatically set
	* onthe client-side UI half-object associated with this
ULC
	* object.
<p>
</p>
Let"x" be the name of the property
	* <code>propertyName</code>.Then, a resulting marshalling call is equivalent
	* to
<code>invokeUI("setX", new Object[] { new Integer(newValue) })</code>.
	* Therefore, the respective client-side method to set the
property is expected
	* to have the signature <code>public void setX(int)</code>.
	*
	* @param propertyName 		 the name of the property to be set on the client side
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeUI(String, Object[])
	* @ulc.extension		
	**/
	 protected  final int setStateUI(java.lang.String propertyName, int newValue)
	{
		return 0;
	}


	/**
	* Ensure that a new value of an <code>int</code> property is automatically set
	* onthe client-side UI half-object associated with this
ULC object. The new
	* value of the property is marshalled to the client, only if the new value is
	* not equal to the old property value.
To determine this, the old property
	* valueis expected to be passed in to this method as
	* <code>oldValue</code>.
<p>
</p>
Let "x" be the name of the property
	* <code>propertyName</code>. Then, a potential marshalling call is equivalent
	* to<code>invokeUI("setX", new Object[] { new Integer(newValue) })</code>.
	* Therefore, the respective client-side method to set the
property is expected
	* to have the signature <code>public void setX(int)</code>.
	*
	* @param propertyName 		 the name of the property to be set on the client side.
	* @param oldValue 		 the old value of the property
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeUI(String, Object[])
	* @ulc.extension		
	**/
	 protected  final int setStateUI(java.lang.String propertyName, int oldValue, int newValue)
	{
		return 0;
	}


	/**
	* Ensure that a new value of a <code>double</code> property is automatically set
	* on the client-side UI half-object associated with this
ULC
	* object.
<p>
</p>
Let "x" be the name of the property
	* <code>propertyName</code>. Then, a resulting marshalling call is equivalent
	* to<code>invokeUI("setX", new Object[] { new Double(newValue) })</code>.
	* Therefore, the respective client-side method to set the
property is expected
	* to have the signature <code>public void setX(double)</code>.
	*
	* @param propertyName 		 the name of the property to be set on the client side.
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeUI(String, Object[])
	* @ulc.extension		
	**/
	 protected  final double setStateUI(java.lang.String propertyName, double newValue)
	{
		return 0.0d;
	}


	/**
	* Ensure that a new value of a <code>double</code> property is automatically set
	* on the client-side UI half-object associated with this
ULC object. The new
	* value of the property is marshalled to the client, only if the new value is
	* not equal to the old property value.
To determine this, the old property
	* valueis expected to be passed in to this method as
	* <code>oldValue</code>.
<p>
</p>
Let "x" be the name of the property
	* <code>propertyName</code>. Then, a potential marshalling call is equivalent
	* to<code>invokeUI("setX", new Object[] { new Double(newValue) })</code>.
	* Therefore, the respective client-side method to set the
property is expected
	* to have the signature <code>public void setX(double)</code>.
	*
	* @param propertyName 		 the name of the property to be set on the client side
	* @param oldValue 		 the old value of the property
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeUI(String, Object[])
	* @ulc.extension		
	**/
	 protected  final double setStateUI(java.lang.String propertyName, double oldValue, double newValue)
	{
		return 0.0d;
	}


	/**
	* Ensure that a new value of a <code>float</code> property is automatically set
	* on the client-side UI half-object associated with this
ULC
	* object.
<p>
</p>
Let "x" be the name of the property
	* <code>propertyName</code>. Then, a resulting marshalling call is equivalent
	* to<code>invokeUI("setX", new Object[] { new Float(newValue) })</code>.
	* Therefore, the respective client-side method to set the property
is expected
	* to have the signature <code>public void setX(float)</code>.
	*
	* @param propertyName 		 the name of the property to be set on the client side. Let "x" be the name of the property. Then the respective
client-side method to set the property is expected to have the signature <code>public void setX(float)</code>.
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeUI(String, Object[])
	* @ulc.extension		
	**/
	 protected  final float setStateUI(java.lang.String propertyName, float newValue)
	{
		return 0.0f;
	}


	/**
	* Ensure that a new value of a <code>float</code> property is automatically set
	* on the client-side UI half-object associated with this
ULC object. The new
	* value of the property is marshalled to the client, only if the new value is
	* not equal to the old property value.
To determine this, the old property
	* valueis expected to be passed in to this method as
	* <code>oldValue</code>.
<p>
</p>
Let "x" be the name of the property
	* <code>propertyName</code>. Then, a potential marshalling call is equivalent
	* to<code>invokeUI("setX", new Object[] { new Float(newValue) })</code>.
	* Therefore, the respective client-side method to set the property
is expected
	* to have the signature <code>public void setX(float)</code>.
	*
	* @param propertyName 		 the name of the property to be set on the client side
	* @param oldValue 		 the old value of the property
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeUI(String, Object[])
	* @ulc.extension		
	**/
	 protected  final float setStateUI(java.lang.String propertyName, float oldValue, float newValue)
	{
		return 0.0f;
	}


	/**
	* Ensure that a new value of a <code>long</code> property is automatically set
	* onthe client-side UI half-object associated with this
ULC
	* object.
<p>
</p>
Let"x" be the name of the property
	* <code>propertyName</code>.Then, a resulting marshalling call is equivalent
	* to
<code>invokeUI("setX", new Object[] { new Long(newValue) })</code>.
	* Therefore, the respective client-side method to set the property
is expected
	* to have the signature <code>public void setX(long)</code>.
	*
	* @param propertyName 		 the name of the property to be set on the client side
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeUI(String, Object[])
	* @ulc.extension		
	**/
	 protected  final long setStateUI(java.lang.String propertyName, long newValue)
	{
		return 0L;
	}


	/**
	* Ensure that a new value of a <code>long</code> property is automatically set
	* onthe client-side UI half-object associated with this
ULC object. The new
	* value of the property is marshalled to the client, only if the new value is
	* not equal to the old property value.
To determine this, the old property
	* valueis expected to be passed in to this method as
	* <code>oldValue</code>.
<p>
</p>
Let "x" be the name of the property
	* <code>propertyName</code>. Then, a potential marshalling call is equivalent
	* to<code>invokeUI("setX", new Object[] { new Long(newValue) })</code>.
	* Therefore, the respective client-side method to set the property
is expected
	* to have the signature <code>public void setX(long)</code>.
	*
	* @param propertyName 		 the name of the property to be set on the client side
	* @param oldValue 		 the old value of the property
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeUI(String, Object[])
	* @ulc.extension		
	**/
	 protected  final long setStateUI(java.lang.String propertyName, long oldValue, long newValue)
	{
		return 0L;
	}


	/**
	* Ensure that a new value of a <code>String</code> property is automatically set
	* on the client-side UI half-object associated with this
ULC
	* object.
<p>
</p>
Let "x" be the name of the property
	* <code>propertyName</code>. Then, a resulting marshalling call is equivalent
	* to<code>invokeUI("setX", new Object[] { newValue })</code>. Therefore, the
	* respective client-side method to set the property is
expected to have the
	* signature <code>public void setX(String)</code>.
	*
	* @param propertyName 		 the name of the property to be set on the client side
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeUI(String, Object[])
	* @ulc.extension		
	**/
	 protected  final java.lang.String setStateUI(java.lang.String propertyName, java.lang.String newValue)
	{
		return null;
	}


	/**
	* Ensure that a new value of a <code>String</code> property is automatically set
	* on the client-side UI half-object associated with this
ULC object. The new
	* value of the property is marshalled to the client, only if the new value is
	* not equal to the old property value.
To determine this, the old property
	* valueis expected to be passed in to this method as
	* <code>oldValue</code>.
<p>
</p>
Let "x" be the name of the property
	* <code>propertyName</code>. Then, a potential marshalling call is equivalent
	* to<code>invokeUI("setX", new Object[] { newValue })</code>. Therefore, the
	* respective client-side method to set the property is
expected to have the
	* signature <code>public void setX(String)</code>.
	*
	* @param propertyName 		 the name of the property to be set on the client side
	* @param oldValue 		 the old value of the property
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeUI(String, Object[])
	* @ulc.extension		
	**/
	 protected  final java.lang.String setStateUI(java.lang.String propertyName, java.lang.String oldValue, java.lang.String newValue)
	{
		return null;
	}


	/**
	* Ensures that the new value of a property is automatically set on the
	* client-side UI half-object associated with this ULC object. The
conversion
	* rules described above are applied when marshalling the new value to the
	* client.
<p>
</p>
Let "x" be the name of the property. Then a resulting
	* marshalling call is equivalent to
<code>invokeUI("setX", new Object[] {
	* newValue })</code>. Therefore, the respective client-side method is expected
	* to have the
signature <code>public void setX("type")</code>, where the
	* parameter type <code>"type"</code> must be a supertype of the
	* client-side
runtime type of <code>newValue</code>, which is a result of the
	* above descibed marshalling conversion.
<p>
</p>
If <code>newValue</code> is
	* aninstance of IProxy, then respective client-side method is expected to have
	* the signature
<code>public void setX("(sub)class of UIProxy")</code>.
	* <code>"(sub)class of UIProxy"</code> represents the respective parameter
	* type
<code>t</code>, which must be a subclass of <code>UIProxy</code> or
	* <code>UIProxy</code> itself. If <code>t</code> is a subclass
	* of
<code>UIProxy</code>, then the runtime type of the UI half-object
	* associated with <code>newValue</code> must be assignable
	* to
<code>t</code>.
<p>
</p>
If <code>newValue</code> is an instance of a Java
	* wrapper class for a primitive type (e.g. <code>java.lang.Integer</code>)
	* then
"type" may as well be the corresponding primitive type (e.g.
	* <code>int</code>).
	*
	* @param propertyName 		 the name of the property to be set on the client side
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeUI(String, Object[])
	* @ulc.extension		
	**/
	 protected  final java.lang.Object setStateUI(java.lang.String propertyName, java.lang.Object newValue)
	{
		return null;
	}


	/**
	* Ensures that the new value of a property is automatically set on the
	* client-side UI half-object associated with this ULC object. The
conversion
	* rules described above are applied when marshalling the new value to the
	* client. The new value of the property is
marshalled to the client, only if
	* thenew value is not equal to the old property value. To determine this, the
	* old property value is
expected to be passed in to this method as
	* <code>oldValue</code>.
<p>
</p>
Let "x" be the name of the property. Then a
	* resulting marshalling call is equivalent to
<code>invokeUI("setX", new
	* Object[] { newValue })</code>. Therefore, the respective client-side method
	* isexpected to have the
signature <code>public void setX("type")</code>, where
	* the parameter type <code>"type"</code> must be a supertype of the
	* client-side
runtime type of <code>newValue</code>, which is a result of the
	* above descibed marshalling conversion.
<p>
</p>
If <code>newValue</code> is
	* aninstance of IProxy, then respective client-side method is expected to have
	* the signature
<code>public void setX("(sub)class of UIProxy")</code>.
	* <code>"(sub)class of UIProxy"</code> represents the respective parameter
	* type
<code>t</code>, which must be a subclass of <code>UIProxy</code> or
	* <code>UIProxy</code> itself. If <code>t</code> is a subclass
	* of
<code>UIProxy</code>, then the runtime type of the UI half-object
	* associated with <code>newValue</code> must be assignable
	* to
<code>t</code>.
<p>
</p>
If <code>newValue</code> is an instance of a Java
	* wrapper class for a primitive type (e.g. <code>java.lang.Integer</code>)
	* then
"type" may as well be the corresponding primitive type (e.g.
	* <code>int</code>).
	*
	* @param propertyName 		 the name of the property to be set on the client side
	* @param oldValue 		 the old value of the property
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeUI(String, Object[])
	* @ulc.extension		
	**/
	 protected  final java.lang.Object setStateUI(java.lang.String propertyName, java.lang.Object oldValue, java.lang.Object newValue)
	{
		return null;
	}


	/**
	* A convenience method to invoke a state setting method via {@link
	* #invokeUI(String, Object[])}. It ensures that a new value of a
composite
	* <code>Object[]</code> property is automatically set on the client-side UI
	* half-object associated with this ULC object.
<p>
</p>
Let "x" be the name of
	* the property bound to <code>propertyName</code>. Then a call to this method
	* isequivalent to
<code>invokeUI("setX", newValues)</code>.
	*
	* @param propertyName 		 the name of the property for which to set state
	* @param newValues 		 the parameter list for "invokeUI"-method call
	* @ulc.extension		
	**/
	 protected  final java.lang.Object[] setCompositeStateUI(java.lang.String propertyName, java.lang.Object[] newValues)
	{
		return null;
	}


	/**
	* A convenience method to invoke a state setting method via {@link
	* #invokeUI(String, Object[])}. It ensures that a new value of a
composite
	* <code>Object[]</code> property is automatically set on the client-side UI
	* half-object associated with this ULC object.
<p>
</p>
Let "x" be the name of
	* the property bound to <code>propertyName</code>. Then a call to this method
	* isequivalent to
<code>invokeUI("setX", newValues)</code>. The
	* "invokeUI"-method call happens only if the <code>newValues</code> is not
	* equalto
<code>oldValues</code> according to {@link #equals(Object[],
	* Object[])}.
	*
	* @param propertyName 		 the name of the property for which to set state
	* @param oldValues 		 the parameter list with which <code>newValues<code> is compared
	* @param newValues 		 the parameter list for the potentially resulting "invokeUI"-method call
	* @ulc.extension		
	**/
	 protected  final java.lang.Object[] setCompositeStateUI(java.lang.String propertyName, java.lang.Object[] oldValues, java.lang.Object[] newValues)
	{
		return null;
	}


	/**
	* A convenience method to invoke a state adding method via {@link
	* #invokeUI(String, Object[])}. Let "x" be the name of the property
bound to
	* <code>propertyName</code>. Then a call to this method is equivalent to
	* <code>invokeUI("addX", new Object[]{ value })</code>.
	*
	* @param propertyName 		 the name of the property for which to add state
	* @param value 		 the only parameter of the resulting "invokeUI"-method call
	* @ulc.extension		
	**/
	 protected void addStateUI(java.lang.String propertyName, java.lang.Object value)
	{
	}


	/**
	* A convenience method to invoke a state adding method via {@link
	* #invokeUI(String, Object[])}. Let "x" be the name of the property
bound to
	* <code>propertyName</code>. Then a call to this method is equivalent
	* to
<code>invokeUI("addX", new Object[]{ key, value })</code>.
	*
	* @param propertyName 		 the name of the property for which to add state
	* @param key 		 the first parameter of the resulting "invokeUI"-method call
	* @param value 		 the second parameter of the resulting "invokeUI"-method call
	* @ulc.extension		
	**/
	 protected  final void addStateUI(java.lang.String propertyName, java.lang.Object key, java.lang.Object value)
	{
	}


	/**
	* A convenience method to invoke a state adding method via {@link
	* #invokeUI(String, Object[])}. Let "x" be the name of the property
bound to
	* <code>propertyName</code>. Then a call to this method is equivalent to
	* <code>invokeUI("addX", values)</code>.
	*
	* @param propertyName 		 the name of the property for which to add state
	* @param values 		 the argument list of the resulting "invokeUI"-method call
	* @ulc.extension		
	**/
	 protected  final void addCompositeStateUI(java.lang.String propertyName, java.lang.Object[] values)
	{
	}


	/**
	* A convenience method to invoke a state removing method via {@link
	* #invokeUI(String, Object[])}. Let "x" be the name of the property
bound to
	* <code>propertyName</code>. Then a call to this method is equivalent
	* to
<code>invokeUI("removeX", new Object[] { key })</code>.
	*
	* @param propertyName 		 the name of the property for which to remove state
	* @param key 		 the only parameter of the resulting "invokeUI"-method call
	* @ulc.extension		
	**/
	 protected  final void removeStateUI(java.lang.String propertyName, java.lang.Object key)
	{
	}


	/**
	* A convenience method to invoke a state removing method via {@link
	* #invokeUI(String, Object[])}. Let "x" be the name of the property
bound to
	* <code>propertyName</code>. Then a call to this method is equivalent to
	* <code>invokeUI("removeX", values)</code>.
	*
	* @param propertyName 		 the name of the property for which to remove state
	* @param values 		 the argument list of the resulting "invokeUI"-method call
	* @ulc.extension		
	**/
	 protected  final void removeCompositeStateUI(java.lang.String propertyName, java.lang.Object[] values)
	{
	}


	/**
	* A convenience method to invoke a state adding method for every element of a
	* collection. Let "x" be the name of the property bound
	* to
<code>propertyName</code>. Then, a call to this method is equivalent to
	* calling <code>addStateUI("x", element)</code> for every
element
	* <code>element</code> in the collection <code>collection</code>.
	*
	* @param propertyName 		 the name of the property for which to add state
	* @param collection 		 the collection with element for which to call {@link #addStateUI(String, Object)}
	* @see		#addStateUI(String, Object)
	* @ulc.extension		
	**/
	 protected  final void addStatesUI(java.lang.String propertyName, java.util.Collection collection)
	{
	}


	/**
	* A convenience method to invoke a state adding method for every key value pair
	* of a map. Let "x" be the name of the property bound
	* to
<code>propertyName</code>. Then, a call to this method is equivalent to
	* calling <code>addStateUI("x", key, value)</code> for every
key value pair of
	* the map <code>map</code>.
	*
	* @param propertyName 		 the name of the property for which to add state
	* @param map 		 the map with key value pairs for which to call {@link #addStateUI(String, Object, Object)}
	* @see		#addStateUI(String, Object, Object)
	* @ulc.extension		
	**/
	 protected  final void addStatesUI(java.lang.String propertyName, java.util.Map map)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected  static java.lang.String getClientPropertyKey(java.lang.String propertyPrefix, java.lang.String propertyName)
	{
		return null;
	}


	/**
	* Invokes a method with arguments at the client-side UI half-object associated
	* with this ULC object. The potential return value of the
client-side method
	* call is ignored. This method only has an effect if this ULC object is already
	* uploaded or if the method
{@link #uploadStateUI()} is being processed as part
	* of this ULC object's upload.
	*
	* @param methodName 		 the name of the method to be invoked. The method is expected to have the signature
<code>public "type" "method"(...)</code>, where <code>"method"</code> is a placeholder of the <code>methodName</code>
argument of this method.
	* @param arguments 		 the list of arguments used when invoking the client-side method. Every argument in the array is subject to the
marshalling conversion rules such as described in {@link ULCProxy}. The resulting client-side runtime types of the
marshalled arguments must be assignable to the the corresponding parameter types of the method that is to be invoked.
E.g., if <code>arguments</code> contains only a single argument of type <code>java.lang.String</code>, then the
client-side method to be invoked must have only one parameter with the type <code>java.lang.String</code> or with a
supertype of <code>java.lang.String</code> (e.g. <code>java.lang.Object</code>).
<p/>
ULC will detect if the method <code>"method"(...)</code> is overloaded, such that the method to be invoked is not unique.
In this case, none of the method candidates will be invoked but instead, a runtime exception will be thrown on the client
side.
	* @see		<a href="http://www.canoo.com/ulc/developerzone/ULCExtensionGuide.pdf">ULC Extension Guide</a> describes how client-side methods
are addressed when using <code>invokeUI()</code>.
	* @ulc.extension		
	**/
	 public void invokeUI(java.lang.String methodName, java.lang.Object[] arguments)
	{
	}


	/**
	* Invokes a method with no arguments at the client-side UI half-object
	* associatedwith this ULC object. The potential return value of
the client-side
	* method call is ignored. This method only has an effect if this ULC object is
	* already uploaded or if the method
{@link #uploadStateUI()} is being processed
	* as part of this ULC object's upload.
<p>
</p>
A call to this method is
	* equivalent to <code>invokeUI(methodName, new Object[0])</code>.
	*
	* @param methodName 		 the name of the method to be invoked. The method is expected to have the signature
<code>public "type" "method"()</code>, where <code>"method"</code> is a placeholder of the <code>methodName</code>
argument of this method.
	* @see		<a href="http://www.canoo.com/ulc/developerzone/ULCExtensionGuide.pdf">ULC Extension Guide</a> describes how client-side methods
are addressed when using <code>invokeUI()</code>.
	* @ulc.extension		
	**/
	 protected  final void invokeUI(java.lang.String methodName)
	{
	}


	/**
	* Uploads the state of this ULC object to the corresponding client-side UI
	* half-object. This method get called by ULC during the upload
phase of the ULC
	* object.
<p>
</p>
Extension developers may override this method in order to
	* upload state (e.g., property state) which is specific to their extension.
It
	* is CRUCIAL to first invoke the super implementation of this method in an
	* overriding version of it.
<p>
</p>
This version of
	* <code>uploadStateUI()</code> calls {@link #createStateUI(Object[])} with the
	* argument <code>new Object[0]</code>.
Overriden versions of
	* <code>uploadStateUI()</code> may provide their own call to {@link
	* #createStateUI(Object[])} with a custom
object array. If required, a related
	* call should be inserted right after
	* <code>super.uploadStateUI();</code>.
<p>
</p>
Typically, an overriding
	* implementation of this method has the following
	* structure:
<p>
</p>

<pre>
public class MyExtension extends &quot;Some
	* subclass of ULCProxy&quot; {
// A sample extension property
private boolean
	* fMyProperty = false;
...
protected void uploadStateUI() {
// 1) Invoke super
	* implementation.
super.uploadStateUI();
// 2) Potential call to
	* createStateUI()here in order
// to pass on construction data for the
	* constuction
// of the client-side basic object. (This call can be
// ommitted
	* if the construction data provided by
// createStateUI(...) call in
	* super.uploadStateUI()
// is sufficient.)
createStateUI(new Object[]{
	* &quot;myConstructionInfo&quot; });
// 3) Calls to setStateUI(...) etc. in
	* order to upload extension specific state here:
...
// false is the default
	* value of the property
	* &quot;myProperty&quot;
setStateUI(&quot;myProperty&quot;, false,
	* fMyProperty);...
}
}
</pre>
	*
	* @ulc.extension		
	**/
	 protected void uploadStateUI()
	{
	}


	/**
	* Provides the client-side upload process with data needed to construct the
	* basicobject which underlies the client-side UI half object
associated with
	* this ULC object. This method may be called inside {@link #uploadStateUI()}
	* with custom data which will be used when
ULC creates the corresponding basic
	* object by invoking {@link
	* com.ulcjava.base.client.UIProxy#createBasicObject(Anything)} on the
client
	* side.
<p>
</p>
Extension developers may call this method as part of their
	* overriding version of {@link #uploadStateUI()}. See
{@link #uploadStateUI()}
	* on where to place the corresponding call.
	*
	* @param arguments 		 the data for constructing the client-side basic object, which is needed during the upload process of this ULC
object.
	* @ulc.extension		
	* @see		#uploadStateUI()
	**/
	 protected  final void createStateUI(java.lang.Object[] arguments)
	{
	}


	/**
	* Fires an action event.
	*
	* @param actionEvent 		 the action event to be distributed to all listeners
	* @ulc.extension		
	**/
	 protected void fireActionPerformed(com.ulcjava.base.application.event.ActionEvent actionEvent)
	{
	}


	/**
	* Fires a selection changed event.
	*
	* @param selectionChangedEvent 		 the selection changed event to be distributed to all listeners
	* @ulc.extension		
	**/
	 protected void fireSelectionChanged(com.ulcjava.base.application.event.SelectionChangedEvent selectionChangedEvent)
	{
	}


	/**
	* Fires a focus lost event.
	*
	* @param focusEvent 		 the focus event to be distributed to all listeners
	* @ulc.extension		
	**/
	 protected void fireFocusLost(com.ulcjava.base.application.event.FocusEvent focusEvent)
	{
	}


	/**
	* Fires a focus gained event.
	*
	* @param focusEvent 		 the focus event to be distributed to all listeners
	* @ulc.extension		
	**/
	 protected void fireFocusGained(com.ulcjava.base.application.event.FocusEvent focusEvent)
	{
	}


	/**
	* Fires a value changed event.
	*
	* @param valueChangedEvent 		 the value changed event to be distributed to all listeners
	* @ulc.extension		
	**/
	 protected void fireValueChanged(com.ulcjava.base.application.event.ValueChangedEvent valueChangedEvent)
	{
	}


	/**
	* Fires a window closing event.
	*
	* @param windowEvent 		 the window event to be distributed to all listeners
	* @ulc.extension		
	**/
	 protected void fireWindowClosing(com.ulcjava.base.application.event.WindowEvent windowEvent)
	{
	}


	/**
	* Fires a key typed event.
	*
	* @param keyEvent 		 the key event to be distributed to all listeners
	* @ulc.extension		
	**/
	 protected void fireKeyTyped(com.ulcjava.base.application.event.KeyEvent keyEvent)
	{
	}


	/**
	* Fires an adjustment value changed event.
	*
	* @param adjustmentEvent 		 the adjustment event to be distributed to all listeners
	* @ulc.extension		
	**/
	 protected void fireAdjustmentValueChanged(com.ulcjava.base.application.event.AdjustmentEvent adjustmentEvent)
	{
	}


	/**
	* Creates a dispatcher object associated with this class. Dispatcher classes
	* (andobjects) are needed in order to be able to invoke
private and protected
	* methods of a <code>ULCProxy</code> object via
{@link
	* com.ulcjava.base.client.UIProxy#invokeULC(String, Object[])}.
	*
	* @return		an instance of the dispatcher class associated with this <code>ULCProxy</code> class
	* @see		IDispatcher
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* ULC processes all client side requests through this method.
	*
	* @param methodName 		 the name of the method to invoke
	* @param arguments 		 the arguments for the method call
	**/
	 public void processInvokeULC(java.lang.String methodName, java.lang.Object[] arguments)
	{
	}


	/**
	* Dispatches a given <code>eventObject</code> to all listeners registered using
	* {@link #addListener(String, java.util.EventListener)}
with the given
	* <code>eventCategory</code> by calling the given
	* <code>listenerMethodName</code> and passing
	* the
<code>eventObject</code>.
<p>
</p>
The method tries to find the listener
	* interface class object, which is necessary to dispatch the listener method
	* invocation via
reflection. To do so, it searches for a no-argument method
	* withthe name <code>get&lt;EventCategory&gt;ListenerClass</code> on
	* the
dispatcher class or on this proxy's class object. The searched method is
	* expected to return the corresponding listener interface
class object. E.g.,
	* for the event category named "action", the get-method would be
	* <code>getActionListenerClass()</code> and should
(likely) return
	* <code>IActionListener.class</code>. If the get-method is not found an {@link
	* IllegalStateException} will be thrown.
	*
	* @param eventCategory 		 the event category
	* @param listenerMethodName 		 the name of the listener method to be called on all listeners
	* @param eventObject 		 the event
	* @ulc.extension		
	**/
	 protected  final void dispatchEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, java.util.EventObject eventObject)
	{
	}


	/**
	* 
	*
	* @ulc.internal		
	**/
	 protected  final void handleEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, java.lang.Object[] createEventArguments)
	{
	}


	/**
	* Creates an action event from the given arguments.
<p>
</p>
<b>Note:</b> This
	* method will be called as part of a client-initiated event firing.
	*
	* @param command 		 the command of the action event
	* @param modifiers 		 the modifiers of the action event
	* @return		an action event with the this <code>ULCProxy</code> object as the source, or null if no event should be fired
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.application.event.ActionEvent createActionEvent(java.lang.String command, int modifiers)
	{
		return null;
	}


	/**
	* Dispatches an action event to registered listeners via {@link
	* #dispatchEvent(String, String, EventObject)}. Extension writers may
override
	* this method to perform different or additional processing
	* actions.
<p>
</p>
<b>Note:</b> This method will be called as part of a
	* client-initiated event firing. </p>
	*
	* @param eventCategory 		 the event category for dispatching ({@link UlcEventCategories#ACTION_EVENT_CATEGORY})
	* @param listenerMethodName 		 the name of the listener method to which to dispatch
	* @param eventObject 		 the event to be dispatched
	* @see		#dispatchEvent(String, String, EventObject)
	* @ulc.extension		
	**/
	 protected void processActionEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.ActionEvent eventObject)
	{
	}


	/**
	* Get the listener class associated with the event category {@link
	* UlcEventCategories#ACTION_EVENT_CATEGORY}.
	*
	* @return		The class object of {@link IActionListener}.
	* @ulc.extension		
	**/
	 protected java.lang.Class getActionListenerClass()
	{
		return null;
	}


	/**
	* Creates a selection changed event.
<p>
</p>
<b>Note:</b> This method will be
	* called as part of a client-initiated event firing. </p>
	*
	* @return		a selection changed event with this <code>ULCProxy</code> object as the source, or null if no event should be fired
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.application.event.SelectionChangedEvent createSelectionChangedEvent()
	{
		return null;
	}


	/**
	* Dispatches a selection change event to registered listeners via {@link
	* #dispatchEvent(String, String, EventObject)}. Extension
writers may override
	* this method to perform different or additional processing
	* actions.
<p>
</p>
<b>Note:</b> This method will be called as part of a
	* client-initiated event firing. </p>
	*
	* @param eventCategory 		 the event category for dispatching ({@link UlcEventCategories#SELECTION_CHANGED_EVENT_CATEGORY})
	* @param listenerMethodName 		 the name of the listener method to which to dispatch
	* @param eventObject 		 the event to be dispatched
	* @see		#dispatchEvent(String, String, EventObject)
	* @ulc.extension		
	**/
	 protected void processSelectionChangedEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.SelectionChangedEvent eventObject)
	{
	}


	/**
	* Get the listener class associated with the event category {@link
	* UlcEventCategories#SELECTION_CHANGED_EVENT_CATEGORY}.
	*
	* @return		The class object of {@link ISelectionChangedListener}.
	* @ulc.extension		
	**/
	 protected java.lang.Class getSelectionChangedListenerClass()
	{
		return null;
	}


	/**
	* Creates a focus event from the given arguments.
<p>
</p>
<b>Note:</b> This
	* method will be called as part of a client-initiated event firing. </p>
	*
	* @return		a focus event with this <code>ULCProxy</code> object as the source, or null if no event should be fired
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.application.event.FocusEvent createFocusEvent()
	{
		return null;
	}


	/**
	* Dispatches a focus event to registered listeners via {@link
	* #dispatchEvent(String, String, EventObject)}. Extension writers may
override
	* this method to perform different or additional processing
	* actions.
<p>
</p>
<b>Note:</b> This method will be called as part of a
	* client-initiated event firing. </p>
	*
	* @param eventCategory 		 the event category for dispatching ({@link UlcEventCategories#FOCUS_EVENT_CATEGORY})
	* @param listenerMethodName 		 the name of the listener method to which to dispatch
	* @param eventObject 		 the event to be dispatched
	* @see		#dispatchEvent(String, String, EventObject)
	* @ulc.extension		
	**/
	 protected void processFocusEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.FocusEvent eventObject)
	{
	}


	/**
	* Get the listener class associated with the event category {@link
	* UlcEventCategories#FOCUS_EVENT_CATEGORY}.
	*
	* @return		The class object of {@link IFocusListener}.
	* @ulc.extension		
	**/
	 protected java.lang.Class getFocusListenerClass()
	{
		return null;
	}


	/**
	* Creates a value changed event.
<p>
</p>
<b>Note:</b> This method will be
	* calledas part of a client-initiated event firing. </p>
	*
	* @return		a value changed event with this <code>ULCProxy</code> object as the source, or null if no event should be fired
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.application.event.ValueChangedEvent createValueChangedEvent()
	{
		return null;
	}


	/**
	* Dispatches a value change event to registered listeners via {@link
	* #dispatchEvent(String, String, EventObject)}. Extension writers
may override
	* this method to perform different or additional processing
	* actions.
<p>
</p>
<b>Note:</b> This method will be called as part of a
	* client-initiated event firing. </p>
	*
	* @param eventCategory 		 the event category for dispatching ({@link UlcEventCategories#VALUE_CHANGED_EVENT_CATEGORY})
	* @param listenerMethodName 		 the name of the listener method to which to dispatch
	* @param eventObject 		 the event to be dispatched
	* @see		#dispatchEvent(String, String, EventObject)
	* @ulc.extension		
	**/
	 protected void processValueChangedEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.ValueChangedEvent eventObject)
	{
	}


	/**
	* Get the listener class associated with the event category {@link
	* UlcEventCategories#VALUE_CHANGED_EVENT_CATEGORY}.
	*
	* @return		The class object of {@link IValueChangedListener}.
	* @ulc.extension		
	**/
	 protected java.lang.Class getValueChangedListenerClass()
	{
		return null;
	}


	/**
	* Creates a window event.
<p>
</p>
<b>Note:</b> This method will be called as
	* part of a client-initiated event firing. </p>
	*
	* @return		a window event with this <code>ULCProxy</code> object as the source
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.application.event.WindowEvent createWindowEvent()
	{
		return null;
	}


	/**
	* Dispatches a window event to registered listeners via {@link
	* #dispatchEvent(String, String, EventObject)}. Extension writers may
override
	* this method to perform different or additional processing
	* actions.
<p>
</p>
<b>Note:</b> This method will be called as part of a
	* client-initiated event firing. </p>
	*
	* @param eventCategory 		 the event category for dispatching ({@link UlcEventCategories#WINDOW_EVENT_CATEGORY})
	* @param listenerMethodName 		 the name of the listener method to which to dispatch
	* @param eventObject 		 the event to be dispatched
	* @see		#dispatchEvent(String, String, EventObject)
	* @ulc.extension		
	**/
	 protected void processWindowEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.WindowEvent eventObject)
	{
	}


	/**
	* Get the listener class associated with the event category {@link
	* UlcEventCategories#WINDOW_EVENT_CATEGORY}.
	*
	* @return		The class object of {@link IWindowListener}.
	* @ulc.extension		
	**/
	 protected java.lang.Class getWindowListenerClass()
	{
		return null;
	}


	/**
	* Creates a window focus event.
<p>
</p>
<b>Note:</b> This method will be called
	* as part of a client-initiated event firing. </p>
	*
	* @return		a window focus event with this <code>ULCProxy</code> object as the source
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.application.event.WindowEvent createWindowFocusEvent()
	{
		return null;
	}


	/**
	* Dispatches a window focus event to registered listeners via {@link
	* #dispatchEvent(String, String, EventObject)}. Extension writers
may override
	* this method to perform different or additional processing
	* actions.
<p>
</p>
<b>Note:</b> This method will be called as part of a
	* client-initiated event firing. </p>
	*
	* @param eventCategory 		 the event category for dispatching ({@link UlcEventCategories#WINDOW_FOCUS_EVENT_CATEGORY})
	* @param listenerMethodName 		 the name of the listener method to which to dispatch
	* @param eventObject 		 the event to be dispatched
	* @see		#dispatchEvent(String, String, EventObject)
	* @ulc.extension		
	**/
	 protected void processWindowFocusEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.WindowEvent eventObject)
	{
	}


	/**
	* Get the listener class associated with the event category {@link
	* UlcEventCategories#WINDOW_FOCUS_EVENT_CATEGORY}.
	*
	* @return		The class object of {@link IWindowFocusListener}.
	* @ulc.extension		
	**/
	 protected java.lang.Class getWindowFocusListenerClass()
	{
		return null;
	}


	/**
	* Creates a key event from the given arguments.
<p>
</p>
<b>Note:</b> This
	* methodwill be called as part of a client-initiated event firing. </p>
	*
	* @param c 		 the key character of the key event
	* @param modifiers 		 the modifiers of the key event
	* @return		a key event with this <code>ULCProxy</code> object as the source, or null if no event should be fired
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.application.event.KeyEvent createKeyEvent(char c, int modifiers)
	{
		return null;
	}


	/**
	* Dispatches a key event to registered listeners via {@link
	* #dispatchEvent(String, String, EventObject)}. Extension writers may
override
	* this method to perform different or additional processing
	* actions.
<p>
</p>
<b>Note:</b> This method will be called as part of a
	* client-initiated event firing. </p>
	*
	* @param eventCategory 		 the event category for dispatching ({@link UlcEventCategories#KEY_EVENT_CATEGORY})
	* @param listenerMethodName 		 the name of the listener method to which to dispatch
	* @param eventObject 		 the event to be dispatched
	* @see		#dispatchEvent(String, String, EventObject)
	* @ulc.extension		
	**/
	 protected void processKeyEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.KeyEvent eventObject)
	{
	}


	/**
	* Get the listener class associated with the event category {@link
	* UlcEventCategories#KEY_EVENT_CATEGORY}.
	*
	* @return		The class object of {@link IKeyListener}.
	* @ulc.extension		
	**/
	 protected java.lang.Class getKeyListenerClass()
	{
		return null;
	}


	/**
	* Creates an adjustment event.
<p>
</p>
<b>Note:</b> This method will be called
	* as part of a client-initiated event firing. </p>
	*
	* @return		a adjustment event changed event with this <code>ULCProxy</code> object as the source, or null if no event should be fired
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.application.event.AdjustmentEvent createAdjustmentEvent()
	{
		return null;
	}


	/**
	* Dispatches an adjustment event to registered listeners via {@link
	* #dispatchEvent(String, String, EventObject)}. Extension writers may
override
	* this method to perform different or additional processing
	* actions.
<p>
</p>
<b>Note:</b> This method will be called as part of a
	* client-initiated event firing. </p>
	*
	* @param eventCategory 		 the event category for dispatching ({@link UlcEventCategories#ADJUSTMENT_EVENT_CATEGORY})
	* @param listenerMethodName 		 the name of the listener method to which to dispatch
	* @param eventObject 		 the event to be dispatched
	* @see		#dispatchEvent(String, String, EventObject)
	* @ulc.extension		
	**/
	 protected void processAdjustmentEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.AdjustmentEvent eventObject)
	{
	}


	/**
	* Get the listener class associated with the event category {@link
	* UlcEventCategories#ADJUSTMENT_EVENT_CATEGORY}.
	*
	* @return		The class object of {@link IAdjustmentListener}.
	* @ulc.extension		
	**/
	 protected java.lang.Class getAdjustmentListenerClass()
	{
		return null;
	}


	/**
	* Creates a popup menu event.
<p>
</p>
<b>Note:</b> This method will be called
	* aspart of a client-initiated event firing. </p>
	*
	* @return		a popup menu event with this <code>ULCProxy</code> object as the source
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.application.event.PopupMenuEvent createPopupMenuEvent()
	{
		return null;
	}


	/**
	* Dispatches a popup event to registered listeners via {@link
	* #dispatchEvent(String, String, EventObject)}. Extension writers may
override
	* this method to perform different or additional processing
	* actions.
<p>
</p>
<b>Note:</b> This method will be called as part of a
	* client-initiated event firing. </p>
	*
	* @param eventCategory 		 the event category for dispatching ({@link UlcEventCategories#POPUP_MENU_EVENT_CATEGORY})
	* @param listenerMethodName 		 the name of the listener method to which to dispatch
	* @param eventObject 		 the event to be dispatched
	* @see		#dispatchEvent(String, String, EventObject)
	* @ulc.extension		
	**/
	 protected void processPopupMenuEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.PopupMenuEvent eventObject)
	{
	}


	/**
	* Get the listener class associated with the event category {@link
	* UlcEventCategories#POPUP_MENU_EVENT_CATEGORY}.
	*
	* @return		The class object of {@link IPopupMenuListener}.
	* @ulc.extension		
	**/
	 protected java.lang.Class getPopupMenuListenerClass()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCProxyDispatcher extends java.lang.Object implements com.ulcjava.base.server.IDispatcher
{

	 public  final void handleEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, java.lang.Object[] createEventArguments)
	{
	}

	 public  final com.ulcjava.base.application.event.ActionEvent createActionEvent(java.lang.String command, int modifiers)
	{
		return null;
	}

	 public  final void processActionEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.ActionEvent eventObject)
	{
	}

	 public  final java.lang.Class getActionListenerClass()
	{
		return null;
	}

	 public  final com.ulcjava.base.application.event.SelectionChangedEvent createSelectionChangedEvent()
	{
		return null;
	}

	 public  final void processSelectionChangedEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.SelectionChangedEvent eventObject)
	{
	}

	 public  final java.lang.Class getSelectionChangedListenerClass()
	{
		return null;
	}

	 public  final com.ulcjava.base.application.event.FocusEvent createFocusEvent()
	{
		return null;
	}

	 public  final void processFocusEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.FocusEvent eventObject)
	{
	}

	 public  final java.lang.Class getFocusListenerClass()
	{
		return null;
	}

	 public  final com.ulcjava.base.application.event.ValueChangedEvent createValueChangedEvent()
	{
		return null;
	}

	 public  final void processValueChangedEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.ValueChangedEvent eventObject)
	{
	}

	 public  final java.lang.Class getValueChangedListenerClass()
	{
		return null;
	}

	 public  final com.ulcjava.base.application.event.WindowEvent createWindowEvent()
	{
		return null;
	}

	 public  final void processWindowEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.WindowEvent eventObject)
	{
	}

	 public  final java.lang.Class getWindowListenerClass()
	{
		return null;
	}

	 public  final com.ulcjava.base.application.event.WindowEvent createWindowFocusEvent()
	{
		return null;
	}

	 public  final void processWindowFocusEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.WindowEvent eventObject)
	{
	}

	 public  final java.lang.Class getWindowFocusListenerClass()
	{
		return null;
	}

	 public  final com.ulcjava.base.application.event.KeyEvent createKeyEvent(char c, int modifiers)
	{
		return null;
	}

	 public  final void processKeyEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.KeyEvent eventObject)
	{
	}

	 public  final java.lang.Class getKeyListenerClass()
	{
		return null;
	}

	 public  final com.ulcjava.base.application.event.AdjustmentEvent createAdjustmentEvent()
	{
		return null;
	}

	 public  final void processAdjustmentEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.AdjustmentEvent eventObject)
	{
	}

	 public  final java.lang.Class getAdjustmentListenerClass()
	{
		return null;
	}

	 public  final java.util.EventObject createModelUpdateEvent()
	{
		return null;
	}

	 public void processPopupMenuEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.PopupMenuEvent eventObject)
	{
	}

	 public com.ulcjava.base.application.event.PopupMenuEvent createPopupMenuEvent()
	{
		return null;
	}

	 public java.lang.Class getPopupMenuListenerClass()
	{
		return null;
	}


}
}