package com.ulcjava.base.application;


	/**
	* The base class for <code>ULCFrame</code>, <code>ULCDialog</code>,
	* <code>ULCWindow</code>. <code>ULCRootPane</code> contains a content
pane to
	* which its children are being added. Using the <code>ULCRootPane.add</code>
	* methods automatically adds the children to the content
pane.
	*
	* @ulc.application		
	* @see		ULCMenuBar
	* @see		ULCWindow
	* @see		ULCFrame
	* @see		ULCDialog
	**/
 public  abstract class ULCRootPane extends com.ulcjava.base.application.ULCContainer
{

	/**
	* windowDecorationStyle constant used to specify that root pane should not
	* impartany Window decorations.
	*
	**/
	 public  final  static int NONE = 0;

	/**
	* windowDecorationStyle constant used to specify that root pane should impart
	* decorations appropriate for a frame.
	*
	**/
	 public  final  static int FRAME = 0;

	/**
	* windowDecorationStyle constant used to specify that root pane should impart
	* decorations appropriate for a dialog.
	*
	**/
	 public  final  static int PLAIN_DIALOG = 0;

	/**
	* windowDecorationStyle constant used to specify that root pane should impart
	* decorations appropriate for an information dialog.
	*
	**/
	 public  final  static int INFORMATION_DIALOG = 0;

	/**
	* windowDecorationStyle constant used to specify that root pane should impart
	* decorations appropriate for an error dialog.
	*
	**/
	 public  final  static int ERROR_DIALOG = 0;

	/**
	* windowDecorationStyle constant used to specify that root pane should impart
	* decorations appropriate for a color chooser dialog.
	*
	**/
	 public  final  static int COLOR_CHOOSER_DIALOG = 0;

	/**
	* windowDecorationStyle constant used to specify that root pane should impart
	* decorations appropriate for a file chooser dialog.
	*
	**/
	 public  final  static int FILE_CHOOSER_DIALOG = 0;

	/**
	* windowDecorationStyle constant used to specify that root pane should impart
	* decorations appropriate for a question dialog.
	*
	**/
	 public  final  static int QUESTION_DIALOG = 0;

	/**
	* windowDecorationStyle constant used to specify that root pane should impart
	* decorations appropriate for a warning dialog.
	*
	**/
	 public  final  static int WARNING_DIALOG = 0;

	 protected ULCRootPane()
	{
		 super();
	}


	/**
	* Set the ULCContainer content pane.
	*
	* @param contentPane 		 a ULCContainer
	**/
	 public void setContentPane(com.ulcjava.base.application.ULCContainer contentPane)
	{
	}


	/**
	* Returns the content pane.
	*
	* @return		the ULCContainer content pane
	**/
	 public com.ulcjava.base.application.ULCContainer getContentPane()
	{
		return null;
	}


	/**
	* Adds a component to the content pane. Convenience method. Equal to
	* <code>getContentPane().add(ULCComponent)</code>
	*
	* @param component 		 the content.
	* @return		the component argument.
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Adds a component to the content pane with the specified constraints.
	* Convenience method. Equal to
<code>getContentPane().add(ULCComponent,
	* Object)</code>
	*
	* @param component 		 the content.
	* @param constraints 		 the constraints.
	* @return		the component argument.
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, java.lang.Object constraints)
	{
		return null;
	}


	/**
	* Puts the component in a box pane with the specified alignment befover adding
	* itto the root pane.<br>
The alignment can be one of the following
	* values:
<ul><li>BOX_EXPAND_EXPAND
<li>BOX_EXPAND_TOP
<li>BOX_EXPAND_CENTER
<li>
	* BOX_EXPAND_BOTTOM
<li>BOX_LEFT_EXPAND
<li>BOX_LEFT_TOP
<li>BOX_LEFT_CENTER
<li>B
	* OX_LEFT_BOTTOM
<li>BOX_CENTER_EXPAND
<li>BOX_CENTER_TOP
<li>BOX_CENTER_CENTER
<l
	* i>BOX_CENTER_BOTTOM
<li>BOX_RIGHT_EXPAND
<li>BOX_RIGHT_TOP
<li>BOX_RIGHT_CENTER
	* <li>BOX_RIGHT_BOTTOM
</ul>
	*
	* @param alignment 		 the alignment string
	* @param component 		 the component to be decorated
	* @return		the box pane which contains the component
	* @see		BorderedComponentUtilities
	* @deprecated		use
<code>add(BorderedComponentUtilities.createBorderedComponent(component, alignment, BorderFactory.createEmptyBorder(5, 5, 5, 5)))</code>
instead
	**/
	 public com.ulcjava.base.application.ULCComponent add(java.lang.String alignment, com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* Gets the alignment of the added component. <b>Note</b>: This method only
	* works,if the component was added with add(String,
component) or if
	* setAlignment() was used.
	*
	* @return		the alignment string
	* @deprecated		since ULC 6.0
	**/
	 public java.lang.String getAlignment()
	{
		return null;
	}


	/**
	* Returns the menu bar.
	*
	* @return		the ULCMenuBar used in the pane
	**/
	 public com.ulcjava.base.application.ULCMenuBar getMenuBar()
	{
		return null;
	}


	/**
	* Returns the component inside this root pane.
	*
	* @return		the component inside this root pane
	* @deprecated		use <code>getContentPane()</code> instead.
	**/
	 public com.ulcjava.base.application.ULCComponent getComponent()
	{
		return null;
	}


	/**
	* Removes the contained component.
	*
	* @deprecated		use removeAll() instead
	**/
	 public void remove()
	{
	}


	/**
	* Removes all components from the content pane. A convenience method equal to
	* <code>getContentPane().removeAll()</code>
	*
	**/
	 public void removeAll()
	{
	}


	/**
	* Removes the given component from the content pane. A convenience method equal
	* to <code>getContentPane().remove(ULCComponent)</code>
	*
	* @param component 		 the component to be removed.
	**/
	 public void remove(com.ulcjava.base.application.ULCComponent component)
	{
	}


	/**
	* Sets the button that gets 'pressed' in case this pane has the focus and
	* action-like event occurs (usually pressing the Enter key).
The default button
	* action wont be triggered if the component that has the focus also handles
	* action events. Also this button must be
enabled and belong to the hierarchy
	* ofchildren for this RootPane. To disable the default button, call this method
	* with
<code>null</code>
	*
	* @param defaultButton 		 the ULCButton which is to be the default button
	**/
	 public void setDefaultButton(com.ulcjava.base.application.ULCButton defaultButton)
	{
	}


	/**
	* Returns the current default button.
	*
	* @return		the default button
	**/
	 public com.ulcjava.base.application.ULCButton getDefaultButton()
	{
		return null;
	}


	/**
	* Sets the alignment to the added component by putting it in a box pane with the
	* specified alignment.<br>
The alignment can be one of the following
	* values:
<ul>
<li>BOX_EXPAND_EXPAND
<li>BOX_EXPAND_TOP
<li>BOX_EXPAND_CENTER
<li
	* >BOX_EXPAND_BOTTOM
<li>BOX_LEFT_EXPAND
<li>BOX_LEFT_TOP
<li>BOX_LEFT_CENTER
<li>
	* BOX_LEFT_BOTTOM
<li>BOX_CENTER_EXPAND
<li>BOX_CENTER_TOP
<li>BOX_CENTER_CENTER
<
	* li>BOX_CENTER_BOTTOM
<li>BOX_RIGHT_EXPAND
<li>BOX_RIGHT_TOP
<li>BOX_RIGHT_CENTER
	* <li>BOX_RIGHT_BOTTOM
</ul>
	*
	* @param		alignment
	* @deprecated		since ULC 6.0.
	**/
	 public void setAlignment(java.lang.String alignment)
	{
	}


	/**
	* Sets the menu bar for this pane.
	*
	* @param menuBar 		 the ULCMenuBar to be set
	**/
	 public void setMenuBar(com.ulcjava.base.application.ULCMenuBar menuBar)
	{
	}

	 public void setVisible(boolean visible)
	{
	}


	/**
	* Returns the windowDecorationStyle.
	*
	* @return		windowDecorationStyle which is one of:
<ul>
<li> <code>NONE</code>
<li> <code>FRAME</code>
<li> <code>PLAIN_DIALOG</code>
<li> <code>INFORMATION_DIALOG</code>
<li> <code>ERROR_DIALOG</code>
<li> <code>COLOR_CHOOSER_DIALOG</code>
<li> <code>FILE_CHOOSER_DIALOG</code>
<li> <code>QUESTION_DIALOG</code>
<li> <code>WARNING_DIALOG</code>
</ul>
	* @see		#setWindowDecorationStyle(int)
	**/
	 public int getWindowDecorationStyle()
	{
		return 0;
	}


	/**
	* Sets the Window decorations style (such as borders, widgets for closing a
	* Window, title ...) that the root pane should provide. The
default is no
	* Windowdecorations (<code>NONE</code>).
<p>
This is only a hint, and some look
	* and feels may not support this.
	*
	* @param windowDecorationStyle 		 Constant identifying Window decorations to provide.
	* @throws		IllegalArgumentException if <code>windowDecorationStyle</code> is not one of:
<p>
<ul>
<li> <code>NONE</code></li>
<li> <code>FRAME</code></li>
<li> <code>PLAIN_DIALOG</code></li>
<li> <code>INFORMATION_DIALOG</code></li>
<li> <code>ERROR_DIALOG</code></li>
<li> <code>COLOR_CHOOSER_DIALOG</code></li>
<li> <code>FILE_CHOOSER_DIALOG</code></li>
<li> <code>QUESTION_DIALOG</code></li>
<li> <code>WARNING_DIALOG</code></li>
</ul>
</p>
	**/
	 public void setWindowDecorationStyle(int windowDecorationStyle)
	{
	}

	 protected void uploadStateUI()
	{
	}

	 protected void updateLocation(com.ulcjava.base.application.util.Point location)
	{
	}

	 protected void updateSize(com.ulcjava.base.application.util.Dimension size)
	{
	}

	 protected void updateVisible(boolean visible)
	{
	}


	/**
	* Return the current x coordinate of the windows position.
	*
	* @return		the current x coordinate of the windows position.
	**/
	 public int getX()
	{
		return 0;
	}


	/**
	* Return the current y coordinate of the windows position.
	*
	* @return		the current y coordinate of the windows position.
	**/
	 public int getY()
	{
		return 0;
	}


	/**
	* Returns the size of this window.
	*
	* @return		A <code>Dimension</code> object that indicates the size of this window.
	**/
	 public com.ulcjava.base.application.util.Dimension getSize()
	{
		return null;
	}


	/**
	* Resizes this window.
	*
	* @param size 		 The dimension specifying the new size of this window.
	**/
	 public void setSize(com.ulcjava.base.application.util.Dimension size)
	{
	}


	/**
	* Resizes this window to the given width <code>width</code> and
	* <code>height</code>.
	*
	* @param width 		 The new width of this window in pixels.
	* @param height 		 The new height of this window in pixels.
	**/
	 public void setSize(int width, int height)
	{
	}


	/**
	* Moves this window to a new location. The parameters <code>x</code> and
	* <code>y</code> spcify the top-left corner of the window.
	*
	* @param x 		 The <i>x</i>-coordinate of the new location's top-left corner
	* @param y 		 The <i>y</i>-coordinate of the new location's top-left corner
	**/
	 public void setLocation(int x, int y)
	{
	}


	/**
	* Gets the location of this window in the form of a point specifying the
	* window'stop-left corner. </p>
	*
	* @return		An instance of <code>Point</code> representing the top-left corner of the window.
	**/
	 public com.ulcjava.base.application.util.Point getLocation()
	{
		return null;
	}


	/**
	* Moves this window to a new location. The top-left corner of the new location
	* isspecified by point <code>location</code>.
	*
	* @param location 		 The point defining the top-left corner of the new location.
	**/
	 public void setLocation(com.ulcjava.base.application.util.Point location)
	{
	}


	/**
	* Returns the height of the window.
	*
	* @return		the height of the window
	**/
	 public int getHeight()
	{
		return 0;
	}


	/**
	* Returns the width of the window.
	*
	* @return		the width of the window
	**/
	 public int getWidth()
	{
		return 0;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCRootPaneDispatcher extends ULCContainerDispatcher
{

	 public  final void updateLocation(com.ulcjava.base.application.util.Point location)
	{
	}

	 public  final void updateSize(com.ulcjava.base.application.util.Dimension size)
	{
	}

	 public  final void updateVisible(boolean visible)
	{
	}


}
}