package com.ulcjava.base.application;


	/**
	* A <code>ULCScrollPane</code> provides a scrollable view of a component. When
	* screen real estate is limited, use a scroll pane to
display a component that
	* is large or one whose size can change dynamically. The
	* <code>ULCScrollPane</code> provides a window, or
"viewport" onto a data
	* source- for example, a <code>ULCList</code>. That data source is the
	* "scrollable client" (also called view or
viewport view). A
	* <code>ULCScrollPane</code> basically consists of <code>ULCScrollBars</code>,
	* an underplaying "scrollable client",
a non accessible viewport, and the
	* wiringbetween them.
<p>
</p>
When the user manipulates the scroll bars in a
	* scroll pane, the area of the client that is visible changes accordingly. This
	* picture
shows the relationship between the scroll pane and its client and
	* indicates the classes that the scroll pane commissions to help:
<p
	* align=center>
<img src="doc-files/scroll-pane.png" alt="Components of a
	* ULCScrollPane"><br>
Components of a
	* <code>ULCScrollPane</code>
<p>
</p>
<b>Features</b>
<ul>
<li>The area drawn
	* bya scroll pane consists of up to nine parts: the center, four sides, and
	* fourcorners. The center is the only
component that is always present in all
	* scroll panes. Besides scroll bars, the sides can contain column and row
	* headers. A corner
component is visible only if both sides that intersect at
	* that corner contain visible components.</li>
<li>In addition to the scroll
	* bars and viewport, a <code>ULCScrollPane</code> can have a column header and
	* arow header. Each of these
is a viewport object that you specify with
	* <code>setRowHeaderView()</code>, and <code>setColumnHeaderView()</code>. The
	* column
header viewport automatically scrolls left and right, tracking the
	* left-right scrolling of the main viewport. (It never scrolls
vertically,
	* however.) The row header acts in a similar fashion.</li>
<li>By default, the
	* corners are empty. You can put a component into a corner using
	* <code>setCorner()</code>, in case you there is
some function or decoration
	* youwould like to add to the scroll pane. The size of corner components is
	* entirely determined by the size of
the headers and scroll bars that surround
	* them.</li>
<li>The example below sets the scroll pane's scroll bar policies
	* explicitly - the default is "as needed". You can set the policies when
you
	* create the scroll pane or change them dynamically.</li>
<li>Some
	* scrolling-savvy components such as <code>ULCList</code>,
	* <code>ULCTable</code>, <code>ULCTree</code> and
<code>ULCTableTree</code>
	* alsoprovide additional API to help you affect their scrolling
	* behavior.</li>
</ul>
</p>
<b>Examples</b>
<p>
</p>

<pre>
ULCTree tree = new
	* ULCTree();
ULCScrollPane scrollPane = new
	* ULCScrollPane(tree);
scrollPane.setPreferredSize(new Dimension(100, 150));
//
	* sets the scrollbar policy to 'always' - default is 'if
	* needed'
scrollPane
.setVerticalScrollBarPolicy(ULCScrollPane.VERTICAL_SCROLLBAR
	* _ALWAYS);
scrollPane
.setHorizontalScrollBarPolicy(ULCScrollPane.HORIZONTAL_SCRO
	* LLBAR_ALWAYS);
ULCScrollBar verticalScrollBar =
	* scrollPane.getVerticalScrollBar();
verticalScrollBar.setBackground(Color.blue);
	* ULCScrollBar horizontalScrollBar =
	* scrollPane.getHorizontalScrollBar();
horizontalScrollBar.setBackground(Color.re
	* d);
</pre>

<p>
</p>
<b>Sizing of components using a
	* ULCScrollPane</b>
<p>
</p>If a component is embedded in a
	* <code>ULCScrollPane</code> it is not practical to set the preferred size on
	* this component. As a result
of this the viewport view size will be restricted
	* to the given size and the surrounding scroll pane will only scroll this given
	* size. The
underplaying component will may not be displayed completely by the
	* viewport - especially if the viewport view is growing dynamically.
	* To
restrictthe size of the component use the method
	* <code>setPreferedSize()</code> on the scroll pane.
	*
	* @ulc.application		
	* @see		ULCScrollBar
	**/
 public class ULCScrollPane extends com.ulcjava.base.application.ULCContainer
{

	/**
	* View of the view port.
	*
	**/
	 public  final  static java.lang.String VIEW_PORT_VIEW = null;

	/**
	* View of the row header view port.
	*
	**/
	 public  final  static java.lang.String ROW_HEADER_VIEW = null;

	/**
	* View of the column header view port.
	*
	**/
	 public  final  static java.lang.String COLUMN_HEADER_VIEW = null;

	/**
	* Lower left corner of the viewport.
	*
	**/
	 public  final  static java.lang.String LOWER_LEFT_CORNER = null;

	/**
	* Lower right corner of the viewport.
	*
	**/
	 public  final  static java.lang.String LOWER_RIGHT_CORNER = null;

	/**
	* Upper left corner of the viewport.
	*
	**/
	 public  final  static java.lang.String UPPER_LEFT_CORNER = null;

	/**
	* Upper right corner of the viewport.
	*
	**/
	 public  final  static java.lang.String UPPER_RIGHT_CORNER = null;

	/**
	* Horizonatal scroll bar.
	*
	**/
	 public  final  static java.lang.String VERTICAL_SCROLLBAR = null;

	/**
	* Vertical scroll bar.
	*
	**/
	 public  final  static java.lang.String HORIZONTAL_SCROLLBAR = null;

	/**
	* Horizontal scrollbars is displayed only when needed.
	*
	**/
	 public  final  static int HORIZONTAL_SCROLLBAR_AS_NEEDED = 0;

	/**
	* Horizontal scrollbar is never displayed.
	*
	**/
	 public  final  static int HORIZONTAL_SCROLLBAR_NEVER = 0;

	/**
	* Horizontal scrollbar is always displayed.
	*
	**/
	 public  final  static int HORIZONTAL_SCROLLBAR_ALWAYS = 0;

	/**
	* Vertical scrollbars is displayed only when needed.
	*
	**/
	 public  final  static int VERTICAL_SCROLLBAR_AS_NEEDED = 0;

	/**
	* Vertical scrollbar is never displayed.
	*
	**/
	 public  final  static int VERTICAL_SCROLLBAR_NEVER = 0;

	/**
	* Vertical scrollbar is always displayed.
	*
	**/
	 public  final  static int VERTICAL_SCROLLBAR_ALWAYS = 0;


	/**
	* Creates an empty <code>ULCScrollPane</code>. No viewport is created. The
	* horizontal and vertical scrollbar appear if the view
component's content is
	* larger than the available viewport size.
	*
	**/
	 public ULCScrollPane()
	{
		 super();
	}


	/**
	* Creates a new <code>ULCScrollPane</code>. The view component is displayed in a
	* viewport. The horizontal and vertical scrollbar
appear if the view
	* component'scontent is larger than the available viewport size.
	*
	* @param viewPortView 		 the component to display in the scroll pane's viewport
	**/
	 public ULCScrollPane(com.ulcjava.base.application.ULCComponent viewPortView)
	{
		 super();
	}


	/**
	* Creates an empty <code>ULCScrollPane</code>. No viewport is created. The view
	* position can be adjusted through a horizontal and a
vertical
	* scrollbar.
<p>
</p>
Legal horizontal scrollbar policy values
	* are:
<ul>
<li>HORIZONTAL_SCROLLBAR_AS_NEEDED</li>
<li>HORIZONTAL_SCROLLBAR_NEVE
	* R</li>
<li>HORIZONTAL_SCROLLBAR_ALWAYS</li>
</ul>
<p>
</p>
Legal vertical
	* scrollbar policy values
	* are:
<ul>
<li>VERTICAL_SCROLLBAR_AS_NEEDED</li>
<li>VERTICAL_SCROLLBAR_NEVER</l
	* i>
<li>VERTICAL_SCROLLBAR_ALWAYS</li>
</ul>
	*
	* @param vsbPolicy 		 one of the three horizontal scrollbar policy values listed above
	* @param hsbPolicy 		 one of the three vertical scrollbar policy values listed above
	**/
	 public ULCScrollPane(int vsbPolicy, int hsbPolicy)
	{
		 super();
	}


	/**
	* Creates a new <code>ULCScrollPane</code>. The view component is displayed in a
	* viewport. The view position can be adjusted through
a horizontal and a
	* vertical scrollbar.
<p>
</p>
Legal horizontal scrollbar policy values
	* are:
<ul>
<li>HORIZONTAL_SCROLLBAR_AS_NEEDED</li>
<li>HORIZONTAL_SCROLLBAR_NEVE
	* R</li>
<li>HORIZONTAL_SCROLLBAR_ALWAYS</li>
</ul>
<p>
</p>
Legal vertical
	* scrollbar policy values
	* are:
<ul>
<li>VERTICAL_SCROLLBAR_AS_NEEDED</li>
<li>VERTICAL_SCROLLBAR_NEVER</l
	* i>
<li>VERTICAL_SCROLLBAR_ALWAYS</li>
</ul>
	*
	* @param viewPortView 		 the component to display in the scroll panes viewport
	* @param verticalScrollBarPolicy 		 one of the three horizontal scrollbar policy values listed above
	* @param horizontalScrollBarPolicy 		 one of the three vertical scrollbar policy values listed above
	* @throws		IllegalArgumentException if horizontal or vertical scrollbar policy is invalid
	**/
	 public ULCScrollPane(com.ulcjava.base.application.ULCComponent viewPortView, int verticalScrollBarPolicy, int horizontalScrollBarPolicy)
	{
		 super();
	}


	/**
	* Adds a component to a scroll pane at a specified place in the scroll pane. The
	* specified constraint must be one of the
	* following:
<ul>
<li>ULCScrollPane.VIEW_PORT_VIEW
<li>ULCScrollPane.VERTICAL_SCR
	* OLLBAR
<li>ULCScrollPane.HORIZONTAL_SCROLLBAR
<li>ULCScrollPane.ROW_HEADER_VIEW
	* <li>ULCScrollPane.COLUMN_HEADER_VIEW
<li>ULCScrollPane.LOWER_LEFT_CORNER
<li>ULC
	* ScrollPane.LOWER_RIGHT_CORNER
<li>ULCScrollPane.UPPER_LEFT_CORNER
<li>ULCScrollP
	* ane.UPPER_RIGHT_CORNER
</ul>
	*
	* @param component 		 the component to be added
	* @param constraints 		 the place where the component should be added
	* @return		the added component
	* @throws		IllegalArgumentException if the constraint is not a String and is not one of the above values
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, java.lang.Object constraints)
	{
		return null;
	}


	/**
	* Returns the view component of the viewport.
	*
	* @return		the view component of the viewport
	**/
	 public com.ulcjava.base.application.ULCComponent getViewPortView()
	{
		return null;
	}


	/**
	* Sets the view component to be displayed in the viewport.
<p>
</p>
Applications
	* should not add children directly to the scroll pane.
	*
	* @param viewPortView 		 the component to display in the scroll pane's viewport
	**/
	 public void setViewPortView(com.ulcjava.base.application.ULCComponent viewPortView)
	{
	}


	/**
	* Returns the row header view component of the row header viewport.
	*
	* @return		the row header view component of the row header viewport
	**/
	 public com.ulcjava.base.application.ULCComponent getRowHeaderView()
	{
		return null;
	}


	/**
	* Sets the row header view component to be displayed in the row header viewport.
	*
	* @param rowHeaderView 		 the component to display in the scroll pane's row header viewport
	**/
	 public void setRowHeaderView(com.ulcjava.base.application.ULCComponent rowHeaderView)
	{
	}


	/**
	* Returns the column header view component of the column header viewport.
	*
	* @return		the column header view component of the column header viewport
	**/
	 public com.ulcjava.base.application.ULCComponent getColumnHeaderView()
	{
		return null;
	}


	/**
	* Sets the column header view component to be displayed in the column header
	* viewport.
	*
	* @param columnHeaderView 		 the component to display in the scroll pane's column header viewport
	**/
	 public void setColumnHeaderView(com.ulcjava.base.application.ULCComponent columnHeaderView)
	{
	}


	/**
	* Returns the corner component at the specified position.
	*
	* @param key 		 the position of the corner to query
	* @return		the corner component at the specified position
	**/
	 public com.ulcjava.base.application.ULCComponent getCorner(java.lang.String key)
	{
		return null;
	}


	/**
	* Sets the component in the specified scroll pane corner position, if there is
	* room.
<p>
</p>
The position key can be one of the following
	* values:
<ul>
<li><code>LOWER_LEFT_CORNER</code>
<code>LOWER_RIGHT_CORNER</code>
	* <code>UPPER_LEFT_CORNER</code> <code>UPPER_RIGHT_CORNER</code>
</ul>
	*
	* @param key 		 the corner position where to add the specified component
	* @param corner 		 the component to be placed in the corner position
	* @throws		IllegalArgumentException if corner key is invalid
	**/
	 public void setCorner(java.lang.String key, com.ulcjava.base.application.ULCComponent corner)
	{
	}


	/**
	* Sets the position of the horizontal scrollbar relative to the height of the
	* viewport view.
	*
	* @param position 		 a value between 0 and 1 indicating the horizontal scrollbar position
	**/
	 public void setHorizontalScrollBarPosition(double position)
	{
	}


	/**
	* Returns the horizontal scroll bar policy value.
	*
	* @return		the horizontal scroll bar policy value
	**/
	 public int getHorizontalScrollBarPolicy()
	{
		return 0;
	}


	/**
	* Determines when the horizontal scrollbar appears in the scroll
	* pane.
<p>
</p>
Legal policy values
	* are:
<ul>
<li>HORIZONTAL_SCROLLBAR_AS_NEEDED
<li>HORIZONTAL_SCROLLBAR_NEVER
<li
	* >HORIZONTAL_SCROLLBAR_ALWAYS
</ul>
	*
	* @param horizontalScrollBarPolicy 		 one of the three vertical scrollbar policy values listed above
	* @throws		IllegalArgumentException if horizontal scrollbar policy is invalid
	**/
	 public void setHorizontalScrollBarPolicy(int horizontalScrollBarPolicy)
	{
	}


	/**
	* Sets the position of the vertical scrollbar relative to the width of the
	* viewport view.
	*
	* @param position 		 a value between 0 and 1 indicating the vertical scrollbar position
	**/
	 public void setVerticalScrollBarPosition(double position)
	{
	}


	/**
	* Returns the vertical scroll bar policy value.
	*
	* @return		the vertical scroll bar policy value
	**/
	 public int getVerticalScrollBarPolicy()
	{
		return 0;
	}


	/**
	* Determines when the vertical scrollbar appears in the scroll
	* pane.
<p>
</p>
Legal policy values
	* are:
<ul>
<li>VERTICAL_SCROLLBAR_AS_NEEDED
<li>VERTICAL_SCROLLBAR_NEVER
<li>VER
	* TICAL_SCROLLBAR_ALWAYS
</ul>
	*
	* @param verticalScrollBarPolicy 		 one of the three horizontal scrollbar policy values listed above
	* @throws		IllegalArgumentException if vertical scrollbar policy is invalid
	**/
	 public void setVerticalScrollBarPolicy(int verticalScrollBarPolicy)
	{
	}


	/**
	* Returns the horizontal scroll bar that controls the viewport's horizontal view
	* position.
	*
	* @return		the horizontal <code>ULCScrollBar</code> instance
	**/
	 public com.ulcjava.base.application.ULCScrollBar getHorizontalScrollBar()
	{
		return null;
	}


	/**
	* Sets the scrollbar that controls the viewport's horizontal view position to
	* thescrollpane.
	*
	* @param horizontalScrollBar 		 the horizontal scrollbar to be added
	* @throws		IllegalArgumentException if horizontalScrollBar is null
	**/
	 public void setHorizontalScrollBar(com.ulcjava.base.application.ULCScrollBar horizontalScrollBar)
	{
	}


	/**
	* Returns the vertical scroll bar that controls the viewport's vertical view
	* position.
	*
	* @return		the vertical <code>ULCScrollBar</code> instance
	**/
	 public com.ulcjava.base.application.ULCScrollBar getVerticalScrollBar()
	{
		return null;
	}


	/**
	* Sets the scrollbar that controls the viewport's vertical view position to the
	* scrollpane.
	*
	* @param verticalScrollBar 		 the vertical scrollbar to be added
	* @throws		IllegalArgumentException if verticalScrollBar is null
	**/
	 public void setVerticalScrollBar(com.ulcjava.base.application.ULCScrollBar verticalScrollBar)
	{
	}


	/**
	* Returns an <code>ULCScrollBar</code> by default.
	*
	* @return		an <code>ULCScrollBar</code> with a horizontal orientation
	**/
	 protected com.ulcjava.base.application.ULCScrollBar createHorizontalScrollBar()
	{
		return null;
	}


	/**
	* Returns an <code>ULCScrollBar</code> by default.
	*
	* @return		an <code>ULCScrollBar</code> with a vertical orientation
	**/
	 protected com.ulcjava.base.application.ULCScrollBar createVerticalScrollBar()
	{
		return null;
	}


	/**
	* Returns the <code>ULCAbstractBorder</code> object that surrounds the viewport.
	*
	* @return		the <code>viewportBorder</code> property
	* @see		#setViewportBorder
	**/
	 public com.ulcjava.base.application.border.ULCAbstractBorder getViewportBorder()
	{
		return null;
	}


	/**
	* Adds a border around the viewport.
<p>
</p>
The default value of this property
	* is computed by the look and feel implementation.
	*
	* @param viewportBorder 		 the border to be added
	* @see		#getViewportBorder
	**/
	 public void setViewportBorder(com.ulcjava.base.application.border.ULCAbstractBorder viewportBorder)
	{
	}


	/**
	* Returns if scrolling by mouse wheel is enabled or not.
	*
	* @return		true if scrolling will take place in response to the mouse wheel, false otherwise
	* @see		#setWheelScrollingEnabled
	**/
	 public boolean isWheelScrollingEnabled()
	{
		return false;
	}


	/**
	* Sets whether scrolling will take place in response to movement of the mouse
	* wheel. Default value is wheel scrolling enabled.
	*
	* @param wheelScrollState 		 <code>true</code> if scrolling should be done in response to mouse wheel movement, <code>false</code>
otherwise
	* @see		#isWheelScrollingEnabled
	**/
	 public void setWheelScrollingEnabled(boolean wheelScrollState)
	{
	}


	/**
	* Sets the orientation for the vertical and horizontal scrollbars as determined
	* by the <code>ComponentOrientation</code> parameter.
	*
	* @param componentOrientation 		 the ComponentOrientation to set
	* @see		com.ulcjava.base.application.util.ComponentOrientation
	**/
	 public void setComponentOrientation(com.ulcjava.base.application.util.ComponentOrientation componentOrientation)
	{
	}

	 protected void uploadStateUI()
	{
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected java.lang.Object createDefaultConstraints(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCScrollPaneDispatcher extends ULCContainerDispatcher
{


}
}