package com.ulcjava.base.application;


	/**
	* The <code>ULCTable</code> component displays a list of objects in the form of
	* ascrollable table containing multiple columns. To make the
table scrollable,
	* it has to be put in a
	* <code>ULCScrollPane</code>.
<p>
</p>
<b>Features</b>
<ul>
<li>The
	* <code>ULCTable</code> component inherits all features of
	* <code>ULCComponent</code>.
<li>The list of items that are displayed in the
	* <code>ULCTable</code> is provided by an <code>ITableModel</code>. The model
	* determines
the number of columns and rows identified by indices and provides
	* the table data.
<li>The <code>ULCTable</code> transparently supports lazy
	* loading of data. Only the data of the currently visible cells are uploaded
	* to
the client.
<li>The table uses <code>ULCListSelectionModel</code>
	* instancesto manage its row selection and column model's selection. The
	* application
can register IListSelectionListener objects with one or both
	* selection models. These listeners are notified when the selection on
	* the
<code>ULCTable</code> changes. <code>ULCTable</code> allows the following
	* selection modes: single selection, single interval selection,
or multiple
	* interval selection. Moreover, the application can use methods to retrieve and
	* alter the current selection on the table.
<li>The visual feedback of the
	* selection can be configured:
<ul>
<li>The color of the selection is specified
	* with the help of the selectionBackground and the selectionForeground
	* properties.
<li>To give visual feedback for selected rows, set the
	* <code>rowSelectionAllowed</code> property to true, for selected columns set
	* the
<code>columnSelectionAllowed</code> property to true (default is
	* <code>rowSelectionAllowed</code> only).
<li>To give visual feedback for
	* selected cells, set the <code>cellSelectionEnabled</code> property to true
	* (default is <code>false</code>
). A cell is selected if both its row and
	* column are selected. Setting this property is equivalent to setting both
	* the
<code>rowSelectionAllowed</code> and the
	* <code>columnSelectionAllowed</code> property to
	* <code>true</code>.
</ul>
<li>Registration of <code>IActionListeners</code>
	* allows tracking of action events issued by the table (i.e., double clicks on
	* acell or
row).
<li>Setting of a <code>TableRowSorter</code> provides the
	* infrastructure for sorting of <code>ULCTables</code> after model changes
	* or
after user interactions, e.g. clicking on a column header.
<li>Setting a
	* <code>TableRowFilter</code> on a <code>TableRowSorter</code> provides the
	* ability for filtering the <code>ULCTable</code>.
<li><code>ULCTable</code>
	* allows customization of its appearance via renderer mechanism. A renderer
	* implements the
<code>ITableCellRenderer</code> interface and can be set on a
	* table column, a table header or on the table itself
	* via
<code>setDefaultRenderer()</code>. When a table cell is to be rendered
	* thefollowing steps are followed:
<ul>
<li>If a renderer for the given column
	* was defined, it is used to draw the cell,
<li>Else if the default renderer
	* wasspecified via <code>setDefaultRenderer(Class columnClass,
	* ITableCellRenderer renderer)</code> then
it is used to draw the cell. The
	* column class is obtained via <code>getColumnClass()</code>. The column class
	* is specified in the model
by implementing
	* <code>getColumnClass(int)</code>,
<li>Otherwise a default renderer is
	* used.
</ul>
<li><code>ULCTable</code> allows customization of cell editors.
	* Aneditor implements the <code>ITableCellEditor</code> interface and can
be
	* seton a table column or on the table itself via
	* <code>setDefaultEditor()</code>. The editor for a cell is selected by a
	* mechanism
that is similar to that for selecting a renderer as described
	* above.A property <code>surrendersFocusOnKeystroke</code> determines if
	* the
table will transfer focus to the editor on a
	* keystroke.
<li><code>ULCTable</code> offers the following mechanisms for
	* stopping cell editor on focus lost event:
<ul>
<li>If the property
	* <code>ulcTerminateEditOnFocusLost</code> has been set to
	* <code>Boolean.FALSE</code> using the
	* method
<code>putClientProperty("ulcTerminateEditOnFocusLost",
	* Boolean.FALSE)</code>, the editor is NOT stopped on focus lost.
<li>If the
	* property <code>ulcTerminateEditOnFocusLost</code> is
	* <code>Boolean.TRUE</code>(which it is by default), the editor is
	* stopped
whenever it or the table loses focus.
<li>If the property
	* <code>terminateEditOnFocusLost</code> has been set to
	* <code>Boolean.TRUE</code> using the
	* method
<code>putClientProperty("terminateEditOnFocusLost",
	* Boolean.TRUE)</code>, the editor is stopped on focus lost but only when the
	* focus is
transferred to a component that does not have the same window
	* ancestor as the table. This mode is used by Swing. This mode is useful
	* when
the developer wishes to have popup editors, however in such as case the
	* onus of stopping the editor is on the
	* developer.
</ul>
</ul>
<b>Examples</b>
<p>
</p>
The following example shows
	* how to set up a simple table. After setting some properties on the table,
	* register an
<code>IActionListener</code> that listens for double
	* clicks.

<pre>
ULCTable table = new
	* ULCTable(tableModel);
table.setShowHorizontalLines(true);
table.setShowVertical
	* Lines(true);
table.setAutoResizeMode(ULCTable.AUTO_RESIZE_ALL_COLUMNS);
table.ad
	* dActionListener(new IActionListener() {
public void
	* actionPerformed(ActionEventevent) {
ULCTable source =
	* (ULCTable)event.getSource();
System.out.println(&quot;row double clicked:
	* &quot;
+ source.getSelectedRow());
}
});
</pre>
<p>
</p>
To select a row and
	* ensure that this row is visible:
<p>

<pre>
table.setRowSelectionInterval(1,
	* 1);
table.scrollCellToVisible(1, 1);
</pre>
<p>
</p>
The following example
	* configures the selection properties of the table and installs a selection
	* changed
	* listener.

<pre>
table.setSelectionBackground(Color.black);
table.setSelectionF
	* oreground(Color.white);
table.setSelectionMode(ULCListSelectionModel.SINGLE_INTE
	* RVAL_SELECTION);
table.setRowSelectionAllowed(false);
table.setColumnSelectionAl
	* lowed(true);
IListSelectionListener listener = new IListSelectionListener()
	* {
public void valueChanged(ListSelectionEvent event) {
ULCListSelectionModel
	* source =
	* (ULCListSelectionModel)event
.getSource();
System.out.println(&quot;selection
	* changed: &quot;
+ source.getMinSelectionIndex());
}
};
ULCTableColumnModel
	* columnModel =
	* table.getColumnModel();
table.getSelectionModel().addListSelectionListener(list
	* ener);
columnModel.getSelectionModel().addListSelectionListener(listener);
</pre
	* >
<p>
</p>
The following sample shows the usage of a TableRowSorter together
	* with a TableRowFilter:

<pre><code>
DefaultTableModel tableModel =
	* createTableModel();

ULCTable table = new
	* ULCTable(tableModel);

TableRowSorter tableRowSorter = new
	* TableRowSorter(tableModel);
tableRowSorter.setRowFilter(TableRowFilter.regexFil
	* ter(".*sample.*", new int[] {0, 1,
	* 2}));
table.setRowSorter(tableRowSorter);
</code></pre>
<p>
</p>
The
	* followingexample shows how to configure the table appearance. The table
	* headeris set to be painted with pink background, one of the
columns will be
	* painted with cyan background, except for the focused cell which will appear
	* onthe orange background.

<pre>
final ULCLabel rendererLabel = new
	* ULCLabel();table.getTableHeader().setDefaultRenderer(new ITableCellRenderer()
	* {
public IRendererComponent getTableCellRendererComponent(
ULCTable table,
	* Object value, boolean isSelected,
boolean hasFocus, int row)
	* {
rendererLabel.setBackground(Color.pink);
return
	* rendererLabel;
}
});
table.getColumnModel().getColumn(TaskTableModel.DUE_INDEX)
	* .setCellRenderer(new ITableCellRenderer() {
public IRendererComponent
	* getTableCellRendererComponent(
ULCTable table, Object value, boolean
	* isSelected,
boolean hasFocus, int row) {
if (hasFocus)
	* {
rendererLabel.setBackground(Color.orange);
} else
	* {
rendererLabel.setBackground(Color.cyan);
}
return rendererLabel;
}
});
</pre>
	*
	* @ulc.application		
	* @see		ULCComponent
	* @see		com.ulcjava.base.application.table.ITableModel
	* @see		com.ulcjava.base.application.table.ULCTableColumn
	* @see		com.ulcjava.base.application.util.Color
	**/
 public class ULCTable extends com.ulcjava.base.application.ULCComponent implements com.ulcjava.base.server.dnd.IDnDComponent
{

	/**
	* Do not adjust column widths automatically; use a scrollbar.
	*
	**/
	 public  final  static int AUTO_RESIZE_OFF = 0;

	/**
	* When a column is adjusted in the UI, adjust the next column the opposite way.
	*
	**/
	 public  final  static int AUTO_RESIZE_NEXT_COLUMN = 0;

	/**
	* During UI adjustment, change subsequent columns to preserve the total width;
	* this is the default behavior.
	*
	**/
	 public  final  static int AUTO_RESIZE_SUBSEQUENT_COLUMNS = 0;

	/**
	* During all resize operations, apply adjustments to the last column only.
	*
	**/
	 public  final  static int AUTO_RESIZE_LAST_COLUMN = 0;

	/**
	* During all resize operations, proportionately resize all columns.
	*
	**/
	 public  final  static int AUTO_RESIZE_ALL_COLUMNS = 0;

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void setParent(com.ulcjava.base.application.ULCContainer parent)
	{
	}

	 protected com.ulcjava.base.application.event.ActionEvent createActionEvent(java.lang.String command, int modifiers)
	{
		return null;
	}

	 protected void requestCellRendererComponents(int[] range, int[] columns)
	{
	}

	 protected void requestCellEditorComponents(int[] range, int[] columns)
	{
	}

	 protected void requestHeaderRendererComponents(int[] columns)
	{
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}


	/**
	* Registers an <code>IActionListener</code> for this table.
	*
	* @param listener 		 the <code>IActionListener</code> to be added
	**/
	 public void addActionListener(com.ulcjava.base.application.event.IActionListener listener)
	{
	}


	/**
	* Returns the action command for this table.
	*
	* @return		the action command property
	**/
	 public java.lang.String getActionCommand()
	{
		return null;
	}


	/**
	* Returns an array of all the <code>IActionListener</code>s added to this
	* <code>ULCTable</code> with <code>addActionListener()</code>.
	*
	* @return		all <code>IActionListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.IActionListener[] getActionListeners()
	{
		return null;
	}


	/**
	* Removes an <code>IActionListener</code> from the table.
	*
	* @param listener 		 the listener to be removed
	**/
	 public void removeActionListener(com.ulcjava.base.application.event.IActionListener listener)
	{
	}


	/**
	* Scrolls the cell identified by row and columnm until it is displayed. The
	* minimum of amount of scrolling necessary to bring the row
into view is
	* performed.
	*
	* @param row 		 an integer specifying the row to scroll, where 0 is the first row in the display
	* @param column 		 an integer specifying the column to scroll, where 0 is the first row in the display
	**/
	 public void scrollCellToVisible(int row, int column)
	{
	}


	/**
	* Sets the action command property for this table.
	*
	* @param actionCommand 		 the action command for the table
	**/
	 public void setActionCommand(java.lang.String actionCommand)
	{
	}


	/**
	* Constructs a default <code>ULCTable</code> that is initialized with a default
	* data model.
	*
	**/
	 public ULCTable()
	{
		 super();
	}


	/**
	* Constructs a <code>ULCTable</code> to display the values in the
	* <code>List</code> of <code>Lists</code>, <code>rowData</code>, with
column
	* names, <code>columnNames</code>. The <code>Lists</code> contained in
	* <code>rowData</code> should contain the values for that
row. In other words,
	* the value of the cell at row 1, column 5 can be obtained with the following
	* code:
<p>
</p>

<pre>
((List)rowData.get(1)).get(5);
</pre>
<p>
</p>
Each row
	* must contain a value for each column or an exception will be raised.
<p>
</p>
	*
	* @param rowData 		 the data for the new table
	* @param columnNames 		 names of each column
	**/
	 public ULCTable(java.util.List rowData, java.util.List columnNames)
	{
		 super();
	}


	/**
	* Constructs a <code>ULCTable</code> to display the values in the two
	* dimensionalarray, <code>rowData</code>, with column
	* names,
<code>columnNames</code>. <code>rowData</code> is an array of rows, so
	* the value of the cell at row 1, column 5 can be obtained with
the following
	* code:
<p>
</p>

<pre>
rowData[1][5];
</pre>
<p>
</p>
All rows must be of the
	* same length as <code>columnNames</code>.
<p>
</p>
	*
	* @param rowData 		 the data for the new table
	* @param columnNames 		 names of each column
	**/
	 public ULCTable(java.lang.Object[][] rowData, java.lang.String[] columnNames)
	{
		 super();
	}


	/**
	* Constructs a ULCTable displaying values retrieved from the given table model.
	*
	* @param model 		 the table model that provides the data.
	**/
	 public ULCTable(com.ulcjava.base.application.table.ITableModel model)
	{
		 super();
	}


	/**
	* Constructs a ULCTable displaying values retrieved from the given table model.
	*
	* @param model 		 the table model that provides the data.
	* @param columnModel 		 the column model
	* @param selectionModel 		 the selection model
	**/
	 public ULCTable(com.ulcjava.base.application.table.ITableModel model, com.ulcjava.base.application.table.ULCTableColumnModel columnModel, com.ulcjava.base.application.ULCListSelectionModel selectionModel)
	{
		 super();
	}


	/**
	* Appends a ULCTableColumn at the right end of the ULCTable.
	*
	* @param column 		 the <code>ULCTableColumn</code> to be added as the last column
	**/
	 public void addColumn(com.ulcjava.base.application.table.ULCTableColumn column)
	{
	}


	/**
	* Adds the columns from <code>index0</code> to <code>index1</code>, inclusive,
	* tothe current selection.
	*
	* @param index0 		 one end of the interval
	* @param index1 		 the other end of the interval
	* @throws		IllegalArgumentException if <code>index0</code> or <code>index1</code> lie outside [0, <code>getColumnCount()</code>-1]
	**/
	 public void addColumnSelectionInterval(int index0, int index1)
	{
	}


	/**
	* Adds the rows from <code>index0</code> to <code>index1</code>, inclusive, to
	* the current selection.
	*
	* @param index0 		 one end of the interval
	* @param index1 		 the other end of the interval
	* @throws		IllegalArgumentException if <code>index0</code> or <code>index1</code> lie outside [0, <code>getRowCount()</code>-1]
	**/
	 public void addRowSelectionInterval(int index0, int index1)
	{
	}


	/**
	* Deselects all selected columns and rows.
	*
	**/
	 public void clearSelection()
	{
	}


	/**
	* Converts the index of the column in the view to the index of the column in the
	* table model. Returns <code>viewColumnIndex</code> in
case it is < 0.
	*
	* @param viewColumnIndex 		 the index of the column in the view
	* @return		the index of the corresponding column in the model
	* @see		#convertColumnIndexToView
	**/
	 public int convertColumnIndexToModel(int viewColumnIndex)
	{
		return 0;
	}


	/**
	* Converts the index of the column in the table model to the index of the column
	* in the view. In case this column is not in the view,
-1 is returned. Returns
	* <code>modelColumnIndex</code> if it is < 0.
	*
	* @param modelColumnIndex 		 the index of the column in the model
	* @return		the index of the corresponding column in the view
	* @see		#convertColumnIndexToModel
	**/
	 public int convertColumnIndexToView(int modelColumnIndex)
	{
		return 0;
	}


	/**
	* Creates default columns for the table from the data model using the
	* <code>getColumnCount</code> method defined in the
<code>ITableModel</code>
	* interface.
<p>
</p>
Clears any existing columns before creating the new
	* columns based on information from the model.
	*
	* @see		#getAutoCreateColumnsFromModel
	* @see		#setAutoCreateColumnsFromModel
	**/
	 public void createDefaultColumnsFromModel()
	{
	}

	 protected com.ulcjava.base.application.ULCListSelectionModel createDefaultSelectionModel()
	{
		return null;
	}


	/**
	* Determines whether the table will create default columns from the model. If
	* true, <code>setModel</code> will clear any existing
columns and create new
	* columns from the new model. Also, if the event in the
	* <code>tableChanged</code> notification specifies that
the entire table
	* changed, then the columns will be rebuilt. The default is true.
	*
	* @return		the autoCreateColumnsFromModel of the table
	* @see		#setAutoCreateColumnsFromModel
	* @see		#createDefaultColumnsFromModel
	**/
	 public boolean getAutoCreateColumnsFromModel()
	{
		return false;
	}


	/**
	* Returns the resize mode of the table. The default mode is
	* AUTO_RESIZE_SUBSEQUENT_COLUMNS.
	*
	* @return		the autoResizeMode of the table
	* @see		#setAutoResizeMode
	**/
	 public int getAutoResizeMode()
	{
		return 0;
	}


	/**
	* Returns true if both row and column selection models are enabled.
	*
	* @return		true if both row and column selection models are enabled
	* @see		#setCellSelectionEnabled
	**/
	 public boolean getCellSelectionEnabled()
	{
		return false;
	}


	/**
	* Returns the <code>ULCTableColumn</code> object for the column in the table
	* whose identifier is equal to <code>identifier</code>, when
compared using
	* <code>equals</code>.
	*
	* @param identifier 		 the identifier object
	* @return		the <code>ULCTableColumn</code> object that matches the identifier
	* @throws		IllegalArgumentException if <code>identifier</code> is <code>null</code> or no <code>ULCTableColumn</code> has this
identifier
	**/
	 public com.ulcjava.base.application.table.ULCTableColumn getColumn(java.lang.Object identifier)
	{
		return null;
	}


	/**
	* Returns the type of the column appearing in the view at column position
	* <code>column</code>.
	*
	* @param column 		 the column in the view being queried
	* @return		the type of the column at position <code>column</code> in the view
	**/
	 public java.lang.Class getColumnClass(int column)
	{
		return null;
	}


	/**
	* Returns the number of columns in the column model. Note that this may be
	* different from the number of columns in the table model.
	*
	* @return		the number of columns in the table
	* @see		#addColumn
	* @see		#removeColumn
	**/
	 public int getColumnCount()
	{
		return 0;
	}


	/**
	* Returns the <code>ULCTableColumnModel</code> that contains all column
	* information of this table.
	*
	* @return		the object that provides the column state of the table
	**/
	 public com.ulcjava.base.application.table.ULCTableColumnModel getColumnModel()
	{
		return null;
	}


	/**
	* Returns the name of the column appearing in the view at column position
	* <code>column</code>.
	*
	* @param column 		 the column in the view being queried
	* @return		the name of the column at position <code>column</code> in the view where the first column is column 0
	**/
	 public java.lang.String getColumnName(int column)
	{
		return null;
	}


	/**
	* Returns true if columns can be selected.
	*
	* @return		true if columns can be selected, otherwise false
	* @see		#setColumnSelectionAllowed
	**/
	 public boolean getColumnSelectionAllowed()
	{
		return false;
	}


	/**
	* Returns the editor to be used when no editor has been set in a
	* <code>ULCTableColumn</code>. During the editing of cells the editor
	* is
fetchedfrom a <code>Map</code> of entries according to the class of the
	* cells in the column. If there is no entry for this
<code>columnClass</code>
	* the method returns the entry for the most specific superclass.
	*
	* @param columnClass 		 return the default cell editor for this columnClass
	* @return		the default cell editor to be used for this columnClass
	* @see		#setDefaultEditor
	* @see		#getColumnClass
	**/
	 public com.ulcjava.base.application.table.ITableCellEditor getDefaultEditor(java.lang.Class columnClass)
	{
		return null;
	}


	/**
	* Returns the cell renderer to be used when no renderer has been set in a
	* <code>ULCTableColumn</code>. During the rendering of cells
the renderer is
	* fetched according to the class of the cells in the column. If there is no
	* entry for this <code>columnClass</code> the
method returns the entry for the
	* most specific superclass.
	*
	* @param columnClass 		 return the default cell renderer for this columnClass
	* @return		the renderer for this columnClass
	* @see		#setDefaultRenderer
	* @see		#getColumnClass
	**/
	 public com.ulcjava.base.application.table.ITableCellRenderer getDefaultRenderer(java.lang.Class columnClass)
	{
		return null;
	}


	/**
	* Returns the color used to draw grid lines.
	*
	* @return		the color used to draw grid lines
	* @see		#setGridColor
	**/
	 public com.ulcjava.base.application.util.Color getGridColor()
	{
		return null;
	}


	/**
	* Returns the horizontal and vertical space between cells. The default spacing
	* is(1, 1), which provides room to draw the grid.
	*
	* @return		the horizontal and vertical spacing between cells
	* @see		#setIntercellSpacing
	**/
	 public com.ulcjava.base.application.util.Dimension getIntercellSpacing()
	{
		return null;
	}


	/**
	* Returns the <code>ITableModel</code> that provides the data displayed by this
	* <code>ULCTable</code>.
	*
	* @return		the <code>ITableModel</code> that provides the data displayed by this <code>ULCTable</code>
	* @see		#setModel
	**/
	 public com.ulcjava.base.application.table.ITableModel getModel()
	{
		return null;
	}


	/**
	* Returns the number of rows in this table's model. If a
	* <code>TableRowSorter</code> with a <code>TableRowFilter</code> is set on
	* this
<code>ULCTable</code> this method will return the view row count, which
	* may differ from the model row count.
	*
	* @return		the number of rows shown in this table
	* @see		#getColumnCount
	**/
	 public int getRowCount()
	{
		return 0;
	}


	/**
	* Returns the height of a table row, in pixels. The default row height is 16.
	*
	* @return		the height in pixels of a table row
	* @see		#setRowHeight
	**/
	 public int getRowHeight()
	{
		return 0;
	}


	/**
	* Gets the amount of empty space, in pixels, between cells. Equivalent to:
	* <code>getIntercellSpacing().height</code>.
	*
	* @return		the number of pixels between cells in a row
	* @see		#setRowMargin
	**/
	 public int getRowMargin()
	{
		return 0;
	}


	/**
	* Returns true if rows can be selected.
	*
	* @return		true if rows can be selected, otherwise false
	* @see		#setRowSelectionAllowed
	**/
	 public boolean getRowSelectionAllowed()
	{
		return false;
	}


	/**
	* Returns the index of the first selected column, -1 if no column is selected.
	*
	* @return		the index of the first selected column
	**/
	 public int getSelectedColumn()
	{
		return 0;
	}


	/**
	* Returns the number of selected columns.
	*
	* @return		the number of selected columns, 0 if no columns are selected
	**/
	 public int getSelectedColumnCount()
	{
		return 0;
	}


	/**
	* Returns the indices of all selected columns.
	*
	* @return		an array of integers containing the indices of all selected columns, or an empty array if no column is selected
	* @see		#getSelectedColumn
	**/
	 public int[] getSelectedColumns()
	{
		return null;
	}


	/**
	* Returns the index of the first selected row, -1 if no row is selected.
	*
	* @return		the index of the first selected row
	**/
	 public int getSelectedRow()
	{
		return 0;
	}


	/**
	* Returns the number of selected rows.
	*
	* @return		the number of selected rows, 0 if no rows are selected
	**/
	 public int getSelectedRowCount()
	{
		return 0;
	}


	/**
	* Returns the indices of all selected rows.
	*
	* @return		an array of integers containing the indices of all selected rows, or an empty array if no row is selected
	* @see		#getSelectedRow
	**/
	 public int[] getSelectedRows()
	{
		return null;
	}


	/**
	* Returns the background color for selected cells.
	*
	* @return		the <code>Color</code> used for the background of selected list items
	* @see		#setSelectionBackground
	* @see		#setSelectionForeground
	**/
	 public com.ulcjava.base.application.util.Color getSelectionBackground()
	{
		return null;
	}


	/**
	* Returns the foreground color for selected cells.
	*
	* @return		the <code>Color</code> object for the foreground property
	* @see		#setSelectionForeground
	* @see		#setSelectionBackground
	**/
	 public com.ulcjava.base.application.util.Color getSelectionForeground()
	{
		return null;
	}


	/**
	* Returns the <code>ULCListSelectionModel</code> that is used to maintain row
	* selection state.
	*
	* @return		the object that provides row selection state
	**/
	 public com.ulcjava.base.application.ULCListSelectionModel getSelectionModel()
	{
		return null;
	}


	/**
	* Returns true if the horizontal lines between cells are to be drawn, false
	* otherwise. The default value is true.
	*
	* @return		true if the horizontal lines between cells are drawn, false otherwise
	* @see		#setShowHorizontalLines
	**/
	 public boolean getShowHorizontalLines()
	{
		return false;
	}


	/**
	* Returns true if the table draws vertical lines between cells, false if it does
	* not. The default is true.
	*
	* @return		true if the table draws vertical lines between cells, false if it does not
	* @see		#setShowVerticalLines
	**/
	 public boolean getShowVerticalLines()
	{
		return false;
	}


	/**
	* Returns the table header used by this <code>ULCTable</code>.
	*
	* @return		the table header used by this table
	**/
	 public com.ulcjava.base.application.table.ULCTableHeader getTableHeader()
	{
		return null;
	}


	/**
	* Returns the cell value at <code>row</code> and
	* <code>column</code>.
<p>
</p>
<b>Note</b>: The column is specified in the
	* table view's display order, and not in the <code>ITableModel</code>'s column
	* order.
	*
	* @param row 		 the row whose value is to be queried
	* @param column 		 the column whose value is to be queried
	* @return		the Object at the specified cell
	**/
	 public java.lang.Object getValueAt(int row, int column)
	{
		return null;
	}


	/**
	* Starts editing the cell at <code>row</code> and <code>column</code>, if the
	* cell is editable.
	*
	* @param row 		 the row to be edited
	* @param column 		 the column to be edited
	* @return		false if for any reason the cell cannot be edited
	**/
	 public boolean editCellAt(int row, int column)
	{
		return false;
	}


	/**
	* Returns true if the cell at <code>row</code> and <code>column</code> is
	* editable. Otherwise, invoking <code>setValueAt</code> on the
cell will have
	* noeffect.
<p>
</p>
<b>Note</b>: The column is specified in the table view's
	* display order, and not in the <code>ITableModel</code>'s column order.
	* This
isan important distinction because as the user rearranges the columns in
	* the table, the column at a given index in the view will
change. Meanwhile the
	* user's actions never affect the model's column ordering.
	*
	* @param row 		 the row whose value is to be queried
	* @param column 		 the column whose value is to be queried
	* @return		true if the cell is editable
	* @see		#setValueAt
	**/
	 public boolean isCellEditable(int row, int column)
	{
		return false;
	}


	/**
	* Returns true if the cell at the specified position is selected.
	*
	* @param row 		 the row being queried
	* @param column 		 the column being queried
	* @return		true if the cell at index <code>(row, column)</code> is selected, where the first row and first column are at index 0
	* @throws		IllegalArgumentException if <code>row</code> or <code>column</code> are not in the valid range
	**/
	 public boolean isCellSelected(int row, int column)
	{
		return false;
	}


	/**
	* Returns true if the column at the specified index is selected.
	*
	* @param column 		 the column in the column model
	* @return		true if the column at index <code>column</code> is selected, where 0 is the first column
	* @throws		IllegalArgumentException if <code>column</code> is not in the valid range
	**/
	 public boolean isColumnSelected(int column)
	{
		return false;
	}


	/**
	* Returns true if the row at the specified index is selected.
	*
	* @param row 		 the row to be checked for selection state
	* @return		true if the row at index <code>row</code> is selected, where 0 is the first row
	* @throws		IllegalArgumentException if <code>row</code> is not in the valid range
	**/
	 public boolean isRowSelected(int row)
	{
		return false;
	}


	/**
	* Moves the ULCTableColumn <code>column</code> to the position currently
	* occupiedby the column <code>targetColumn</code> in the view.
The old column
	* at<code>targetColumn</code> is moved to the right to make room.
	*
	* @param column 		 the index of column to be moved
	* @param targetColumn 		 the new index of the column
	**/
	 public void moveColumn(int column, int targetColumn)
	{
	}


	/**
	* Removes <code>column</code> from this <code>ULCTable</code>. Note: this method
	* does not remove the column of data from the model; it
just removes the
	* <code>ULCTableColumn</code> that was responsible for displaying it.
	*
	* @param column 		 the <code>ULCTableColumn</code> to be removed
	* @see		#addColumn
	**/
	 public void removeColumn(com.ulcjava.base.application.table.ULCTableColumn column)
	{
	}


	/**
	* Deselects the columns from <code>index0</code> to <code>index1</code>,
	* inclusive.
	*
	* @param index0 		 one end of the interval
	* @param index1 		 the other end of the interval
	* @throws		IllegalArgumentException if <code>index0</code> or <code>index1</code> lie outside [0, <code>getColumnCount()</code>-1]
	**/
	 public void removeColumnSelectionInterval(int index0, int index1)
	{
	}


	/**
	* Deselects the rows from <code>index0</code> to <code>index1</code>, inclusive.
	*
	* @param index0 		 one end of the interval
	* @param index1 		 the other end of the interval
	* @throws		IllegalArgumentException if <code>index0</code> or <code>index1</code> lie outside [0, <code>getRowCount()</code>-1]
	**/
	 public void removeRowSelectionInterval(int index0, int index1)
	{
	}


	/**
	* Selects all rows, columns, and cells in the table.
	*
	**/
	 public void selectAll()
	{
	}


	/**
	* Sets this table's <code>autoCreateColumnsFromModel</code> flag. This method
	* calls <code>createDefaultColumnsFromModel</code>
	* if
<code>autoCreateColumnsFromModel</code> changes from false to true.
	*
	* @param autoCreateColumnsFromModel 		 true if <code>ULCTable</code> should automatically create columns
	* @see		#getAutoCreateColumnsFromModel
	* @see		#createDefaultColumnsFromModel
	**/
	 public void setAutoCreateColumnsFromModel(boolean autoCreateColumnsFromModel)
	{
	}


	/**
	* Sets the table's auto resize mode when the table is resized.
	*
	* @param mode 		 one of 5 legal values: AUTO_RESIZE_OFF, AUTO_RESIZE_NEXT_COLUMN, AUTO_RESIZE_SUBSEQUENT_COLUMNS, AUTO_RESIZE_LAST_COLUMN,
AUTO_RESIZE_ALL_COLUMNS
	* @see		#getAutoResizeMode
	**/
	 public void setAutoResizeMode(int mode)
	{
	}


	/**
	* Sets the preferred size of the viewport for this table.
	*
	* @param preferredScrollableViewportSize 		 a <code>Dimension</code> object specifying the <code>preferredSize</code> of a table if
residing in a <code>ULCScrollPane</code>.
	**/
	 public void setPreferredScrollableViewportSize(com.ulcjava.base.application.util.Dimension preferredScrollableViewportSize)
	{
	}


	/**
	* Returns the preferred size of the viewport for this table.
	*
	* @return		a <code>Dimension</code> object containing the <code>preferredSize</code> of the <code>ULCScrollPane</code> which displays
this table
	**/
	 public com.ulcjava.base.application.util.Dimension getPreferredScrollableViewportSize()
	{
		return null;
	}


	/**
	* Sets whether this table allows both a column selection and a row selection to
	* exist simultaneously. When set, the table treats the
intersection of the row
	* and column selection models as the selected cells.
	*
	* @param cellSelectionEnabled 		 true if simultaneous row and column selection is allowed
	* @see		#getCellSelectionEnabled
	**/
	 public void setCellSelectionEnabled(boolean cellSelectionEnabled)
	{
	}


	/**
	* Sets whether the columns in this table can be selected.
	*
	* @param columnSelectionAllowed 		 true if this table will allow column selection
	* @see		#getColumnSelectionAllowed
	**/
	 public void setColumnSelectionAllowed(boolean columnSelectionAllowed)
	{
	}


	/**
	* Selects the columns from <code>index0</code> to <code>index1</code>, inclusive.
	*
	* @param index0 		 one end of the interval
	* @param index1 		 the other end of the interval
	* @throws		IllegalArgumentException if <code>index0</code> or <code>index1</code> lie outside [0, <code>getColumnCount()</code>-1]
	**/
	 public void setColumnSelectionInterval(int index0, int index1)
	{
	}


	/**
	* Sets a default cell editor to be used if no editor has been set in a
	* <code>ULCTableColumn</code>. If editor is <code>null</code>,
removes the
	* default editor for this column class.
	*
	* @param columnClass 		 set the default cell editor for this columnClass
	* @param editor 		 default cell editor to be used for this columnClass
	* @see		com.ulcjava.base.application.table.ITableModel#isCellEditable
	* @see		#getDefaultEditor
	* @see		#setDefaultRenderer
	**/
	 public void setDefaultEditor(java.lang.Class columnClass, com.ulcjava.base.application.table.ITableCellEditor editor)
	{
	}


	/**
	* Sets a default cell renderer to be used if no renderer has been set in a
	* <code>ULCTableColumn</code>. If renderer is
<code>null</code>, removes the
	* default renderer for this column class.
	*
	* @param columnClass 		 set the default cell renderer for this columnClass
	* @param renderer 		 default cell renderer to be used for this columnClass
	* @see		#getDefaultRenderer
	* @see		#setDefaultEditor
	**/
	 public void setDefaultRenderer(java.lang.Class columnClass, com.ulcjava.base.application.table.ITableCellRenderer renderer)
	{
	}


	/**
	* Sets the color used to draw grid lines to <code>gridColor</code> and redisplays.
	*
	* @param gridColor 		 the new color of the grid lines
	* @throws		IllegalArgumentException if <code>gridColor</code> is <code>null</code>
	* @see		#getGridColor
	**/
	 public void setGridColor(com.ulcjava.base.application.util.Color gridColor)
	{
	}


	/**
	* Sets the <code>rowMargin</code> and the <code>columnMargin</code> -- the
	* heightand width of the space between cells -- to
<code>intercellSpacing</code>.
	*
	* @param intercellSpacing 		 specifying the new height and width between cells
	* @see		#getIntercellSpacing
	* @see		#setRowMargin
	**/
	 public void setIntercellSpacing(com.ulcjava.base.application.util.Dimension intercellSpacing)
	{
	}


	/**
	* Sets the data model for this table to the specified <code>model</code>. The
	* table registers itself with the model for listener
notifications. If the same
	* model is set again on this table, only the editor and renderer caches are
	* cleared. If the
<code>autoCreateColumnsFromModel</code> property is set,
	* default columns are created for this model. If
	* the
<code>autoCreateRowSorter</code> property is set, a new
	* <code>TableRowSorter</code> is created.
	*
	* @param model 		 the new data source for this table
	* @throws		IllegalArgumentException if <code>model</code> is <code>null</code>
	* @see		#getModel
	* @see		#setAutoCreateColumnsFromModel
	* @see		#createDefaultColumnsFromModel
	* @see		#setAutoCreateRowSorter
	* @see		#setRowSorter
	**/
	 public void setModel(com.ulcjava.base.application.table.ITableModel model)
	{
	}


	/**
	* 
	*
	* @return		The TableRowSorter that is used for sorting this <code>ULCTable</code>.
	**/
	 public com.ulcjava.base.application.table.TableRowSorter getRowSorter()
	{
		return null;
	}


	/**
	* Sets a <code>TableRowSorter</code> on this <code>ULCTable</code>. The
	* <code>TableRowSorter</code> provides the infrastructure for
sorting and
	* filtering the table. If a <code>null</code> value is passed as
	* <code>TableRowSorter</code> the table will be unsorted,
i.e. the data is
	* ordered the way it is in the underlying table model.
<p>
The current
	* selectionwill be cleared when the <code>TableRowSorter</code> is set on the
	* table.
<p>
The <code>TableRowSorter</code> will provide a mapping from model
	* co-ordinates to view co-ordinates and vice versa.
<p>
Before this mapping is
	* updated the <code>ULCTable</code> is notified by a <code>RowSorterEvent
	* SORT_ORDER_CHANGED</code>. This event
will trigger the following
	* actions:
<ul><li>If no user defined renderer is set on the appropriate table
	* header cell, a sort icon is painted on this cell. If a server-side
renderer
	* isset, the painting of the sort icon has to be handled manually.
<li>The
	* selection is cached if the property <code>updateSelectionOnSort</code> is to
	* true.
</ul>
<p>
After the update of the model-view index mapping the
	* <code>ULCTable</code> is notified by a <code>RowSorterEvent SORTED</code>.
	* This
event will trigger the following actions:
<ul>
<li>The client side table
	* is notified about the changed row order.
<li>The selection is updated if the
	* property <code>updateSelectionOnSort</code> is set to true.
</ul>
	*
	* @param rowSorter 		 The <code>TableRowSorter</code> to be set on this <code>ULCTable</code>
	* @see		com.ulcjava.base.application.table.TableRowSorter
	**/
	 public void setRowSorter(com.ulcjava.base.application.table.TableRowSorter rowSorter)
	{
	}


	/**
	* Converts the model row index to the corresponding view row index. Model and
	* view row indices are the same if the table model has not
been sorted. Returns
	* -1 if the specified model row index is not visible.
	*
	* @param modelRowIndex 		 the model row index
	* @return		the corresponding view row index for the given model row index.
	**/
	 public int convertRowIndexToView(int modelRowIndex)
	{
		return 0;
	}


	/**
	* Converts the view row index to the corresponding model row index. Model and
	* view row indices are the same if the table model has not
been sorted.
	*
	* @param viewRowIndex 		 the view row index
	* @return		the corresponding model row index for a given view row index
	**/
	 public int convertRowIndexToModel(int viewRowIndex)
	{
		return 0;
	}


	/**
	* Determines if a <code>TableRowSorter</code> will be created automatically set
	* on this <code>ULCTable</code>.
	*
	* @param autoCreateRowSorter 		 True if a TableRowSorter should be created an set automatically.
	**/
	 public void setAutoCreateRowSorter(boolean autoCreateRowSorter)
	{
	}


	/**
	* 
	*
	* @return		The <code>autoCreateRowSorter</code> property.
	**/
	 public boolean getAutoCreateRowSorter()
	{
		return false;
	}


	/**
	* Determines if the selection of a table will be updated upon a sort operation.
	* The default value is true.
	*
	* @param update 		 true if selection should be updated
	**/
	 public void setUpdateSelectionOnSort(boolean update)
	{
	}


	/**
	* Returns whether or not the selection will be updated on sorting.
	*
	* @return		true if the selection is to be updated on sort, false otherwise
	* @see		#setUpdateSelectionOnSort(boolean)
	**/
	 public boolean getUpdateSelectionOnSort()
	{
		return false;
	}


	/**
	* Sets the height, in pixels, of all cells to <code>rowHeight</code>,
	* revalidates, and repaints. The height of the cells in this row
will be equal
	* to the row height minus the row margin.
	*
	* @param rowHeight 		 new row height
	* @throws		IllegalArgumentException if <code>rowHeight</code> is less than 1
	* @see		#getRowHeight
	**/
	 public void setRowHeight(int rowHeight)
	{
	}


	/**
	* Sets the amount of empty space between cells in adjacent rows.
	*
	* @param rowMargin 		 the number of pixels between cells in a row, default is 1
	* @see		#getRowMargin
	**/
	 public void setRowMargin(int rowMargin)
	{
	}


	/**
	* Sets whether the rows in this model can be selected.
	*
	* @param rowSelectionAllowed 		 true if this model will allow row selection
	* @see		#getRowSelectionAllowed
	**/
	 public void setRowSelectionAllowed(boolean rowSelectionAllowed)
	{
	}


	/**
	* Selects the rows from <code>index0</code> to <code>index1</code>, inclusive.
	*
	* @param index0 		 one end of the interval
	* @param index1 		 the other end of the interval
	* @throws		IllegalArgumentException if <code>index0</code> or <code>index1</code> lie outside [0, <code>getRowCount()</code>-1]
	**/
	 public void setRowSelectionInterval(int index0, int index1)
	{
	}


	/**
	* Choose the background color for selected cells. Cell renderers can use this
	* value to for background in selected cells.
<p>
</p>
The default value of this
	* property is defined by the look and feel implementation.
	*
	* @param selectionBackground 		 the <code>Color</code> to use for the background of selected cells
	* @see		#getSelectionBackground
	* @see		#setSelectionForeground
	**/
	 public void setSelectionBackground(com.ulcjava.base.application.util.Color selectionBackground)
	{
	}


	/**
	* Sets the foreground color for selected cells. Cell renderers can use this
	* valuefor text and graphics color in selected cells.
<p>
</p>
The default
	* valueof this property is defined by the look and feel implementation.
	*
	* @param selectionForeground 		 the <code>Color</code> to use in the foreground for selected list items
	* @see		#getSelectionForeground
	* @see		#setSelectionBackground
	**/
	 public void setSelectionForeground(com.ulcjava.base.application.util.Color selectionForeground)
	{
	}


	/**
	* Sets the table's selection mode to allow only single selections, a single
	* contiguous interval, or multiple intervals.
	*
	* @param selectionMode 		 the <code>selectionMode</code> one of 3 legal values: ULCListSelectionModel.SINGLE_SELECTION,
ULCListSelectionModel.SINGLE_INTERVAL_SELECTION or ULCListSelectionModel.MULTIPLE_INTERVAL_SELECTION
	**/
	 public void setSelectionMode(int selectionMode)
	{
	}


	/**
	* Sets whether the table draws grid lines around cells. If <code>showGrid</code>
	* is true it does; if it is false it doesn't. There is
no
	* <code>getShowGrid</code> method as this state is held in two variables --
	* <code>showHorizontalLines</code> and
<code>showVerticalLines</code> -- each
	* ofwhich can be queried independently.
	*
	* @param showGrid 		 true if table view should draw grid lines
	* @see		#setShowVerticalLines
	* @see		#setShowHorizontalLines
	**/
	 public void setShowGrid(boolean showGrid)
	{
	}


	/**
	* Sets whether the table draws horizontal lines between cells. If
	* <code>showHorizontalLines</code> is true it does; if it is false it
doesn't.
	*
	* @param showHorizontalLines 		 true if table view should draw horizontal lines
	* @see		#getShowHorizontalLines
	* @see		#setShowGrid
	* @see		#setShowVerticalLines
	**/
	 public void setShowHorizontalLines(boolean showHorizontalLines)
	{
	}


	/**
	* Sets whether the table draws vertical lines between cells. If
	* <code>showVerticalLines</code> is true it does; if it is false it
doesn't.
	*
	* @param showVerticalLines 		 true if table view should draw vertical lines
	* @see		#getShowVerticalLines
	* @see		#setShowGrid
	* @see		#setShowHorizontalLines
	**/
	 public void setShowVerticalLines(boolean showVerticalLines)
	{
	}


	/**
	* Sets the table header for this <code>ULCTable</code> to
	* <code>tableHeader</code>. It is allowed to have a
	* <code>null</code>
<code>tableHeader</code>.
	*
	* @param tableHeader 		 new table header
	**/
	 public void setTableHeader(com.ulcjava.base.application.table.ULCTableHeader tableHeader)
	{
	}


	/**
	* Sets the value for the cell in the table model at <code>row</code> and
	* <code>column</code>.
<p>
</p>
<b>Note</b>: The column is specified in the
	* table view's display order, and not in the <code>ITableModel</code>'s column
	* order.
<p>
</p>
<code>value</code> is the new value.
	*
	* @param value 		 the new value
	* @param row 		 the row of the cell to be changed
	* @param column 		 the column of the cell to be changed
	* @see		#getValueAt
	**/
	 public void setValueAt(java.lang.Object value, int row, int column)
	{
	}

	 public void setVisible(boolean b)
	{
	}


	/**
	* Return true if the table surrenders focus to cell editor on a keystroke.
	*
	* @return		true if table surrenders focus to cell editor on a keystroke, false otherwise.
	**/
	 public boolean getSurrendersFocusOnKeystroke()
	{
		return false;
	}


	/**
	* Sets whether the table surrenders focus to cell editor when a keystroke is
	* typed on a cell.
	*
	* @param surrendersFocusOnKeystroke 		 true if the table should surrender focus to cell editor on a keystroke, false otherwise
	**/
	 public void setSurrendersFocusOnKeystroke(boolean surrendersFocusOnKeystroke)
	{
	}


	/**
	* Set to true to make the table fill the height of the enclosing viewport. The
	* default value is <code>true</code>, i.e., the table will
fill the viewport.
	*
	* @param fillsViewportHeight 		 true to make the table fill the height of the enclosing viewport, false otherwise.
	* @see		#getFillsViewportHeight
	**/
	 public void setFillsViewportHeight(boolean fillsViewportHeight)
	{
	}


	/**
	* Returns whether or not this table is stretched to fill the enclosing viewport.
	*
	* @return		true if this table is stretched to fill the enclosing viewport, false otherwise
	* @see		#setFillsViewportHeight
	**/
	 public boolean getFillsViewportHeight()
	{
		return false;
	}


	/**
	* Determines if Drag & Drop support is enabled or disabled.
	*
	* @return		true, if Drag & Drop support is enabled, false otherwise
	**/
	 public boolean isDragEnabled()
	{
		return false;
	}


	/**
	* Determines if Drag & Drop support is enabled or disabled.
	*
	* @param enabled 		 true, if Drag & Drop support should be enabled, false otherwise
	**/
	 public void setDragEnabled(boolean enabled)
	{
	}


	/**
	* Sets the transfer handler instance used to configure the Drag & Drop behavior
	* for this component and to handle data import / export.
	*
	* @param transferHandler 		 an instance of TransferHandler
	**/
	 public void setTransferHandler(com.ulcjava.base.application.dnd.TransferHandler transferHandler)
	{
	}


	/**
	* Creates the transfer handler used as default for this component.
	*
	* @return		an subclass of TransferHandler used as default transfer handler for this component
	**/
	 protected com.ulcjava.base.application.dnd.TransferHandler createDefaultTransferHandler()
	{
		return null;
	}


	/**
	* Returns the transfer handler.
	*
	* @return		the instance of TransferHandler
	**/
	 public com.ulcjava.base.application.dnd.TransferHandler getTransferHandler()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 public com.ulcjava.base.application.dnd.IDnDData restoreDnDSourceData(com.ulcjava.base.shared.internal.Anything args)
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 public com.ulcjava.base.application.dnd.IDnDData restoreDnDTargetData(com.ulcjava.base.shared.internal.Anything args)
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCTableDispatcher extends ULCComponentDispatcher
{

	 public  final void requestCellRendererComponents(int[] range, int[] columns)
	{
	}

	 public  final void requestCellEditorComponents(int[] range, int[] columns)
	{
	}

	 public  final void requestHeaderRendererComponents(int[] columns)
	{
	}


}
}