package com.ulcjava.base.application;


	/**
	* The <code>ULCTableTree</code> component displays a hierarchy of items. It
	* combines the functionality of a table and a tree widget by
displaying the
	* treein selected column of the table. In addition to a standard tree, the
	* tabletree can display several columns for each
node in adjacent table
	* columns.To make the <code>ULCTableTree</code> scrollable, it has to be put in
	* a <code>ULCScrollPane</code>.
<p>
<b>Features</b>
<ul>
<li>The
	* <code>ULCTableTree</code> component inherits all features of
	* <code>ULCComponent</code>.
<li>The hierarchy of items that are displayed in
	* the <code>ULCTableTree</code> is provided by an <code>ITableTreeModel</code>.
	* One column
is rendered as a tree with the possibility to expand and collapse
	* non-leaf nodes. The index of this column is specified
	* via
<code>getTreeColumn()</code> method on the table tree model. The other
	* columns are rendered as table columns.
<li>The table tree uses
	* <code>ULCTreeSelectionModel</code> to manage its row selection and
	* <code>ULCListSelectionModel</code> to manage
column model's selection. The
	* application can register <code>ITreeSelectionListener</code> or
	* <code>IListSelectionListener</code> objects
with the corresponding selection
	* model. These listeners are notified when the selection on the
	* <code>ULCTableTree</code> changes.
<code>ULCTableTree</code> allows the
	* following selection modes: single selection, single interval selection, or
	* multiple interval
selection. Moreover, the application can use methods to
	* retrieve and alter the current selection on the table tree.
<li>Registration
	* of <code>IActionListeners</code> allows tracking of action events issued by
	* the table tree (i.e., double clicks on a
cell).
<li>To be notified about tree
	* nodes being expanded and collapsed, register
	* <code>ITreeExpansionListeners</code> with a
<code>ULCTableTree</code>.
	* Moreover, nodes can be expanded and collapsed programmatically.
	* <code>ULCTableTree</code> also offers the
possibility to programmatically
	* ensure that a specific node is visible (by expanding nodes if
	* necessary).
<li>Just like <code>ULCTable</code>, table tree allows fine
	* customization of its appearance with use of appropriate renderers
	* and
editors.Please see {@link
	* com.ulcjava.base.application.ULCTable}.
</ul>
<b>Examples</b>
<p>
The
	* following example shows how to set up a <code>ULCTableTree</code>. At the end
	* of the example we install an action listener that
listens for double
	* clicks.

<pre>
ULCTableTree tableTree = new
	* ULCTableTree(tableTreeModel);
tableTree.setRootVisible(true);
tableTree.setAuto
	* ResizeMode(ULCTableTree.AUTO_RESIZE_ALL_COLUMNS);
tableTree.addActionListener(ne
	* w IActionListener() {
public void actionPerformed(ActionEvent event)
	* {
ULCTableTree source =
	* (ULCTableTree)event.getSource();
System.out.println(&quot;node double
	* clicked:&quot;
+ source.getSelectedRow());
}
});
</pre>
The following example
	* configures the selection properties of the table tree and installs selection
	* listeners for both nodes and
	* columns.

<pre>
tableTree.setSelectionBackground(Color.black);
tableTree.setSel
	* ectionForeground(Color.white);
tableTree.getSelectionModel().setSelectionMode(
U
	* LCTreeSelectionModel.SINGLE_TREE_SELECTION);
tableTree.addTreeSelectionListener(
	* new ITreeSelectionListener() {
public void valueChanged(TreeSelectionEvent
	* event) {
ULCTreeSelectionModel source =
	* (ULCTreeSelectionModel)event
.getSource();
System.out.println(&quot;selected
	* path(row) changed: &quot;
+
	* source.getSelectionPath());
}
});
tableTree.getColumnModel().getSelectionModel(
	* ).addListSelectionListener(
new IListSelectionListener() {
public void
	* valueChanged(ListSelectionEvent event) {
ULCListSelectionModel source =
	* (ULCListSelectionModel)event
.getSource();
System.out.println(&quot;selected
	* column changed: &quot;
+ source.getMinSelectionIndex());
}
});
</pre>
	*
	* @ulc.application		
	* @see		ULCComponent
	* @see		ITableTreeModel
	* @see		ULCTableTreeColumn
	* @see		com.ulcjava.base.application.ULCTable
	**/
 public class ULCTableTree extends com.ulcjava.base.application.ULCComponent implements com.ulcjava.base.server.dnd.IDnDComponent
{

	/**
	* Do not adjust column widths automatically; use a scrollbar.
	*
	**/
	 public  final  static int AUTO_RESIZE_OFF = 0;

	/**
	* When a column is adjusted in the UI, adjust the next column the opposite way.
	*
	**/
	 public  final  static int AUTO_RESIZE_NEXT_COLUMN = 0;

	/**
	* During UI adjustment, change subsequent columns to preserve the total width;
	* this is the default behavior.
	*
	**/
	 public  final  static int AUTO_RESIZE_SUBSEQUENT_COLUMNS = 0;

	/**
	* During all resize operations, apply adjustments to the last column only.
	*
	**/
	 public  final  static int AUTO_RESIZE_LAST_COLUMN = 0;

	/**
	* During all resize operations, proportionately resize all columns.
	*
	**/
	 public  final  static int AUTO_RESIZE_ALL_COLUMNS = 0;

	 public void setEventDeliveryMode(java.lang.String eventCategory, int mode)
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void setParent(com.ulcjava.base.application.ULCContainer parent)
	{
	}

	 protected void uploadStateUI()
	{
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}

	 protected com.ulcjava.base.application.event.ActionEvent createActionEvent(java.lang.String command, int modifiers)
	{
		return null;
	}


	/**
	* Registers an <code>IActionListener</code> for this table tree.
	*
	* @param listener 		 the <code>IActionListener</code> to be added
	**/
	 public void addActionListener(com.ulcjava.base.application.event.IActionListener listener)
	{
	}


	/**
	* Returns the action command for this table tree.
	*
	* @return		the action command property
	**/
	 public java.lang.String getActionCommand()
	{
		return null;
	}


	/**
	* Returns an array of all the <code>IActionListener</code>s added to this
	* <code>ULCTableTree</code> with
<code>addActionListener()</code>.
	*
	* @return		all <code>IActionListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.IActionListener[] getActionListeners()
	{
		return null;
	}


	/**
	* Removes an <code>IActionListener</code> from the table tree.
	*
	* @param listener 		 the listener to be removed
	**/
	 public void removeActionListener(com.ulcjava.base.application.event.IActionListener listener)
	{
	}


	/**
	* Sets the action command property for this table tree.
	*
	* @param actionCommand 		 the action command for the table tree
	**/
	 public void setActionCommand(java.lang.String actionCommand)
	{
	}


	/**
	* Constructs a default table tree that is initialized with a default data model.
	*
	**/
	 public ULCTableTree()
	{
		 super();
	}


	/**
	* Constructs a table tree displaying values retrieved from the given table tree
	* model.
	*
	* @param model 		 the table tree model that provides the data.
	**/
	 public ULCTableTree(com.ulcjava.base.application.tabletree.ITableTreeModel model)
	{
		 super();
	}


	/**
	* Constructs a table tree displaying values retrieved from the given table tree
	* model and column model.
	*
	* @param model 		 the table tree model that provides the data.
	* @param columnModel 		 the column model
	**/
	 public ULCTableTree(com.ulcjava.base.application.tabletree.ITableTreeModel model, com.ulcjava.base.application.tabletree.ULCTableTreeColumnModel columnModel)
	{
		 super();
	}


	/**
	* Appends a table tree column at the right end of the table tree.
	*
	* @param column 		 the table tree column to be added as the last column
	**/
	 public void addColumn(com.ulcjava.base.application.tabletree.ULCTableTreeColumn column)
	{
	}


	/**
	* Selects the columns from <code>start</code> to <code>end</code>, inclusive.
	*
	* @param start 		 one end of the interval
	* @param end 		 the other end of the interval
	* @throws		IllegalArgumentException if <code>start</code> or <code>end</code> lie outside [0, <code>getColumnCount()</code>-1]
	**/
	 public void addColumnSelectionInterval(int start, int end)
	{
	}


	/**
	* Adds the specified path to the current selection. If the path isn't viewable,
	* it is made viewable.
	*
	* @param path 		 the path to add
	**/
	 public void addPathSelection(com.ulcjava.base.application.tree.TreePath path)
	{
	}


	/**
	* Adds each path in the array of paths to the current selection. If any of the
	* paths isn't viewable it is made viewable.
	*
	* @param paths 		 the paths to add
	**/
	 public void addPathSelection(com.ulcjava.base.application.tree.TreePath[] paths)
	{
	}


	/**
	* Adds the specified row to the current selection. If the row isn't viewable, it
	* is made viewable.
	*
	* @param row 		 the row to add
	**/
	 public void addRowSelection(int row)
	{
	}


	/**
	* Adds each row in the array of rows to the current selection. If any of the
	* rowsisn't viewable it is made viewable.
	*
	* @param rows 		 the rows to add
	**/
	 public void addRowSelection(int[] rows)
	{
	}


	/**
	* Adds the rows from <code>start</code> to <code>end</code>, inclusive, to the
	* current selection where 0 is the first row in the
display.
	*
	* @param start 		 one end of the interval
	* @param end 		 the other end of the interval
	* @throws		IllegalArgumentException if <code>start</code> or <code>end</code> lie outside [0, <code>getRowCount()</code>-1]
	**/
	 public void addRowSelectionInterval(int start, int end)
	{
	}


	/**
	* Adds a listener for tree expansion events.
	*
	* @param listener 		 the tree expansion listener to add
	**/
	 public void addTreeExpansionListener(com.ulcjava.base.application.event.ITreeExpansionListener listener)
	{
	}


	/**
	* Adds a listener for tree selection events. This listener is notified when the
	* selection of a row / tree node changes. To listen to
selection changes of of
	* the column model add a list selection listener.
	*
	* @param listener 		 the tree selection listener to add
	* @see		#addListSelectionListener(IListSelectionListener)
	**/
	 public void addTreeSelectionListener(com.ulcjava.base.application.event.ITreeSelectionListener listener)
	{
	}


	/**
	* Convenience method to add a listener to the list selection model of the column
	* model. The listener is notified each time a selection
changes in the list
	* selection model of the column model.
<p>
</p>
To listen to changes in the
	* selection of rows / tree nodes use a tree selection listener.
	*
	* @param listener 		 the list selection listener to add
	* @see		#addTreeSelectionListener(ITreeSelectionListener)
	**/
	 public void addListSelectionListener(com.ulcjava.base.application.event.IListSelectionListener listener)
	{
	}


	/**
	* Deselects all selected columns and rows.
	*
	**/
	 public void clearSelection()
	{
	}


	/**
	* Collapses the specified paths including (if specified) all descendant paths.
	* Invisible descendant paths are collapsed as well.
	*
	* @param paths 		 the paths to collapse
	* @param includingDescendants 		 true if all descendant paths should be collapsed as well, false otherwise
	**/
	 public void collapsePaths(com.ulcjava.base.application.tree.TreePath[] paths, boolean includingDescendants)
	{
	}


	/**
	* Collapses all paths including all descendant paths. Invisible descendant paths
	* are collapsed as well.
	*
	**/
	 public void collapseAll()
	{
	}


	/**
	* Collapse the specified path. If the path isn't viewable it is made vieable.
	*
	* @param path 		 the TreePath to collapse
	**/
	 public void collapsePath(com.ulcjava.base.application.tree.TreePath path)
	{
	}


	/**
	* Ensures that the node in the specified row is collapsed.
<p>
</p>
If
	* <code>row</code> is < 0 or >= <code>getRowCount</code> this will have no
	* effect.
	*
	* @param row 		 an integer specifying a display row, where 0 is the first row in the display
	**/
	 public void collapseRow(int row)
	{
	}


	/**
	* Maps the index of the column in the view at <code>viewColumnIndex</code> to
	* theindex of the column in the table tree model. Returns
the index of the
	* corresponding column in the model. If <code>viewColumnIndex</code> is less
	* than zero, returns
<code>viewColumnIndex</code>.
	*
	* @param viewColumnIndex 		 the index of the column in the view
	* @return		the index of the corresponding column in the model
	* @see		#convertColumnIndexToView
	**/
	 public int convertColumnIndexToModel(int viewColumnIndex)
	{
		return 0;
	}


	/**
	* Maps the index of the column in the table tree model at
	* <code>modelColumnIndex</code> to the index of the column in the view.
	* Returns
the index of the corresponding column in the view; returns -1 if this
	* column is not being displayed. If <code>modelColumnIndex</code>
is less than
	* zero, returns <code>modelColumnIndex</code>.
	*
	* @param modelColumnIndex 		 the index of the column in the model
	* @return		the index of the corresponding column in the view
	* @see		#convertColumnIndexToModel
	**/
	 public int convertColumnIndexToView(int modelColumnIndex)
	{
		return 0;
	}


	/**
	* Creates default columns for the table tree from the data model using the
	* <code>getColumnCount</code> method defined in
	* the
<code>ITableTreeModel</code>interface.
<p>
</p>
Clears any existing
	* columns before creating the new columns based on information from the model.
	*
	* @see		#getAutoCreateColumnsFromModel
	* @see		#setAutoCreateColumnsFromModel
	**/
	 public void createDefaultColumnsFromModel()
	{
	}


	/**
	* Expands the specified paths including (if specified) all descendant paths. If
	* the paths are not visible they are made visible.
	*
	* @param paths 		 the paths to expand
	* @param includingDescendants 		 true if all descendant paths should be expanded as well, false otherwise
	**/
	 public void expandPaths(com.ulcjava.base.application.tree.TreePath[] paths, boolean includingDescendants)
	{
	}


	/**
	* Expands all paths including all descendant paths.
	*
	**/
	 public void expandAll()
	{
	}


	/**
	* Expands the specified path. If the path isn't visible it is made visible.
	*
	* @param path 		 the TreePath to expand
	**/
	 public void expandPath(com.ulcjava.base.application.tree.TreePath path)
	{
	}


	/**
	* Ensures that the node in the specified row is expanded and
	* visible.
<p>
</p>
If<code>row</code> is < 0 or >= <code>getRowCount</code>
	* this will have no effect.
	*
	* @param row 		 an integer specifying a display row, where 0 is the first row in the display
	**/
	 public void expandRow(int row)
	{
	}


	/**
	* Determines whether the table tree will create default columns from the model.
	* If true, <code>setModel</code> will clear any existing
columns and the
	* <code>tableTreeStructureChanged</code> notification specifies that the entire
	* table tree changed, then the columns
will be rebuilt. The default is true.
	*
	* @return		the autoCreateColumnsFromModel of the table tree
	* @see		#setAutoCreateColumnsFromModel
	* @see		#createDefaultColumnsFromModel
	**/
	 public boolean getAutoCreateColumnsFromModel()
	{
		return false;
	}


	/**
	* Returns the resize mode of the table tree. The default mode is
	* AUTO_RESIZE_SUBSEQUENT_COLUMNS.
	*
	* @return		the autoResizeMode of the table tree
	* @see		#setAutoResizeMode
	**/
	 public int getAutoResizeMode()
	{
		return 0;
	}


	/**
	* Returns true if both row and column selection models are enabled.
	*
	* @return		true if both row and column selection models are enabled
	* @see		#setCellSelectionEnabled
	**/
	 public boolean getCellSelectionEnabled()
	{
		return false;
	}


	/**
	* Returns the <code>ULCTableTreeColumn</code> object for the column in the table
	* tree whose identifier is equal to
<code>identifier</code>, when compared
	* using<code>equals</code>.
	*
	* @param identifier 		 the identifier object
	* @return		the <code>ULCTableTreeColumn</code> object that matches the identifier
	* @throws		IllegalArgumentException if <code>identifier</code> is <code>null</code> or no <code>ULCTableTreeColumn</code> has this
identifier
	**/
	 public com.ulcjava.base.application.tabletree.ULCTableTreeColumn getColumn(java.lang.Object identifier)
	{
		return null;
	}


	/**
	* Returns the type of the column appearing in the view at column position
	* <code>column</code>.
	*
	* @param column 		 the column in the view being queried
	* @return		the type of the column at position <code>column</code> in the view
	**/
	 public java.lang.Class getColumnClass(int column)
	{
		return null;
	}


	/**
	* Returns the number of columns in the column model. Note that this may be
	* different from the number of columns in the table tree
model.
	*
	* @return		the number of columns in the table tree
	* @see		#addColumn
	* @see		#removeColumn
	**/
	 public int getColumnCount()
	{
		return 0;
	}


	/**
	* Returns the <code>ULCTableTreeColumnModel</code> that contains all column
	* information of this table tree.
	*
	* @return		the object that provides the column state of the table tree
	**/
	 public com.ulcjava.base.application.tabletree.ULCTableTreeColumnModel getColumnModel()
	{
		return null;
	}


	/**
	* Returns the name of the column appearing in the view at column position
	* <code>column</code>.
	*
	* @param column 		 the column in the view being queried
	* @return		the name of the column at position <code>column</code> in the view where the first column is column 0
	**/
	 public java.lang.String getColumnName(int column)
	{
		return null;
	}


	/**
	* Returns true if columns can be selected.
	*
	* @return		true if columns can be selected, otherwise false
	* @see		#setColumnSelectionAllowed
	**/
	 public boolean getColumnSelectionAllowed()
	{
		return false;
	}


	/**
	* Returns an Enumeration of the descendants of <code>path</code> that are
	* currently expanded. If <code>path</code> is not currently
expanded, this will
	* return null. If you expand/collapse nodes while iterating over the returned
	* Enumeration this may not return all
the expanded paths, or may return paths
	* that are no longer expanded.
	*
	* @param parent 		 the parent for which to return expanded descendants
	* @return		the enumeration of expanded descendants
	**/
	 public java.util.Enumeration getExpandedDescendants(com.ulcjava.base.application.tree.TreePath parent)
	{
		return null;
	}


	/**
	* Returns the color used to draw grid lines.
	*
	* @return		the color used to draw grid lines
	* @see		#setGridColor
	**/
	 public com.ulcjava.base.application.util.Color getGridColor()
	{
		return null;
	}


	/**
	* Returns the horizontal and vertical space between cells. The default spacing
	* is(1, 1), which provides room to draw the grid.
	*
	* @return		the horizontal and vertical spacing between cells
	* @see		#setIntercellSpacing
	**/
	 public com.ulcjava.base.application.util.Dimension getIntercellSpacing()
	{
		return null;
	}


	/**
	* Returns the last path component of the first selected node.
	*
	* @return		the last path component of the first selected node
	**/
	 public java.lang.Object getLastSelectedPathComponent()
	{
		return null;
	}


	/**
	* Returns an array of all the <code>IListSelectionListener</code>s added to this
	* <code>ULCTableTree</code> with
<code>addListSelectionListener()</code>.
	*
	* @return		all <code>IListSelectionListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.IListSelectionListener[] getListSelectionListeners()
	{
		return null;
	}


	/**
	* Returns the <code>ITableTreeModel</code> that provides the data displayed by
	* this <code>ULCTableTree</code>.
	*
	* @return		the <code>ITableTreeModel</code> that provides the data displayed by this <code>ULCTableTree</code>
	* @see		#setModel
	**/
	 public com.ulcjava.base.application.tabletree.ITableTreeModel getModel()
	{
		return null;
	}


	/**
	* Returns the path for the specified row. If the specified row is not visible,
	* null is returned.
	*
	* @param row 		 the row
	* @return		the path for the specified row
	**/
	 public com.ulcjava.base.application.tree.TreePath getPathForRow(int row)
	{
		return null;
	}


	/**
	* Returns the number of rows currently being displayed.
	*
	* @return		the number of rows currently being displayed
	**/
	 public int getRowCount()
	{
		return 0;
	}


	/**
	* Returns the display row of the specified path. If the specified path is not
	* displayed -1 is returned.
	*
	* @param path 		 the path
	* @return		the display row of the specified path
	**/
	 public int getRowForPath(com.ulcjava.base.application.tree.TreePath path)
	{
		return 0;
	}


	/**
	* Returns the height of a table tree row, in pixels. The default row height is
	* 16.0.
	*
	* @return		the height in pixels of a table tree row
	* @see		#setRowHeight
	**/
	 public int getRowHeight()
	{
		return 0;
	}


	/**
	* Gets the amount of empty space, in pixels, between cells. Equivalent to:
	* <code>getIntercellSpacing().height</code>.
	*
	* @return		the number of pixels between cells in a row
	* @see		#setRowMargin
	**/
	 public int getRowMargin()
	{
		return 0;
	}


	/**
	* Returns true if rows can be selected.
	*
	* @return		true if rows can be selected, otherwise false
	* @see		#setRowSelectionAllowed
	**/
	 public boolean getRowSelectionAllowed()
	{
		return false;
	}


	/**
	* Returns the index of the first selected column, -1 if no column is selected.
	*
	* @return		the index of the first selected column
	**/
	 public int getSelectedColumn()
	{
		return 0;
	}


	/**
	* Returns the number of selected rows.
	*
	* @return		the number of selected rows, 0 if no rows are selected
	**/
	 public int getSelectedColumnCount()
	{
		return 0;
	}


	/**
	* Returns the indices of all selected columns.
	*
	* @return		an array of integers containing the indices of all selected columns, or an empty array if no column is selected
	* @see		#getSelectedColumn
	**/
	 public int[] getSelectedColumns()
	{
		return null;
	}


	/**
	* Returns the first selected path, or null if nothing is selected.
	*
	* @return		the first selected path, or null if nothing is selected
	**/
	 public com.ulcjava.base.application.tree.TreePath getSelectedPath()
	{
		return null;
	}


	/**
	* Returns the number of selected pahts.
	*
	* @return		the number of selected pahts
	**/
	 public int getSelectedPathCount()
	{
		return 0;
	}


	/**
	* Returns the selected paths, or null if nothing is selected.
	*
	* @return		the selected paths, or null if nothing is selected
	**/
	 public com.ulcjava.base.application.tree.TreePath[] getSelectedPaths()
	{
		return null;
	}


	/**
	* Returns the selected row, or -1 if nothing is selected.
	*
	* @return		the selected row, or -1 if nothing is selected
	**/
	 public int getSelectedRow()
	{
		return 0;
	}


	/**
	* Returns the number of selected rows.
	*
	* @return		the number of selected rows
	**/
	 public int getSelectedRowCount()
	{
		return 0;
	}


	/**
	* Returns the selected rows, or null if nothing is selected.
	*
	* @return		the selected rows, or null if nothing is selected
	**/
	 public int[] getSelectedRows()
	{
		return null;
	}


	/**
	* Returns the background color for selected cells.
	*
	* @return		the <code>Color</code> used for the background of selected list items
	* @see		#setSelectionBackground
	* @see		#setSelectionForeground
	**/
	 public com.ulcjava.base.application.util.Color getSelectionBackground()
	{
		return null;
	}


	/**
	* Returns the foreground color for selected cells.
	*
	* @return		the <code>Color</code> object for the foreground property
	* @see		#setSelectionForeground
	* @see		#setSelectionBackground
	**/
	 public com.ulcjava.base.application.util.Color getSelectionForeground()
	{
		return null;
	}


	/**
	* Returns the <code>ULCTreeSelectionModel</code> that is used to maintain
	* row/path selection state.
	*
	* @return		the object that provides row selection state
	**/
	 public com.ulcjava.base.application.tree.ULCTreeSelectionModel getSelectionModel()
	{
		return null;
	}


	/**
	* Returns true if the horizontal lines between cells are to be drawn, false
	* otherwise. The default value is true.
	*
	* @return		true if the horizontal lines between cells are drawn, false otherwise
	* @see		#setShowHorizontalLines
	**/
	 public boolean getShowHorizontalLines()
	{
		return false;
	}


	/**
	* Returns true if root handles are shown, false otherwise.
	*
	* @return		true if root handles are shown, false otherwise
	* @see		#setShowsRootHandles
	**/
	 public boolean getShowsRootHandles()
	{
		return false;
	}


	/**
	* Returns true if the table tree draws vertical lines between cells, false if it
	* does not. The default is true.
	*
	* @return		true if the table tree draws vertical lines between cells, false if it does not
	* @see		#setShowVerticalLines
	**/
	 public boolean getShowVerticalLines()
	{
		return false;
	}


	/**
	* Returns the table tree header used by this <code>ULCTableTree</code>.
	*
	* @return		the table tree header used by this table tree
	**/
	 public com.ulcjava.base.application.tabletree.ULCTableTreeHeader getTableTreeHeader()
	{
		return null;
	}


	/**
	* Returns an array of all the <code>ITreeExpansionListener</code>s added to this
	* <code>ULCTableTree</code> with
<code>addTreeExpansionListener()</code>.
	*
	* @return		all <code>ITreeExpansionListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.ITreeExpansionListener[] getTreeExpansionListeners()
	{
		return null;
	}


	/**
	* Returns an array of all the <code>ITreeSelectionListener</code>s added to this
	* <code>ULCTableTree</code> with
<code>addTreeSelectionListener()</code>.
	*
	* @return		all <code>ITreeSelectionListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.ITreeSelectionListener[] getTreeSelectionListeners()
	{
		return null;
	}


	/**
	* Returns the cell value at the specified row and column.
	*
	* @param row 		 the row
	* @param column 		 the column
	* @return		the cell value at the specified row and column
	**/
	 public java.lang.Object getValueAt(int row, int column)
	{
		return null;
	}


	/**
	* Returns the cell value at the specified path and column.
	*
	* @param path 		 the path
	* @param column 		 the column
	* @return		the cell value at the specified path and column
	**/
	 public java.lang.Object getValueAt(com.ulcjava.base.application.tree.TreePath path, int column)
	{
		return null;
	}


	/**
	* Returns true if the cell at the specified row and column is editable, false
	* otherwise.
	*
	* @param row 		 the row
	* @param column 		 the column
	* @return		true if the cell at the specified row and column is editable, false otherwise
	**/
	 public boolean isCellEditable(int row, int column)
	{
		return false;
	}


	/**
	* Returns true if the cell at the specified path and column is editable, false
	* otherwise.
	*
	* @param path 		 the path
	* @param column 		 the column
	* @return		true if the cell at the specified path and column is editable, false otherwise
	**/
	 public boolean isCellEditable(com.ulcjava.base.application.tree.TreePath path, int column)
	{
		return false;
	}


	/**
	* Returns true if the cell at the specified position is selected.
	*
	* @param path 		 the path being queried
	* @param column 		 the column being queried
	* @return		true if the cell specified by path and column is selected.
	* @throws		IllegalArgumentException if <code>path</code> is null or <code>column</code> is not in the valid range.
	**/
	 public boolean isCellSelected(com.ulcjava.base.application.tree.TreePath path, int column)
	{
		return false;
	}


	/**
	* Returns true if the cell at the specified position is selected.
	*
	* @param row 		 the row being queried
	* @param column 		 the column being queried
	* @return		true if the cell at index <code>(row, column)</code> is selected, where the first row and first column are at index 0
	* @throws		IllegalArgumentException if <code>row</code> or <code>column</code> are not in the valid range
	**/
	 public boolean isCellSelected(int row, int column)
	{
		return false;
	}


	/**
	* Returns true if the specified row is collapsed or invisible, false otherwise.
	*
	* @param row 		 the row to be checked if collapsed
	* @return		true if the specified row is collapsed or invisible, false otherwise
	**/
	 public boolean isCollapsed(int row)
	{
		return false;
	}


	/**
	* Returns true if the specified path is collapsed or invisible, false otherwise.
	*
	* @param path 		 the path to be checked if collapsed
	* @return		true if the specified path is collapsed or invisible, false otherwise
	**/
	 public boolean isCollapsed(com.ulcjava.base.application.tree.TreePath path)
	{
		return false;
	}


	/**
	* Returns true if the column at the specified index is selected.
	*
	* @param column 		 the column in the column model
	* @return		true if the column at index <code>column</code> is selected, where 0 is the first column
	* @throws		IllegalArgumentException if <code>column</code> is not in the valid range
	**/
	 public boolean isColumnSelected(int column)
	{
		return false;
	}


	/**
	* Returns true if the specified row is expanded and visible, false otherwise.
	*
	* @param row 		 the row to be checked if expanded
	* @return		true if the specified row is expanded and visible, false otherwise
	**/
	 public boolean isExpanded(int row)
	{
		return false;
	}


	/**
	* Returns true if the specified path is expanded and visible, false otherwise.
	*
	* @param path 		 the path to be checked if expanded
	* @return		true if the specified path is expanded and visible, false otherwise
	**/
	 public boolean isExpanded(com.ulcjava.base.application.tree.TreePath path)
	{
		return false;
	}


	/**
	* Returns true if the specified path is selected, false otherwise.
	*
	* @param path 		 the path to be checked if selected
	* @return		true if the specified path is selected, false otherwise
	**/
	 public boolean isPathSelected(com.ulcjava.base.application.tree.TreePath path)
	{
		return false;
	}


	/**
	* Returns true if the root is visible, false otherwise.
	*
	* @return		true if the root is visible, false otherwise
	**/
	 public boolean isRootVisible()
	{
		return false;
	}


	/**
	* Returns true if row with the specified index is selected, false otherwise.
	*
	* @param row 		 the row to be checked if selected
	* @return		true if row with the specified index is selected, false otherwise
	**/
	 public boolean isRowSelected(int row)
	{
		return false;
	}


	/**
	* Returns true if the specified row is visible, false otherwise.
	*
	* @param row 		 the row to be checked if visible
	* @return		true if the specified row is visible, false otherwise
	**/
	 public boolean isVisible(int row)
	{
		return false;
	}


	/**
	* Returns true if the specified path is visible, false otherwise.
	*
	* @param path 		 the path to be checked if visible
	* @return		true if the specified path is visible, false otherwise
	**/
	 public boolean isVisible(com.ulcjava.base.application.tree.TreePath path)
	{
		return false;
	}


	/**
	* Makes the specified row visible.
	*
	* @param row 		 the row to make visible
	**/
	 public void makeVisible(int row)
	{
	}


	/**
	* Makes the specified path visible.
	*
	* @param path 		 the path to make visible
	**/
	 public void makeVisible(com.ulcjava.base.application.tree.TreePath path)
	{
	}


	/**
	* Initiates editing the specified cell of the specified node. The edit-attempt
	* fails if the the cell is not editable.
	*
	* @param path 		 the <code>TreePath</code> identifying the node
	* @param column 		 the column to be edited
	**/
	 public void startEditingAtPath(com.ulcjava.base.application.tree.TreePath path, int column)
	{
	}


	/**
	* Starts editing the cell at <code>row</code> and <code>column</code>, if the
	* cell is editable.
	*
	* @param row 		 the row to be edited
	* @param column 		 the column to be edited
	* @return		false if for any reason the cell cannot be edited
	**/
	 public boolean editCellAt(int row, int column)
	{
		return false;
	}


	/**
	* Moves the ULCTableTreeColumn <code>column</code> to the position currently
	* occupied by the column <code>targetColumn</code> in the
view. The old column
	* at <code>targetColumn</code> is moved to the right to make room.
	*
	* @param column 		 the index of column to be moved
	* @param targetColumn 		 the new index of the column
	**/
	 public void moveColumn(int column, int targetColumn)
	{
	}


	/**
	* Removes <code>column</code> from this <code>ULCTableTree</code>. Note: this
	* method does not remove the column of data from the model;
it just removes the
	* <code>ULCTableTreeColumn</code> that was responsible for displaying it.
	*
	* @param column 		 the <code>ULCTableTreeColumn</code> to be removed
	* @see		#addColumn
	**/
	 public void removeColumn(com.ulcjava.base.application.tabletree.ULCTableTreeColumn column)
	{
	}


	/**
	* Deselects the columns from <code>start</code> to <code>end</code>, inclusive.
	*
	* @param start 		 one end of the interval
	* @param end 		 the other end of the interval
	* @throws		IllegalArgumentException if <code>start</code> or <code>end</code> lie outside [0, <code>getColumnCount()</code>-1]
	**/
	 public void removeColumnSelectionInterval(int start, int end)
	{
	}


	/**
	* Removes the specified path from the current selection.
	*
	* @param path 		 the path to remove
	**/
	 public void removePathSelection(com.ulcjava.base.application.tree.TreePath path)
	{
	}


	/**
	* Removes the specified paths from the current selection.
	*
	* @param paths 		 the paths to remove
	**/
	 public void removePathSelection(com.ulcjava.base.application.tree.TreePath[] paths)
	{
	}


	/**
	* Removes the specified row from the current selection.
	*
	* @param row 		 the row to remove
	**/
	 public void removeRowSelection(int row)
	{
	}


	/**
	* Removes the specified rows from the current selection.
	*
	* @param rows 		 the rows to remove
	**/
	 public void removeRowSelection(int[] rows)
	{
	}


	/**
	* Deselects the rows from <code>start</code> to <code>end</code>, inclusive.
	*
	* @param start 		 one end of the interval
	* @param end 		 the other end of the interval
	* @throws		IllegalArgumentException if <code>start</code> or <code>end</code> lie outside [0, <code>getRowCount()</code>-1]
	**/
	 public void removeRowSelectionInterval(int start, int end)
	{
	}


	/**
	* Removes a listener for tree expansion events.
	*
	* @param listener 		 the tree expansion listener to remove
	**/
	 public void removeTreeExpansionListener(com.ulcjava.base.application.event.ITreeExpansionListener listener)
	{
	}


	/**
	* Removes a listener for tree selection events.
	*
	* @param listener 		 the tree selection listener to remove
	**/
	 public void removeTreeSelectionListener(com.ulcjava.base.application.event.ITreeSelectionListener listener)
	{
	}


	/**
	* Removes a listener for column model selection events.
	*
	* @param listener 		 the list selection listener to remove
	**/
	 public void removeListSelectionListener(com.ulcjava.base.application.event.IListSelectionListener listener)
	{
	}


	/**
	* Scrolls the cell identified by row and columnm until it is displayed. The
	* minimum of amount of scrolling necessary to bring the path
into view is
	* performed.
	*
	* @param row 		 the row of the cell to scroll to
	* @param column 		 an integer specifying the column to scroll
	**/
	 public void scrollCellToVisible(int row, int column)
	{
	}


	/**
	* Scrolls the cell identified by path and columnm until it is displayed. The
	* minimum of amount of scrolling necessary to bring the path
into view is
	* performed.
	*
	* @param path 		 the path of the cell to scroll to
	* @param column 		 an integer specifying the column to scroll
	**/
	 public void scrollCellToVisible(com.ulcjava.base.application.tree.TreePath path, int column)
	{
	}


	/**
	* Sets this table tree's <code>autoCreateColumnsFromModel</code> flag. This
	* method calls <code>createDefaultColumnsFromModel</code>
	* if
<code>autoCreateColumnsFromModel</code> changes from false to true.
	*
	* @param autoCreateColumnsFromModel 		 true if <code>ULCTableTree</code> should automatically create columns
	* @see		#getAutoCreateColumnsFromModel
	* @see		#createDefaultColumnsFromModel
	**/
	 public void setAutoCreateColumnsFromModel(boolean autoCreateColumnsFromModel)
	{
	}


	/**
	* Sets the table tree's auto resize mode when the table tree is resized.
	*
	* @param autoResizeMode 		 one of 5 legal values: AUTO_RESIZE_OFF, AUTO_RESIZE_NEXT_COLUMN, AUTO_RESIZE_SUBSEQUENT_COLUMNS,
AUTO_RESIZE_LAST_COLUMN, AUTO_RESIZE_ALL_COLUMNS
	* @see		#getAutoResizeMode
	**/
	 public void setAutoResizeMode(int autoResizeMode)
	{
	}


	/**
	* Sets the preferred size of the viewport for this table tree.
	*
	* @param preferredScrollableViewportSize 		 a <code>Dimension</code> object specifying the <code>preferredSize</code> of a table tree if
residing in a <code>ULCScrollPane</code>.
	**/
	 public void setPreferredScrollableViewportSize(com.ulcjava.base.application.util.Dimension preferredScrollableViewportSize)
	{
	}


	/**
	* Returns the preferred size of the viewport for this table tree.
	*
	* @return		a <code>Dimension</code> object containing the <code>preferredSize</code> of the <code>ULCScrollPane</code> which displays
this table tree
	**/
	 public com.ulcjava.base.application.util.Dimension getPreferredScrollableViewportSize()
	{
		return null;
	}


	/**
	* Sets whether this table tree allows both a column selection and a row
	* selectionto exist simultaneously. When set, the table tree
treats the
	* intersection of the row and column selection models as the selected cells.
	*
	* @param cellSelectionEnabled 		 true if simultaneous row and column selection is allowed
	* @see		#getCellSelectionEnabled
	**/
	 public void setCellSelectionEnabled(boolean cellSelectionEnabled)
	{
	}


	/**
	* Sets whether the columns in this table tree can be selected.
	*
	* @param columnSelectionAllowed 		 true if this table tree will allow column selection
	* @see		#getColumnSelectionAllowed
	**/
	 public void setColumnSelectionAllowed(boolean columnSelectionAllowed)
	{
	}


	/**
	* Selects the columns from <code>start</code> to <code>end</code>, inclusive.
	*
	* @param start 		 one end of the interval
	* @param end 		 the other end of the interval
	* @throws		IllegalArgumentException if <code>start</code> or <code>end</code> lie outside [0, <code>getColumnCount()</code>-1]
	**/
	 public void setColumnSelectionInterval(int start, int end)
	{
	}


	/**
	* Sets the color used to draw grid lines to <code>gridColor</code> and redisplays.
	*
	* @param gridColor 		 the new color of the grid lines
	* @throws		IllegalArgumentException if <code>gridColor</code> is <code>null</code>
	* @see		#getGridColor
	**/
	 public void setGridColor(com.ulcjava.base.application.util.Color gridColor)
	{
	}


	/**
	* Sets the <code>rowMargin</code> and the <code>columnMargin</code> -- the
	* heightand width of the space between cells -- to
<code>intercellSpacing</code>.
	*
	* @param intercellSpacing 		 specifying the new heigth and width between cells
	* @see		#getIntercellSpacing
	* @see		#setRowMargin
	**/
	 public void setIntercellSpacing(com.ulcjava.base.application.util.Dimension intercellSpacing)
	{
	}


	/**
	* Sets the data model for this table tree to <code>model</code> and registers
	* with it for listener notifications from the new data
model.
	*
	* @param model 		 the new data source for this table tree
	* @throws		IllegalArgumentException if <code>model</code> is <code>null</code>
	* @see		#getModel
	**/
	 public void setModel(com.ulcjava.base.application.tabletree.ITableTreeModel model)
	{
	}


	/**
	* Selects the specified path. If the path isn't viewable it is made viewable.
	*
	* @param path 		 the path to select
	**/
	 public void setPathSelection(com.ulcjava.base.application.tree.TreePath path)
	{
	}


	/**
	* Selects the specified paths. If any of the paths isn't viewable it is made
	* viewable.
	*
	* @param paths 		 the paths to select
	**/
	 public void setPathSelection(com.ulcjava.base.application.tree.TreePath[] paths)
	{
	}


	/**
	* Selects the specified row. If the row isn't viewable it is made viewable.
	*
	* @param row 		 the row to select
	**/
	 public void setRowSelection(int row)
	{
	}


	/**
	* Selects the specified rows. If any of the rows isn't viewable it is made
	* viewable.
	*
	* @param rows 		 the rows to select
	**/
	 public void setRowSelection(int[] rows)
	{
	}


	/**
	* Determines if the root is visible or not.
	*
	* @param rootVisible 		 true if the root should be visible, false otherwise
	* @see		#isRootVisible
	**/
	 public void setRootVisible(boolean rootVisible)
	{
	}


	/**
	* Sets the height, in pixels, of all cells to <code>rowHeight</code>,
	* revalidates, and repaints. The height of the cells in this row
will be equal
	* to the row height minus the row margin.
	*
	* @param rowHeight 		 new row height
	* @throws		IllegalArgumentException if <code>rowHeight</code> is less than 1
	* @see		#getRowHeight
	**/
	 public void setRowHeight(int rowHeight)
	{
	}


	/**
	* Sets the amount of empty space between cells in adjacent rows.
	*
	* @param rowMargin 		 the number of pixels between cells in a row, default is 1
	* @see		#getRowMargin
	**/
	 public void setRowMargin(int rowMargin)
	{
	}


	/**
	* Sets whether the rows in this model can be selected.
	*
	* @param rowSelectionAllowed 		 true if this model will allow row selection
	* @see		#getRowSelectionAllowed
	**/
	 public void setRowSelectionAllowed(boolean rowSelectionAllowed)
	{
	}


	/**
	* Selects the rows from <code>start</code> to <code>end</code>, inclusive.
	*
	* @param start 		 one end of the interval
	* @param end 		 the other end of the interval
	* @throws		IllegalArgumentException if <code>start</code> or <code>end</code> lie outside [0, <code>getRowCount()</code>-1]
	**/
	 public void setRowSelectionInterval(int start, int end)
	{
	}


	/**
	* Choose the background color for selected cells. Cell renderers can use this
	* value to for background in selected cells.
<p>
</p>
The default value of this
	* property is defined by the look and feel implementation.
	*
	* @param selectionBackground 		 the <code>Color</code> to use for the background of selected cells
	* @see		#getSelectionBackground
	* @see		#setSelectionForeground
	**/
	 public void setSelectionBackground(com.ulcjava.base.application.util.Color selectionBackground)
	{
	}


	/**
	* Sets the foreground color for selected cells. Cell renderers can use this
	* valuefor text and graphics color in selected cells.
<p>
</p>
The default
	* valueof this property is defined by the look and feel implementation.
	*
	* @param selectionForeground 		 the <code>Color</code> to use in the foreground for selected list items
	* @see		#getSelectionForeground
	* @see		#setSelectionBackground
	**/
	 public void setSelectionForeground(com.ulcjava.base.application.util.Color selectionForeground)
	{
	}


	/**
	* Sets whether the table tree draws grid lines around cells. If
	* <code>showGrid</code> is true it does; if it is false it doesn't. There
is no
	* <code>getShowGrid</code> method as this state is held in two variables --
	* <code>showHorizontalLines</code> and
<code>showVerticalLines</code> -- each
	* ofwhich can be queried independently.
	*
	* @param showGrid 		 true if table tree view should draw grid lines
	* @see		#setShowVerticalLines
	* @see		#setShowHorizontalLines
	**/
	 public void setShowGrid(boolean showGrid)
	{
	}


	/**
	* Sets whether the table tree draws horizontal lines between cells. If
	* <code>showHorizontalLines</code> is true it does; if it is false
it doesn't.
	*
	* @param showHorizontalLines 		 true if table tree view should draw horizontal lines
	* @see		#getShowHorizontalLines
	* @see		#setShowGrid
	* @see		#setShowVerticalLines
	**/
	 public void setShowHorizontalLines(boolean showHorizontalLines)
	{
	}


	/**
	* Determines if root handles are shown or not.
	*
	* @param showsRootHandles 		 true if root handles should be shown, false otherwise
	* @see		#getShowsRootHandles
	**/
	 public void setShowsRootHandles(boolean showsRootHandles)
	{
	}


	/**
	* Sets whether the table tree draws vertical lines between cells. If
	* <code>showVerticalLines</code> is true it does; if it is false it
doesn't.
	*
	* @param showVerticalLines 		 true if table tree view should draw vertical lines
	* @see		#getShowVerticalLines
	* @see		#setShowGrid
	* @see		#setShowHorizontalLines
	**/
	 public void setShowVerticalLines(boolean showVerticalLines)
	{
	}


	/**
	* Return true if the tabletree surrenders focus to cell editor on a keystroke.
	*
	* @return		true if tabletree surrenders focus to cell editor on a keystroke, false otherwise.
	**/
	 public boolean getSurrendersFocusOnKeystroke()
	{
		return false;
	}


	/**
	* Sets whether the tabletree surrenders focus to cell editor when a keystroke is
	* typed on a cell.
	*
	* @param surrendersFocusOnKeystroke 		 true if the tabletree should surrender focus to cell editor on a keystroke, false otherwise
	**/
	 public void setSurrendersFocusOnKeystroke(boolean surrendersFocusOnKeystroke)
	{
	}


	/**
	* Sets the table tree header for this <code>ULCTableTree</code> to
	* <code>tableTreeHeader</code>. It is allowed to have a
<code>null</code>
	* <code>tableTreeHeader</code>.
	*
	* @param tableTreeHeader 		 new table tree header
	**/
	 public void setTableTreeHeader(com.ulcjava.base.application.tabletree.ULCTableTreeHeader tableTreeHeader)
	{
	}


	/**
	* Sets the cell value at the specified row and column to the specified value.
	*
	* @param value 		 the value
	* @param row 		 the row
	* @param column 		 the column
	**/
	 public void setValueAt(java.lang.Object value, int row, int column)
	{
	}


	/**
	* Sets the cell value at the specified path and column to the specified value.
	*
	* @param value 		 the value
	* @param path 		 the path
	* @param column 		 the column
	**/
	 public void setValueAt(java.lang.Object value, com.ulcjava.base.application.tree.TreePath path, int column)
	{
	}

	 public void setVisible(boolean b)
	{
	}


	/**
	* Determines if Drag & Drop support is enabled or disabled.
	*
	* @return		true, if Drag & Drop support is enabled, false otherwise
	**/
	 public boolean isDragEnabled()
	{
		return false;
	}


	/**
	* Determines if Drag & Drop support is enabled or disabled.
	*
	* @param enabled 		 true, if Drag & Drop support should be enabled, false otherwise
	**/
	 public void setDragEnabled(boolean enabled)
	{
	}


	/**
	* Sets the transfer handler instance used to configure the Drag & Drop behavior
	* for this component and to handle data import / export.
	*
	* @param transferHandler 		 an instance of TransferHandler
	**/
	 public void setTransferHandler(com.ulcjava.base.application.dnd.TransferHandler transferHandler)
	{
	}


	/**
	* Creates the transfer handler used as default for this component.
	*
	* @return		an subclass of TransferHandler used as default transfer handler for this component
	**/
	 protected com.ulcjava.base.application.dnd.TransferHandler createDefaultTransferHandler()
	{
		return null;
	}

	 public com.ulcjava.base.application.dnd.TransferHandler getTransferHandler()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 public com.ulcjava.base.application.dnd.IDnDData restoreDnDSourceData(com.ulcjava.base.shared.internal.Anything args)
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 public com.ulcjava.base.application.dnd.IDnDData restoreDnDTargetData(com.ulcjava.base.shared.internal.Anything args)
	{
		return null;
	}

	 protected com.ulcjava.base.server.ULCTableTreeModelAdapter getModelAdapter()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCTableTreeDispatcher extends ULCComponentDispatcher
{

	 public  final void requestCellRendererComponents(int columnOid, int[][] descriptions)
	{
	}

	 public  final void requestHeaderRendererComponent(int columnOid)
	{
	}

	 public  final void requestCellEditorComponents(int columnOid, int[][] descriptions)
	{
	}


}
}