package com.ulcjava.base.application;


	/**
	* The abstract class <code>ULCTextComponent</code> provides common behavior for
	* components containing editable text.
<p>
</p>
<b>Features</b>
<ul>
<li>The
	* <code>ULCTextComponent</code> component inherits all features from
	* <code>ULCComponent</code>.
<li>The basic visual properties that are available
	* on <code>ULCTextComponent</code> are editable state, margin, and background
	* and
foreground colors of the selected text.
<li>The selection of the
	* <code>ULCTextComponent</code> can be queried and manipulated.
<li>The
	* <code>ULCTextComponent</code> component supports the basic editing commands
	* such as copy, paste, and cut.
<li>An application can register an
	* <code>IValueChangedListener</code> to be notified about state changes of
	* the
<code>ULCTextComponent.</code>
</ul>
<b>Examples</b>
<p>
</p>
The
	* following example sets some visual
	* properties.

<pre>
textComponent.setEditable(true);
textComponent.setMargin(new
	* Insets(10, 10, 10,
	* 10));
textComponent.setSelectedTextColor(Color.red);
textComponent.setSelection
	* Color(Color.green);
</pre>

Using the basic editing commands is
	* straighforward.
<pre>
textComponent.setText(&quot;Text was: &quot; +
	* textComponent.getText());
textComponent.select(0,
	* 10);
textComponent.copy();
textComponent.select(0, 0); // sets the
	* caret
textComponent.paste();
textComponent.paste();
textComponent.paste();
</pr
	* e>

The following example installs a value changed listener on a text
	* component.

<pre>
textComponent.addValueChangedListener(new
	* IValueChangedListener() {
public void valueChanged(ValueChangedEvent event)
	* {
ULCTextComponent textComponent =
	* (ULCTextComponent)event
.getSource();
System.out.println(textComponent.getText(
	* ));
}
});
</pre>
	*
	* @ulc.application		
	* @see		ULCComponent
	* @see		Color
	* @see		Insets
	**/
 public  abstract class ULCTextComponent extends com.ulcjava.base.application.ULCComponent implements com.ulcjava.base.application.enabler.IEnabler, com.ulcjava.base.server.dnd.IDnDComponent, com.ulcjava.base.application.enabler.IHasChangedSource
{


	/**
	* Creates a new ULCTextComponent. The text component is marked as editable and
	* its text is set to null.
	*
	**/
	 public ULCTextComponent()
	{
		 super();
	}


	/**
	* Registers the observer <code>listener</code>.
<p>
</p>
The text component
	* triggers an <code>ValueChangedEvent</code> whenever it's content has been
	* changed. Client side changes are late
propagated to the server side, i.e.
	* whenthe text component looses focus.
	*
	* @param listener 		 the observer to be registered
	* @see		#removeValueChangedListener
	**/
	 public void addValueChangedListener(com.ulcjava.base.application.event.IValueChangedListener listener)
	{
	}


	/**
	* The currently selected range in the text component is copied into the system
	* clipboard. The text and the current selection remain
unchanged. A null
	* selection has no effect.
<p>
</p>
<b>Note:</b> Calling this method before the
	* widget has been uploaded has no effect.
	*
	**/
	 public void copy()
	{
	}


	/**
	* The currently selected range in the text component is moved into the system
	* clipboard. The selected range of text is removed from the
text component and
	* the current selection is reset. A null selection has no
	* effect.
<p>
</p>
<b>Note:</b> Calling this method before the widget has been
	* uploaded has no effect.
	*
	**/
	 public void cut()
	{
	}


	/**
	* Returns the current color used to render the selection.
	*
	* @return		the selection color
	**/
	 public com.ulcjava.base.application.util.Color getSelectionColor()
	{
		return null;
	}


	/**
	* Returns the current color used to render the selected text.
	*
	* @return		the selection text color
	**/
	 public com.ulcjava.base.application.util.Color getSelectedTextColor()
	{
		return null;
	}


	/**
	* Returns the current color used to render the disabled text.
	*
	* @return		the disabled text color
	**/
	 public com.ulcjava.base.application.util.Color getDisabledTextColor()
	{
		return null;
	}


	/**
	* Returns the text contained in this text component.
	*
	* @return		the text
	* @see		#setText
	**/
	 public java.lang.String getText()
	{
		return null;
	}


	/**
	* Returns an array of all the <code>IValueChangedListener</code>s added to this
	* <code>ULCTextComponent</code> with
<code>addValueChangedListener()</code>.
	*
	* @return		all <code>IValueChangedListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.IValueChangedListener[] getValueChangedListeners()
	{
		return null;
	}

	 protected java.lang.Object getValue()
	{
		return null;
	}

	 protected void setValue(java.lang.Object value)
	{
	}


	/**
	* Returns the margin space between the text component's border and its text.
	*
	* @return		the margin
	**/
	 public com.ulcjava.base.application.util.Insets getMargin()
	{
		return null;
	}


	/**
	* Sets the margin space between the text component's border and its text.
	*
	* @param margin 		 the margin
	**/
	 public void setMargin(com.ulcjava.base.application.util.Insets margin)
	{
	}


	/**
	* Returns the current color of the caret.
	*
	* @return		the color used in rendering the caret
	**/
	 public com.ulcjava.base.application.util.Color getCaretColor()
	{
		return null;
	}


	/**
	* Sets the current color used while rendering the caret.
	*
	* @param caretColor 		 the color of caret
	* @see		#getCaretColor
	**/
	 public void setCaretColor(com.ulcjava.base.application.util.Color caretColor)
	{
	}


	/**
	* Sets the key accelerator that enables the text component to get the focus. The
	* accelerator is the combination of <em>alt</em> key
and the character given
	* (converted to upper case). There is no focus accelerator key by default.
	*
	* @param focusAcceleratorKey 		 the key
	* @see		#getFocusAccelerator
	* @beaninfo		description: accelerator character used to grab focus bound: true
	**/
	 public void setFocusAccelerator(char focusAcceleratorKey)
	{
	}


	/**
	* Returns the focus accelerator key character.
	*
	* @return		the focus accelerator key, '\0' if no the accelerator has not been set
	**/
	 public char getFocusAccelerator()
	{
		return 'a';
	}


	/**
	* Replaces the currently selected content with new content represented by the
	* given string. If there is no selection this amounts to an
insert of the given
	* text. If there is no replacement text this amounts to a removal of the
	* currentselection.
<p>
This is the method that is used by the default
	* implementation of the action for inserting content that gets bound to the
	* keymap
actions.
<p>
This method is thread safe, although most Swing methods
	* are not. Please see
	* <A
HREF="http://java.sun.com/products/jfc/swingdoc-archive/threads.html">Thread
	* s and Swing</A> for more information.
	*
	* @param content 		 the content to replace the selection with
	**/
	 public void replaceSelection(java.lang.String content)
	{
	}

	 protected void updateSelectionStart(int selectionStart)
	{
	}

	 protected void updateSelectionEnd(int selectionEnd)
	{
	}

	 protected void updateCaretPosition(int caretPosition)
	{
	}

	 protected void updateValue(java.lang.Object value)
	{
	}


	/**
	* Returns true for an editable text component, otherwise false.
	*
	* @return		is text component editable
	* @see		#setEditable
	**/
	 public boolean isEditable()
	{
		return false;
	}


	/**
	* Copies the contents of the system clipboard into the text component. If the
	* text component has a selection, it is replaced with the
pasted text. With no
	* selection the contents of the clipboard is inserted in front of the current
	* insertion position. An empty
clipboard has no effect.
<p>
</p>
<b>Note:</b>
	* Calling this method before the widget has been uploaded has no effect.
	*
	**/
	 public void paste()
	{
	}


	/**
	* Removes the observer <code>listener</code> from the text component. The
	* listener does not receive change updates from this
component anymore.
	*
	* @param listener 		 the observer to register
	* @see		#addValueChangedListener
	**/
	 public void removeValueChangedListener(com.ulcjava.base.application.event.IValueChangedListener listener)
	{
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* Selects all the text in the text component. It has no effect with a null or
	* empty text.
	*
	**/
	 public void selectAll()
	{
	}


	/**
	* Selects the text between the positions <code>selectionStart</code> and
	* <code>selectionEnd</code>.
	*
	* @param selectionStart 		 the start position of the text >= 0
	* @param selectionEnd 		 the end position of the text >= 0
	**/
	 public void select(int selectionStart, int selectionEnd)
	{
	}

	 protected int getTextLength()
	{
		return 0;
	}


	/**
	* Returns the text selected in this text component. Returns null if there is no
	* selection.
	*
	* @return		the selected text
	* @see		#setText
	**/
	 public java.lang.String getSelectedText()
	{
		return null;
	}


	/**
	* Returns the start position of the selection in this text component. Returns 0
	* for an empty document, or the value of dot if no there
is no selection.
	*
	* @return		the start position >= 0
	**/
	 public int getSelectionStart()
	{
		return 0;
	}


	/**
	* Sets the start position of the selection in this text component.
	*
	* @param selectionStart 		 the start position of the text >= 0
	* @see		#select(int, int)
	**/
	 public void setSelectionStart(int selectionStart)
	{
	}


	/**
	* Returns the end position of the selection in this text component. Returns 0
	* foran empty document, or the value of dot if no there is
no selection.
	*
	* @return		the end position >= 0
	**/
	 public int getSelectionEnd()
	{
		return 0;
	}


	/**
	* Sets the end position of the selection in this text component.
	*
	* @param selectionEnd 		 the end position of the text >= 0
	* @see		#select(int, int)
	**/
	 public void setSelectionEnd(int selectionEnd)
	{
	}


	/**
	* Sets the editable property.
	*
	* @param editable 		 the editable property
	* @see		#isEditable
	**/
	 public void setEditable(boolean editable)
	{
	}


	/**
	* Sets the color used to render the selection. Setting the color to null is
	* equivalent to setting the color to <code>Color.white</code>.
	*
	* @param c 		 the selection color
	* @see		#getSelectionColor
	**/
	 public void setSelectionColor(com.ulcjava.base.application.util.Color c)
	{
	}


	/**
	* Sets the color used to render the selected text. Setting the color to null is
	* equivalent to setting the color to
<code>Color.black</code>.
	*
	* @param color 		 the selection text color
	* @see		#getSelectedTextColor
	**/
	 public void setSelectedTextColor(com.ulcjava.base.application.util.Color color)
	{
	}


	/**
	* Sets the color used to render the disabled text. Setting the color to null is
	* equivalent to setting the color
	* to
<code>UIManager.getColor("TextField.inactiveForeground")</code>.
	*
	* @param color 		 the disabled text color
	* @see		#getDisabledTextColor
	**/
	 public void setDisabledTextColor(com.ulcjava.base.application.util.Color color)
	{
	}


	/**
	* Sets the text of this text component to <code>text</code>. If
	* <code>text</code>is null or empty the old text will be deleted.
	*
	* @param text 		 the new text to be set
	* @see		#getText
	**/
	 public void setText(java.lang.String text)
	{
	}


	/**
	* Sets the position of the text insertion caret for the TextComponent.
	*
	* @param position 		 the position
	**/
	 public void setCaretPosition(int position)
	{
	}


	/**
	* Moves the caret to a new position, leaving behind a mark defined by the last
	* time setCaretPosition was called. This forms a
selection.
	*
	* @param position 		 the position
	* @see		#setCaretPosition
	**/
	 public void moveCaretPosition(int position)
	{
	}


	/**
	* Scrolls the position until it is displayed. The minimum of amount of scrolling
	* necessary to bring the position into view is
performed.
	*
	* @param position 		 an integer specifying the position to scroll
	**/
	 public void scrollPositionToVisible(int position)
	{
	}


	/**
	* Returns the position of the text insertion caret for the text component.
	*
	* @return		the position of the text insertion caret for the text component >= 0
	**/
	 public int getCaretPosition()
	{
		return 0;
	}


	/**
	* Determines if Drag & Drop support is enabled or disabled.
	*
	* @return		true, if Drag & Drop support is enabled, false otherwise
	**/
	 public boolean isDragEnabled()
	{
		return false;
	}


	/**
	* Determines if Drag & Drop support is enabled or disabled.
	*
	* @param enabled 		 true, if Drag & Drop support should be enabled, false otherwise
	**/
	 public void setDragEnabled(boolean enabled)
	{
	}


	/**
	* Sets the transfer handler instance used to configure the Drag & Drop behavior
	* for this component and to handle data import / export.
	*
	* @param transferHandler 		 an instance of TransferHandler
	**/
	 public void setTransferHandler(com.ulcjava.base.application.dnd.TransferHandler transferHandler)
	{
	}


	/**
	* Creates the transfer handler used as default for this component.
	*
	* @return		an subclass of TransferHandler used as default transfer handler for this component
	**/
	 protected com.ulcjava.base.application.dnd.TransferHandler createDefaultTransferHandler()
	{
		return null;
	}


	/**
	* Returns the transfer handler.
	*
	* @return		the instance of TransferHandler
	**/
	 public com.ulcjava.base.application.dnd.TransferHandler getTransferHandler()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 public com.ulcjava.base.application.dnd.IDnDData restoreDnDSourceData(com.ulcjava.base.shared.internal.Anything args)
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 public com.ulcjava.base.application.dnd.IDnDData restoreDnDTargetData(com.ulcjava.base.shared.internal.Anything args)
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCTextComponentDispatcher extends ULCComponentDispatcher
{

	 public  final void updateSelectionStart(int selectionStart)
	{
	}

	 public  final void updateSelectionEnd(int selectionEnd)
	{
	}

	 public  final void updateCaretPosition(int caretPosition)
	{
	}

	 public  final void updateValue(java.lang.Object value)
	{
	}


}
}