package com.ulcjava.base.application;


	/**
	* A <code>ULCTextField</code> allows the editing of a single line of
	* text.
<p>
</p>
<b>Features</b>
<ul>
<li>The <code>ULCTextField</code>
	* component inherits all features from <code>ULCTextComponent</code>.
<li>The
	* <code>ULCTextField</code> supports horizontal alignment of text.
<li>An
	* <code>IDataType</code> object can be used to edit non-string values (e.g.,
	* dates using a <code>ULCDateDataType</code>). The
<code>IDataType</code>
	* objects offer formatting and validation (without roundtrips to the server).
	* Ifan <code>IDataType</code> is used,
the <code>getValue()</code> and
	* <code>setValue()</code> accessor methods can be used to access the actual
	* value.
<li>An application can register an <code>IValueChangedListener</code>
	* to be notified about state changes of the <code>ULCTextField</code>.
<li>An
	* application can register an <code>IActionListener</code> to be notified when
	* the <code>ULCTextField</code> issues an action event
(when the user presses
	* the Enter key).
</ul>
<b>Examples</b>
<p>
</p>
The following example creates
	* atext field and installs an <code>IDataType</code>
	* (<code>ULCDateDataType</code>) on it.

<pre>
final ULCTextField textField =
	* new
	* ULCTextField(10);
textField.setHorizontalAlignment(ULCTextField.RIGHT);
textFie
	* ld.setDataType(new
	* ULCDateDataType(&quot;dd.MM.yyyy&quot;));
textField.setValue(new
	* Date());
</pre>
<p>
</p>
The next code snippet demonstrates how to register
	* an<code>IActionListener</code> and access a non-string value on a text field
	* with an
installed <code>IDataType</code>. Note that getValue() is called on
	* the text field instead of <code>getText()</code>, which throws an
exception
	* when called and a datatype is
	* installed.
<p>
</p>

<pre>
textField.addActionListener(new IActionListener()
	* {public void actionPerformed(ActionEvent event)
	* {
System.out.println(&quot;enter typed. value: &quot; +
	* textField.getValue());}
});
</pre>
	*
	* @ulc.application		
	* @see		ULCTextComponent
	* @see		ULCComponent
	**/
 public class ULCTextField extends com.ulcjava.base.application.ULCTextComponent implements com.ulcjava.base.shared.IDefaults, com.ulcjava.base.application.IEditorComponent
{


	/**
	* Constructs a new text field. The initial text is null, and the number of
	* columns is set to 0.
	*
	**/
	 public ULCTextField()
	{
		 super();
	}


	/**
	* Constructs a new text field with the initial text <code>text</code>. The
	* numberof columns is 0.
	*
	* @param text 		 the text to be displayed, or null
	**/
	 public ULCTextField(java.lang.String text)
	{
		 super();
	}


	/**
	* Constructs a new empty text field with specified number of columns. The
	* initialstring is set to null.
	*
	* @param columns 		 the number of columns for determining the preferred width. If columns is set to zero, the preferred width is left to
the component implementation.
	**/
	 public ULCTextField(int columns)
	{
		 super();
	}


	/**
	* Constructs a new text field with initial <code>text</code> and
	* <code>columns</code>.
	*
	* @param text 		 the text to be displayed, or null
	* @param columns 		 the number of columns for determining the preferred width. If columns is set to zero, the preferred width is left to
the component implementation.
	* @throws		IllegalArgumentException if columns < 0
	**/
	 public ULCTextField(java.lang.String text, int columns)
	{
		 super();
	}


	/**
	* Adds the action listener <code>listener</code> to this text field.
<p/>
The
	* text field triggers an <code>ActionEvent</code> whenever the
	* "notify-field-accept" key stroke is pressed. The
"notify-field-accept" key
	* stroke is defined by the look and feel, usually it is the ENTER key.
	*
	* @param listener 		 the action listener
	**/
	 public void addActionListener(com.ulcjava.base.application.event.IActionListener listener)
	{
	}


	/**
	* Returns an array of all the <code>IActionListener</code>s added to this
	* <code>ULCTextField</code> with
<code>addActionListener()</code>.
	*
	* @return		all <code>IActionListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.IActionListener[] getActionListeners()
	{
		return null;
	}


	/**
	* Removes the specified action listener <code>listener</code>.
	*
	* @param listener 		 the action listener
	**/
	 public void removeActionListener(com.ulcjava.base.application.event.IActionListener listener)
	{
	}


	/**
	* Returns the data type for this text field.
	*
	* @return		the data type
	**/
	 public com.ulcjava.base.application.datatype.IDataType getDataType()
	{
		return null;
	}


	/**
	* Sets the data type for this text field.
<p>
</p>
<b>Note:</b>
<ul>
<li>If the
	* textfield is already uploaded, the current value will be cleared
	* out.
<li>Whenyou set a datatype, ULC disables the drag operation and installs
	* a default datatype TransferHandler that does nothing on
drag and drop. To
	* handle drag and drop of datatype values the developer has to implement and
	* seta custom TransferHandler on the
textfield.
<li>When you set datatype to
	* null, ULC disables the drag operation and installs a default TransferHandler
	* that handles drag and drop
of String values. Subsequently you may install
	* yourown transfer handler.
</ul>
	*
	* @param dataType 		 the data type
	* @see		IDataType
	* @see		com.ulcjava.base.application.datatype.ULCDateDataType
	* @see		com.ulcjava.base.application.datatype.ULCPercentDataType
	* @see		com.ulcjava.base.application.datatype.ULCNumberDataType
	* @see		com.ulcjava.base.application.datatype.ULCRegularExpressionDataType
	* @see		com.ulcjava.base.application.datatype.ULCStringDataType
	**/
	 public void setDataType(com.ulcjava.base.application.datatype.IDataType dataType)
	{
	}


	/**
	* Determines if Drag & Drop support is enabled or
	* disabled.
<p>
</p>
<b>Note:</b>Setting dragEnabled to true is not supported
	* when a datatype is set along with the default datatype transfer
	* handler.
<p>
</p>
	*
	* @param enabled 		 true, if Drag & Drop support should be enabled, false otherwise
	**/
	 public void setDragEnabled(boolean enabled)
	{
	}


	/**
	* Sets the transfer handler instance used to configure the Drag & Drop behavior
	* for this component and to handle data import /
	* export.
<p>
</p>
<b>Note:</b>ULC will set a default datatype TransferHandler
	* if the argument is null and datatype is set.
<p>
</p>
	*
	* @param transferHandler 		 an instance of TransferHandler
	**/
	 public void setTransferHandler(com.ulcjava.base.application.dnd.TransferHandler transferHandler)
	{
	}


	/**
	* Returns the horizontal alignment of this text field's text. Valid keys: LEFT,
	* CENTER and RIGHT
	*
	* @return		the horizontal alignment
	* @see		#setHorizontalAlignment
	**/
	 public int getHorizontalAlignment()
	{
		return 0;
	}


	/**
	* Sets the horizontal alignment of this text field's text. Valid keys: LEFT (the
	* default), CENTER and RIGHT.
	*
	* @param alignment 		 the horizontal alignment
	* @see		#getHorizontalAlignment
	**/
	 public void setHorizontalAlignment(int alignment)
	{
	}


	/**
	* Returns the action command for this text field.
	*
	* @return		the action command property
	**/
	 public java.lang.String getActionCommand()
	{
		return null;
	}


	/**
	* Sets the action command property for this text field.
	*
	* @param actionCommand 		 the action command for the text field
	**/
	 public void setActionCommand(java.lang.String actionCommand)
	{
	}


	/**
	* Creates the transfer handler used as default for this component when datatype
	* is set.
	*
	* @return		an subclass of TransferHandler used as default transfer handler for this component when datatype is set.
	**/
	 protected com.ulcjava.base.application.dnd.TransferHandler createDefaultDataTypeTransferHandler()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* For backward compatibility with Anything keys. Used in deprecated
	* com.ulcjava.base.client.UIProxy#createBasicObject(Anything) method.
	*
	* @ulc.internal		
	* @deprecated		
	**/
	 protected void saveState(com.ulcjava.base.shared.internal.Anything a)
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected int getTextLength()
	{
		return 0;
	}

	 public java.lang.String getSelectedText()
	{
		return null;
	}


	/**
	* Set the value of this text field. Allows passing basic data types to the UI
	* (e.g. Boolean, Date, Long etc). The value if edited in
the UI will also be of
	* the same type if this field is associated with a IDataType (using the {@link
	* #setDataType(IDataType)
setDataType} method) that supports the type
	* passed.
<p/>
For example:
<p>
</p>

<pre>
field.setDataType(new
	* ULCDateDataType());
field.setValue(new Date());
&lt;p/&gt;
...Edit the value
	* in the UI...
&lt;p/&gt;
Date d= (Date)field.getValue();
</pre>
	*
	* @param value 		 the new value to be set
	* @see		IDataType
	* @see		#setDataType
	* @see		#setText
	**/
	 public void setValue(java.lang.Object value)
	{
	}


	/**
	* Returns the value contained in this text field. Returns a basic data types
	* fromthe UI (e.g. Boolean, Date, Long etc), if this field
is associated with a
	* IDataType (using the {@link #setDataType(IDataType) setDataType} method) that
	* supports the type.
<p/>
For example:
<p>
</p>

<pre>
field.setDataType(new
	* ULCDateDataType());
field.setValue(new Date());
&lt;p/&gt;
...Edit the value
	* in the UI...
&lt;p/&gt;
Date d= (Date)field.getValue();
</pre>
	*
	* @return		the value contained in this TextComponent
	* @see		IDataType
	* @see		#getDataType
	* @see		#getText
	**/
	 public java.lang.Object getValue()
	{
		return null;
	}

	 public java.lang.String getText()
	{
		return null;
	}

	 public void setText(java.lang.String text)
	{
	}


	/**
	* Returns the number of columns.
	*
	* @return		the number of columns
	**/
	 public int getColumns()
	{
		return 0;
	}


	/**
	* Sets the number of columns.
	*
	* @param columns 		 the number of columns
	**/
	 public void setColumns(int columns)
	{
	}


	/**
	* Sets the action. Any previously set action is removed first. In addition, the
	* text field uses the short description property defined
in the action object
	* toadapt the tooltip text. The enabling state of the text field is set
	* according to the enabled / enabler
property of the action respectively. The
	* action is registered as action listener with the text field.
<p/>
Action
	* listeners registered using <code>addActionListener()</code> are not affected
	* by this operation.
	*
	* @param action 		 the action to be set
	**/
	 public void setAction(com.ulcjava.base.application.IAction action)
	{
	}


	/**
	* Returns the action set for this component.
	*
	* @return		an <code>IAction</code> object or null
	**/
	 public com.ulcjava.base.application.IAction getAction()
	{
		return null;
	}

	 protected void configurePropertiesFromAction(com.ulcjava.base.application.IAction action)
	{
	}

	 protected java.beans.PropertyChangeListener createActionPropertyChangeListener(com.ulcjava.base.application.IAction action)
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 public void copyAttributes(com.ulcjava.base.server.ICellComponent source)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 public boolean areAttributesEqual(com.ulcjava.base.server.ICellComponent component)
	{
		return false;
	}

	 public int attributesHashCode()
	{
		return 0;
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCTextFieldDispatcher extends ULCTextComponentDispatcher
{


}
}