package com.ulcjava.base.application;


	/**
	* The <code>ULCToolBar</code> class implements a floatable container for any
	* <code>ULCComponent</code>.
<p>
</p>
<b>Features</b>
<ul>
<li>The
	* <code>ULCToolBar</code> component inherits all features from
	* <code>ULCComponent</code>.
<li>The <code>ULCToolBar</code> component can
	* contain any <code>ULCComponent</code>. It is typically used to present a tool
	* bar of
the most important actions on a root pane. <code>ULCComponent</code>s
	* can be added and removed at runtime.
<li> The components can be visually
	* separated using <code>ULCSeparator</code> instances.
<li>The developer can
	* define if the toolbar should be floatable, i.e., if it can be dragged out of
	* its parent. <b>Note</b>: A floatable
tool bar needs to have a
	* <code>ULCBorderLayoutPane</code> as parent with no other children in it to
	* work correctly.
<li>The visual appearance of a <code>ULCToolBar</code>
	* component can be adapted by changing the following attributes: the
	* margin,
painting of the border, and horizontal or vertical
	* orientation.
</ul>
<p>
</p>
<b>Examples</b>
<p>
</p>
The following excerpt
	* shows how to create a simple floatable <code>ULCToolbar</code> that contains
	* two buttons.

<pre>
ULCToolBar toolBar = new ULCToolBar(&quot;ToolBar&quot;,
	* ULCToolBar.HORIZONTAL);
toolBar.setFloatable(true);
toolBar.setBorderPainted(tr
	* ue);
toolBar.setMargin(5);
toolBar.add(buttonOne);
toolBar.add(buttonTwo);
toolB
	* ar.addSeparator();
toolBar.add(buttonThree);
</pre>
	*
	* @ulc.application		
	* @see		ULCComponent
	* @see		ULCMenu
	* @see		ULCSeparator
	**/
 public class ULCToolBar extends com.ulcjava.base.application.ULCContainer implements com.ulcjava.base.shared.IDefaults
{


	/**
	* Creates a new horizontal toolbar.
	*
	**/
	 public ULCToolBar()
	{
		 super();
	}


	/**
	* Creates a new toolbar with the specified horizontal or vertical
	* orientation.
<p>
</p>
Legal orientation values
	* are:
<ul>
<li>HORIZONTAL
<li>VERTICAL
</ul>
	*
	* @param orientation 		 one of the two values listed above
	* @throws		IllegalArgumentException if orientation is invalid
	**/
	 public ULCToolBar(int orientation)
	{
		 super();
	}


	/**
	* Creates a new horizontal toolbar with the specified name which is used as the
	* title of the undocked toolbar.
	*
	* @param name 		 the name of the toolbar
	**/
	 public ULCToolBar(java.lang.String name)
	{
		 super();
	}


	/**
	* Creates a new toolbar with the specified name which is used as the title of
	* theundocked toolbar and with the specified horizontal or
vertical
	* orientation.<p>
</p>
Legal orientation values
	* are:
<ul>
<li>HORIZONTAL
<li>VERTICAL
</ul>
	*
	* @param name 		 the name of the toolbar
	* @param orientation 		 one of the two values listed above
	* @throws		IllegalArgumentException if orientation is invalid
	**/
	 public ULCToolBar(java.lang.String name, int orientation)
	{
		 super();
	}


	/**
	* Adds a component at the position indicated by index.
	*
	* @param component 		 the ULCComponent to be added
	* @param index 		 the index where to add the component
	* @return		the component argument
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, int index)
	{
		return null;
	}


	/**
	* Adds a component at the position indicated by index with a specific aligment.
	*
	* @param component 		 the ULCComponent to be added
	* @param index 		 the index where to add the component
	* @param alignment 		 the aligment for the component
	* @return		the component argument
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, int index, float alignment)
	{
		return null;
	}


	/**
	* Adds a component to the container with the specified constraints. The
	* constraints have to be a Float describing the alignment for the
component
	*
	* @param component 		 the content.
	* @param constraints 		 the constraints.
	* @return		the component argument.
	**/
	 public com.ulcjava.base.application.ULCComponent add(com.ulcjava.base.application.ULCComponent component, java.lang.Object constraints)
	{
		return null;
	}

	 protected int convertToIndex(java.lang.Object constraints)
	{
		return 0;
	}

	 protected java.lang.Object createDefaultConstraints(com.ulcjava.base.application.ULCComponent component)
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* For backward compatibility with Anything keys used in deprecated {@link
	* com.ulcjava.base.client.UIProxy#createBasicObject(Anything)}
	*
	* @ulc.extension		
	**/
	 protected void saveState(com.ulcjava.base.shared.internal.Anything a)
	{
	}


	/**
	* Gets the n<sup>th</sup> component in this toolbar.
	*
	* @param n 		 the index of the component to get.
	* @return		the n<sup>th</sup> component in this container.
	* @deprecated		use getComponents()[n] instead
	**/
	 public com.ulcjava.base.application.ULCComponent getComponent(int n)
	{
		return null;
	}


	/**
	* Appends a toolbar separator to the end of the toolbar.
	*
	**/
	 public void addSeparator()
	{
	}


	/**
	* Returns the current orientation of the toolbar.
	*
	* @return		an the current orientation of the toolbar
	**/
	 public int getOrientation()
	{
		return 0;
	}


	/**
	* Returns the margin space between the toolbar's border and its buttons.
	*
	* @return		the margin
	**/
	 public com.ulcjava.base.application.util.Insets getMargin()
	{
		return null;
	}


	/**
	* Returns true if the toolbar can be dragged out by the user.
	*
	* @return		true if the toolbar can be dragged out by the user, false otherwise
	**/
	 public boolean isFloatable()
	{
		return false;
	}


	/**
	* Checks whether the border should be painted.
	*
	* @return		true if the border should be painted, false otherwise
	**/
	 public boolean isBorderPainted()
	{
		return false;
	}


	/**
	* Sets the orientation of the toolbar.
<p>
</p>
Legal orientation values
	* are:
<ul>
<li>HORIZONTAL
<li>VERTICAL
</ul>
	*
	* @param orientation 		 one of the two values listed above
	* @throws		IllegalArgumentException if orientation is invalid
	**/
	 public void setOrientation(int orientation)
	{
	}


	/**
	* Sets the margin between the toolbar's border and its buttons. Setting to
	* <code>null</code> causes the toolbar to use the default
margins. The tool
	* bar's default border object uses this value to create the proper margin.
	* However, if a non-default border is set on
the tool bar, it is that
	* <code>ULCAbstractBorder</code> object's responsibility to create the
	* appropriate margin space (otherwise
this property will effectively be
	* ignored). For example, a compound border on the tool bar that has an empty
	* border (representing the
margin) as inside border will have the effect
	* similarto that of a margin between the default border and the buttons.
	*
	* @param margin 		 the space between the toolbar's border and its buttons
	* @see		com.ulcjava.base.application.border.ULCAbstractBorder
	**/
	 public void setMargin(com.ulcjava.base.application.util.Insets margin)
	{
	}


	/**
	* Sets whether the toolbar can be made to float.
	*
	* @param b 		 if true, the toolbar can be dragged out
	**/
	 public void setFloatable(boolean b)
	{
	}


	/**
	* Sets whether the border should be painted.
	*
	* @param b 		 if true, the border is painted
	**/
	 public void setBorderPainted(boolean b)
	{
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* Sets whether the toolbar will draw rollover button borders when the mouse
	* pointer hovers over them. The default is false. This
property's behavior is
	* dependent on the look and feel.
	*
	* @param rollover 		 true for rollover toolbar buttons, false otherwise
	**/
	 public void setRollover(boolean rollover)
	{
	}


	/**
	* Returns the rollover state.
	*
	* @return		true if rollover toolbar buttons are to be drawn, false otherwise
	* @see		#setRollover(boolean)
	**/
	 public boolean isRollover()
	{
		return false;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* This class is a toolbar-specific separator whose size can be configured.
	*
	* @ulc.application		
	**/
 public  static class ULCSeparator extends com.ulcjava.base.application.ULCSeparator
{


	/**
	* Creates a new horizontal toolbar separator of the look&feel default size.
	*
	**/
	 public ULCSeparator()
	{
		 super();
	}


	/**
	* Creates a new horizontal toolbar separator of the specified size.
	*
	* @param size 		 the <code>Dimension</code> of the separator
	**/
	 public ULCSeparator(com.ulcjava.base.application.util.Dimension size)
	{
		 super();
	}


	/**
	* Returns the size of the separator.
	*
	* @return		the size of the separator
	**/
	 public com.ulcjava.base.application.util.Dimension getSeparatorSize()
	{
		return null;
	}


	/**
	* Sets the size of the separator.
	*
	* @param separatorSize 		 the size of the separator
	**/
	 public void setSeparatorSize(com.ulcjava.base.application.util.Dimension separatorSize)
	{
	}


	/**
	* Returns the minimum size for the separator.
	*
	* @return		the <code>Dimension</code> object containing the separator's minimum size
	**/
	 public com.ulcjava.base.application.util.Dimension getMinimumSize()
	{
		return null;
	}


	/**
	* Returns the maximum size for the separator.
	*
	* @return		the <code>Dimension</code> object containing the separator's maximum size
	**/
	 public com.ulcjava.base.application.util.Dimension getMaximumSize()
	{
		return null;
	}


	/**
	* Returns the preferred size for the separator.
	*
	* @return		the <code>Dimension</code> object containing the separator's preferred size
	**/
	 public com.ulcjava.base.application.util.Dimension getPreferredSize()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCSeparatorDispatcher extends com.ulcjava.base.application.ULCSeparator$ULCSeparatorDispatcher
{


}
}
	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCToolBarDispatcher extends ULCContainerDispatcher
{


}
}