package com.ulcjava.base.application.border;


	/**
	* <code>ULCCompoundBorder</code> provides a composite border class that composes
	* two <code>ULCAbstractBorder</code> objects into a single
border by nesting an
	* inside border object within the insets of an outside border object. For
	* example, a <code>ULCEmptyBorder</code> can
be set on a component having
	* <code>ULCBevelBorder</code> to add blank margin space around that
	* component.
<p>
</p>
<b>Features </b>
<ul>
<li>Combines an outer and an inner
	* border to create a single border.
<li>Allows arbitrary nesting of instances
	* of<code>ULCAbstractBorder</code>
</ul>
<p>
</p>
<b>Examples
	* </b>
<p>
</p>

<pre>
ULCAbstractBorder raisedbevel, loweredbevel, compound,
	* nested;
raisedbevel = BorderFactory.createRaisedBevelBorder();
loweredbevel =
	* BorderFactory.createLoweredBevelBorder();
compound =
	* BorderFactory.createCompoundBorder(raisedbevel, loweredbevel);
nested =
	* BorderFactory.createCompoundBorder(new ULCLineBorder(Color.cyan,
5),
	* compound);
ULCLabel label = new ULCLabel(&quot;Compound Bevel Border in a
	* LineBorder&quot;);
label.setBorder(nested);
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.BorderFactory
	**/
 public class ULCCompoundBorder extends com.ulcjava.base.application.border.ULCAbstractBorder
{


	/**
	* Constructs a compound border. The outside and inside borders are set to null.
	*
	**/
	 public ULCCompoundBorder()
	{
	}


	/**
	* Constructs a compound border with the supplied outside and inside borders
	* whichcould be null.
	*
	* @param outsideBorder 		 the outside border
	* @param insideBorder 		 the inside border to be nested
	**/
	 public ULCCompoundBorder(com.ulcjava.base.application.border.ULCAbstractBorder outsideBorder, com.ulcjava.base.application.border.ULCAbstractBorder insideBorder)
	{
	}


	/**
	* Returns the outside border object.
	*
	* @return		<code>ULCAbstractBorder</code> the outside border
	**/
	 public com.ulcjava.base.application.border.ULCAbstractBorder getOutsideBorder()
	{
		return null;
	}


	/**
	* Returns the inside border object.
	*
	* @return		<code>ULCAbstractBorder</code> the inside border
	**/
	 public com.ulcjava.base.application.border.ULCAbstractBorder getInsideBorder()
	{
		return null;
	}

	 public boolean equals(java.lang.Object obj)
	{
		return false;
	}

	 public int hashCode()
	{
		return 0;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* For backward compatibility with Anything keys used in the deprecated
	* com.ulcjava.base.client.UIProxy#createBasicObject(Anything)
method.
	*
	* @ulc.extension		
	* @deprecated		
	**/
	 protected void saveState(com.ulcjava.base.shared.internal.Anything a)
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCCompoundBorderDispatcher extends ULCAbstractBorderDispatcher
{


}
}