package com.ulcjava.base.application.datatype;


	/**
	* The error manager manages and visualizes {@link ErrorObject}s for {@link
	* ULCComponent}s. ErrorObjects can be created on the server or on
the client
	* side. The standard ULC data types are working with an error manager to report
	* errors when the String conversion fails. The
client part of the error manager
	* provide hooks for the visualization of the error. Clients using the error
	* manager must make sure that it
gets uploaded, either by setting it on a
	* datatype of a {@link ULCTextField} that is contained in a visible component
	* orby calling
upload() on the error manager object itself.
	*
	* @see		ErrorObject
	* @see		UIAbstractErrorManager
	* @see		ULCDefaultErrorManager
	**/
 public  abstract class ULCAbstractErrorManager extends com.ulcjava.base.application.ULCProxy
{


	/**
	* Initializes the error manager. To show error messages the error manager uses a
	* map that holds error messages templates for the error
code of the {@link
	* ErrorObject}s. The messages are processed by {@link MessageFormat#format }
	* using the ErrorObjects parameters.
	*
	* @param errorMessages 		 a {@link Map} that maps error codes to error message templates.
	**/
	 public ULCAbstractErrorManager(java.util.Map errorMessages)
	{
		 super();
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* Stores the given {@link ErrorObject} for the given {@link ULCComponent}.
	* Triggers the visualization of the error.
	*
	* @param widget 		 that the error belongs to.
	* @param error 		 {@link ErrorObject} describing the error.
	**/
	 public void showError(com.ulcjava.base.application.ULCComponent widget, com.ulcjava.base.shared.ErrorObject error)
	{
	}


	/**
	* Retrieves the {@link ErrorObject} for the given {@link ULCComponent}.
	*
	* @param field 		 that the error is requested for.
	* @return		the {@link ErrorObject} that is shown on the component or <code>null</code>, if there is no error on the component.
	**/
	 public com.ulcjava.base.shared.ErrorObject getError(com.ulcjava.base.application.ULCComponent field)
	{
		return null;
	}

	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 public class ULCAbstractErrorManagerDispatcher extends ULCProxyDispatcher implements com.ulcjava.base.server.IDispatcher
{

	 public  final void setErrorMap(java.util.Map errorMap)
	{
	}


}
}