package com.ulcjava.base.application.datatype;


	/**
	* The <code>ULCNumberDataType</code> formats number values and validates user
	* input to be valid and to respect user-defined
	* constraints.
<p>
</p>
<b>Features</b>
<ul>
<li>The developer can specify
	* whether only integral numbers are allowed.
<li>Bounds (minimum and maximum)
	* can be specified, to which the entered number must adhere.
<li>The formatting
	* policy can be specified. The formatting policy "java.text" allows for full
	* flexibility in formatting the number. The
"java.lang" policy should only be
	* used for validating values (displaying them in an unformatted way).
<li>The
	* minimum and maximum number of fraction digits to be used in formatting can be
	* specified.
<li><code>ULCNumberDataType</code>'s formatting capabilities
	* include grouping, i.e., separating groups of three digits by a "'"
	* marker.
<li>It is possible to set the locale to be used to format the
	* numbers.The locale can only be set by passing it to the data
	* type's
constructor. In this case, the formatting policy is set to
	* <code>JAVA_TEXT_STYLE</code> in the constructor and this setting should not
	* bechanged via <code>setFormattingPolicy()</code>.
<li>It is possible to set a
	* pattern to format the number. The pattern can have the following
	* form:

<pre>
pattern := integer{.fraction}
integer := {#}* {0}* 0
fraction :=
	* {0}* {#}*
</pre>
During formatting, pattern characters create output as
	* follows (see also {@link java.text.DecimalFormat}):

<pre>
0 outputs a single
	* digit
# outputs a single digit,
except that a leading or trailing zero is
	* suppressed
. outputs a decimal separator
, outputs a grouping
	* separator
</pre></code>
<p>
<b>Note:</b> If a pattern specifies grouping
	* characters and fraction digits then the pattern's specification takes
	* precedence over
explicit specification of grouping characters (e.g.
	* <code>setGroupingUsed(false)</code>) and minimum and maximum fraction digits
	* (e.g.
<code>setMinimumFractionDigits()</code> and
	* <code>setMaximumFractionDigits()</code>). <br>
<br>
</p>
<li>It is also
	* possible to set the symbols used for grouping and decimal separator. This can
	* be done by creating a new instance of the
class
	* <code>DecimalFormatSymbols</code> and setting the separator accordingly. The
	* pattern and symbols can only be set by passing them to
the data type's
	* constructor. The formatting policy is set to JAVA_TEXT_STYLE in the
	* constructor and should not be overridden
	* with
<code>setFormattingPolicy()</code>.
<li>The developer can specify
	* whetheror not all leading zeros should be displayed. By default, only one
	* leading zero is displayed.
</ul>
<b>Examples</b>
<p>
</p>
The following
	* excerpt shows how to add a <code>ULCTableColumn</code> to a
	* <code>ULCTable</code> that displays and edits double values.
The validator is
	* configured to show a minimum of one and a maximum of three fraction
	* digits.

<pre>
ULCNumberDataType effortColumnValidator = new
	* ULCNumberDataType();
effortColumnValidator
.setFormattingPolicy(ULCNumberDataTy
	* pe.JAVA_TEXT_FORMATTING);
effortColumnValidator.setMinFractionDigits(1);
effortC
	* olumnValidator.setMaxFractionDigits(3);

ULCTableColumn effortColumn =
	* taskTable.getColumnModel().getColumn(
EFFORT_COLUMN);

DefaultTableCellRenderer
	* renderer = new
	* DefaultTableCellRenderer();
renderer.setDataType(effortColumnValidator);

ULCTe
	* xtField editorTextField = new
	* ULCTextField();
editorTextField.setDataType(effortColumnValidator);
DefaultCell
	* Editor editor = new
	* DefaultCellEditor(editorTextField);

effortColumn.setCellRenderer(renderer);
ef
	* fortColumn.setCellEditor(editor);
</pre>

In the following example, a
	* ULCTextField with a ULCNumberDataType is used to edit integer numbers with a
	* minimum defined as 5. Grouping
is used to increase the readability of the
	* number.

<pre>
ULCTextField field = new ULCTextField();
ULCNumberDataType
	* fieldValidator = new
	* ULCNumberDataType();
fieldValidator.setFormattingPolicy(ULCNumberDataType.JAVA_
	* TEXT_FORMATTING);
fieldValidator.setInteger(true);
fieldValidator.setMin(5);
fie
	* ldValidator.setGroupingUsed(true);
fieldValidator.setMinFractionDigits(0);
field
	* Validator.setMaxFractionDigits(0);
field.setDataType(fieldValidator);
</pre>

Th
	* e next example edits numbers in a special format which does not correlate to a
	* format used with a special Locale using a pattern
	* and
DecimalFormatSymbols.

<pre>
ULCTextField field = new
	* ULCTextField();
DecimalFormatSymbols symbols = new
	* DecimalFormatSymbols();
symbols.setGroupingSeparator('\'');
symbols.setDecimalS
	* eparator(',');
ULCNumberDataType fieldValidator = new
	* ULCNumberDataType(&quot;###,#00.00#&quot;,
symbols);
fieldValidator.setGrouping
	* Used(true);
field.setDataType(fieldValidator);
</pre>
	*
	* @ulc.application		
	**/
 public class ULCNumberDataType extends com.ulcjava.base.application.datatype.ULCAbstractDataType implements com.ulcjava.base.application.datatype.IDataType
{

	/**
	* The (Locale unaware) java.lang formatting policy.
	*
	**/
	 public  final  static int JAVA_LANG_FORMATTING = 0;

	/**
	* The (Locale and pattern aware) java.text formatting policy.
	*
	**/
	 public  final  static int JAVA_TEXT_FORMATTING = 0;

	/**
	* Round away from zero. Always increments the digit prior to a non-zero
	* discardedfraction. Note that this rounding mode never
decreases the magnitude
	* of the calculated value.
	*
	**/
	 public  final  static int ROUND_UP = 0;

	/**
	* Round towards zero. Never increments the digit prior to a discarded fraction
	* (i.e., truncates). Note that this rounding mode never
increases the magnitude
	* of the calculated value.
	*
	**/
	 public  final  static int ROUND_DOWN = 0;

	/**
	* Round towards positive infinity. If the BigDecimal is positive, behaves as for
	* <tt>ROUND_UP</tt>; if negative, behaves as for
<tt>ROUND_DOWN</tt>. Note that
	* this rounding mode never decreases the calculated value.
	*
	**/
	 public  final  static int ROUND_CEILING = 0;

	/**
	* RRound towards negative infinity. If the BigDecimal is positive, behave as for
	* <tt>ROUND_DOWN</tt>; if negative, behave as for
<tt>ROUND_UP</tt>. Note that
	* this rounding mode never increases the calculated value.
	*
	**/
	 public  final  static int ROUND_FLOOR = 0;

	/**
	* Round towards "nearest neighbor" unless both neighbors are equidistant, in
	* which case round up. Behaves as for <tt>ROUND_UP</tt> if
the discarded
	* fraction is &gt;= .5; otherwise, behaves as for <tt>ROUND_DOWN</tt>. Note
	* thatthis is the rounding mode that most of
us were taught in grade school.
	*
	**/
	 public  final  static int ROUND_HALF_UP = 0;

	/**
	* Round towards "nearest neighbor" unless both neighbors are equidistant, in
	* which case round down. Behaves as for <tt>ROUND_UP</tt> if
the discarded
	* fraction is &gt; .5; otherwise, behaves as for <tt>ROUND_DOWN</tt>.
	*
	**/
	 public  final  static int ROUND_HALF_DOWN = 0;

	/**
	* Round towards the "nearest neighbor" unless both neighbors are equidistant, in
	* which case, round towards the even neighbor. Behaves
as for ROUND_HALF_UP if
	* the digit to the left of the discarded fraction is odd; behaves as for
	* ROUND_HALF_DOWN if it's even. Note
that this is the rounding mode that
	* minimizes cumulative error when applied repeatedly over a sequence of
	* calculations.
	*
	**/
	 public  final  static int ROUND_HALF_EVEN = 0;

	/**
	* Rounding mode to assert that the requested operation has an exact result,
	* henceno rounding is necessary. If this rounding mode is
specified on an
	* operation that yields an inexact result, an <tt>ArithmeticException</tt> is
	* thrown.
	*
	**/
	 public  final  static int ROUND_UNNECESSARY = 0;


	/**
	* Constructs a new number data type.
	*
	**/
	 public ULCNumberDataType()
	{
		 super();
	}


	/**
	* Constructs a new number data type.
	*
	* @param errorManager 		 that coordinates client and server side error handling
	**/
	 public ULCNumberDataType(com.ulcjava.base.application.datatype.ULCAbstractErrorManager errorManager)
	{
		 super();
	}


	/**
	* Constructs a new number data type using the given locale.
	*
	* @param locale 		 the locale to use for formatting
	**/
	 public ULCNumberDataType(java.util.Locale locale)
	{
		 super();
	}


	/**
	* Constructs a new number data type.
	*
	* @param errorManager 		 that coordinates client and server side error handling
	* @param locale 		 the locale to use for formatting
	**/
	 public ULCNumberDataType(com.ulcjava.base.application.datatype.ULCAbstractErrorManager errorManager, java.util.Locale locale)
	{
		 super();
	}


	/**
	* Constructs a new number data type using a user defined pattern and
	* <code>DecimalFormatSymbols</code>.
<p>
</p>
Note:
<ul>
<li>The pattern can
	* have the following form:<br>
<code>
pattern := integer{.fraction}<br>
integer
	* := {#}* {0}* 0<br>
fraction := {0}* {#}*<br>
<br>
The pattern characters have
	* the following meaning<br><code>
0 a digit <br>
# a digit, zero shows as
	* absent<br>
. placeholder for decimal separator<br>
, placeholder for grouping
	* separator <br>
</code>
<li>From <code>DecimalFormatSymbols</code> only the
	* grouping separator or decimal separator is supported.
	*
	* @param pattern 		 the pattern to use for formatting
	* @param symbols 		 the DecimalFormatSymbols used in the pattern.
	**/
	 public ULCNumberDataType(java.lang.String pattern, java.text.DecimalFormatSymbols symbols)
	{
		 super();
	}


	/**
	* Constructs a new number data type using a user defined pattern and
	* <code>DecimalFormatSymbols</code>.
<p>
</p>
Note:
<ul>
<li>The pattern can
	* have the following form:<br>
<code>
pattern := integer{.fraction}<br>
integer
	* := {#}* {0}* 0<br>
fraction := {0}* {#}*<br>
<br>
The pattern characters have
	* the following meaning<br><code>
0 a digit <br>
# a digit, zero shows as
	* absent<br>
. placeholder for decimal separator<br>
, placeholder for grouping
	* separator <br>
</code>
<li>From <code>DecimalFormatSymbols</code> only the
	* grouping separator or decimal separator is supported.
	*
	* @param errorManager 		 that coordinates client and server side error handling
	* @param pattern 		 the pattern to use for formatting
	* @param symbols 		 the DecimalFormatSymbols used in the pattern.
	**/
	 public ULCNumberDataType(com.ulcjava.base.application.datatype.ULCAbstractErrorManager errorManager, java.lang.String pattern, java.text.DecimalFormatSymbols symbols)
	{
		 super();
	}


	/**
	* Returns the formatting policy.
<p>
</p>
Valid values
	* are:
<ul>
<li>JAVA_LANG_FORMATTING
<li>JAVA_TEXT_FORMATTING
</ul>
	*
	* @return		the formatting policy
	**/
	 public int getFormattingPolicy()
	{
		return 0;
	}


	/**
	* Returns the maximum value.
	*
	* @return		the maximum value
	**/
	 public java.lang.Number getMax()
	{
		return null;
	}


	/**
	* Returns the maximum number of fraction digits.
	*
	* @return		the maximum number of fraction digits
	**/
	 public int getMaxFractionDigits()
	{
		return 0;
	}


	/**
	* Returns the minimum value.
	*
	* @return		the minimum value
	**/
	 public java.lang.Number getMin()
	{
		return null;
	}


	/**
	* Returns the minimum number of fraction digits.
	*
	* @return		the minimum number of fraction digits
	**/
	 public int getMinFractionDigits()
	{
		return 0;
	}


	/**
	* Returns true if grouping is being used, false otherwise.
	*
	* @return		true if grouping is being used, false otherwise
	**/
	 public boolean isGroupingUsed()
	{
		return false;
	}


	/**
	* Returns true if all leading zeros are displayed, false otherwise.
	*
	* @return		true if all leading zeros are displayed, false otherwise
	**/
	 public boolean isDisplayAllLeadingZeros()
	{
		return false;
	}


	/**
	* Returns true if the returned number is converted to an <code>Integer</code>,
	* false otherwise.
	*
	* @return		true if the returned number is converted to an <code>Integer</code>, false otherwise
	**/
	 public boolean isInteger()
	{
		return false;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* Sets the formatting policy (Default is
	* JAVA_LANG_FORMATTING).
<p>
</p>
<b>Note:</b> Setting this value after the
	* widget has been uploaded has no effect.
	*
	* @param policy 		 the formatting policy. Valid values are:
<ul>
<li>JAVA_LANG_FORMATTING
<li>JAVA_TEXT_FORMATTING
</ul>
	**/
	 public void setFormattingPolicy(int policy)
	{
	}


	/**
	* Sets whether or not grouping should be used.
<p>
</p>
<b>Note:</b> Setting
	* thisvalue after the widget has been uploaded has no effect.
	*
	* @param useGroups 		 flag to indicate whether or not grouping should be used
	**/
	 public void setGroupingUsed(boolean useGroups)
	{
	}


	/**
	* Sets whether or not all leading zeros should be displayed. If set to false,
	* allleading zeros except one are removed.
<p>
</p>
<b>Note:</b> Setting this
	* value after the widget has been uploaded has no effect.
	*
	* @param displayAllLeadingZeros 		 flag to indicate whether or not all leading zeros should be displayed.
	**/
	 public void setDisplayAllLeadingZeros(boolean displayAllLeadingZeros)
	{
	}


	/**
	* Sets the integer value property.
<p>
</p>
<b>Note:</b> Setting this value
	* afterthe widget has been uploaded has no effect.
	*
	* @param newIntValue 		 flag to indicate integer value
	**/
	 public void setInteger(boolean newIntValue)
	{
	}


	/**
	* Sets the max property to the given double (convenience).
<p>
</p>
<b>Note:</b>
	* Setting this value after the widget has been uploaded has no effect.
	*
	* @param newMax 		 the max property
	**/
	 public void setMax(double newMax)
	{
	}


	/**
	* Set the max property to the given int (convenience).
<p>
</p>
<b>Note:</b>
	* Setting this value after the widget has been uploaded has no effect.
	*
	* @param newMax 		 the max property
	**/
	 public void setMax(int newMax)
	{
	}


	/**
	* Sets the max property.
<p>
</p>
<b>Note:</b> Setting this value after the
	* widget has been uploaded has no effect.
	*
	* @param max 		 the max property
	**/
	 public void setMax(java.lang.Number max)
	{
	}


	/**
	* Sets the maximum number of fraction digits.
<p>
</p>
<b>Note:</b> Setting this
	* value after the widget has been uploaded has no effect.
	*
	* @param maxDigits 		 the max number of fraction digits.
	**/
	 public void setMaxFractionDigits(int maxDigits)
	{
	}


	/**
	* Set the min property to the given double (convenience).
<p>
</p>
<b>Note:</b>
	* Setting this value after the widget has been uploaded has no effect.
	*
	* @param newMin 		 the min property.
	**/
	 public void setMin(double newMin)
	{
	}


	/**
	* Set the min property to the given int (convenience).
<p>
</p>
<b>Note:</b>
	* Setting this value after the widget has been uploaded has no effect.
	*
	* @param newMin 		 the min property.
	**/
	 public void setMin(int newMin)
	{
	}


	/**
	* Set the min property.
<p>
</p>
<b>Note:</b> Setting this value after the
	* widgethas been uploaded has no effect.
	*
	* @param min 		 the min property.
	**/
	 public void setMin(java.lang.Number min)
	{
	}


	/**
	* Set the minimum number of fraction digits.
<p>
</p>
<b>Note:</b> Setting this
	* value after the widget has been uploaded has no effect.
	*
	* @param minDigits 		 the minimum number of fraction digits.
	**/
	 public void setMinFractionDigits(int minDigits)
	{
	}


	/**
	* Gets the rounding mode.
	*
	* @return		the rounding mode.
	* @see		#setRoundingMode(int)
	**/
	 public int getRoundingMode()
	{
		return 0;
	}


	/**
	* Sets the rounding mode. The default is ROUND_HALF_EVEN. The valid modes
	* are:
<ul>
<li>ROUND_UP
<li>ROUND_DOWN
<li>ROUND_CEILING
<li>ROUND_FLOOR
<li>ROU
	* ND_HALF_UP
<li>ROUND_HALF_DOWN
<li>ROUND_HALF_EVEN
<li>ROUND_UNNECESSARY
</ul>
<
	* p>
</p>
<b>Note:</b> Setting this value after the widget has been uploaded has
	* no effect.
	*
	* @param roundingMode 		 the rounding mode.
	* @throws		IllegalArgumentException <tt>roundingMode</tt> does not represent a valid rounding modes.
	* @see		#ROUND_UP
	* @see		#ROUND_DOWN
	* @see		#ROUND_CEILING
	* @see		#ROUND_FLOOR
	* @see		#ROUND_HALF_UP
	* @see		#ROUND_HALF_DOWN
	* @see		#ROUND_HALF_EVEN
	* @see		#ROUND_UNNECESSARY
	**/
	 public void setRoundingMode(int roundingMode)
	{
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCNumberDataTypeDispatcher extends ULCAbstractDataTypeDispatcher
{


}
}