package com.ulcjava.base.application.datatype;


	/**
	* The <code>ULCStringDataType</code> offers the possibility to limit text entry
	* to a specified length.
<p>
</p>
<b>Features</b>
<ul>
<li>Additionally, text
	* can automatically be converted to all upper case or all lower case.
<li>The
	* property <code>ignoreLongStringCompeletely</code> to ignore completely the
	* text being set if the length of current and new
text exceeds the length
	* limit,partial text is set otherwise.
</ul>
<b>Examples</b>
<p>
</p>
The
	* following example shows an application of the <code>ULCStringDataType</code>.
	* Note that the example uses the methods
<code>getValue()</code> and
	* <code>setValue()</code> on the text field. The <code>getText()</code> and
	* <code>setText()</code>
methods cannot be used in connection with data
	* types.

<pre>
ULCStringDataType stringFormatter = new
	* ULCStringDataType();
stringFormatter.setMaxLength(10);
stringFormatter.setMode(
	* ULCStringDataType.ALL_UPPER_CASE);
field.setDataType(stringFormatter);
field.set
	* Value(&quot;Test&quot;);
field.addActionListener(new IActionListener()
	* {
publicvoid actionPerformed(ActionEvent event)
	* {
System.out.println(field.getValue());
}
});
</pre>
	*
	* @ulc.application		
	**/
 public class ULCStringDataType extends com.ulcjava.base.application.datatype.ULCAbstractDataType implements com.ulcjava.base.application.datatype.IDataType
{

	/**
	* Constant that indicates the no change mode of the formatter.
	*
	**/
	 public  final  static int IDENTITY = 0;

	/**
	* Constant that indicates that all input should be converted to uppercase.
	*
	**/
	 public  final  static int ALL_UPPER_CASE = 0;

	/**
	* Constant that indicates that all input should be converted to lowercase.
	*
	**/
	 public  final  static int ALL_LOWER_CASE = 0;


	/**
	* Constructs a new string data type.
	*
	**/
	 public ULCStringDataType()
	{
		 super();
	}


	/**
	* Constructs a new string data type with maximum string length as specified.
	*
	* @param maxLength 		 The maximum length in characters for the input
	**/
	 public ULCStringDataType(int maxLength)
	{
		 super();
	}


	/**
	* Constructs a new string data type with maximum string length as specified and
	* <code>mode</code>.
	*
	* @param maxLength 		 the maximum length in characters for the input
	* @param mode 		 can be one of <code>IDENTITY</code>, <code>ALL_UPPER_CASE</code>, <code>ALL_LOWER_CASE</code>
	**/
	 public ULCStringDataType(int maxLength, int mode)
	{
		 super();
	}


	/**
	* Constructs a new string data type.
	*
	* @param errorManager 		 that coordinates client and server side error handling
	**/
	 public ULCStringDataType(com.ulcjava.base.application.datatype.ULCAbstractErrorManager errorManager)
	{
		 super();
	}


	/**
	* Constructs a new string data type with maximum string length as specified.
	*
	* @param errorManager 		 that coordinates client and server side error handling
	* @param maxLength 		 The maximum length in characters for the input
	**/
	 public ULCStringDataType(com.ulcjava.base.application.datatype.ULCAbstractErrorManager errorManager, int maxLength)
	{
		 super();
	}


	/**
	* Constructs a new string data type with maximum string length as specified and
	* <code>mode</code>.
	*
	* @param errorManager 		 that coordinates client and server side error handling
	* @param maxLength 		 the maximum length in characters for the input
	* @param mode 		 can be one of <code>IDENTITY</code>, <code>ALL_UPPER_CASE</code>, <code>ALL_LOWER_CASE</code>
	**/
	 public ULCStringDataType(com.ulcjava.base.application.datatype.ULCAbstractErrorManager errorManager, int maxLength, int mode)
	{
		 super();
	}


	/**
	* Returns the max length property.
	*
	* @return		the maximum length in characters for the input
	**/
	 public int getMaxLength()
	{
		return 0;
	}


	/**
	* Returns the mode property.
	*
	* @return		a value of <code>mode</code>:
<ul>
<li><code>IDENTITY = 0</code>
<li><code>ALL_UPPER_CASE = 1</code>
<li><code>ALL_LOWER_CASE = 2</code>
</ul>
	**/
	 public int getMode()
	{
		return 0;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* Sets the max length property.
<p>
</p>
<b>Note:</b> Setting this value after
	* the widget has been uploaded has no effect.
	*
	* @param maxLength 		 The maximum length in characters for the input
	**/
	 public void setMaxLength(int maxLength)
	{
	}


	/**
	* Sets the mode property.
<p>
</p>
<b>Note:</b> Setting this value after the
	* widget has been uploaded has no effect.
	*
	* @param mode 		 It can be one of:
<ul>
<li><code>IDENTITY = 0</code>
<li><code>ALL_UPPER_CASE = 1</code>
<li><code>ALL_LOWER_CASE = 2</code>
</ul>
	**/
	 public void setMode(int mode)
	{
	}


	/**
	* Returns true if a string whose string length when added to current text length
	* exceeds maximum length should be ignored completely,
i.e. its substring
	* shouldnot be set to fit the maximum length limit.
	*
	* @return		true if a string exceeding max length should be ignored, false otherwise.
	**/
	 public boolean isIgnoreLongStringCompeletely()
	{
		return false;
	}


	/**
	* Determines if a string whose string length when added to current text length
	* exceeds maximum length should be ignored completely,
i.e. its substring
	* shouldnot be set to fit the maximum length limit.
	*
	* @param ignoreLongStringCompeletely 		 true if a string exceeding max length should be ignored, false otherwise.
	**/
	 public void setIgnoreLongStringCompeletely(boolean ignoreLongStringCompeletely)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCStringDataTypeDispatcher extends ULCAbstractDataTypeDispatcher
{


}
}