package com.ulcjava.base.application.dnd;


	/**
	* The <code>TransferHandler</code> is used to configure the behavior of a
	* specific ULC component during Drag & Drop operations. It is
also responsible
	* for handling data import and export. Typically, each ULC component has its
	* owninstance of <code>TransferHandler</code>.
	*
	* @ulc.application		
	**/
 public  abstract class TransferHandler extends java.lang.Object implements java.io.Serializable
{

	/**
	* Represents the none action.
	*
	**/
	 public  final  static int ACTION_NONE = 0;

	/**
	* Represents the copy action.
	*
	**/
	 public  final  static int ACTION_COPY = 0;

	/**
	* Represents the move action.
	*
	**/
	 public  final  static int ACTION_MOVE = 0;

	/**
	* Represents either the copy or the move action.
	*
	**/
	 public  final  static int ACTION_COPY_OR_MOVE = 0;

	/**
	* Represents the link action. The semantic of the link action may both by
	* platform and/or application dependent. Broadly spoken, link
means "do not
	* copy, or move the operand, but create a reference to it". Reference is the
	* ambiguous part of the semantic.
	*
	**/
	 public  final  static int ACTION_LINK = 0;


	/**
	* Returns the Drag & Drop actions supported by the component provided when
	* actingas drag source.
	*
	* @param component 		 the ULCComponent the source actions are requested for
	* @return		the Drag & Drop action supported by the component when acting as drag source
	**/
	 public int getSourceActions(com.ulcjava.base.application.ULCComponent component)
	{
		return 0;
	}


	/**
	* Returns the Drag & Drop actions supported by the component provided when
	* actingas drop target.
	*
	* @param component 		 the ULC component the taret actions are requested for
	* @return		the Drag & Drop action supported by the component when acting as drop target
	**/
	 public int getTargetActions(com.ulcjava.base.application.ULCComponent component)
	{
		return 0;
	}


	/**
	* Called by the Drag & Drop system to import transferable data into the target
	* component. During a single Drag & Drop operation, this
method is called on
	* thedrop target component when the drop occurs.
<p>
</p>
The following data
	* flavors are supported: <table>
<tr>
<td>Data
	* Flavor</td>
<td>Type</td>
<td>Description</td>
</tr>
<tr>
<td>DataFlavor.DRAG_F
	* LAVOR</td>
<td>com.ulcjava.base.application.dnd.IDnDData</td>
<td>contains the
	* data provided by the drag source
	* component</td>
</tr>
<tr>
<td>DataFlavor.DROP_FLAVOR</td>
<td>com.ulcjava.base.
	* application.dnd.IDnDData</td>
<td>contains the data provided by the drop
	* targetcomponent</td>
</tr>
</table>
<p>
</p>
If the drag source is not an ULC
	* application, but an external application such as a text
	* editor,
transferable.getTransferData(DataFlavor.DRAG_FLAVOR) returns an
	* instance of com.ulcjava.base.application.dnd.DnDExternalData that
only
	* contains a textual representation of the data provided by the external drag
	* source.
	*
	* @param targetComponent 		 the Drag & Drop target component
	* @param transferable 		 the transferable data container.
	* @return		true, if the import succeeded, false otherwise
	**/
	 public  abstract boolean importData(com.ulcjava.base.application.ULCComponent targetComponent, com.ulcjava.base.application.dnd.Transferable transferable);

	/**
	* Called by the Drag & Drop system to complete the export of transferable data
	* from the drag source component. During a single Drag &
Drop operation, this
	* method is called on the drag source component when the drop
	* occurs.
<p>
</p>
if the import of the transferable data on the drop target
	* component was successful, the transferable data container contains
	* the
transferable data actually transferred between the drag source and the
	* drop target component. In this case, the following data
flavors are
	* supported:<table>
<tr>
<td>Data
	* Flavor</td>
<td>Type</td>
<td>Description</td></tr>
<tr>
<td>DataFlavor.DRAG_FL
	* AVOR</td>
<td>com.ulcjava.base.application.dnd.IDnDData</td>
<td>contains the
	* data provided by the drag source
	* component</td>
</tr>
<tr>
<td>DataFlavor.DROP_FLAVOR</td>
<td>com.ulcjava.base.
	* application.dnd.IDnDData</td>
<td>contains the data provided by the drop
	* targetcomponent</td>
</tr>
</table>
<p>
</p>
If the import failed, the
	* transferable data object is null, and the drop action provided is
	* TransferHandler.ACTION_NONE.
	*
	* @param sourceComponent 		 the Drag & Drop source component
	* @param transferable 		 the transferable data container
	* @param dropAction 		 the action executed on the transfered data.
	**/
	 public  abstract void exportDone(com.ulcjava.base.application.ULCComponent sourceComponent, com.ulcjava.base.application.dnd.Transferable transferable, int dropAction);

}