package com.ulcjava.base.application.enabler;


	/**
	* The <code>ULCMandatoryAndEnabler</code> component is used to combine multiple
	* enablers using a logical AND.
<p>
</p>
<b>Features</b>
<ul>
<li>Additionally,
	* the <code>ULCMandatoryAndEnabler</code> renders fields that are added as
	* enablers with a special color as
highlight color to indicate that these
	* fieldsare mandatory. As soon as text is entered into the fields, the color is
	* changed
to the normal color. This way the user can easily see what fields
	* still need to be filled in. It is also possible to control
whether a disabled
	* component should display the highlight color by setting the property
	* <code>showHighLightColorWhenDisabled</code>.
</ul>
<b>Examples</b>
<p>
</p>
The
	* following example enables an OK button only when the "email" text field is
	* notempty. While empty, the "email" field automatically
has a special color to
	* indicate that it is mandatory. Note that in this example, we do not really
	* usethe
<code>ULCMandatoryAndEnabler</code> to logically combine multiple
	* enablers but merely use its highlighting functionality.

<pre>
ULCTextField
	* firstNameField = new ULCTextField(10);
ULCTextField lastNameField = new
	* ULCTextField(10);
ULCTextField emailField = new ULCTextField(10);
ULCButton
	* okButton = new ULCButton(&quot;OK&quot;);
ULCMandatoryAndEnabler
	* okButtonEnabler = new
	* ULCMandatoryAndEnabler();
okButtonEnabler.add(emailField); // email field is
	* mandatory
okButton.setEnabler(okButtonEnabler);
</pre>
	*
	* @ulc.application		
	**/
 public class ULCMandatoryAndEnabler extends com.ulcjava.base.application.enabler.ULCAndEnabler implements com.ulcjava.base.shared.IDefaults
{


	/**
	* Constructs a new ULCMandatoryAndEnabler with the style
	* MANDATORY_STYLE_BACKGROUND.
	*
	**/
	 public ULCMandatoryAndEnabler()
	{
		 super();
	}


	/**
	* Gets the highlight color for this widget or null if not specified.
	*
	* @return		the <code>Color</code> that is used within this widget
	**/
	 public com.ulcjava.base.application.util.Color getHighLightColor()
	{
		return null;
	}


	/**
	* Gets the default color for this widget when the widget is in non-mandatory
	* state.
	*
	* @return		the <code>Color</code> that is used within this widget
	**/
	 public com.ulcjava.base.application.util.Color getDefaultColor()
	{
		return null;
	}


	/**
	* Gets the mandatory style type of this widget. The style can be one
	* of:
<ul>
<li><code>MANDATORY_STYLE_BACKGROUND</code>
<li><code>MANDATORY_STYLE_
	* BORDERED</code>
</ul>
	*
	* @return		the <code>int</code> style that is used within this widget
	**/
	 public int getMandatoryStyle()
	{
		return 0;
	}


	/**
	* Returns true if the highlight color is to be set when the mandatory widgets
	* aredisabled.
	*
	* @return		true if the highlight color is to be set when the widget disabled, false otherwise
	**/
	 public boolean getShowHighLightColorWhenDisabled()
	{
		return false;
	}


	/**
	* Sets the highlight color for this widget or null if not specified.
	*
	* @param highLightColor 		 the <code>Color</code> that is used within this widget
	**/
	 public void setHighLightColor(com.ulcjava.base.application.util.Color highLightColor)
	{
	}


	/**
	* <p>Sets the default color for this widget when the widget is in non-mandatory
	* state.
</p>
When appropriate value is set on a mandatory component,
	* ULCMandatoryAndEnabler will replace the highlight color with the
	* default
colorif it is specified, else with the color of the component at the
	* time when highlight color was set on it.
	*
	* @param defaultColor 		 the <code>Color</code> that is used within this widget
	**/
	 public void setDefaultColor(com.ulcjava.base.application.util.Color defaultColor)
	{
	}


	/**
	* Sets the mandatory style type of this widget.
	*
	* @param mandatoryStyle 		 one of the valid style values:
<ul>
<li><code>MANDATORY_STYLE_BACKGROUND</code>
<li><code>MANDATORY_STYLE_BORDERED</code>
</ul>
	**/
	 public void setMandatoryStyle(int mandatoryStyle)
	{
	}


	/**
	* Determines if the highlight color is to be set even if the mandatory widgets
	* are disabled.
	*
	* @param showHighLightColorWhenDisabled 		 true if disabled mandatory widgets should show highlight color, false otherwise.
	**/
	 public void setShowHighLightColorWhenDisabled(boolean showHighLightColorWhenDisabled)
	{
	}

	 protected void uploadStateUI()
	{
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCMandatoryAndEnablerDispatcher extends ULCAndEnablerDispatcher
{


}
}