package com.ulcjava.base.application.event;


	/**
	* Action events are semantic events that indicate a user action (e.g., button
	* pressed) has been triggered on a <code>ULCComponent</code>
(e.g.,
	* <code>ULCButton</code>). The event is passed to every
	* <code>IActionListener</code> object that is registered to receive such
events
	* using the component's <code>addActionListener()</code>
	* method.
<p>
<b>Features</b>
<ul>
<li><code>ULCActionEvent</code> represents
	* anaction event. An instance of this event class provides information about
	* theactionCommand
property that can be set on the components. This property
	* canbe used to either reuse the same action listener for multiple
	* components,
or pass additional information (such as some state of the
	* component) to the listeners.
<li><code>IActionListener</code> defines the
	* interface for action event listeners (a single
	* <code>actionPerformed(ActionEvent)</code>
method).
</ul>
<b>Examples</b>
<p>
Th
	* e following example shows how to install an action listener on a
	* <code>ULCTextField</code> to be notified when the user presses the
Enter key.
	* Note that this event will be delivered synchronously to the installed
	* listener. More specifically, the listener can rely on
the fact that the state
	* of the client has not been changed by user interactions in the meantime (and
	* will not change until all side
effects have been applied to the
	* client).

<pre>
public class SearchAction implements IActionListener {
public
	* void actionPerformed(ActionEvent event) {
// handle action event
	* here
}
}
ULCTextField searchField = new
	* ULCTextField();
searchField.addActionListener(new SearchAction());
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCAbstractButton
	* @see		UlcEvent
	* @see		com.ulcjava.base.application.ULCMenuItem
	* @see		com.ulcjava.base.application.ULCTable
	* @see		com.ulcjava.base.application.table.ULCTableHeader
	* @see		com.ulcjava.base.application.ULCTableTree
	* @see		com.ulcjava.base.application.tabletree.ULCTableTreeHeader
	* @see		com.ulcjava.base.application.ULCTextComponent
	* @see		com.ulcjava.base.application.ULCTree
	**/
 public class ActionEvent extends com.ulcjava.base.application.event.UlcEvent
{

	/**
	* The shift modifier is an indicator that the shift key was pressed during the
	* event.
	*
	**/
	 public  final  static int SHIFT_MASK = 0;

	/**
	* The control modifier is an indicator that the control key was pressed during
	* the event.
	*
	**/
	 public  final  static int CTRL_MASK = 0;

	/**
	* The meta modifier is an indicator that the meta key was pressed during the
	* event.
	*
	**/
	 public  final  static int META_MASK = 0;

	/**
	* The alt modifier is an indicator that the alt key was pressed during the event.
	*
	**/
	 public  final  static int ALT_MASK = 0;

	/**
	* This modifier is an indicator that the mouse <i>Button1</i> was pressed during
	* the event.
	*
	**/
	 public  final  static int BUTTON1_MASK = 0;

	/**
	* This modifier is an indicator that the <i>Alt Graph</i> key was pressed during
	* the event.
	*
	**/
	 public  final  static int ALT_GRAPH_MASK = 0;


	/**
	* Constructs an <code>ActionEvent</code> object.
	*
	* @param source 		 the object from which the event originated
	* @param command 		 a string that may describe a command associated with the event.
	* @see		#getActionCommand
	**/
	 public ActionEvent(java.lang.Object source, java.lang.String command)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Constructs an <code>ActionEvent</code> object.
	*
	* @param source 		 the object from which the event originated
	* @param command 		 a string that may describe a command associated with the event.
	* @param modifiers 		 the modifier keys pressed during this action
	* @see		#getActionCommand
	* @see		#getModifiers
	**/
	 public ActionEvent(java.lang.Object source, java.lang.String command, int modifiers)
	{
		 super((java.lang.Object)null);
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public void dispatch(com.ulcjava.base.application.event.IEventListener actionListener)
	{
	}


	/**
	* Returns a string describing the command associated with this action. This way
	* acomponent can trigger one of few commands, depending
on its state. For
	* example, a button might toggle between "show details" and "hide details". In
	* both events, the source object would
be the same, but different command
	* stringa would allow to perform the right action.
	*
	* @return		the string identifying the command for this event
	**/
	 public java.lang.String getActionCommand()
	{
		return null;
	}


	/**
	* Returns the key modifier that is used to determine the state of the pressed
	* keys during the event. If no modifier key has been
pressed, zero will be
	* returned.
	*
	* @return		the key modifier for this event
	**/
	 public int getModifiers()
	{
		return 0;
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public int getCategory()
	{
		return 0;
	}

	 public java.lang.String toString()
	{
		return null;
	}


}