package com.ulcjava.base.application.event;


	/**
	* Adjustment events are used to notify changes of the scroll bar
	* position.
<p>
</p>
<b>Features</b>
<ul>
<li>The
	* <code>IAdjustmentListener</code> defines the single method
	* <code>adjustmentValueChanged(AdjustmentEvent)</code>.
</ul>
<p>
</p>
<b>Example
	* s</b> This adds an adjustment handler to the horizontal scroll bar of a scroll
	* pane.
<p>
</p>

<pre>
fScrollPane.getHorizontalScrollBar().addAdjustmentListene
	* r(
horizontalAdjustmentHandler);
</pre>

<p>
</p>
The following code shows an
	* IAdjustmentListener which prints out the new position of the horizontal
	* scrollbar.
<p>
</p>

<pre>
IAdjustmentListener horizontalAdjustmentHandler =
	* new IAdjustmentListener() {
public void
	* adjustmentValueChanged(AdjustmentEventevent) {
double pos =
	* fScrollPane.getHorizontalScrollBar().getPosition();
System.out.println(&quot;ho
	* rizontal scroll bar position changed to: &quot;
+ pos);
}
};
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCScrollBar
	* @see		com.ulcjava.base.application.ULCScrollPane
	**/
 public class AdjustmentEvent extends com.ulcjava.base.application.event.UlcEvent
{


	/**
	* Constructs an <code>AdjustmentEvent</code> object.
	*
	* @param source 		 the object from which the event originated
	**/
	 public AdjustmentEvent(java.lang.Object source)
	{
		 super((java.lang.Object)null);
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public void dispatch(com.ulcjava.base.application.event.IEventListener listener)
	{
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public int getCategory()
	{
		return 0;
	}


}