package com.ulcjava.base.application.event;


	/**
	* Column model event is used to notify listeners that a column model has changed
	* i.e. a column was added, removed, or moved.
<p>
<b>Features</b>
<ul>
<li>The
	* <code>ColumnModelEvent</code> provides information about the changes to the
	* source column model. The following types of
changes can be
	* distinguished:
<ul><li>Column has been added.
<li>Column has been
	* removed.
<li>Column has been moved.
</ul>
<li>The
	* <code>IColumnModelListener</code> defines the following methods for the above
	* events:
<ul>
<li><code>columnAdded(ColumnModelEvent event)</code> method that
	* is called when a column is added.
<li><code>columnRemoved(ColumnModelEvent
	* event)</code> method that is called when a column is
	* removed.
<li><code>columnMoved(ColumnModelEvent event)</code> method that is
	* called when a column is moved.
</ul>
<li>Note that the
	* <code>AbstractColumnModel</code> class provides convenience methods to create
	* and fire column model events to all
registered
	* listeners.
</ul>
<b>Examples</b>
<p>
The following example shows how to
	* install an column model listener on a <code>ULCTableColumnModel</code> to be
	* notified when a column
is added, removed, or moved or the user explicitly
	* moves a column.

<pre>
DefaultTableModel model = new DefaultTableModel(new
	* Object[][] { {"00", "01", "02"},
{"10", "11", "12"}}, new String[] {"C1",
	* "C2", "C3"});
ULCTable table = new
	* ULCTable();
table.setModel(model);
ULCTableColumnModel columnModel =
	* table.getColumnModel();
columnModel.addColumnModelListener(new
	* IColumnModelListener() {
public void columnAdded(ColumnModelEvent event)
	* {
System.out.println("Column Added: " + event.getToIndex());
}

public void
	* columnMoved(ColumnModelEvent event) {
System.out.println("Column Moved: " +
	* event.getFromIndex() + " " + event.getToIndex());
}

public void
	* columnRemoved(ColumnModelEvent event) {
System.out.println("Column Removed: "
	* + event.getFromIndex());
}
});
</pre>

<p>
Adding, removing, or moving a
	* column as follows will notify the listener:

<pre>
ULCTableColumn column =
	* newULCTableColumn(0);
columnModel.addColumn(column);
columnModel.removeColumn(c
	* olumn);
columnModel.moveColumn(0, 1);
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.AbstractColumnModel
	* @see		com.ulcjava.base.application.event.IColumnModelListener
	**/
 public class ColumnModelEvent extends java.util.EventObject
{


	/**
	* Create a ColumnModelEvent.
	*
	* @param source 		 the ColumnModel that originated the event (typically <code>this</code>)
	* @param fromIndex 		 position from which the column was moved or removed
	* @param toIndex 		 position to which column was added or moved
	**/
	 public ColumnModelEvent(java.lang.Object source, int fromIndex, int toIndex)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Gets the index from where a column was removed or moved.
	*
	* @return		from index
	**/
	 public int getFromIndex()
	{
		return 0;
	}


	/**
	* Gets the index to which a column was added or moved.
	*
	* @return		to index
	**/
	 public int getToIndex()
	{
		return 0;
	}


}