package com.ulcjava.base.application.event;


	/**
	* Defines an object which listens for popup menu events. It should be used in
	* order to listen to popup menu events.
	*
	* @see		com.ulcjava.base.application.event.PopupMenuEvent
	**/
 public interface IPopupMenuListener extends java.io.Serializable, com.ulcjava.base.application.event.IEventListener
{


	/**
	* Invoked after the popup menu becomes visible
	*
	* @param event 		 the popup menu event
	**/
	void popupMenuHasBecomeVisible(com.ulcjava.base.application.event.PopupMenuEvent event);

	/**
	* Invoked after the popup menu becomes invisible
	*
	* @param event 		 the popup menu event
	**/
	void popupMenuHasBecomeInvisible(com.ulcjava.base.application.event.PopupMenuEvent event);

	/**
	* Invoked when the popup menu is canceled
	*
	* @param event 		 popup menu event
	**/
	void popupMenuCanceled(com.ulcjava.base.application.event.PopupMenuEvent event);

}