package com.ulcjava.base.application.event;


	/**
	* Defines an object which listens for table tree model events.
	*
	* @ulc.application		
	**/
 public interface ITableTreeModelListener extends java.io.Serializable, com.ulcjava.base.application.event.IEventListener
{


	/**
	* Invoked after the table tree structure has changed.
	*
	* @param event 		 the table tree model event
	**/
	 public void tableTreeStructureChanged(com.ulcjava.base.application.event.TableTreeModelEvent event);

	/**
	* Invoked after fundamental changes in the tree.
	*
	* @param event 		 the table tree model event
	**/
	 public void tableTreeNodeStructureChanged(com.ulcjava.base.application.event.TableTreeModelEvent event);

	/**
	* Invoked if nodes have been inserted into the tree.
	*
	* @param event 		 the table tree model event
	**/
	 public void tableTreeNodesInserted(com.ulcjava.base.application.event.TableTreeModelEvent event);

	/**
	* Invoked if nodes have been removed from the tree.
	*
	* @param event 		 the table tree model event
	**/
	 public void tableTreeNodesRemoved(com.ulcjava.base.application.event.TableTreeModelEvent event);

	/**
	* Invoked if some nodes have been changed.
	*
	* @param event 		 the table tree model event
	**/
	 public void tableTreeNodesChanged(com.ulcjava.base.application.event.TableTreeModelEvent event);

}