package com.ulcjava.base.application.event;


	/**
	* Defines an object which listens for tree model events.
	*
	* @ulc.application		
	**/
 public interface ITreeModelListener extends java.io.Serializable, com.ulcjava.base.application.event.IEventListener
{


	/**
	* <p>
Invoked after a node (or a set of siblings) has changed in some way. The
	* node(s) have not changed locations in the tree or altered
their children
	* arrays, but other attributes have changed and may affect presentation.
	* Example: the name of a file has changed, but it
is in the same location in
	* thefile system.
</p>
<p>
To indicate the root has changed, childIndices and
	* children will be null.
</p>
<p>
</p>
<p>
Use <code>e.getPath()</code> to get
	* the parent of the changed node(s). <code>e.getChildIndices()</code> returns
	* the index(es) of
the changed node(s).
</p>
	*
	* @param event 		 the tree model event
	**/
	void treeNodesChanged(com.ulcjava.base.application.event.TreeModelEvent event);

	/**
	* <p>
Invoked after nodes have been inserted into the
	* tree.
</p>
<p>
</p>
<p>
Use<code>e.getPath()</code> to get the parent of the
	* new node(s). <code>e.getChildIndices()</code> returns the index(es) of
	* the
newnode(s) in ascending order.
</p>
	*
	* @param event 		 the tree model event
	**/
	void treeNodesInserted(com.ulcjava.base.application.event.TreeModelEvent event);

	/**
	* <p>
Invoked after nodes have been removed from the tree. Note that if a
	* subtreeis removed from the tree, this method may only be invoked
once for the
	* root of the removed subtree, not once for each individual set of siblings
	* removed.
</p>
<p>
</p>
<p>
Use <code>e.getPath()</code> to get the former
	* parent of the deleted node(s). <code>e.getChildIndices()</code> returns,
	* in
ascending order, the index(es) the node(s) had before being deleted.
</p>
	*
	* @param event 		 the tree model event
	**/
	void treeNodesRemoved(com.ulcjava.base.application.event.TreeModelEvent event);

	/**
	* <p>
Invoked after the tree has drastically changed structure from a given node
	* down. If the path returned by e.getPath() is of length one
and the first
	* element does not identify the current root node the first element should
	* become the new root of the tree.
<p>
<p>
</p>
<p>
Use
	* <code>e.getPath()</code>to get the path to the node.
	* <code>e.getChildIndices()</code> returns null.
</p>
	*
	* @param event 		 the tree model event
	**/
	void treeStructureChanged(com.ulcjava.base.application.event.TreeModelEvent event);

}