package com.ulcjava.base.application.event;


	/**
	* The listener interface for receiving window events. The class that is
	* interested in processing a window event implements this interface.
The
	* listener object created from that class is then registered with a Window
	* usingthe window's <code>addWindowListener()</code>
method. When the window's
	* status changes the relevant method in the listener object is invoked, and the
	* <code>WindowEvent</code> is
passed to it.
	*
	* @ulc.application		
	* @see		WindowEvent
	**/
 public interface IWindowListener extends java.io.Serializable, com.ulcjava.base.application.event.IEventListener
{


	/**
	* Invoked when the user attempts to close the window using the default platform
	* specific action. (Given a listener is registered, this
listener method will
	* <emph>always</emph> be invoked, regardless of setting a hide or close
	* strategyusing
{@link
	* com.ulcjava.base.application.ULCFrame#setDefaultCloseOperation(int)} or alike
	* methods.)
	*
	* @param event 		 the window event
	**/
	 public void windowClosing(com.ulcjava.base.application.event.WindowEvent event);

}