package com.ulcjava.base.application.event;


	/**
	* Key events are low-level events that indicate a keystroke occurred in a
	* component (e.g., <code>ULCTextField</code>). The event is passed
to every
	* <code>IKeyListener</code> object which registered to receive such events
	* usingthe component's <code>addKeyListener()</code>
method.
<p>
</p>
As key
	* events are typically triggered very frequently, usage of these events (and
	* their respective listeners) can have a negative impact
on the performance of
	* aULC application. Key events should therefore be used with caution. As a
	* rule,these events should be delivered
asynchronously whenever
	* possible.
<p>
<b>Features</b>
<ul>
<li>A <code>KeyEvent</code> instance
	* provides information on what character has been
	* typed.
<li><code>IKeyListener</code> defines the corresponding interface
	* consisting of the single method
	* <code>keyTyped(KeyEvent)</code>.
</ul>
<b>Examples</b>
<p>
The following code
	* shows how to use an <code>IKeyListener</code> on a <code>ULCTextField</code>
	* to implement a type look-ahead mechanism:
as the user types the first few
	* letters of a name, the ULC application checks if there is a corresponding
	* entry in a table and selects
it. In order to maintain good user interface
	* responsiveness, it is important to configure the text field to deliver the
	* keyevents to the
server asynchronously. The following code shows how to
	* install an <code>IKeyListener</code> and configure the events to be
	* delivered
asynchronously.

<pre>
searchField.addKeyListener(new
	* TypeLookAheadAction());
ClientContext.setEventDeliveryMode(searchField,
UlcEven
	* tCategories.KEY_EVENT_CATEGORY,
UlcEventConstants.ASYNCHRONOUS_MODE);
</pre>
The
	* implementation of the key listener performs the lookup and selects the
	* corresponding entry if available.

<pre>
public class TypeLookAheadAction
	* implements IKeyListener {
public void keyTyped(KeyEvent event) {
ULCTextField
	* textField = (ULCTextField)event.getSource();
int row =
	* fPersonTableModel.findEntry(textField.getText());
if (row != -1)
	* {
fTable.setRowSelectionInterval(row, row);
} else
	* {
fTable.clearSelection();
}
}
}
</pre>
	*
	* @ulc.application		
	* @see		UlcEvent
	* @see		com.ulcjava.base.application.ULCTextComponent
	* @see		com.ulcjava.base.application.ULCTextField
	* @see		com.ulcjava.base.application.ULCTextArea
	* @see		com.ulcjava.base.application.ULCPasswordField
	**/
 public class KeyEvent extends com.ulcjava.base.application.event.UlcEvent
{

	/**
	* This flag indicates that the Shift key was down when the event occurred. It is
	* recommended that SHIFT_DOWN_MASK be used instead.
	*
	**/
	 public  final  static int SHIFT_MASK = 0;

	/**
	* This flag indicates that the Control key was down when the event occurred. It
	* is recommended that CTRL_DOWN_MASK be used instead.
	*
	**/
	 public  final  static int CTRL_MASK = 0;

	/**
	* This flag indicates that the Meta key was down when the event occurred. For
	* mouse events, this flag indicates that the right button
was pressed or
	* released. It is recommended that META_DOWN_MASK be used instead.
	*
	**/
	 public  final  static int META_MASK = 0;

	/**
	* This flag indicates that the Alt key was down when the event occurred. For
	* mouse events, this flag indicates that the middle mouse
button was pressed or
	* released. It is recommended that ALT_DOWN_MASK be used instead.
	*
	**/
	 public  final  static int ALT_MASK = 0;

	/**
	* This flag indicates that the Mouse <i>Button1</i> was down when the event
	* occurred. It is recommended that {@link #BUTTON1_DOWN_MASK}
be used instead.
	*
	**/
	 public  final  static int BUTTON1_MASK = 0;

	/**
	* The AltGraph key modifier constant.
	*
	**/
	 public  final  static int ALT_GRAPH_MASK = 0;

	/**
	* The Shift key extended modifier constant.
	*
	**/
	 public  final  static int SHIFT_DOWN_MASK = 0;

	/**
	* The Control key extended modifier constant.
	*
	**/
	 public  final  static int CTRL_DOWN_MASK = 0;

	/**
	* The Meta key extended modifier constant.
	*
	**/
	 public  final  static int META_DOWN_MASK = 0;

	/**
	* The Alt key extended modifier constant.
	*
	**/
	 public  final  static int ALT_DOWN_MASK = 0;

	/**
	* This extended modifier flag indicates that the Mouse <i>Button1</i> was down
	* when the event occurred.
	*
	**/
	 public  final  static int BUTTON1_DOWN_MASK = 0;

	/**
	* This extended modifier flag indicates that the Mouse <i>Button2</i> was down
	* when the event occurred.
	*
	**/
	 public  final  static int BUTTON2_DOWN_MASK = 0;

	/**
	* This extended modifier flag indicates that the Mouse <i>Button3</i> was down
	* when the event occurred.
	*
	**/
	 public  final  static int BUTTON3_DOWN_MASK = 0;

	/**
	* The AltGraph key extended modifier constant.
	*
	**/
	 public  final  static int ALT_GRAPH_DOWN_MASK = 0;

	/**
	* Constant for the ENTER key.
	*
	**/
	 public  final  static int VK_ENTER = 0;

	/**
	* Constant for the BACK_SPACE key.
	*
	**/
	 public  final  static int VK_BACK_SPACE = 0;

	/**
	* Constant for the TAB key.
	*
	**/
	 public  final  static int VK_TAB = 0;

	/**
	* Constant for the CANCEL key.
	*
	**/
	 public  final  static int VK_CANCEL = 0;

	/**
	* Constant for the CLEAR key.
	*
	**/
	 public  final  static int VK_CLEAR = 0;

	/**
	* Constant for the SHIFT key.
	*
	**/
	 public  final  static int VK_SHIFT = 0;

	/**
	* Constant for the CONTROL key.
	*
	**/
	 public  final  static int VK_CONTROL = 0;

	/**
	* Constant for the ALT key.
	*
	**/
	 public  final  static int VK_ALT = 0;

	/**
	* Constant for the PAUSE key.
	*
	**/
	 public  final  static int VK_PAUSE = 0;

	/**
	* Constant for the CAPS_LOCK key.
	*
	**/
	 public  final  static int VK_CAPS_LOCK = 0;

	/**
	* Constant for the ESCAPE key.
	*
	**/
	 public  final  static int VK_ESCAPE = 0;

	/**
	* Constant for the SPACE key.
	*
	**/
	 public  final  static int VK_SPACE = 0;

	/**
	* Constant for the PAGE_UP key.
	*
	**/
	 public  final  static int VK_PAGE_UP = 0;

	/**
	* Constant for the PAGE_DOWN key.
	*
	**/
	 public  final  static int VK_PAGE_DOWN = 0;

	/**
	* Constant for the END key.
	*
	**/
	 public  final  static int VK_END = 0;

	/**
	* Constant for the HOME key.
	*
	**/
	 public  final  static int VK_HOME = 0;

	/**
	* Constant for the LEFT key.
	*
	**/
	 public  final  static int VK_LEFT = 0;

	/**
	* Constant for the UP key.
	*
	**/
	 public  final  static int VK_UP = 0;

	/**
	* Constant for the RIGHT key.
	*
	**/
	 public  final  static int VK_RIGHT = 0;

	/**
	* Constant for the DOWN key.
	*
	**/
	 public  final  static int VK_DOWN = 0;

	/**
	* Constant for the COMMA key.
	*
	**/
	 public  final  static int VK_COMMA = 0;

	/**
	* Constant for the "-" key.
	*
	**/
	 public  final  static int VK_MINUS = 0;

	/**
	* VK_PERIOD is the same as ASCII '.' (0x2E).
	*
	**/
	 public  final  static int VK_PERIOD = 0;

	/**
	* VK_SLASH is the same as ASCII '/' (0x2F).
	*
	**/
	 public  final  static int VK_SLASH = 0;

	/**
	* VK_0 is the same as ASCII '0' (0x30).
	*
	**/
	 public  final  static int VK_0 = 0;

	/**
	* VK_1 is the same as ASCII '1' (0x31).
	*
	**/
	 public  final  static int VK_1 = 0;

	/**
	* VK_2 is the same as ASCII '2' (0x32).
	*
	**/
	 public  final  static int VK_2 = 0;

	/**
	* VK_3 is the same as ASCII '3' (0x33).
	*
	**/
	 public  final  static int VK_3 = 0;

	/**
	* VK_4 is the same as ASCII '4' (0x34).
	*
	**/
	 public  final  static int VK_4 = 0;

	/**
	* VK_5 is the same as ASCII '5' (0x35).
	*
	**/
	 public  final  static int VK_5 = 0;

	/**
	* VK_6 is the same as ASCII '6' (0x36).
	*
	**/
	 public  final  static int VK_6 = 0;

	/**
	* VK_7 is the same as ASCII '7' (0x37).
	*
	**/
	 public  final  static int VK_7 = 0;

	/**
	* VK_8 is the same as ASCII '8' (0x38).
	*
	**/
	 public  final  static int VK_8 = 0;

	/**
	* VK_9 is the same as ASCII '9' (0x39).
	*
	**/
	 public  final  static int VK_9 = 0;

	/**
	* VK_SEMICOLON is the same as ASCII ';' (0x3B).
	*
	**/
	 public  final  static int VK_SEMICOLON = 0;

	/**
	* VK_EQUALS is the same as ASCII '=' (0x3D).
	*
	**/
	 public  final  static int VK_EQUALS = 0;

	/**
	* VK_A is the same as ASCII 'A' (0x41).
	*
	**/
	 public  final  static int VK_A = 0;

	/**
	* VK_B is the same as ASCII 'B' (0x42).
	*
	**/
	 public  final  static int VK_B = 0;

	/**
	* VK_C is the same as ASCII 'C' (0x43).
	*
	**/
	 public  final  static int VK_C = 0;

	/**
	* VK_D is the same as ASCII 'D' (0x44).
	*
	**/
	 public  final  static int VK_D = 0;

	/**
	* VK_E is the same as ASCII 'E' (0x45).
	*
	**/
	 public  final  static int VK_E = 0;

	/**
	* VK_F is the same as ASCII 'F' (0x46).
	*
	**/
	 public  final  static int VK_F = 0;

	/**
	* VK_G is the same as ASCII 'G' (0x47).
	*
	**/
	 public  final  static int VK_G = 0;

	/**
	* VK_H is the same as ASCII 'H' (0x48).
	*
	**/
	 public  final  static int VK_H = 0;

	/**
	* VK_I is the same as ASCII 'I' (0x49).
	*
	**/
	 public  final  static int VK_I = 0;

	/**
	* VK_J is the same as ASCII 'J' (0x4A).
	*
	**/
	 public  final  static int VK_J = 0;

	/**
	* VK_K is the same as ASCII 'K' (0x4B).
	*
	**/
	 public  final  static int VK_K = 0;

	/**
	* VK_L is the same as ASCII 'L' (0x4C).
	*
	**/
	 public  final  static int VK_L = 0;

	/**
	* VK_M is the same as ASCII 'M' (0x4D).
	*
	**/
	 public  final  static int VK_M = 0;

	/**
	* VK_N is the same as ASCII 'N' (0x4E).
	*
	**/
	 public  final  static int VK_N = 0;

	/**
	* VK_O is the same as ASCII 'O' (0x4F).
	*
	**/
	 public  final  static int VK_O = 0;

	/**
	* VK_P is the same as ASCII 'P' (0x50).
	*
	**/
	 public  final  static int VK_P = 0;

	/**
	* VK_Q is the same as ASCII 'Q' (0x51).
	*
	**/
	 public  final  static int VK_Q = 0;

	/**
	* VK_R is the same as ASCII 'R' (0x52).
	*
	**/
	 public  final  static int VK_R = 0;

	/**
	* VK_S is the same as ASCII 'S' (0x53).
	*
	**/
	 public  final  static int VK_S = 0;

	/**
	* VK_T is the same as ASCII 'T' (0x54).
	*
	**/
	 public  final  static int VK_T = 0;

	/**
	* VK_U is the same as ASCII 'U' (0x55).
	*
	**/
	 public  final  static int VK_U = 0;

	/**
	* VK_V is the same as ASCII 'V' (0x56).
	*
	**/
	 public  final  static int VK_V = 0;

	/**
	* VK_W is the same as ASCII 'W' (0x57).
	*
	**/
	 public  final  static int VK_W = 0;

	/**
	* VK_X is the same as ASCII 'X' (0x58).
	*
	**/
	 public  final  static int VK_X = 0;

	/**
	* VK_Y is the same as ASCII 'Y' (0x59).
	*
	**/
	 public  final  static int VK_Y = 0;

	/**
	* VK_Z is the same as ASCII 'Z' (0x5A).
	*
	**/
	 public  final  static int VK_Z = 0;

	/**
	* VK_OPEN_BRACKET is the same as ASCII '(' (0x5B).
	*
	**/
	 public  final  static int VK_OPEN_BRACKET = 0;

	/**
	* VK_BACK_SLASH is the same as ASCII '\' (0x5C).
	*
	**/
	 public  final  static int VK_BACK_SLASH = 0;

	/**
	* VK_CLOSE_BRACKET is the same as ASCII ')' (0x5D).
	*
	**/
	 public  final  static int VK_CLOSE_BRACKET = 0;

	/**
	* Constant for the '0' key on the numpad.
	*
	**/
	 public  final  static int VK_NUMPAD0 = 0;

	/**
	* Constant for the '1' key on the numpad.
	*
	**/
	 public  final  static int VK_NUMPAD1 = 0;

	/**
	* Constant for the '2' key on the numpad.
	*
	**/
	 public  final  static int VK_NUMPAD2 = 0;

	/**
	* Constant for the '3' key on the numpad.
	*
	**/
	 public  final  static int VK_NUMPAD3 = 0;

	/**
	* Constant for the '4' key on the numpad.
	*
	**/
	 public  final  static int VK_NUMPAD4 = 0;

	/**
	* Constant for the '5' key on the numpad.
	*
	**/
	 public  final  static int VK_NUMPAD5 = 0;

	/**
	* Constant for the '6' key on the numpad.
	*
	**/
	 public  final  static int VK_NUMPAD6 = 0;

	/**
	* Constant for the '7 key on the numpad.
	*
	**/
	 public  final  static int VK_NUMPAD7 = 0;

	/**
	* Constant for the '8' key on the numpad.
	*
	**/
	 public  final  static int VK_NUMPAD8 = 0;

	/**
	* Constant for the '9' key on the numpad.
	*
	**/
	 public  final  static int VK_NUMPAD9 = 0;

	/**
	* Constant for the MULTIPLY / * key.
	*
	**/
	 public  final  static int VK_MULTIPLY = 0;

	/**
	* Constant for the ADD / + key.
	*
	**/
	 public  final  static int VK_ADD = 0;

	/**
	* Constant for the SEPARATER key.
	*
	**/
	 public  final  static int VK_SEPARATER = 0;

	/**
	* Constant for the SUBSTRACT / - key.
	*
	**/
	 public  final  static int VK_SUBTRACT = 0;

	/**
	* Constant for the DECIMAL / . key.
	*
	**/
	 public  final  static int VK_DECIMAL = 0;

	/**
	* Constant for the DIVIDE / / key.
	*
	**/
	 public  final  static int VK_DIVIDE = 0;

	/**
	* Constant for the DELETE key.
	*
	**/
	 public  final  static int VK_DELETE = 0;

	/**
	* Constant for the NUM_LOCK key.
	*
	**/
	 public  final  static int VK_NUM_LOCK = 0;

	/**
	* Constant for the SCROLL_LOCK key.
	*
	**/
	 public  final  static int VK_SCROLL_LOCK = 0;

	/**
	* Constant for the F1 function key.
	*
	**/
	 public  final  static int VK_F1 = 0;

	/**
	* Constant for the F2 function key.
	*
	**/
	 public  final  static int VK_F2 = 0;

	/**
	* Constant for the F3 function key.
	*
	**/
	 public  final  static int VK_F3 = 0;

	/**
	* Constant for the F4 function key.
	*
	**/
	 public  final  static int VK_F4 = 0;

	/**
	* Constant for the F5 function key.
	*
	**/
	 public  final  static int VK_F5 = 0;

	/**
	* Constant for the F6 function key.
	*
	**/
	 public  final  static int VK_F6 = 0;

	/**
	* Constant for the F7 function key.
	*
	**/
	 public  final  static int VK_F7 = 0;

	/**
	* Constant for the F8 function key.
	*
	**/
	 public  final  static int VK_F8 = 0;

	/**
	* Constant for the F9 function key.
	*
	**/
	 public  final  static int VK_F9 = 0;

	/**
	* Constant for the F10 function key.
	*
	**/
	 public  final  static int VK_F10 = 0;

	/**
	* Constant for the F11 function key.
	*
	**/
	 public  final  static int VK_F11 = 0;

	/**
	* Constant for the F12 function key.
	*
	**/
	 public  final  static int VK_F12 = 0;

	/**
	* Constant for the F13 function key.
	*
	**/
	 public  final  static int VK_F13 = 0;

	/**
	* Constant for the F14 function key.
	*
	**/
	 public  final  static int VK_F14 = 0;

	/**
	* Constant for the F15 function key.
	*
	**/
	 public  final  static int VK_F15 = 0;

	/**
	* Constant for the F16 function key.
	*
	**/
	 public  final  static int VK_F16 = 0;

	/**
	* Constant for the F17 function key.
	*
	**/
	 public  final  static int VK_F17 = 0;

	/**
	* Constant for the F18 function key.
	*
	**/
	 public  final  static int VK_F18 = 0;

	/**
	* Constant for the F19 function key.
	*
	**/
	 public  final  static int VK_F19 = 0;

	/**
	* Constant for the F20 function key.
	*
	**/
	 public  final  static int VK_F20 = 0;

	/**
	* Constant for the F21 function key.
	*
	**/
	 public  final  static int VK_F21 = 0;

	/**
	* Constant for the F22 function key.
	*
	**/
	 public  final  static int VK_F22 = 0;

	/**
	* Constant for the F23 function key.
	*
	**/
	 public  final  static int VK_F23 = 0;

	/**
	* Constant for the F24 function key.
	*
	**/
	 public  final  static int VK_F24 = 0;

	/**
	* Constant for the PRINTSCREEN function key.
	*
	**/
	 public  final  static int VK_PRINTSCREEN = 0;

	/**
	* Constant for the INSERT function key.
	*
	**/
	 public  final  static int VK_INSERT = 0;

	/**
	* Constant for the HELP function key.
	*
	**/
	 public  final  static int VK_HELP = 0;

	/**
	* Constant for the META function key.
	*
	**/
	 public  final  static int VK_META = 0;

	/**
	* VK_BACK_QUOTE is the same as ASCII '`' (left quote) (0xC0).
	*
	**/
	 public  final  static int VK_BACK_QUOTE = 0;

	/**
	* VK_QUOTE is the same as ASCII ''' (0xDE).
	*
	**/
	 public  final  static int VK_QUOTE = 0;

	/**
	* Constant for the key pad arrow up function key.
	*
	**/
	 public  final  static int VK_KP_UP = 0;

	/**
	* Constant for the key pad arrow down function key.
	*
	**/
	 public  final  static int VK_KP_DOWN = 0;

	/**
	* Constant for the key pad arrow left function key.
	*
	**/
	 public  final  static int VK_KP_LEFT = 0;

	/**
	* Constant for the key pad arrow right function key.
	*
	**/
	 public  final  static int VK_KP_RIGHT = 0;

	/**
	* For european keyboards: grave.
	*
	**/
	 public  final  static int VK_DEAD_GRAVE = 0;

	/**
	* For european keyboards: acute.
	*
	**/
	 public  final  static int VK_DEAD_ACUTE = 0;

	/**
	* For european keyboards: circumflex.
	*
	**/
	 public  final  static int VK_DEAD_CIRCUMFLEX = 0;

	/**
	* For european keyboards: tilde.
	*
	**/
	 public  final  static int VK_DEAD_TILDE = 0;

	/**
	* For european keyboards: macron.
	*
	**/
	 public  final  static int VK_DEAD_MACRON = 0;

	/**
	* For european keyboards: breve.
	*
	**/
	 public  final  static int VK_DEAD_BREVE = 0;

	/**
	* For european keyboards: abovedot.
	*
	**/
	 public  final  static int VK_DEAD_ABOVEDOT = 0;

	/**
	* For european keyboards: diaeresis.
	*
	**/
	 public  final  static int VK_DEAD_DIAERESIS = 0;

	/**
	* For european keyboards: abovering.
	*
	**/
	 public  final  static int VK_DEAD_ABOVERING = 0;

	/**
	* For european keyboards: doubleacute.
	*
	**/
	 public  final  static int VK_DEAD_DOUBLEACUTE = 0;

	/**
	* For european keyboards: caron.
	*
	**/
	 public  final  static int VK_DEAD_CARON = 0;

	/**
	* For european keyboards: cedilla.
	*
	**/
	 public  final  static int VK_DEAD_CEDILLA = 0;

	/**
	* For european keyboards: ogonek.
	*
	**/
	 public  final  static int VK_DEAD_OGONEK = 0;

	/**
	* For european keyboards: iota.
	*
	**/
	 public  final  static int VK_DEAD_IOTA = 0;

	/**
	* For european keyboards: voiced sound.
	*
	**/
	 public  final  static int VK_DEAD_VOICED_SOUND = 0;

	/**
	* For european keyboards: semivoiced sound.
	*
	**/
	 public  final  static int VK_DEAD_SEMIVOICED_SOUND = 0;

	/**
	* VK_AMPERSAND is the same as ASCII '&' (0x96).
	*
	**/
	 public  final  static int VK_AMPERSAND = 0;

	/**
	* VK_ASTERISK is the same as ASCII '*' (0x97).
	*
	**/
	 public  final  static int VK_ASTERISK = 0;

	/**
	* VK_QUOTEDBL is the same as ASCII '"' (0x98).
	*
	**/
	 public  final  static int VK_QUOTEDBL = 0;

	/**
	* VK_LESS is the same as ASCII '<' (0x99).
	*
	**/
	 public  final  static int VK_LESS = 0;

	/**
	* VK_GREATER is the same as ASCII '>' (0xa0).
	*
	**/
	 public  final  static int VK_GREATER = 0;

	/**
	* VK_BRACELEFT is the same as ASCII '{' (0xa1).
	*
	**/
	 public  final  static int VK_BRACELEFT = 0;

	/**
	* VK_BRACERIGHT is the same as ASCII '}' (0xa2).
	*
	**/
	 public  final  static int VK_BRACERIGHT = 0;

	/**
	* Constant for the "@" key.
	*
	**/
	 public  final  static int VK_AT = 0;

	/**
	* Constant for the ":" key.
	*
	**/
	 public  final  static int VK_COLON = 0;

	/**
	* Constant for the "^" key.
	*
	**/
	 public  final  static int VK_CIRCUMFLEX = 0;

	/**
	* Constant for the "$" key.
	*
	**/
	 public  final  static int VK_DOLLAR = 0;

	/**
	* Constant for the Euro currency sign key.
	*
	**/
	 public  final  static int VK_EURO_SIGN = 0;

	/**
	* Constant for the "&#33" key.
	*
	**/
	 public  final  static int VK_EXCLAMATION_MARK = 0;

	/**
	* Constant for the inverted exclamation mark key.
	*
	**/
	 public  final  static int VK_INVERTED_EXCLAMATION_MARK = 0;

	/**
	* Constant for the "(" key.
	*
	**/
	 public  final  static int VK_LEFT_PARENTHESIS = 0;

	/**
	* Constant for the "#" key.
	*
	**/
	 public  final  static int VK_NUMBER_SIGN = 0;

	/**
	* Constant for the "+" key.
	*
	**/
	 public  final  static int VK_PLUS = 0;

	/**
	* Constant for the ")" key.
	*
	**/
	 public  final  static int VK_RIGHT_PARENTHESIS = 0;

	/**
	* Constant for the "_" key.
	*
	**/
	 public  final  static int VK_UNDERSCORE = 0;

	/**
	* Undefined but present for compatability.
	*
	**/
	 public  final  static int VK_FINAL = 0;

	/**
	* Constant for the Convert function key.
	*
	**/
	 public  final  static int VK_CONVERT = 0;

	/**
	* Constant for the Don't Convert function key.
	*
	**/
	 public  final  static int VK_NONCONVERT = 0;

	/**
	* Constant for the Accept or Commit function key.
	*
	**/
	 public  final  static int VK_ACCEPT = 0;

	/**
	* Undefined but present for compatability.
	*
	**/
	 public  final  static int VK_MODECHANGE = 0;

	/**
	* Replaced by VK_KANA_LOCK but present for compatability with other platforms.
	*
	**/
	 public  final  static int VK_KANA = 0;

	/**
	* Replaced by VK_INPUT_METHOD but present for compatability with other platforms.
	*
	**/
	 public  final  static int VK_KANJI = 0;

	/**
	* Constant for the Alphanumeric function key.
	*
	**/
	 public  final  static int VK_ALPHANUMERIC = 0;

	/**
	* Constant for the Katakana function key.
	*
	**/
	 public  final  static int VK_KATAKANA = 0;

	/**
	* Constant for the Hiragana function key.
	*
	**/
	 public  final  static int VK_HIRAGANA = 0;

	/**
	* Constant for the Full-Width Characters function key.
	*
	**/
	 public  final  static int VK_FULL_WIDTH = 0;

	/**
	* Constant for the Half-Width Characters function key.
	*
	**/
	 public  final  static int VK_HALF_WIDTH = 0;

	/**
	* Constant for the Roman Characters function key.
	*
	**/
	 public  final  static int VK_ROMAN_CHARACTERS = 0;

	/**
	* Constant for the All Candidates function key.
	*
	**/
	 public  final  static int VK_ALL_CANDIDATES = 0;

	/**
	* Constant for the Previous Candidate function key.
	*
	**/
	 public  final  static int VK_PREVIOUS_CANDIDATE = 0;

	/**
	* Constant for the Code Input function key.
	*
	**/
	 public  final  static int VK_CODE_INPUT = 0;

	/**
	* Constant for the Japanese-Katakana function key. This key switches to a
	* Japanese input method and selects its Katakana input mode.
	*
	**/
	 public  final  static int VK_JAPANESE_KATAKANA = 0;

	/**
	* Constant for the Japanese-Hiragana function key. This key switches to a
	* Japanese input method and selects its Hiragana input mode.
	*
	**/
	 public  final  static int VK_JAPANESE_HIRAGANA = 0;

	/**
	* Constant for the Japanese-Roman function key. This key switches to a Japanese
	* input method and selects its Roman-Direct input mode.
	*
	**/
	 public  final  static int VK_JAPANESE_ROMAN = 0;

	/**
	* Constant for the locking Kana function key. This key locks the keyboard into a
	* Kana layout.
	*
	**/
	 public  final  static int VK_KANA_LOCK = 0;

	/**
	* Constant for the input method on/off key.
	*
	**/
	 public  final  static int VK_INPUT_METHOD_ON_OFF = 0;

	/**
	* Constant for Sun keyboards for cut.
	*
	**/
	 public  final  static int VK_CUT = 0;

	/**
	* Constant for Sun keyboards for copy.
	*
	**/
	 public  final  static int VK_COPY = 0;

	/**
	* Constant for Sun keyboards for paste.
	*
	**/
	 public  final  static int VK_PASTE = 0;

	/**
	* Constant for Sun keyboards for undo.
	*
	**/
	 public  final  static int VK_UNDO = 0;

	/**
	* Constant for Sun keyboards for again.
	*
	**/
	 public  final  static int VK_AGAIN = 0;

	/**
	* Constant for Sun keyboards for find.
	*
	**/
	 public  final  static int VK_FIND = 0;

	/**
	* Constant for Sun keyboards for props.
	*
	**/
	 public  final  static int VK_PROPS = 0;

	/**
	* Constant for Sun keyboards for stop.
	*
	**/
	 public  final  static int VK_STOP = 0;

	/**
	* Constant for the Compose function key.
	*
	**/
	 public  final  static int VK_COMPOSE = 0;

	/**
	* Constant for the AltGraph function key.
	*
	**/
	 public  final  static int VK_ALT_GRAPH = 0;

	/**
	* KEY_TYPED events do not have a keyCode value. This value is used, instead.
	*
	**/
	 public  final  static int VK_UNDEFINED = 0;

	/**
	* KEY_PRESSED and KEY_RELEASED events which do not map to a valid Unicode
	* character use this for the keyChar value.
	*
	**/
	 public  final  static char CHAR_UNDEFINED = 'a';


	/**
	* Constructs a KeyEvent object.
	*
	* @param source 		 the Component that originated the event
	* @param keyChar 		 the Unicode character generated by this event, or CHAR_UNDEFINED (for key-pressed and key-released events which do not
map to a valid Unicode character)
	* @param modifiers 		 the modifier keys down during event (shift, ctrl, alt, meta)
	**/
	 public KeyEvent(java.lang.Object source, char keyChar, int modifiers)
	{
		 super((java.lang.Object)null);
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public void dispatch(com.ulcjava.base.application.event.IEventListener l)
	{
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public int getCategory()
	{
		return 0;
	}


	/**
	* Returns the code of character associated with the key in this event. For
	* example, the key-typed event for shift + "a" returns the
value for "A".
	*
	* @return		the Unicode character defined for this key event. If no valid Unicode character exists for this key event, keyChar is
CHAR_UNDEFINED.
	**/
	 public char getKeyChar()
	{
		return 'a';
	}


	/**
	* Returns the modifiers flag for this event.
	*
	* @return		modifiers as int
	**/
	 public int getModifiers()
	{
		return 0;
	}


	/**
	* Returns the extended modifier mask for this event. Extended modifiers
	* representthe state of all modal keys, such as ALT, CTRL, META,
just after the
	* event occurred.
	*
	**/
	 public int getModifiersEx()
	{
		return 0;
	}


	/**
	* Returns whether or not the Shift modifier is down on this event.
	*
	**/
	 public boolean isShiftDown()
	{
		return false;
	}


	/**
	* Returns whether or not the Control modifier is down on this event.
	*
	**/
	 public boolean isControlDown()
	{
		return false;
	}


	/**
	* Returns whether or not the Meta modifier is down on this event.
	*
	**/
	 public boolean isMetaDown()
	{
		return false;
	}


	/**
	* Returns whether or not the Alt modifier is down on this event.
	*
	**/
	 public boolean isAltDown()
	{
		return false;
	}


	/**
	* Returns whether or not the AltGraph modifier is down on this event.
	*
	**/
	 public boolean isAltGraphDown()
	{
		return false;
	}


	/**
	* For given <i>modifiers</i> returns a description of the modifier
	* key(s).
<p>
Note that the returned <code>String</code> is not localized.
</p>
	*
	**/
	 public  final  static java.lang.String getKeyModifiersText(int modifiers)
	{
		return null;
	}


}