package com.ulcjava.base.application.event;


	/**
	* A popup menu event that contains the source of the
	* event.
<p>
</p>
<b>Features</b>
<ul>
<li>The <code>IPopupMenuListener</code>
	* defines methods to handle the following events:
<ul>
<li> Popup menu has
	* become visible
<li> Popup menu has become invisible
<li> Popup menu is
	* cancelled
</ul>
</ul>
<p>
</p>
<b>Examples</b>
<p>
</p>
The following example
	* adds a popup handler to a <code>ULCComboBox</code> that adds items to the
	* combobox list as it comes up.
<p>

<pre>
public class ComboPopupListener
	* implements IPopupMenuListener {
public void
	* popupMenuHasBecomeVisible(PopupMenuEvent e) {
System.out.println("Server:
	* Popup
	* Visible");
comboBox1.removeAllItems();

comboBox1.addItem("One");
comboBox1.add
	* Item("Two");
comboBox1.addItem("Three");
comboBox1.addItem("Four");
comboBox1.ad
	* dItem("Five");
comboBox1.addItem("Six");
comboBox1.addItem("Seven");
comboBox1.a
	* ddItem("Eight");

comboBox1.updatePopupMenu();
}

public void
	* popupMenuCanceled(PopupMenuEvent event) {
System.out.println("Server: Popup
	* Canceled");
}

public void popupMenuHasBecomeInvisible(PopupMenuEvent event)
	* {System.out.println("Server: Popup Invisible");
}
}

...
comboBox = new
	* ULCComboBox();
comboBox.addItem("Initial
	* Value");
comboBox.addPopupMenuListener(new ComboPopupListener());

</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCComboBox
	* @see		com.ulcjava.base.application.ULCPopupMenu
	* @see		com.ulcjava.base.application.event.IPopupMenuListener
	**/
 public class PopupMenuEvent extends java.util.EventObject
{


	/**
	* Constructa a popup menu event
	*
	* @param source 		 the object on which the popup menu was activated
	**/
	 public PopupMenuEvent(java.lang.Object source)
	{
		 super((java.lang.Object)null);
	}


}