package com.ulcjava.base.application.event;


	/**
	* <code>RowSorterEvent</code> describes and notifies the changes to the
	* <code>TableRowSorter</code> such as sorting of the data contained
in a
	* <code>ULCTable</code>.
<p>
The <code>RowSorterEvent</code> contains
	* information about the current state of sorting:
<p>
<ul>
<li>If the
	* SortEventType is set to <code>SORT_ORDER_CHANGED</code> it indicates that the
	* sort order has changed and a sort operation will
be performed. This event is
	* fired at the beginning of a sort operation.
<li>If the SortEventType is set
	* to<code>SORTED</code> it indicates that a sort operation has been performed
	* and the mapping from model
indices to view indices might have changed. This
	* event is fired at the end of a sort operation.
</ul>
	*
	* @see		TableRowSorter
	* @see		ULCTable
	* @see		IRowSorterListener
	**/
 public class RowSorterEvent extends java.util.EventObject
{


	/**
	* Constructor for a new <code>RowSorterEvent</code>.
	*
	* @param source 		 The <code>TableRowSorter</code> that fired this event.
	* @param eventType 		 The type of this <code>RowSorterEvent</code>.
	* @param previousRowIndexToModel 		 The previous mapping of view row indices to model row indices.
	**/
	 public RowSorterEvent(com.ulcjava.base.application.table.TableRowSorter source, com.ulcjava.base.application.event.RowSorterEvent$SortEventType eventType, int[] previousRowIndexToModel)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Returns the source of this event - the <code>TableRowSorter</code> that fired
	* this event.
	*
	* @return		The TableRowSorter that fired this event.
	**/
	 public com.ulcjava.base.application.table.TableRowSorter getEventSource()
	{
		return null;
	}


	/**
	* Returns the type of this event.
	*
	* @return		The type of this event.
	* @see		SortEventType#SORT_ORDER_CHANGED
	* @see		SortEventType#SORTED
	**/
	 public com.ulcjava.base.application.event.RowSorterEvent$SortEventType getType()
	{
		return null;
	}


	/**
	* The row count of the mapping before the new sort operation was performed.
	*
	* @return		The previous row count.
	**/
	 public int getPreviousRowCount()
	{
		return 0;
	}


	/**
	* The previous mapping from view rows to model rows before the new sort
	* operationwas performed.
	*
	* @return		The previous view row to model row mapping.
	**/
	 public int[] getOldViewToModelIndices()
	{
		return null;
	}


	/**
	* Returns model index in terms of the row sorter prior to the sort. Returns -1
	* ifthe index is not valid.
	*
	* @param index 		 the view index
	* @return		model index in terms of the row sorter prior to the sort
	**/
	 public int convertPreviousRowIndexToModel(int index)
	{
		return 0;
	}


	/**
	* Returns model indices in terms of the row sorter prior to the sort.
	*
	* @param indices 		 the view indices
	* @return		model index in terms of the row sorter prior to the sort
	**/
	 public int[] convertPreviousRowIndicesToModel(int[] indices)
	{
		return null;
	}


	/**
	* The types of <code>RowSorterEvent</code>s.
	*
	**/
 public  static class SortEventType extends java.lang.Object implements java.io.Serializable
{

	/**
	* Specifies that sort order has changed.
	*
	**/
	 public  final  static com.ulcjava.base.application.event.RowSorterEvent$SortEventType SORT_ORDER_CHANGED = null;

	/**
	* Specifies that model has been sorted or transformed.
	*
	**/
	 public  final  static com.ulcjava.base.application.event.RowSorterEvent$SortEventType SORTED = null;

	 private SortEventType()
	{
		 super();
	}


}
}