package com.ulcjava.base.application.event;


	/**
	* Selection changed events are used to listen to changes of the selection of the
	* current page in the
	* <code>ULCTabbedPane</code>
component.
<p>
<b>Features</b>
<ul>
<li>The
	* <code>ISelectionChangedListener</code> interface defines the single
	* method
<code>selectionChanged(SelectionChangedEvent)</code>.
</ul>
<b>Examples<
	* /b>
<p>
The following example shows how to handle selections on a
	* <code>ULCComboBox</code>
	* component.

<pre>
tabbedPane.addSelectionChangedListener(new
	* SelectionHandler());
</pre>

The implementation of the
	* <code>ISelectionChangedListener</code> interface, retrieves the current
	* selection from the event source,
i.e., the <code>ULCTabbedPane</code>, and
	* prints out the new selection.

<pre>
public class SelectionHandler implements
	* ISelectionChangedListener {
public void
	* selectionChanged(SelectionChangedEventevent) {
ULCTabbedPane tabbedPane =
	* (ULCTabbedPane)event.getSource();
int selection =
	* tabbedPane.getSelectedIndex();
System.out.println(&quot;selected tab &quot; +
	* selection);
}
}
</pre>
	*
	* @ulc.application		
	* @see		UlcEvent
	* @see		com.ulcjava.base.application.ULCTabbedPane
	**/
 public class SelectionChangedEvent extends com.ulcjava.base.application.event.UlcEvent
{


	/**
	* Constructs a SelectionChangedEvent object.
	*
	* @param source 		 the Component that originated the event
	**/
	 public SelectionChangedEvent(java.lang.Object source)
	{
		 super((java.lang.Object)null);
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public void dispatch(com.ulcjava.base.application.event.IEventListener l)
	{
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public int getCategory()
	{
		return 0;
	}


}