package com.ulcjava.base.application.event;


	/**
	* Table model events are used to notify listeners that a table model has
	* changed.The <code>ITableModelEvent</code> describes changes to
the
	* <code>ITableModel</code>. All references to rows and columns are in the
	* coordinate system of the model.
<p>
<b>Features</b>
<ul>
<li>The
	* <code>TableModelEvent</code> provides information about the changes of the
	* source table model. The following types of changes can
be
	* distinguished:
<ul>
<li>The whole model has changed (a table base component
	* will in turn refetch all the data that is currently visible).
<li>The cell
	* contents of a single row or a range of rows have changed (a table base
	* component will in turn refetch the data of the
affected cells if currently
	* visible).
<li>The cell content of a single cell has changed (a table base
	* component will in turn refetch the data of the affected cell if
	* currently
visible).
<li>New rows have been inserted (a table base component
	* will in turn insert the new rows into the view and fetch the data of the new
	* rows
if currently visible).
<li>Rows have been deleted (a table base
	* componentwill in turn remove the rows from the view).
</ul>
<li>The
	* <code>ITableModelListener</code> defines the
	* <code>tableChanged(TableModelEvent)</code> method that is called when the
	* table
model has changed.
<li>Note that the <code>AbstractTableModel</code>
	* class provides convenience methods to create and fire table model events to
	* all
registered listeners.
</ul>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.table.AbstractTableModel
	* @see		com.ulcjava.base.application.ULCTable
	**/
 public class TableModelEvent extends java.util.EventObject
{

	/**
	* Identifies the addition of new rows or columns.
	*
	**/
	 public  final  static int INSERT = 0;

	/**
	* Identifies a change to existing data.
	*
	**/
	 public  final  static int UPDATE = 0;

	/**
	* Identifies the removal of rows or columns.
	*
	**/
	 public  final  static int DELETE = 0;

	/**
	* Identifies the header row.
	*
	**/
	 public  final  static int HEADER_ROW = 0;

	/**
	* Specifies all columns in a row or rows.
	*
	**/
	 public  final  static int ALL_COLUMNS = 0;


	/**
	* All row data in the table has changed, listeners should discard any state that
	* was based on the rows and requery the
<code>ITableModel</code> to get the new
	* row count and all the appropriate values. The <code>ULCTable</code> will
	* repaint the entire
visible region on receiving this event, querying the model
	* for the cell values that are visible. The structure of the table , i.e.,
the
	* column names, types and order have not changed.
	*
	* @param source 		 the new data source
	**/
	 public TableModelEvent(com.ulcjava.base.application.table.ITableModel source)
	{
		 super((java.lang.Object)null);
	}


	/**
	* This row of data has been updated. To denote the arrival of a completely new
	* table with a different structure use
<code>HEADER_ROW</code> as the value for
	* the <code>row</code>. When the <code>ULCTable</code> receives this event and
	* its
<code>autoCreateColumnsFromModel</code> flag is set it discards any
	* ULCTableColumns that it had and reallocates default ones in the
order they
	* appear in the model. This is the same as calling
	* <code>setModel(ITableModel)</code> on the <code>ULCTable</code>.
	*
	* @param source 		 the new data source
	* @param row 		 indicating the row that changed
	**/
	 public TableModelEvent(com.ulcjava.base.application.table.ITableModel source, int row)
	{
		 super((java.lang.Object)null);
	}


	/**
	* The data in rows <i>firstRow</i> to <i>lastRow</i> has been updated.
	*
	* @param source 		 the new data source
	* @param firstRow 		 indicating the start of the interval updated
	* @param lastRow 		 indicating the end of the interval updated
	**/
	 public TableModelEvent(com.ulcjava.base.application.table.ITableModel source, int firstRow, int lastRow)
	{
		 super((java.lang.Object)null);
	}


	/**
	* The cells in column <i>column</i> in the range <i>firstRow</i> to
	* <i>lastRow</i> have been updated.
	*
	* @param source 		 the new data source
	* @param firstRow 		 indicating the start of the interval updated
	* @param lastRow 		 indicating the end of the interval updated
	* @param column 		 indicating the column that has been updated
	**/
	 public TableModelEvent(com.ulcjava.base.application.table.ITableModel source, int firstRow, int lastRow, int column)
	{
		 super((java.lang.Object)null);
	}


	/**
	* The cells in column <i>column</i>, rows <i>firstRow</i> to <i>lastRow</i> have
	* been changed. If <I>column</I> is ALL_COLUMNS, all
cells in the specified
	* range of rows are considered changed.
<p>
</p>
The <I>type</I> should be one
	* of: INSERT, UPDATE and DELETE.
	*
	* @param source 		 the new data source
	* @param firstRow 		 indicating the start of the interval updated
	* @param lastRow 		 indicating the end of the interval updated
	* @param column 		 indicating the column that has been updated
	* @param type 		 indicating if data are inserted, updated or deleted
	**/
	 public TableModelEvent(com.ulcjava.base.application.table.ITableModel source, int firstRow, int lastRow, int column, int type)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Returns the first row that changed. HEADER_ROW means the meta data, i.e.,
	* names, types and order of the columns.
	*
	* @return		the first row that changed
	**/
	 public int getFirstRow()
	{
		return 0;
	}


	/**
	* Returns the last row that changed.
	*
	* @return		the first row that changed
	**/
	 public int getLastRow()
	{
		return 0;
	}


	/**
	* Returns the column for the event. If the return value is ALL_COLUMNS; every
	* column in the specified rows changed.
	*
	* @return		the column that changed
	**/
	 public int getColumn()
	{
		return 0;
	}


	/**
	* Returns the type of event.
	*
	* @return		the type of event - one of: INSERT, UPDATE and DELETE
	**/
	 public int getType()
	{
		return 0;
	}


	/**
	* Returns true if this event is a structure changed event, false otherwise. A
	* structure changed event is triggered as reaction
	* to
AbstractTableModel.fireTableStructureChanged().
	*
	* @return		true if this event is a structure changed event, false otherwise
	* @see		javax.swing.table.AbstractTableModel#fireTableStructureChanged()
	**/
	 public boolean isStructureChangedEvent()
	{
		return false;
	}


	/**
	* Returns true if this event is a data changed event, false otherwise. A data
	* changed event is triggered as reaction
	* to
AbstractTableModel.fireTableDataChanged().
	*
	* @return		true if this event is a data changed event, false otherwise
	* @see		javax.swing.table.AbstractTableModel#fireTableDataChanged()
	**/
	 public boolean isDataChangedEvent()
	{
		return false;
	}


	/**
	* Returns true if this event is rows updated event, false otherwise. A rows
	* updated event is triggered as reaction
	* to
AbstractTableModel.fireTableRowsUpdated().
	*
	* @return		true if this event is rows updated event, false otherwise
	* @see		javax.swing.table.AbstractTableModel#fireTableRowsUpdated(int, int)
	**/
	 public boolean isRowsUpdatedEvent()
	{
		return false;
	}


	/**
	* Returns true if this event is rows inserted event, false otherwise. A rows
	* inserted event is triggered as reaction
	* to
AbstractTableModel.fireTableRowsInserted().
	*
	* @return		true if this event is rows inserted event, false otherwise
	* @see		javax.swing.table.AbstractTableModel#fireTableRowsInserted(int, int)
	**/
	 public boolean isRowsInsertedEvent()
	{
		return false;
	}


	/**
	* Returns true if this event is rows deleted event, false otherwise. A rows
	* deleted event is triggered as reaction
	* to
AbstractTableModel.fireTableRowsDeleted().
	*
	* @return		true if this event is rows deleted event, false otherwise
	* @see		javax.swing.table.AbstractTableModel#fireTableRowsDeleted(int, int)
	**/
	 public boolean isRowsDeletedEvent()
	{
		return false;
	}


	/**
	* Returns true if this event is a cell updated event, false otherwise. A cell
	* updated event is triggered as reaction
	* to
AbstractTableModel.fireTableCellUpdated().
	*
	* @return		true if this event is a cell updated event, false otherwise
	* @see		javax.swing.table.AbstractTableModel#fireTableCellUpdated(int, int)
	**/
	 public boolean isCellUpdatedEvent()
	{
		return false;
	}


}