package com.ulcjava.base.application.event;


	/**
	* Table tree model events are used to notify listeners that a table tree model
	* has changed. The <code>ITableTreeModelEvent</code>
describes changes to the
	* <code>ITableTreeModel</code>.
<p>
<b>Features</b>
<ul>
<li>The
	* <code>TableTreeModelEvent</code> provides information about the changes of
	* thesource table tree model. The following types of
changes can be
	* distinguished:
<ul>
<li>The whole model has changed (a
	* <code>ULCTableTree</code> will in turn refetch all the data that is currently
	* visible).
<li>The children nodes of some node have been (structurally)
	* changed(a <code>ULCTableTree</code> will in turn refetch the children
count
	* ofthis node and refetch all children data).
<li>The cell contents of certain
	* sibling nodes have changed (a <code>ULCTableTree</code> will in turn refetch
	* the data of the affected
cells if currently visible). The nodes are addressed
	* by specifying their parent and the children's indices.
<li>The cell content
	* ofa single cell has changed (a <code>ULCTableTree</code> will in turn refetch
	* the data of the affected cell if
currently visible).
<li>New children have
	* been inserted at some node (a <code>ULCTableTree</code> will in turn insert
	* the new nodes into the view and
fetch the data of the new rows if currently
	* visible).
<li>Certain children of a node have been deleted (a
	* <code>ULCTableTree</code> will in turn remove the nodes from the
	* view).
</ul>
<li>The <code>ITableTreeModelListener</code> interface defines
	* the single <code>tableTreeChanged(TableTreeModelEvent)</code> method
that is
	* called when the table tree model has changed.
<li>Note that the
	* <code>AbstractTableTreeModel</code> class provides convenience methods to
	* create and fire table tree model events to
all registered listeners.
</ul>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.tabletree.AbstractTableTreeModel
	* @see		com.ulcjava.base.application.ULCTableTree
	**/
 public class TableTreeModelEvent extends java.util.EventObject
{

	/**
	* A flag representing all column for events like updates.
	*
	**/
	 public  final  static int ALL_COLUMNS = 0;


	/**
	* Used to create an event when all row data in the table has changed.
	*
	* @param source 		 the source of the event
	**/
	 public TableTreeModelEvent(java.lang.Object source)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Used to create an event when nodes have been changed, inserted, or
	* removed.
<p></p>
For inserts, the indexes represent the <i>final</i> state of
	* the tree, after the inserts have occurred. For deletes, the indexes
represent
	* the <i>initial</i> state of the tree, before the deletes have occurred.
	*
	* @param source 		 the source of the event
	* @param path 		 the parent of the modified children
	* @param childIndices 		 the child indices of the modified children
	* @param children 		 the modified children
	**/
	 public TableTreeModelEvent(java.lang.Object source, com.ulcjava.base.application.tree.TreePath path, int[] childIndices, java.lang.Object[] children)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Used to create an event when nodes have been changed, inserted, or
	* removed.
<p></p>
For inserts, the indexes represent the <i>final</i> state of
	* the tree, after the inserts have occurred. For deletes, the indexes
represent
	* the <i>initial</i> state of the tree, before the deletes have occurred.
	*
	* @param source 		 the source of the event
	* @param path 		 the parent of the modified children
	* @param childIndices 		 the child indices of the modified children
	* @param children 		 the modified children
	**/
	 public TableTreeModelEvent(java.lang.Object source, java.lang.Object[] path, int[] childIndices, java.lang.Object[] children)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Used to create an event when the node structure has changed in some way.
	*
	* @param source 		 the source of the event
	* @param path 		 the node whose structure has changed
	**/
	 public TableTreeModelEvent(java.lang.Object source, java.lang.Object[] path)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Used to create an event when the node structure has changed in some way.
	*
	* @param source 		 the source of the event
	* @param path 		 the node whose structure has changed
	**/
	 public TableTreeModelEvent(java.lang.Object source, com.ulcjava.base.application.tree.TreePath path)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Used to create an event when cells have been changed.
	*
	* @param source 		 the source of the event
	* @param path 		 the parent of the modified children
	* @param childIndices 		 the child indices of the modified children
	* @param children 		 the modified children
	* @param column 		 the column of the modified children
	**/
	 public TableTreeModelEvent(java.lang.Object source, java.lang.Object[] path, int[] childIndices, java.lang.Object[] children, int column)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Used to create an event when cells have been changed.
	*
	* @param source 		 the source of the event
	* @param path 		 the parent of the modified children
	* @param childIndices 		 the child indices of the modified children
	* @param children 		 the modified children
	* @param column 		 the column of the modified children
	**/
	 public TableTreeModelEvent(java.lang.Object source, com.ulcjava.base.application.tree.TreePath path, int[] childIndices, java.lang.Object[] children, int column)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Returns the column for the event.
	*
	* @return		the column for the event
	**/
	 public int getColumn()
	{
		return 0;
	}


	/**
	* Returns the child indices for the event.
	*
	* @return		the child indices for the event
	**/
	 public int[] getChildIndices()
	{
		return null;
	}


	/**
	* Returns the children for the event.
	*
	* @return		the children for the event
	**/
	 public java.lang.Object[] getChildren()
	{
		return null;
	}


	/**
	* Returns the path for the event.
	*
	* @return		the path for the event
	**/
	 public com.ulcjava.base.application.tree.TreePath getTreePath()
	{
		return null;
	}


}