package com.ulcjava.base.application.event;


	/**
	* ULC applications can register listeners to be notified when tree nodes of a
	* <code>ULCTree</code> or <code>ULCTableTree</code> are
expanded or
	* collapsed.
<p>
<b>Features</b>
<ul>
<li>A <code>TreeExpansionEvent</code> is
	* used to provide information about which nodes of a <code>ULCTree</code>
	* or
<code>ULCTableTree</code> have been expanded or collapsed.
<li>The
	* <code>ITreeExpansionListener</code> interface defines two methods that are
	* called when a node is expanded and when a node is
collapsed:
	* <code>treeExpanded(TreeExpansionEvent)</code> and
	* <code>treeCollapsed(TreeExpansionEvent)</code>.
</ul>
	*
	* @ulc.application		
	* @see		UlcEvent
	* @see		com.ulcjava.base.application.ULCTableTree
	* @see		com.ulcjava.base.application.ULCTree
	**/
 public class TreeExpansionEvent extends com.ulcjava.base.application.event.UlcEvent
{


	/**
	* Constructs a TreeExpansionEvent object.
	*
	* @param source 		 the Component that originated the event
	* @param path 		 a <code>TreePath</code> for this event
	**/
	 public TreeExpansionEvent(java.lang.Object source, com.ulcjava.base.application.tree.TreePath path)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Constructs a TreeExpansionEvent object.
	*
	* @param source 		 the Component that originated the event
	* @param id 		 an integer indicating the type of event
	* @param path 		 a <code>TreePath</code> for this event
	* @deprecated		Use {@link #TreeExpansionEvent(Object, com.ulcjava.base.application.tree.TreePath)} instead.
	**/
	 public TreeExpansionEvent(java.lang.Object source, int id, com.ulcjava.base.application.tree.TreePath path)
	{
		 super((java.lang.Object)null);
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public void dispatch(com.ulcjava.base.application.event.IEventListener treeExpansionListener)
	{
	}


	/**
	* Returns the event type.
	*
	* @return		the event type
	* @deprecated		Ids are no longer needed and thus, no longer supported with the new-style event delivery mechanism. This method only
returns a valid id if the event object has been constructed using
{@link #TreeExpansionEvent(Object, int, com.ulcjava.base.application.tree.TreePath)}. Otherwise, this method returns -1.
	**/
	 public int getId()
	{
		return 0;
	}


	/**
	* The node that was expanded or collapsed.
	*
	* @return		the node that was expanded or collapsed.
	**/
	 public com.ulcjava.base.application.tree.TreePath getPath()
	{
		return null;
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public int getCategory()
	{
		return 0;
	}


}