package com.ulcjava.base.application.event;


	/**
	* ULC applications can register listeners to be notified when tree nodes of a
	* <code>ULCTree</code> or <code>ULCTableTree</code> are
selected or
	* deselected.
<p>
<b>Features</b>
<ul>
<li>A <code>TreeSelectionEvent</code> is
	* used to provide information about which nodes of a <code>ULCTree</code>
	* or
<code>ULCTableTree</code> have been selected or deselected. The
	* <code>getPaths()</code> method returns all nodes that changed their
selection
	* state. The isAddedPath() method can be used to determine if a node has been
	* selected or deselected.
<li>The <code>ITreeSelectionListener</code> interface
	* defines the <code>valueChanged(TreeSelectionEvent)</code> method that
	* is
called when nodes are selected or deselected.
</ul>
<b>Example</b>
<p>
The
	* following example prints out information on how the selection in a
	* <code>ULCTree</code> changes.

<pre>
tree.addTreeSelectionListener(new
	* TreeSelectionHandler());
...
public class TreeSelectionHandler implements
	* ITreeSelectionListener {
public void valueChanged(TreeSelectionEvent event)
	* {
for (int i = 0; i &lt; event.getPaths().length; i++) {
TreePath treePath =
	* event.getPaths()[i];
System.out.print(treePath + &quot; has been
	* &quot;);
System.out.println(event.isAddedPath(treePath)
	* ?
&quot;selected&quot;: &quot;deselected&quot;);
}
}
}
</pre>
	*
	* @ulc.application		
	* @see		UlcEvent
	* @see		com.ulcjava.base.application.ULCTableTree
	* @see		com.ulcjava.base.application.ULCTree
	**/
 public class TreeSelectionEvent extends com.ulcjava.base.application.event.UlcEvent
{


	/**
	* Represents a change in the selection of a TreeSelectionModel. path identifies
	* the path that have been either added or removed from
the selection.
	*
	* @param source 		 source of event
	* @param path 		 the paths that have changed in the selection
	* @param addedPath 		 indicates whether path was added(true) or removed from selection
	**/
	 public TreeSelectionEvent(java.lang.Object source, com.ulcjava.base.application.tree.TreePath path, boolean addedPath)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Represents a change in the selection of a TreeSelectionModel. paths identifies
	* the paths that have been either added or removed from
the selection.
	*
	* @param source 		 source of event
	* @param paths 		 the paths that have changed in the selection
	* @param addedPaths 		 indicates which paths have been added (true) or removed from the selection
	**/
	 public TreeSelectionEvent(java.lang.Object source, com.ulcjava.base.application.tree.TreePath[] paths, boolean[] addedPaths)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Returns the paths that have been added or removed from the selection.
	*
	* @return		the paths that have been added or removed from the selection
	**/
	 public com.ulcjava.base.application.tree.TreePath[] getPaths()
	{
		return null;
	}


	/**
	* Returns the first path element.
	*
	* @return		the first path element
	**/
	 public com.ulcjava.base.application.tree.TreePath getPath()
	{
		return null;
	}


	/**
	* Returns true if the first path element has been added to the selection, a
	* return value of false means the first path has been removed
from the selection.
	*
	* @return		true if the first path element has been added, false if removed from the selection
	**/
	 public boolean isAddedPath()
	{
		return false;
	}


	/**
	* Returns true if the path identified by path was added to the selection. A
	* return value of false means the path was in the selection
but is no longer in
	* the selection. This throw an IllegalArgumentException if path is not one of
	* the paths identified by this event.
	*
	* @param path 		 a <code>TreePath</code> for this event
	* @return		true if the path identified by path was added, false if was removed from selection
	**/
	 public boolean isAddedPath(com.ulcjava.base.application.tree.TreePath path)
	{
		return false;
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public void dispatch(com.ulcjava.base.application.event.IEventListener listener)
	{
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public int getCategory()
	{
		return 0;
	}


}