package com.ulcjava.base.application.event;


	/**
	* The <code>UlcEvent</code> class is the superclass of all events that are
	* issuedby client half
	* objects.
<p>
<b>Features</b>
<ul>
<li><code>UlcEvent</code> subclasses
	* supporttwo different modes of delivering the event to server side listeners:
	* synchronous
delivery (default) blocks the user interface until the server
	* round trip triggered by the event has been completed, asynchronous
	* delivery
allows the user to continue to interact. Using the
	* <code>setEventDeliveryMode()</code> method on the
	* <code>ClientContext</code>
class, the event delivery mode can be adjusted per
	* component instance and event type.
<li>All <code>UlcEvent</code> classes
	* provide access to the source of the event, i.e., the component that fired the
	* event.
</ul>
<b>Examples</b>
<p>
The following example shows how to register
	* an <code>ISelectionChangedListener</code> on the
	* <code>ListSelectionModel</code> of a
<code>ULCTable</code> and how to
	* configure the <code>ListSelectionModel</code> to deliver
	* <code>ListSelectionEvents</code>
asynchronously to the server
	* side.

<pre>
table.getSelectionModel().addListSelectionListener(new
	* StatusBarUpdater());
ClientContext.setEventDeliveryMode(table.getSelectionModel
	* (),
UlcEventCategories.LIST_SELECTION_EVENT_CATEGORY,
UlcEventConstants.ASYNCHRO
	* NOUS_MODE);
</pre>
	*
	* @ulc.application		
	* @deprecated		Inherit from {@link java.util.EventObject} instead.
	**/
 public  abstract class UlcEvent extends java.util.EventObject implements com.ulcjava.base.shared.IUlcEventConstants
{


	/**
	* Constructs a prototypical Event.
	*
	* @param source 		 The object on which the Event initially occurred.
	**/
	 public UlcEvent(java.lang.Object source)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Dispatches this event to the specified object if it implements the right
	* interface.
	*
	* @param l 		 the listener object for the event
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public  abstract void dispatch(com.ulcjava.base.application.event.IEventListener l);

	/**
	* Returns the event category.
	*
	* @return		the event category
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public  abstract int getCategory();

}