package com.ulcjava.base.application.event;


	/**
	* <code>ULCTextField</code>, <code>ULCTextArea</code>,
	* <code>ULCPasswordField</code>,
	* <code>ULCSlider</code>,
<code>ULCCheckBox</code>, and
	* <code>ULCRadioButton</code> offer the possibility to register an
	* <code>IValueChangedListener</code>.
This listener will be notified about user
	* changes to the data that is visualized by the component. The exact time of
	* notification of the
listener depends on the type of
	* component:
<p>
</p>
<tableborder="1">
<tr
	* bgcolor="#C0C0C0">
<td><b>ULCComponent</b>
<td><b>Time of event
	* notification<b>
<tr>
<td><code>ULCTextField</code>, <code>ULCTextArea</code>,
	* <code>ULCPasswordField</code>
<td>The event is fired when the text component
	* loses the focus.
<tr>
<td><code>ULCSlider</code>
<td>The event is fired after
	* the user releases the mouse or the key that was used to change the slider's
	* value.
<tr>
<td><code>ULCCheckBox</code>, <code>ULCRadioButton</code>
<td>The
	* event is fired after the toggle button has changed its state.
	* </table>
<p>
<b>Features</b>
<ul>
<li>The <code>ValueChangedEvent</code>
	* itself does not provide information on the new value of the component. The
	* newvalue must be
retrieved from the source component itself.
<li>The
	* <code>IValueChangedListener</code> defines the
	* <code>valueChanged(ValueChangedEvent)</code> method that is called when
	* a
value is changed (at times as defined above).
</ul>
<b>Examples</b>
<p>
The
	* following example fills out remaining text fields after the user has filled
	* ina person's social security number
	* (SSN).

<pre>
fSSNField.addValueChangedListener(new
	* AutoCompleteAction());
...public class AutoCompleteAction implements
	* IValueChangedListener {
public void valueChanged(ValueChangedEvent event)
	* {
autoComplete();
}
}
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCCheckBox
	* @see		UlcEvent
	* @see		com.ulcjava.base.application.ULCPasswordField
	* @see		com.ulcjava.base.application.ULCRadioButton
	* @see		com.ulcjava.base.application.ULCTextArea
	* @see		com.ulcjava.base.application.ULCTextField
	* @see		com.ulcjava.base.application.ULCSlider
	**/
 public class ValueChangedEvent extends com.ulcjava.base.application.event.UlcEvent
{


	/**
	* Constructs a ValueChangedEvent object.
	*
	* @param source 		 the Object that is the source of the event (typically <code>this</code>)
	**/
	 public ValueChangedEvent(java.lang.Object source)
	{
		 super((java.lang.Object)null);
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public void dispatch(com.ulcjava.base.application.event.IEventListener l)
	{
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public int getCategory()
	{
		return 0;
	}


}