package com.ulcjava.base.application.event.serializable;


	/**
	* <code>IListSelectionListener</code>s are notified when a list's selection
	* valuechanges.
<p>
</p>
<b>Features</b>
<ul>
<li><code>IListSelectionListener</c
	* ode>s can be registered with a <code>ULCList</code> or a
	* <code>ULCListSelectionModel</code> to
be notified when the list's selection
	* value changes</li>.
</ul>
<b>Examples</b> The following example installs an
	* <code>IListSelectionListener</code> which prints the selected index to the
	* console.

<pre>
ULCList list = new ULCList(new
	* MyListModel());
list.addListSelectionListener(new IListSelectionListener()
	* {
public void valueChanged(ListSelectionEvent event) {
ULCListSelectionModel
	* source =
	* (ULCListSelectionModel)event
.getSource();
System.out.println(&quot;selection
	* changed: &quot;
+ source.getMinSelectionIndex());
}
});
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCListSelectionModel
	* @see		com.ulcjava.base.application.event.ListSelectionEvent
	* @deprecated		use com.ulcjava.base.application.event.IListSelectionListener instead
	**/
 public interface IListSelectionListener extends com.ulcjava.base.application.event.IListSelectionListener
{


}