package com.ulcjava.base.application.table;


	/**
	* The <code>AbstractTableModel</code> class provides a default implementation
	* formost of the methods in the <code>ITableModel</code>
interface. In most
	* cases developer will subclass <code>AbstractTableModel</code> to implement
	* hisown table model.
<p>
</p>
<b>Features</b>
<ul>
<li>The
	* <code>AbstractTableModel</code> class manages the handling of table model
	* listeners.
<li>To notify the table model listeners that data in the table
	* model has changed the application should use the following
	* convenience
methods:
<ul>
<li><code>fireTableCellUpdated()</code> when a
	* single cell has been updated
<li><code>fireTableRowsUpdated()</code> when a
	* range of rows has been updated
<li><code>fireTableRowsInserted()</code> when
	* arange of rows has been inserted
<li><code>fireTableRowsRemoved()</code> when
	* a range of rows has been removed
<li><code>fireTableDataChanged()</code> when
	* all cells have been changed
</ul>
<li>In many applications, table model
	* implementations are read-only and will not support writing back to the model.
	* For this reason a
default implementation of the <code>setValueAt()</code>
	* method is provided which throws an
	* <code>UnsupportedOperationException</code>.</ul>
<b>Examples</b>
<p>
</p>
The
	* following example shows how to implement a custom table model containing a
	* list of tasks. When the application itself changes the
data source (setting
	* the list of tasks, adding a new task, removing a task) the table model has to
	* notify the table model listeners. To
allow in-place editing, the
	* <code>setValueAt()</code> method has been overridden to write back the user
	* changes to the list of tasks.
<p>
</p>

<pre>
public class TaskTableModel
	* extends AbstractTableModel {
public static final int NAME_INDEX = 0;
public
	* static final int DUE_INDEX = 1;
public static final int EFFORT_INDEX =
	* 2;
private List fTasks;

public TaskTableModel(Task[] tasks) {
fTasks = new
	* ArrayList(Arrays.asList(tasks));
}

public Object getRowAt(int rowIndex)
	* {
return fTasks.get(rowIndex);
}

public int getRowCount() {
return
	* fTasks.size();
}

public int getColumnCount() {
return 3;
}

public Object
	* getValueAt(int rowIndex, int columnIndex) {
Task task =
	* (Task)fTasks.get(rowIndex);
if (columnIndex == NAME_INDEX) {
return
	* task.getName();
}
if (columnIndex == DUE_INDEX) {
return
	* task.getDueBy();
}
if(columnIndex == EFFORT_INDEX) {
return new
	* Double(task.getEffort());
}
throw new IllegalArgumentException(&quot;unknown
	* column identifier: &quot;
+ columnIndex);
}

// Overrides default
	* implementation in AbstractTableModel.
// The default implementation is
	* invokedfor non-editable columns
// (the default implementation throws a
	* UnsupportedOperationException)
public void setValueAt(Object aValue, int
	* rowIndex, int columnIndex) {
Task task = (Task)fTasks.get(rowIndex);
if
	* (columnIndex == EFFORT_INDEX) {
Double effort =
	* (Double)aValue;
task.setEffort(effort.doubleValue());
} else
	* {
super.setValueAt(aValue, rowIndex, columnIndex);
}
}

public String
	* getColumnName(int column) {
if (column == NAME_INDEX) {
return
	* &quot;Name&quot;;
} else if (column == DUE_INDEX) {
return &quot;Due
	* by&quot;;} else if (column == EFFORT_INDEX) {
return &quot;Effort&quot;;
}
	* else
throw new IllegalArgumentException(&quot;wrong column index: &quot;
+
	* column);
}

public void setTasks(Task[] tasks) {
fTasks = new
	* ArrayList(Arrays.asList(tasks));
fireTableDataChanged();
}

public void
	* addTask(Task task) {
fTasks.add(task);
fireTableRowsInserted(fTasks.size() -
	* 1, fTasks.size() - 1);
}

public void removeTask(int rowIndex)
	* {
fTasks.remove(rowIndex);
fireTableRowsDeleted(rowIndex, rowIndex);
}
}
</pre>
	*
	* @ulc.application		
	* @see		ITableModel
	* @see		com.ulcjava.base.application.ULCTable
	**/
 public  abstract class AbstractTableModel extends java.lang.Object implements com.ulcjava.base.application.table.ITableModel, java.io.Serializable
{

	 protected AbstractTableModel()
	{
		 super();
	}


	/**
	* Adds a listener to the list that's notified each time a change to the data
	* model occurs.
	*
	* @param listener 		 the ITableModelListener
	**/
	 public void addTableModelListener(com.ulcjava.base.application.event.ITableModelListener listener)
	{
	}


	/**
	* Removes a listener from the list that's notified each time a change to the
	* datamodel occurs.
	*
	* @param listener 		 the ITableModelListener
	**/
	 public void removeTableModelListener(com.ulcjava.base.application.event.ITableModelListener listener)
	{
	}


	/**
	* Returns an array of all the table model listeners registered on this model.
	*
	* @return		all of this model's <code>ITableModelListener</code>s or an empty array if no table model listeners are currently
registered
	* @see		#addTableModelListener(ITableModelListener)
	* @see		#removeTableModelListener(ITableModelListener)
	**/
	 public com.ulcjava.base.application.event.ITableModelListener[] getTableModelListeners()
	{
		return null;
	}


	/**
	* Returns a column given its name.
	*
	* @param columnName 		 string containing name of column to be located
	* @return		the column with <code>columnName</code>, or -1 if not found
	**/
	 public int findColumn(java.lang.String columnName)
	{
		return 0;
	}


	/**
	* Notifies all listeners that all cell values in the table's rows may have
	* changed. The number of rows may also have changed and
	* the
<code>ULCTable</code> should redraw the table from scratch. The structure
	* of the table (as in the order of the columns) is assumed
to be the same.
	*
	* @see		com.ulcjava.base.application.event.TableModelEvent
	**/
	 public void fireTableDataChanged()
	{
	}


	/**
	* Notifies all listeners that the table's structure has changed. The number of
	* columns in the table, and the names and types of the new
columns may be
	* different from the previous state. If the <code>ULCTable</code> receives this
	* event and its
<code>autoCreateColumnsFromModel</code> flag is set it discards
	* any table columns that it had and reallocates default columns in
the order
	* they appear in the model. This is the same as calling
	* <code>setModel(ITableModel)</code> on the <code>ULCTable</code>.
	*
	* @see		TableModelEvent
	**/
	 public void fireTableStructureChanged()
	{
	}


	/**
	* Notifies all listeners that rows in the range <code>firstRow</code> to
	* <code>lastRow</code>, inclusive, have been inserted.
	*
	* @param firstRow 		 the first row
	* @param lastRow 		 the last row
	* @see		TableModelEvent
	**/
	 public void fireTableRowsInserted(int firstRow, int lastRow)
	{
	}


	/**
	* Notifies all listeners that rows in the range <code>firstRow</code> to
	* <code>lastRow</code>, inclusive, have been updated.
	*
	* @param firstRow 		 the first row
	* @param lastRow 		 the last row
	* @see		TableModelEvent
	**/
	 public void fireTableRowsUpdated(int firstRow, int lastRow)
	{
	}


	/**
	* Notifies all listeners that rows in the range <code>firstRow</code> to
	* <code>lastRow</code>, inclusive, have been deleted.
	*
	* @param firstRow 		 the first row
	* @param lastRow 		 the last row
	* @see		TableModelEvent
	**/
	 public void fireTableRowsDeleted(int firstRow, int lastRow)
	{
	}


	/**
	* Notifies all listeners that the value of the cell at row <code>row</code> and
	* column <code>column</code> has been updated.
	*
	* @param row 		 row of cell which has been updated
	* @param column 		 column of cell which has been updated
	* @see		TableModelEvent
	**/
	 public void fireTableCellUpdated(int row, int column)
	{
	}


	/**
	* Forwards the given notification event to all <code>ITableModelListeners</code>
	* that registered themselves as listeners for this
table model.
	*
	* @param event 		 the event to be forwarded
	* @see		#addTableModelListener
	* @see		TableModelEvent
	**/
	 public void fireTableChanged(com.ulcjava.base.application.event.TableModelEvent event)
	{
	}


	/**
	* Returns <code>Object.class</code> regardless of <code>columnIndex</code>.
	*
	* @param columnIndex 		 the column being queried
	* @return		the Object.class
	**/
	 public java.lang.Class getColumnClass(int columnIndex)
	{
		return null;
	}


	/**
	* Returns a default name for the column using spreadsheet conventions: A, B, C,
	* ... Z, AA, AB, etc. If <code>column</code> cannot be
found, returns an empty
	* string.
	*
	* @param column 		 the column being queried
	* @return		a string containing the default name of <code>column</code>
	**/
	 public java.lang.String getColumnName(int column)
	{
		return null;
	}


	/**
	* Returns false. This is the default implementation for all cells.
	*
	* @param rowIndex 		 the row being queried
	* @param columnIndex 		 the column being queried
	* @return		false
	**/
	 public boolean isCellEditable(int rowIndex, int columnIndex)
	{
		return false;
	}


	/**
	* This empty implementation is provided so users don't have to implement this
	* method if their data model is not editable.
	*
	* @param value 		 value to assign to cell
	* @param rowIndex 		 row of cell
	* @param columnIndex 		 column of cell
	**/
	 public void setValueAt(java.lang.Object value, int rowIndex, int columnIndex)
	{
	}


}