package com.ulcjava.base.application.table;


	/**
	* <code>ITableCellRenderer</code> interface provides components to draw table
	* cells.
<p>
</p>
<b>Features</b>
<ul>
<li>Allows definition of a component to
	* be used for drawing a table cell.
<li>The component can be chosen based on
	* value, selection, focus and row states.
</ul>
<b>Examples</b>
<p>
</p>
The
	* example below demonstrates how to set the cell background for focused cells
	* (orange) and non-focused cells (cyan). For most simple
modifications, the
	* {@link DefaultTableCellRenderer} class should be
	* sufficient.
<p>
</p>

<pre>
final ULCLabel rendererLabel = new
	* ULCLabel();
rendererLabel.setOpaque(true);
ULCTableColumn nameColumn =
	* table.getColumnModel().getColumn(
TaskTableModel.NAME_INDEX);
nameColumn.setCel
	* lRenderer(new ITableCellRenderer() {
public IRendererComponent
	* getTableCellRendererComponent(
ULCTable table, Object value, boolean
	* isSelected,
boolean hasFocus, int row) {
if (hasFocus)
	* {
rendererLabel.setBackground(Color.orange);
} else
	* {
rendererLabel.setBackground(Color.cyan);
}
return rendererLabel;
}
});
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.IListCellRenderer
	**/
 public interface ITableCellRenderer
{


	/**
	* Return the renderer component that is used to render a table cell.
	*
	* @param table 		 the table of the cell to render
	* @param value 		 the value of the cell to render
	* @param isSelected 		 true if the cell to render is selected, false otherwise
	* @param hasFocus 		 true if the cell to render has focus, false otherwise
	* @param row 		 the row of the cell to render
	* @return		the renderer component that is used to render a table cell
	**/
	 public com.ulcjava.base.application.IRendererComponent getTableCellRendererComponent(com.ulcjava.base.application.ULCTable table, java.lang.Object value, boolean isSelected, boolean hasFocus, int row);

}