package com.ulcjava.base.application.table;


	/**
	* The <code>TableRowFilter</code> is used to specify which rows from the model
	* will be displayed in the view of the <code>ULCTable</code>
and which ones
	* not.Thus, it provides support for filtering of the rows from the model. A
	* custom implementation of a
<code>TableRowFilter</code> has to implement the
	* <code>include</code> method that indicates whether a row should be visible in
	* the
<code>ULCTable</code> or not.
<p>
The following code sample shows an
	* implementation of a <code>TableRowFilter</code> that filters all rows that do
	* not contain a String,
which contains character "A" for the specified
	* column:

<pre><code>
...
TableRowSorter tableRowSorter = new
	* TableRowSorter(tableModel);
tableRowSorter.setRowFilter(new
	* MyTableRowFilter(new int[]
	* {2}));
table.setRowSorter(tableRowSorter);
...

private class
	* MyTableRowFilterextends AbstractFilter {

MyTableRowFilter(int[] columns)
	* {
super(columns);
}

protected boolean include(RowEntry rowEntry, int index)
	* {
//returns the model value at the specified index for this row
Object value
	* =rowEntry.getValue(index);
if (String.valueOf(value).contains("A")) {
return
	* true;
}
return false;
}
...
</code></pre>

<p>
</p>
The abstract class
	* <code>TableRowFilter</code> contains the following predefined filters that
	* canbe instantiated using the
appropriate factory method:
<ul>
<li>
	* AbstractFilter
<li> AndFilter
<li> DateFilter
<li> NotFilter
<li>
	* NumberFilter<li> OrFilter
<li> RegexFilter
</ul>
	*
	* @see		com.ulcjava.base.application.table.TableRowFilter.AbstractFilter
	* @see		com.ulcjava.base.application.table.TableRowFilter.AndFilter
	* @see		com.ulcjava.base.application.table.TableRowFilter.DateFilter
	* @see		com.ulcjava.base.application.table.TableRowFilter.NotFilter
	* @see		com.ulcjava.base.application.table.TableRowFilter.NumberFilter
	* @see		com.ulcjava.base.application.table.TableRowFilter.OrFilter
	* @see		com.ulcjava.base.application.table.TableRowFilter.RegexFilter
	**/
 public  abstract class TableRowFilter extends java.lang.Object implements java.io.Serializable
{


	/**
	* Return a <code>ULCTableRowFilter</code> that is based on regular expressions.
	* Only those row entries with values that match the
regular expression pattern
	* are included. The API documentation of the java regular expression
	* language
{@link java.util.regex.Pattern} contains a complete description of
	* the supported constructs.
	*
	* @param regexPattern 		 the regex pattern that describes the filtering rule
	* @param columnIndices 		 the column indices of the values that have to be checked against the regex pattern
	* @return		a <code>ULCTableRowFilter</code> that includes values matching the given regex pattern
	* @throws		IllegalArgumentException if a given index is not a valid column index
	* @throws		PatternSyntaxException if the given <code>regex</code> pattern is not valid
	* @throws		NullPointerException if the given <code>regex</code> pattern is <code>null<code>
	* @see		java.util.regex.Pattern
	**/
	 public  static com.ulcjava.base.application.table.TableRowFilter regexFilter(java.lang.String regexPattern, int[] columnIndices)
	{
		return null;
	}


	/**
	* Returns a <code>ULCTableRowFilter</code> that is based on type
	* <code>Date</code>. It includes row entries with date values that
match the
	* given <code>ComparisonType</code> criteria for the given <code>date</code>.
	*
	* @param type 		 the <code>ComparisonType</code> criteria for this filter
	* @param date 		 the given <code>Date</code> for the comparison
	* @param columnIndices 		 the column indices of the values that have to be checked against given <code>date</code>
	* @return		a <code>ULCTableRowFilter</code> that includes values matching the specified criteria
	* @throws		IllegalArgumentException if a given index is not a valid column index or <code>type</code> is <code>null</code>
	* @throws		NullPointerException if the given <code>date</code> is <code>null</code>
	* @see		java.util.Date
	**/
	 public  static com.ulcjava.base.application.table.TableRowFilter dateFilter(com.ulcjava.base.application.table.TableRowFilter$ComparisonType type, java.util.Date date, int[] columnIndices)
	{
		return null;
	}


	/**
	* Returns a <code>ULCTableRowFilter</code> that is based on type
	* <code>Number</code>. It includes those row entries that have at
least one
	* <code>Number</code> value that matches the <code>ComparisonType</code> for
	* thegiven <code>Number</code>.
	*
	* @param type 		 the <code>ComparisonType</code> criteria for this filter.
	* @param number 		 the given <code>Number</code> for the comparison.
	* @param columnIndices 		 the column indices of the values that have to be checked against given <code>Number</code>.
	* @return		a <code>ULCTableRowFilter</code> that includes values matching the specified criteria
	* @throws		IllegalArgumentException if a given index is not a valid column index or <code>type</code> is <code>null</code> or
<code>number</code>is <code>null</code>
	* @throws		NullPointerException if the given <code>number</code> is <code>null</code>
	**/
	 public  static com.ulcjava.base.application.table.TableRowFilter numberFilter(com.ulcjava.base.application.table.TableRowFilter$ComparisonType type, java.lang.Number number, int[] columnIndices)
	{
		return null;
	}


	/**
	* Returns a <code>ULCTableRowFilter</code> based on logical OR operation. It
	* includes those row entries that are included in ANY
one of the filters
	* belonging to the given list of filters.
	*
	* @param filters 		 the list of <code>ULCTableRowFilter</code>s
	* @return		a <code>ULCTableRowFilter</code> that includes values matching the specified criteria
	* @throws		IllegalArgumentException if a given <code>ULCTableRowFilter</code> is null
	* @throws		NullPointerException if the given filter list is <code>null</code>
	**/
	 public  static com.ulcjava.base.application.table.TableRowFilter orFilter(java.util.List filters)
	{
		return null;
	}


	/**
	* Returns a <code>ULCTableRowFilter</code> based on logical AND operation. It
	* includes a row entry only if it is included in ALL
of the filters in the
	* givenlist of filters.
	*
	* @param filters 		 the list of <code>ULCTableRowFilter</code>s
	* @return		a <code>ULCTableRowFilter</code> that includes values matching the specified criteria
	* @throws		IllegalArgumentException if a given <code>ULCTableRowFilter</code> is null.
	* @throws		NullPointerException if the given filter list is <code>null</code>
	**/
	 public  static com.ulcjava.base.application.table.TableRowFilter andFilter(java.util.List filters)
	{
		return null;
	}


	/**
	* Returns a <code>ULCTableRowFilter</code> based on logical NOT operation. It
	* includes those row entries that are NOT included in
the given filter.
	*
	* @param filter 		 the <code>ULCTableRowFilter</code> whose result has to be negated
	* @return		a <code>ULCTableRowFilter</code> that includes values matching the specified criteria
	* @throws		IllegalArgumentException if the given <code>ULCTableRowFilter</code> is null.
	**/
	 public  static com.ulcjava.base.application.table.TableRowFilter notFilter(com.ulcjava.base.application.table.TableRowFilter filter)
	{
		return null;
	}


	/**
	* All filters have to implement this method. The method returns true if the
	* givenentry should be visible, false otherwise.
	*
	* @param entry 		 a non-null value that wraps the underlying table model row
	* @return		true if the model row should be visible, false otherwise.
	**/
	 public  abstract boolean include(com.ulcjava.base.application.table.TableRowFilter$RowEntry entry);

	/**
	* The ComparisonType is used to specify comparison rules.
	*
	**/
 public  static class ComparisonType extends java.lang.Object implements java.io.Serializable
{

	/**
	* EQUAL: all values of row entries equal to the supplied value are included.
	*
	**/
	 public  final  static com.ulcjava.base.application.table.TableRowFilter$ComparisonType EQUAL = null;

	/**
	* NOT_ EQUAL: all values of row entries not equal to the supplied value are
	* included.
	*
	**/
	 public  final  static com.ulcjava.base.application.table.TableRowFilter$ComparisonType NOT_EQUAL = null;

	/**
	* BEFORE: all values of row entries before the supplied value are included.
	*
	**/
	 public  final  static com.ulcjava.base.application.table.TableRowFilter$ComparisonType BEFORE = null;

	/**
	* AFTER: all values of row entries after the supplied value are included.
	*
	**/
	 public  final  static com.ulcjava.base.application.table.TableRowFilter$ComparisonType AFTER = null;

	 private ComparisonType()
	{
		 super();
	}


}
	/**
	* The <code>AbstractFilter</code> class provides the infrastructure for
	* filteringon specified columns. Instead of the method
<code>include(RowEntry
	* value)</code> the method <code>include(RowEntry value, int index)</code> has
	* to be overridden in
subclasses.
	*
	**/
 public  abstract  static class AbstractFilter extends com.ulcjava.base.application.table.TableRowFilter
{

	 public AbstractFilter(int[] columns)
	{
		 super();
	}

	 public boolean include(com.ulcjava.base.application.table.TableRowFilter$RowEntry value)
	{
		return false;
	}

	 abstract  protected boolean include(com.ulcjava.base.application.table.TableRowFilter$RowEntry value, int index);

}
	/**
	* A <code>RowEntry</code> is a wrapper for a table row of a underlying
	* <code>ITableModel</code>. It holds some information about
the model and as
	* well the reference to the model. A <code>TableRowFilter</code> checks the
	* values of the <code>RowEntry</code>
and determines if the row should be
	* visible or not.
	*
	**/
 public  abstract  static class RowEntry extends java.lang.Object implements java.io.Serializable
{

	 public RowEntry()
	{
		 super();
	}


	/**
	* Returns the underlying table model.
	*
	* @return		the table model that contains the data for this row entry
	**/
	 public  abstract com.ulcjava.base.application.table.ITableModel getModel();

	/**
	* Returns the number of values in the row entry. This is corresponds to the
	* number of columns in the underlying table model.
	*
	* @return		number of values in the row entry
	**/
	 public  abstract int getValueCount();

	/**
	* Returns the value at the given index from the row entry. The index represents
	* the position of a column in the table model.
	*
	* @param index 		 the index of the value in the row entry
	* @return		value at the specified index
	* @throws		IndexOutOfBoundsException if the index is out of range
	**/
	 public  abstract java.lang.Object getValue(int index);

	/**
	* Returns the string value at the specified index. Subclasses of
	* <code>RowEntry</code> may overwrite this method.
	*
	* @param index 		 the index of the value in the row entry
	* @return		never null - the string value at the specified index
	* @throws		IndexOutOfBoundsException if the index is out of range
	**/
	 public java.lang.String getStringValue(int index)
	{
		return null;
	}


	/**
	* Returns the identifier (in the model) for the entry. The identifier represents
	* the index of a row in the table model.
	*
	* @return		a model-based (not view-based) identifier for this entry
	**/
	 public  abstract java.lang.Integer getIdentifier();

}
}