package com.ulcjava.base.application.table;


	/**
	* The <code>TableRowSorter</code> facilitates sorting and filtering of
	* <code>ULCTables</code>. The <code>TableRowSorter</code> provides a
mapping
	* between the coordinates of the view (i.e. <code>ULCTable</code>) and the
	* model(i.e. <code>ITableModel</code>). By default, rows
are in the unsorted
	* order (the same as the model) and every column is sortable.
<p>
The sorting
	* ofeach column is done using comparators that can be set by calling the
	* <code>setComparator</code> method. If no specific
comparator is set for a
	* column, the following rule is used to choose a comparator:
<ul>
<li>If the
	* column class as returned by <code>getColumnClass</code> is String, a
	* comparator is used that is returned
	* by
<code>Collator.getInstance()</code>.
<li>If the column class implements
	* <code>Comparable</code>, the default comparator is used that invokes the
	* <code>compareTo</code> method
for the given objects.
<li>Otherwise use the
	* <code>Comparator</code> that is returned by
	* <code>Collator.getInstance()</code> on the objects (the toString values
of
	* this objects will be compared).
</ul>
<p>
The following sample code
	* demonstrates how to enable sorting on a
	* <code>ULCTable</code>:

<pre><code>
DefaultTableModel tableModel =
	* createTableModel();

ULCTable table = new
	* ULCTable(tableModel);

TableRowSorter tableRowSorter = new
	* TableRowSorter(tableModel);
table.setRowSorter(tableRowSorter);
</code></pre>
W
	* hen a <code>TableRowSorter</code> is set on a <code>ULCTable</code> there are
	* two possible ways of triggering sorting on the table:
<ul>
<li>The user
	* triggers the sorting, for example by clicking to the table header: In this
	* case the appropriate listener will call the
<code>toggleSortOrder</code>
	* method.
<li>The model data is changed: In this case the
	* <code>TableRowSorter</code> which is registered as
	* <code>ITableModelListener</code>,
reacts to insert, delete and update events
	* from the underlying table model. If the table model is updated, it only sorts
	* the table if the
sortsOnModelUpdate property is set to true (default is
	* false).
</ul>
<br>
<p>
The <code>TableRowSorter</code> notifies any changes
	* toit through the <code>IRowSorterListener</code>. Two types of notifications
	* are
sent:
<ul>
<li>SORT_ORDER_CHANGED indicates sort order has changed. This
	* event is fired immediately after the the sort order has changed and
	* before
thedata has been re-sorted.
<li>SORTED indicates the contents have
	* beennewly sorted or transformed in some way. This event is fired after the
	* sort operation is
over.
</ul>
<p>
The <code>TableRowSorter</code> also
	* provides the ability to filter the <code>ULCTable</code> by setting a
	* <code>TableRowFilter</code>.
All rows are included if no filter has been
	* specified.
<p>
The following code example demonstrates the usage of a
	* <code>TableRowFilter</code> that filters all rows, that do not contain the
	* String
"sample" in the specified columns:

<pre><code>
DefaultTableModel
	* tableModel = createTableModel();

ULCTable table = new
	* ULCTable(tableModel);

TableRowSorter tableRowSorter = new
	* TableRowSorter(tableModel);
tableRowSorter.setRowFilter(TableRowFilter.regexFil
	* ter(".*sample.*", new int[] {0, 1,
	* 2}));
table.setRowSorter(tableRowSorter);
</code></pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.table.ITableModel
	* @see		com.ulcjava.base.application.table.TableRowFilter
	* @see		com.ulcjava.base.application.ULCTable
	**/
 public class TableRowSorter extends java.lang.Object implements java.io.Serializable
{


	/**
	* Creates a <code>TableRowSorter</code> based on the model (an
	* <code>ITableModel</code> instance) that is used by the
<code>ULCTable</code>.
	* When this <code>TableRowSorter</code> is set on a <code>ULCTable</code>, it
	* registers itself as
<code>ITableModelListener</code> on the table model so
	* that it can react to changes on the underlying <code>ITableModel</code>.
	*
	* @param tableModel 		 The ITableModel instance, which is used by the <code>ULCTable</code> as its model. The model must not be null
	**/
	 public TableRowSorter(com.ulcjava.base.application.table.ITableModel tableModel)
	{
		 super();
	}


	/**
	* Adds a <code>IRowSorterListener</code> to the list of
	* <code>IRowSorterLisener</code>s. The registered listeners will be notified
	* with
a <code>RowSorterEvent</code> if the sort order has changed and if the
	* contents have been newly sorted or transformed in some way
	*
	* @param listener 		 The <code>IRowSorterListener</code> that is to be added to the list of listeners.
	* @see		com.ulcjava.base.application.event.RowSorterEvent
	**/
	 public void addRowSorterListener(com.ulcjava.base.application.event.IRowSorterListener listener)
	{
	}


	/**
	* Removes a <code>IRowSorterListener</code> from the list of
	* <code>IRowSorterLiseners</code>.
	*
	* @param listener 		 The <code>IRowSorterListener</code> that is to be removed from the list of listeners.
	**/
	 public void removeRowSorterListener(com.ulcjava.base.application.event.IRowSorterListener listener)
	{
	}


	/**
	* Returns all registered <code>IRowSorterListeners</code>.
	*
	* @return		All registered <code>IRowSorterListeners</code>.
	**/
	 public com.ulcjava.base.application.event.IEventListener[] getRowSorterListeners()
	{
		return null;
	}

	 protected void fireRowSorterChanged(int[] lastRowIndexToModel, com.ulcjava.base.application.event.RowSorterEvent$SortEventType eventType)
	{
	}


	/**
	* Invoked by ULC when the underlying table model has changed.
	*
	* @param event 		 the event that describes the table model change
	**/
	 public void tableChanged(com.ulcjava.base.application.event.TableModelEvent event)
	{
	}


	/**
	* Returns whether or not a change of the underlying table model should trigger a
	* re-sort of the view coordinates
	*
	* @return		true if the change of table data should trigger a re-sort, false otherwise
	**/
	 public boolean getSortsOnUpdates()
	{
		return false;
	}


	/**
	* Specifies if a change of the underlying table model should trigger a re-sort
	* ofthe view coordinates (default is false).
	*
	* @param sortOnUpdate 		 Indicates if table data gets sorted after a model update.
	**/
	 public void setSortsOnUpdates(boolean sortOnUpdate)
	{
	}


	/**
	* Resets the sort order for the <code>TableRowSorter</code>. The sort column is
	* set to -1 and the sort order to UNSORTED.
	*
	**/
	 public void resetSortOrder()
	{
	}


	/**
	* Sets an instance of <code>TableRowFilter</code> for this
	* <code>TableRowSorter</code>. The filter determines if any rows will be
hidden
	* from the view. Note that a sort is triggered upon setting the filter.
	*
	* @param filter 		 the <code>TableRowFilter</code> that is set to this <code>TableRowSorter</code>.
	**/
	 public void setRowFilter(com.ulcjava.base.application.table.TableRowFilter filter)
	{
	}


	/**
	* Returns the <code>TabelRowFilter</code> that is set on this
	* <code>TableRowSorter</code>. The filter determines if any rows will be
hidden
	* from the view.
	*
	* @return		the <code>TableRowSorter</code> instance that was set to this <code>TableRowSorter</code>
	**/
	 public com.ulcjava.base.application.table.TableRowFilter getRowFilter()
	{
		return null;
	}


	/**
	* Toggels the sort order of the column from ascending to descending and vice
	* versa. The sort order is made ascending if the column was
unsorted or sorted
	* in a descending order. The sort order is made descending if the column was
	* sorted in ascending order.
	*
	* @param column 		 The column that contains the keys for sorting and which becomes the primary sorted column w.r.t. the model
	**/
	 public void toggleSortOrder(int column)
	{
	}


	/**
	* Sorts and filters the rows in the view, based on sort order. If the sort order
	* is set to UNSORTED, the mappings from model to view
indices are reset.
	*
	* @see		#setRowFilter
	**/
	 public void sort()
	{
	}


	/**
	* Checks if the row with the given view index would be filtered with the
	* currently set <code>TableRowFilter</code>. If the filter is
null all rows are
	* included.
	*
	* @deprecated		unused
	* @param viewRowIndex 		 The view index of the row to check.
	* @return		true if the row should be included, false otherwise
	**/
	 public boolean checkIfViewRowIsFiltered(int viewRowIndex)
	{
		return false;
	}


	/**
	* Checks if the row with the given model index would be filtered with the
	* currently set <code>TableRowFilter</code>. If the filter is
null all rows are
	* included.
	*
	* @deprecated		unused
	* @param modelRowIndex 		 The model index of the row to check.
	* @return		true if the row should be included or the filter is null (this means all rows are included)
	**/
	 public boolean checkIfModelRowIsFiltered(int modelRowIndex)
	{
		return false;
	}


	/**
	* Returns the column index of the current sorted column.
	*
	* @return		the index of the sorted column
	**/
	 public int getSortColumn()
	{
		return 0;
	}


	/**
	* Sets the index of the selected column that is used for sorting.
	*
	* @param sortColumn 		 The index of the sort column.
	* @deprecated		use setSortColumn(int sortColumn, SortOrder sortOrder) instead
	**/
	 public void setSortColumn(int sortColumn)
	{
	}


	/**
	* Sets the index of the column that is used for sorting and sets the sort order
	* that is applied for the sorting.
	*
	* @param sortColumn 		 The index of the sort column.
	* @param sortOrder 		 The sort order the is applied to the sort operation
	**/
	 public void setSortColumn(int sortColumn, com.ulcjava.base.shared.SortOrder sortOrder)
	{
	}


	/**
	* Returns the sort order of the currently selected sort column.
	*
	* @return		The sort order of the sorted column
	**/
	 public com.ulcjava.base.shared.SortOrder getSortOrder()
	{
		return null;
	}


	/**
	* Enables or disables the sorting functionality for the column.
	*
	* @param column 		 the column index of the model
	* @param sortable 		 true if column is sortable, false otherwise
	**/
	 public void setSortable(int column, boolean sortable)
	{
	}


	/**
	* Returns if the specified column is sortable.
	*
	* @param column 		 the column index of the model
	* @return		<code>true</code> if the column is sortable, false otherwise
	**/
	 public boolean isSortable(int column)
	{
		return false;
	}


	/**
	* Sets a user defined comparator for a specified column index.
	*
	* @param column 		 The index of the column, which should be sorted with the specified comparator
	* @param comparator 		 The user defined comparator for the specified column
	**/
	 public void setComparator(int column, java.util.Comparator comparator)
	{
	}


	/**
	* Returns the comparator that is set for the specified column. If no comparator
	* is set, the following rule is used:
<ul>
<li>If the class returned by
	* <code>getColumnClass</code> is String, a comparator is used that is returned
	* by
<code>Collator.getInstance</code>.
<li>If the class returned by
	* <code>getColumnClass</code> implements comparable, a default comparator is
	* used to compare the objects
of this column.
<li>If no rule is matching, a
	* comparator is used that is returned by <code>Collator.getInstance</code> and
	* String.valueOf() is called
on each object.
</ul>
	*
	* @param column 		 The column for that a comparator is searched
	* @return		A comparator that is dependent on the column type or null if no rule is matching
	**/
	 public java.util.Comparator getComparator(int column)
	{
		return null;
	}


	/**
	* Converts the row index that is used by the model to a row index that is used
	* bythe view.
	*
	* @param modelIndex 		 The model index that has to be converted to the view index.
	* @return		The view row index of a model row index.
	**/
	 public int convertRowIndexToView(int modelIndex)
	{
		return 0;
	}


	/**
	* Converts the row index that is used by the view to a row index that is used by
	* the model.
	*
	* @param viewIndex 		 The view index that has to be converted to the model index.
	* @return		The model row index of a view row index.
	**/
	 public int convertRowIndexToModel(int viewIndex)
	{
		return 0;
	}


	/**
	* Returns the underlying <code>ITableModel</code>.
	*
	* @return		The <code>ITableModel</code> that is used with this <code>TableRowSorter</code>.
	**/
	 public com.ulcjava.base.application.table.ITableModel getModel()
	{
		return null;
	}


	/**
	* Get the count of currently visible view rows.
	*
	* @return		The view row count.
	**/
	 public int getViewRowCount()
	{
		return 0;
	}


	/**
	* Returns the mapping of all view indices to model indices
	*
	* @deprecated		unused
	* @return		An int array: the position number of the int value is equivalent to the view row index, the int value is equivalent to the
model row index
	**/
	 public int[] getViewToModelIndices()
	{
		return null;
	}


}