package com.ulcjava.base.application.table;


	/**
	* A <code>ULCTableColumn</code> represents one column in a ULCTable. The
	* <code>ULCTableColumn</code> is used to configure the
appearance of the
	* column,ie., components used to render table values, header and to edit its
	* contents.
<p>
<b>Features</b>
<ul>
<li>The displayed data can be retrieved
	* from the model using column index defined with
	* <code>setModelIndex()</code>.
<li>It allows specification of minimal and
	* maximal width for the column.
<li>For the convenience reason, an identifier
	* can be assigned to the column.
<li>To customize the appearance of the
	* displayed data, the developer may provide his own renderer for either column
	* header or regular
contents. The same holds true for the editor used to alter
	* table data.
</ul>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCTable
	* @see		ITableModel
	* @see		com.ulcjava.base.application.util.Color
	**/
 public class ULCTableColumn extends com.ulcjava.base.application.AbstractColumn
{

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* Constructor using a default model index of 0, default width of 75, a
	* <code>null</code> renderer and a <code>null</code> editor.
	*
	**/
	 public ULCTableColumn()
	{
		 super(0, 0);
	}


	/**
	* Constructor using a specified <code>modelIndex </code>, a default width of 75,
	* a <code>null</code> renderer and a
<code>null</code> editor.
	*
	* @param modelIndex 		 index specifiying the column in the model delivering the data for this column
	**/
	 public ULCTableColumn(int modelIndex)
	{
		 super(0, 0);
	}


	/**
	* Constructor using the specified <code>modelIndex</code>, column
	* <code>width<c/ode> and using a <code>null</code>
renderer and a
	* <code>null</code> editor.
	*
	* @param modelIndex 		 index specifiying the column in the model delivering the data for this column
	* @param width 		 the width for this column
	**/
	 public ULCTableColumn(int modelIndex, int width)
	{
		 super(0, 0);
	}


	/**
	* Creates and initializes an instance of <code>ULCTableColumn</code> with
	* <code>modelIndex</code>. The <code>modelIndex</code>
is the index of the
	* column in the model which will supply the data for this column in the table.
	* The <code>modelIndex</code> does
not change as the columns are reordered in
	* the view. The width parameter is used to set both the
	* <code>preferredWidth</code> for
this column and the initial width. The
	* renderer and editor are the objects used respectively to render and edit
	* values in this
column. When these are <code>null</code>, default values,
	* provided by the <code>getDefaultRenderer</code>
	* and
<code>getDefaultEditor</code> methods in the <code>ULCTable</code> class
	* are used to provide defaults based on the type of the
data in this column.
	*
	* @param modelIndex 		 index specifiying the column in the model delivering the data for this column
	* @param width 		 the width for the specified table column
	* @param cellRenderer 		 the specified cell renderer
	* @param cellEditor 		 the specified cell editor
	**/
	 public ULCTableColumn(int modelIndex, int width, com.ulcjava.base.application.table.ITableCellRenderer cellRenderer, com.ulcjava.base.application.table.ITableCellEditor cellEditor)
	{
		 super(0, 0);
	}


	/**
	* Returns the <code>ITableCellEditor</code> used by the <code>ULCTable</code> to
	* edit values for this column. When the
<code>cellEditor</code> is
	* <code>null</code>, the <code>ULCTable</code> uses a default editor based on
	* the class of the cells
in that column. The default value for a
	* <code>cellEditor</code> is <code>null</code>.
	*
	* @return		the <code>cellEditor</code> property
	* @see		#setCellEditor
	**/
	 public com.ulcjava.base.application.table.ITableCellEditor getCellEditor()
	{
		return null;
	}


	/**
	* Returns the <code>ITableCellRenderer</code> used by the <code>ULCTable</code>
	* to draw values for this column. When the
<code>cellRenderer</code> is
	* <code>null</code>, the <code>ULCTable</code> uses a default renderer based on
	* the class of the
cells in that column. The default value for a
	* <code>cellRenderer</code> is <code>null</code>.
	*
	* @return		the <code>cellRenderer</code> property
	* @see		#setCellRenderer
	**/
	 public com.ulcjava.base.application.table.ITableCellRenderer getCellRenderer()
	{
		return null;
	}


	/**
	* Returns the <code>ITableCellRenderer</code> used to draw the header of the
	* <code>ULCTableColumn</code>. When the
<code>headerRenderer</code> is
	* <code>null</code>, the <code>ULCTable</code> uses the
	* <code>defaultRenderer</code> of the
<code>ULCTableHeader</code>. The default
	* value for a <code>headerRenderer</code> is <code>null</code>.
	*
	* @return		the <code>headerRenderer</code> property
	* @see		#setHeaderRenderer
	* @see		#setHeaderValue
	**/
	 public com.ulcjava.base.application.table.ITableCellRenderer getHeaderRenderer()
	{
		return null;
	}


	/**
	* Sets the editor to used by when a cell in this column is edited.
	*
	* @param cellEditor 		 the new cellEditor
	* @see		#getCellEditor
	**/
	 public void setCellEditor(com.ulcjava.base.application.table.ITableCellEditor cellEditor)
	{
	}


	/**
	* Sets the <code>ITableCellRenderer</code> used by <code>ULCTable</code> to draw
	* individual values for this column.
	*
	* @param cellRenderer 		 the new cellRenderer
	* @see		#getCellRenderer
	**/
	 public void setCellRenderer(com.ulcjava.base.application.table.ITableCellRenderer cellRenderer)
	{
	}


	/**
	* Sets the <code>ITableCellRenderer</code> used to draw the
	* <code>ULCTableColumn</code>'s header to <code>headerRenderer</code>.
	*
	* @param headerRenderer 		 the new headerRenderer
	* @see		#getHeaderRenderer
	**/
	 public void setHeaderRenderer(com.ulcjava.base.application.table.ITableCellRenderer headerRenderer)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCTableColumnDispatcher extends AbstractColumnDispatcher
{


}
}