package com.ulcjava.base.application.tabletree;


	/**
	* The <code>DefaultMutableTableTreeNode</code> is an implementation of an
	* <code>IMutableTableTreeNode</code> that stores its cells in
an array. It is
	* suitable for very simple applications where the amount of data is relatively
	* small.
<p>
<b>Features</b>
<ul>
<li>The
	* <code>DefaultMutableTableTreeNode</code> class manages the handling of the
	* parent and the children.
<li>A default implementation of the
	* <code>setValueAt()</code> method is provided which throws
	* an
<code>UnsupportedOperationException</code>.
<li>The
	* <code>DefaultMutableTableTreeNode</code> stores its cells in an array, the
	* individual values are accessed with the column
index.
</ul>
	*
	* @ulc.application		
	* @see		IMutableTableTreeNode
	* @see		ITableTreeNode
	* @see		com.ulcjava.base.application.ULCTableTree
	**/
 public class DefaultMutableTableTreeNode extends java.lang.Object implements com.ulcjava.base.application.tabletree.IMutableTableTreeNode, java.io.Serializable
{


	/**
	* Creates a node that is not editable and is not a leaf.
	*
	* @param data 		 the data for the node
	**/
	 public DefaultMutableTableTreeNode(java.lang.Object[] data)
	{
		 super();
	}


	/**
	* Creates a node that is not a leaf.
	*
	* @param data 		 the data for the node
	* @param editable 		 specifies if the data is editable or not
	**/
	 public DefaultMutableTableTreeNode(java.lang.Object[] data, boolean[] editable)
	{
		 super();
	}


	/**
	* Creates a node that is not editable.
	*
	* @param data 		 the data for the node
	* @param leaf 		 specifies if the node should be a leaf or not
	**/
	 public DefaultMutableTableTreeNode(java.lang.Object[] data, boolean leaf)
	{
		 super();
	}


	/**
	* Creates a node.
	*
	* @param data 		 the data for the node
	* @param editable 		 specifies if the data is editable or not
	* @param leaf 		 specifies if the node should be a leaf or not
	**/
	 public DefaultMutableTableTreeNode(java.lang.Object[] data, boolean[] editable, boolean leaf)
	{
		 super();
	}

	 public java.lang.Object getValueAt(int column)
	{
		return null;
	}

	 public void setValueAt(java.lang.Object value, int column)
	{
	}

	 public boolean isLeaf()
	{
		return false;
	}

	 public void setLeaf(boolean leaf)
	{
	}

	 public java.lang.String toString()
	{
		return null;
	}

	 public void setParent(com.ulcjava.base.application.tabletree.IMutableTableTreeNode parent)
	{
	}

	 public com.ulcjava.base.application.tabletree.ITableTreeNode getParent()
	{
		return null;
	}

	 public com.ulcjava.base.application.tabletree.ITableTreeNode getChildAt(int index)
	{
		return null;
	}

	 public int getChildCount()
	{
		return 0;
	}


	/**
	* Removes the specified child from its parent and makes it a child of this node.
	*
	* @param child 		 the node to add to this node
	**/
	 public void add(com.ulcjava.base.application.tabletree.IMutableTableTreeNode child)
	{
	}


	/**
	* Inserts the given node as a child at the specified position.
	*
	* @param child 		 node to add.
	* @param index 		 position where the child is inserted.
	* @throws		IllegalStateException if this node is a leaf.
	* @throws		IllegalArgumentException if the given child is <code>null</code> or an ancestor of this node.
	**/
	 public void insert(com.ulcjava.base.application.tabletree.IMutableTableTreeNode child, int index)
	{
	}


	/**
	* Returns true if the specified node is an ancestor of this node, false otherwise.
	*
	* @param node 		 the node to test
	* @return		true if the specified node is an ancestor of this node, false otherwise
	**/
	 public boolean isNodeAncestor(com.ulcjava.base.application.tabletree.ITableTreeNode node)
	{
		return false;
	}

	 public void remove(int index)
	{
	}

	 public int getIndex(com.ulcjava.base.application.tabletree.ITableTreeNode child)
	{
		return 0;
	}

	 public boolean isCellEditable(int column)
	{
		return false;
	}


	/**
	* Removes all children.
	*
	**/
	 public void removeAllChildren()
	{
	}


	/**
	* Returns the path to the root.
	*
	* @return		the path to the root
	**/
	 public com.ulcjava.base.application.tabletree.ITableTreeNode[] getPath()
	{
		return null;
	}


}