package com.ulcjava.base.application.tabletree;


	/**
	* The <code>DefaultTableTreeModel</code> is an implementation of a table tree
	* model that uses
	* <code>ITableTreeNodes</code>.
<p>
<b>Features</b>
<ul>
<li>The<code>DefaultTabl
	* eTreeModel</code> component inherits all features of
	* <code>AbstractTableTreeModel</code>.
<li>It provides a table tree model
	* implementation that uses <code>ITableTreeNodes</code>.
<li>Manipulate the
	* content of a <code>DefaultTableTreeModel</code> with the help of the provided
	* <code>insertNodeInto()</code> and
<code>removeNodeFromParent()</code>
	* methods.To set the value of a single cell, use the <code>setValueAt()</code>
	* method of the
<code>ITableTreeModel</code> interface. When using these
	* methodsthe necessary table model events are automatically fired. Note
	* that
adding and removing children to and from a node in a
	* <code>DefaultTableTreeModel</code> is only possible if this node is
	* an
<code>IMutableTableTreeNode</code>.
<li>Reading the content of the
	* <code>DefaultTableTreeModel</code> can be done with the help of the various
	* getter methods of the
<code>ITableTreeModel</code>
	* interface.
</ul>
<b>Examples</b>
<p>
The following example shows how to fill
	* data into a <code>DefaultTableTreeModel</code>.

<pre>
DefaultTableTreeModel
	* tableTreeModel = new DefaultTableTreeModel(root,
new String[]
	* {&quot;Name&quot;, &quot;Due By&quot;,
	* &quot;Effort&quot;});
tableTreeModel.insertNodeInto(nodeOne, root,
	* 0);
tableTreeModel.insertNodeInto(nodeTwo, root, 1);
</pre>

<p>
</p>
The
	* following example prints all nodes of a table tree
	* model.
<p>
</p>

<pre>
private void printModel(ITableTreeModel model)
	* {
printNode(model, (ITableTreeNode)model.getRoot(), &quot;&quot;);
}

private
	* void printNode(ITableTreeModel model, ITableTreeNode node,
String indent)
	* {
System.out.println(&quot;&quot; + indent + node);
for (int i = 0; i &lt;
	* model.getChildCount(node); i++) {
printNode(model,
	* (ITableTreeNode)model.getChild(node, i),
indent + '\t');
}
}
</pre>
	*
	* @ulc.application		
	* @see		AbstractTableTreeModel
	* @see		ITableTreeModel
	* @see		ITableTreeNode
	* @see		com.ulcjava.base.application.ULCTableTree
	**/
 public class DefaultTableTreeModel extends com.ulcjava.base.application.tabletree.AbstractTableTreeModel
{


	/**
	* Creates a table tree model that delegates all callback methods to
	* correspondingmethods on its <code>ITableTreeNode</code> objects.
	*
	* @param root 		 the root of the table tree
	* @param columnNames 		 the column names
	**/
	 public DefaultTableTreeModel(com.ulcjava.base.application.tabletree.ITableTreeNode root, java.lang.String[] columnNames)
	{
		 super();
	}

	 public int getChildCount(java.lang.Object parent)
	{
		return 0;
	}

	 public java.lang.Object getChild(java.lang.Object parent, int index)
	{
		return null;
	}

	 public java.lang.Object getRoot()
	{
		return null;
	}

	 public java.lang.Object getValueAt(java.lang.Object node, int column)
	{
		return null;
	}

	 public int getIndexOfChild(java.lang.Object parent, java.lang.Object child)
	{
		return 0;
	}

	 public int getColumnCount()
	{
		return 0;
	}

	 public java.lang.String getColumnName(int column)
	{
		return null;
	}


	/**
	* Returns true if the node is mutable and the cell at the specified column of
	* thenode is editable, false otherwise.

Returns false if the node is not
	* mutable.
	*
	* @param node 		 the node being queried
	* @param columnIndex 		 the column being queried
	* @return		true if node is mutable and its cell at columnIndex is editable, false otherwise
	**/
	 public boolean isCellEditable(java.lang.Object node, int columnIndex)
	{
		return false;
	}

	 public boolean isLeaf(java.lang.Object node)
	{
		return false;
	}

	 public void setValueAt(java.lang.Object value, java.lang.Object node, int column)
	{
	}


	/**
	* Returns the path to the root.
	*
	* @param node 		 the node to get the path for
	* @return		the path to the root
	**/
	 public  static com.ulcjava.base.application.tabletree.ITableTreeNode[] getPathToRoot(com.ulcjava.base.application.tabletree.ITableTreeNode node)
	{
		return null;
	}


	/**
	* Inserts the specified child into the specified parent at the specified index.
	*
	* @param child 		 the child to insert
	* @param parent 		 the parent to insert the child into
	* @param index 		 the index to insert the child at
	**/
	 public void insertNodeInto(com.ulcjava.base.application.tabletree.IMutableTableTreeNode child, com.ulcjava.base.application.tabletree.IMutableTableTreeNode parent, int index)
	{
	}


	/**
	* Removes the specified node from its parent.
	*
	* @param node 		 the node to be removed
	**/
	 public void removeNodeFromParent(com.ulcjava.base.application.tabletree.IMutableTableTreeNode node)
	{
	}


	/**
	* Sets the root.
	*
	* @param root 		 the new root
	**/
	 public void setRoot(com.ulcjava.base.application.tabletree.ITableTreeNode root)
	{
	}


	/**
	* Method to be invoked after the specified node changed.
	*
	* @param node 		 the node changed
	**/
	 public void nodeChanged(com.ulcjava.base.application.tabletree.ITableTreeNode node)
	{
	}


	/**
	* Method to be invoked after the specified node changed.
	*
	* @param node 		 the node changed
	* @param column 		 the column index
	**/
	 public void nodeChanged(com.ulcjava.base.application.tabletree.ITableTreeNode node, int column)
	{
	}


	/**
	* To be invoked after the specified parent's children specified by the int array
	* have changed their representation mode.
	*
	* @param parent 		 the parent node
	* @param childIndices 		 an array indicating the changed children
	**/
	 public void nodesChanged(com.ulcjava.base.application.tabletree.ITableTreeNode parent, int[] childIndices)
	{
	}


	/**
	* Call if all children of the specified node have changed.
	*
	* @param node 		 the node whose children have changed
	**/
	 public void nodeStructureChanged(com.ulcjava.base.application.tabletree.ITableTreeNode node)
	{
	}


	/**
	* After inserting nodes this method needs to be called.
	*
	* @param parent 		 the parent node
	* @param childIndices 		 the indices indicating the new children
	**/
	 public void nodesWereInserted(com.ulcjava.base.application.tabletree.ITableTreeNode parent, int[] childIndices)
	{
	}


	/**
	* After removing nodes this method needs to be called.
	*
	* @param parent 		 the parent node
	* @param childIndices 		 the indices indicating the removed children
	* @param removedChildren 		 an array with the removed children
	**/
	 public void nodesWereRemoved(com.ulcjava.base.application.tabletree.ITableTreeNode parent, int[] childIndices, java.lang.Object[] removedChildren)
	{
	}


}