package com.ulcjava.base.application.tabletree;


	/**
	* The <code>ITableTreeNode</code> interface defines the requirements for an
	* object that can be used as an immutable table tree node in
	* a
<code>DefaultTableTreeModel</code>.
<p>
<b>Features</b>
<ul>
<li>An
	* <code>ITableTreeNode</code> encapsulates one business object.
<li>An
	* <code>ITableTreeNode</code> can return its children and its parent.
</ul>
	*
	* @ulc.application		
	* @see		DefaultTableTreeModel
	* @see		com.ulcjava.base.application.ULCTableTree
	**/
 public interface ITableTreeNode
{


	/**
	* Returns the child <code>ITableTreeNode</code> at index <code>index</code>.
	*
	* @param index 		 the index of the child to return
	* @return		the <code>ITableTreeNode</code> at index <code>index</code>
	**/
	 public com.ulcjava.base.application.tabletree.ITableTreeNode getChildAt(int index);

	/**
	* Returns the number of children <code>ITableTreeNodes</code> of this node.
	*
	* @return		the number of children
	**/
	 public int getChildCount();

	/**
	* Returns the parent <code>ITableTreeNodes</code> of this node.
	*
	* @return		the parent node
	**/
	 public com.ulcjava.base.application.tabletree.ITableTreeNode getParent();

	/**
	* Returns the index of <code>child</code> in the node's children array. If the
	* node does not contain the given <code>child</code>,
-1 will be returned.
	*
	* @param child 		 the child that the index is queried for
	* @return		the index of the child
	**/
	 public int getIndex(com.ulcjava.base.application.tabletree.ITableTreeNode child);

	/**
	* Returns the value of the <code>node's</code> cell at <code>column</code>.
	*
	* @param column 		 the column of the cell being queried
	* @return		Object the value of the cell
	**/
	 public java.lang.Object getValueAt(int column);

	/**
	* Returns true if the node is a leaf, false otherwise.
	*
	* @return		boolean true if this node is a leaf, otherwise false
	**/
	 public boolean isLeaf();

}