package com.ulcjava.base.application.tabletree;


	/**
	* A <code>ULCTableTreeColumn</code> represents one column in a
	* <code>ULCTableTree</code>. The <code>ULCTableTreeColumn</code> is
used to map
	* values from the model to the widget and to configure the appearance of the
	* column, ie., components used to render table
values, header and to edit its
	* contents.
<p>
<b>Features</b>
<ul>
<li>The displayed data can be retrieved
	* from the model using column index defined with
	* <code>setModelIndex()</code>.
<li>It allows specification of minimal and
	* maximal width for the column.
<li>For the convenience reason, an identifier
	* can be assigned to the column.
<li>To customize the appearance of the
	* displayed data, the developer may provide his own renderer for either column
	* header or regular
contents. The same holds true for the editor used to alter
	* table data.
</ul>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.table.ULCTableColumn
	**/
 public class ULCTableTreeColumn extends com.ulcjava.base.application.AbstractColumn
{

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* Constructor using a default model index of 0, default width of 75, a
	* <code>null</code> renderer and a <code>null</code> editor.
	*
	**/
	 public ULCTableTreeColumn()
	{
		 super(0, 0);
	}


	/**
	* Constructor using a default width of 75, a <code>null</code> renderer and a
	* <code>null</code> editor.
	*
	* @param modelIndex 		 the model index
	**/
	 public ULCTableTreeColumn(int modelIndex)
	{
		 super(0, 0);
	}


	/**
	* Constructor using a <code>null</code> renderer and a <code>null</code> editor.
	*
	* @param modelIndex 		 the model index
	* @param width 		 the with for this column
	**/
	 public ULCTableTreeColumn(int modelIndex, int width)
	{
		 super(0, 0);
	}


	/**
	* Creates and initializes an instance of <code>ULCTableTreeColumn</code> with
	* <code>modelIndex</code>. The <code>modelIndex</code>
is the index of the
	* column in the model which will supply the data for this column in the table
	* tree. The <code>modelIndex</code>
does not change as the columns are
	* reorderedin the view. The width parameter is used to set both the
	* <code>preferredWidth</code>
for this column and the initial width. The
	* renderer and editor are the objects used respectively to render and edit
	* values in this
column. When these are null default implementations will be
	* used instead.
	*
	* @param modelIndex 		 the model index
	* @param width 		 the with for this column
	* @param cellRenderer 		 the cell renderer for this column
	* @param cellEditor 		 the cell editor for this column
	**/
	 public ULCTableTreeColumn(int modelIndex, int width, com.ulcjava.base.application.tabletree.ITableTreeCellRenderer cellRenderer, com.ulcjava.base.application.tabletree.ITableTreeCellEditor cellEditor)
	{
		 super(0, 0);
	}


	/**
	* Sets the <code>ITableTreeCellRenderer</code> used to draw the
	* <code>ULCTableTreeColumn</code>'s header to
<code>headerRenderer</code>.
	*
	* @param headerRenderer 		 the new headerRenderer
	* @see		#getHeaderRenderer
	**/
	 public void setHeaderRenderer(com.ulcjava.base.application.tabletree.ITableTreeCellRenderer headerRenderer)
	{
	}


	/**
	* Returns the <code>ITableTreeCellRenderer</code> used to draw the header of the
	* <code>ULCTableTreeColumn</code>. When the
<code>headerRenderer</code> is
	* <code>null</code>, the <code>ULCTableTree</code> uses its
	* <code>defaultRenderer</code>.
	*
	* @return		the <code>headerRenderer</code> property
	* @see		#setHeaderRenderer
	* @see		#setHeaderValue
	**/
	 public com.ulcjava.base.application.tabletree.ITableTreeCellRenderer getHeaderRenderer()
	{
		return null;
	}


	/**
	* Sets the <code>ITableTreeCellRenderer</code> used by <code>ULCTableTree</code>
	* to draw individual values for this column.
	*
	* @param cellRenderer 		 the new cellRenderer
	* @see		#getCellRenderer
	**/
	 public void setCellRenderer(com.ulcjava.base.application.tabletree.ITableTreeCellRenderer cellRenderer)
	{
	}


	/**
	* Returns the <code>ITableTreeCellRenderer</code> used by the
	* <code>ULCTableTree</code> to draw values for this column. When
	* the
<code>cellRenderer</code> is <code>null</code>, the
	* <code>ULCTableTree</code> uses a default renderer based on the class of
the
	* cells in that column.
	*
	* @return		the <code>cellRenderer</code> property
	* @see		#setCellRenderer
	**/
	 public com.ulcjava.base.application.tabletree.ITableTreeCellRenderer getCellRenderer()
	{
		return null;
	}


	/**
	* Sets the editor to used by when a cell in this column is edited.
	*
	* @param cellEditor 		 the new cellEditor
	* @see		#getCellEditor
	**/
	 public void setCellEditor(com.ulcjava.base.application.tabletree.ITableTreeCellEditor cellEditor)
	{
	}


	/**
	* Returns the <code>ITableTreeCellEditor</code> used by the
	* <code>ULCTableTree</code> to edit values for this column. When
	* the
<code>cellEditor</code> is <code>null</code>, the
	* <code>ULCTableTree</code> uses a default editor based on the class of
	* the
cells in that column.
	*
	* @return		the <code>cellEditor</code> property
	* @see		#setCellEditor
	**/
	 public com.ulcjava.base.application.tabletree.ITableTreeCellEditor getCellEditor()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCTableTreeColumnDispatcher extends AbstractColumnDispatcher
{


}
}